/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/BranchPresentation;", "", "<init>", "()V", "TEXT_COLOR", "Lcom/intellij/ui/JBColor;", "BACKGROUND_BASE_COLOR", "Lorg/jetbrains/annotations/NotNull;", "BACKGROUND_BALANCE", "", "getBACKGROUND_BALANCE", "()D", "getBranchPresentationBackground", "Ljava/awt/Color;", "background", "namedDouble", "name", "", "default", "intellij.platform.vcs.impl.shared"})
public final class BranchPresentation {
    @NotNull
    public static final BranchPresentation INSTANCE = new BranchPresentation();
    @JvmField
    @NotNull
    public static final JBColor TEXT_COLOR;
    @NotNull
    private static final JBColor BACKGROUND_BASE_COLOR;

    private BranchPresentation() {
    }

    private final double getBACKGROUND_BALANCE() {
        return this.namedDouble("VersionControl.RefLabel.backgroundBrightness", 0.08);
    }

    @JvmStatic
    @NotNull
    public static final Color getBranchPresentationBackground(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Color color = ColorUtil.mix((Color)background, (Color)((Color)BACKGROUND_BASE_COLOR), (double)INSTANCE.getBACKGROUND_BALANCE());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"mix(...)");
        return color;
    }

    private final double namedDouble(String name, double d) {
        double d2;
        Object value = UIManager.get(name);
        if (value instanceof Double) {
            d2 = ((Number)value).doubleValue();
        } else if (value instanceof Integer) {
            d2 = ((Number)value).intValue();
        } else if (value instanceof String) {
            Double d3 = StringsKt.toDoubleOrNull((String)((String)value));
            d2 = d3 != null ? d3 : d;
        } else {
            d2 = d;
        }
        return d2;
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.RefLabel.foreground", (Color)((Color)new JBColor(new Color(0x7A7A7A), new Color(0x909090))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        TEXT_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"VersionControl.RefLabel.backgroundBase", (Color)((Color)new JBColor(Color.BLACK, Color.WHITE)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        BACKGROUND_BASE_COLOR = jBColor2;
    }
}

