/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.commit;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.impl.shared.commit.EditedCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitDetails;", "editedCommit", "<init>", "(Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitDetails;)V", "getEditedCommit", "()Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitDetails;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "isDifferentCommitter", "getTextPresentation", "", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public final class EditedCommitNode
extends ChangesBrowserNode<EditedCommitDetails> {
    public EditedCommitNode(@NotNull EditedCommitDetails editedCommit2) {
        Intrinsics.checkNotNullParameter((Object)editedCommit2, (String)"editedCommit");
        super(editedCommit2);
    }

    private final EditedCommitDetails getEditedCommit() {
        Object t = this.getUserObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getUserObject(...)");
        return (EditedCommitDetails)t;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        if (this.isDifferentCommitter()) {
            renderer.setIcon(AllIcons.General.Warning);
            renderer.setToolTipText(VcsBundle.message((String)"amend.commit.different.committer.warning", (Object[])new Object[0]));
        } else {
            renderer.setIcon(AllIcons.Vcs.CommitNode);
        }
        renderer.append(this.getEditedCommit().getSubject());
        this.appendCount(renderer);
    }

    private final boolean isDifferentCommitter() {
        VcsUser vcsUser = this.getEditedCommit().getCurrentUser();
        if (vcsUser == null) {
            return false;
        }
        VcsUser currentUser = vcsUser;
        return !VcsUserUtil.isSamePerson(currentUser, this.getEditedCommit().getCommitter());
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        return this.getEditedCommit().getSubject();
    }
}

