/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSXFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.dialects.FlowJSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSDialectsMappingsBase;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JavaScriptDialectFileType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.SubstitutedFileType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u001a\u0010\u0018\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/BasicDialectDetector;", "", "<init>", "()V", "KEY", "Lcom/intellij/psi/FilePropertyKey;", "", "JAVASCRIPT_FILE_TYPES_ARRAY", "", "Lcom/intellij/openapi/fileTypes/FileType;", "[Lcom/intellij/openapi/fileTypes/FileType;", "getLanguageDialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageDialectForJSFile", "getCombinedLanguageDialect", "configuredLanguage", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "fileSpecialLanguage", "getConfiguredJSVersion", "Lcom/intellij/psi/PsiFile;", "getConfiguredJSLevel", "intellij.javascript.psi.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBasicDialectDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicDialectDetector.kt\ncom/intellij/lang/javascript/BasicDialectDetector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,128:1\n30#2,2:129\n*S KotlinDebug\n*F\n+ 1 BasicDialectDetector.kt\ncom/intellij/lang/javascript/BasicDialectDetector\n*L\n107#1:129,2\n*E\n"})
public final class BasicDialectDetector {
    @NotNull
    public static final BasicDialectDetector INSTANCE = new BasicDialectDetector();
    @JvmField
    @NotNull
    public static final FilePropertyKey<String> KEY = FilePropertyKeyImpl.Companion.createPersistentStringKey("JS_LANGUAGE_LEVEL", new FileAttribute("js_language_level_persistence", 5, true));
    @JvmField
    @NotNull
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY;

    private BasicDialectDetector() {
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        Language language;
        JSLanguageDialect jsDialect;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Registry.Companion.is("javascript.language.level.pusher.enabled") && (jsDialect = BasicDialectDetector.getLanguageDialectForJSFile(file, project)) != null) {
            return jsDialect;
        }
        Language language2 = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        if (Intrinsics.areEqual((Object)language2, (Object)((Object)JavascriptLanguage.INSTANCE))) {
            language2 = ECMA6LanguageDialect.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)language2, (Object)ECMA6LanguageDialect.INSTANCE) && FlowJSAnnotation.hasFlowPrefix(file)) {
            language2 = FlowJSLanguageDialect.INSTANCE;
        }
        return (language = language2) instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileType fileType = SubstitutedFileType.substituteFileType((VirtualFile)file, (FileType)file.getFileType(), (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"substituteFileType(...)");
        FileType type = fileType;
        if (type instanceof SubstitutedFileType) {
            FileType fileType2 = ((SubstitutedFileType)type).getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
            type = fileType2;
        }
        if (ArraysKt.contains((Object[])JAVASCRIPT_FILE_TYPES_ARRAY, (Object)type)) {
            JSLanguageLevel configuredJSLevel = BasicDialectDetector.getConfiguredJSLevel(file, project);
            JSLanguageDialect fileSpecialLanguage = type instanceof JavaScriptDialectFileType ? ((JavaScriptDialectFileType)type).getDefaultLanguage() : null;
            return BasicDialectDetector.getCombinedLanguageDialect(configuredJSLevel, fileSpecialLanguage);
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getCombinedLanguageDialect(@NotNull JSLanguageLevel configuredLanguage, @Nullable JSLanguageDialect fileSpecialLanguage) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuredLanguage), (String)"configuredLanguage");
        if (fileSpecialLanguage == null || configuredLanguage.getDialect().isAtLeast(fileSpecialLanguage)) {
            return configuredLanguage.getDialect();
        }
        return fileSpecialLanguage;
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return BasicDialectDetector.getConfiguredJSVersion(virtualFile, project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getConfiguredJSLevel(@Nullable VirtualFile file, @NotNull Project project) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = file;
        Object object = file2 = virtualFile != null ? VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile) : null;
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        Object configuredLevel = null;
        if (file2 != null) {
            String level;
            String string;
            VirtualFile parent = file2.getParent();
            boolean bl = Registry.Companion.is("javascript.language.level.pusher.enabled");
            if (bl) {
                string = (String)KEY.getPersistentValue(parent);
            } else if (!bl) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<JSDialectsMappingsBase> serviceClass$iv = JSDialectsMappingsBase.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                string = (String)((JSDialectsMappingsBase)object2).getMapping(file2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String string2 = level = string;
            Object object3 = configuredLevel = string2 != null ? JSLanguageLevel.Companion.ofId(string2) : null;
        }
        if (configuredLevel == null) {
            JSRootConfiguration configuration = JSRootConfiguration.Companion.getInstanceOrNull(project);
            Object object4 = configuration;
            if (object4 == null || (object4 = object4.getLanguageLevel()) == null) {
                object4 = JSLanguageLevel.DEFAULT;
            }
            configuredLevel = object4;
        }
        return configuredLevel;
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSLevel(file, project).getDialect();
    }

    static {
        LanguageFileType[] languageFileTypeArray = new LanguageFileType[]{JavaScriptSupportLoader.JAVASCRIPT, JSXFileType.INSTANCE, FlowJSFileType.INSTANCE};
        JAVASCRIPT_FILE_TYPES_ARRAY = (FileType[])languageFileTypeArray;
    }
}

