/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavascriptLanguage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B<\b\u0004\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bB2\b\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/JSLanguageDialect;", "Lcom/intellij/lang/Language;", "id", "", "Lorg/jetbrains/annotations/NonNls;", "optionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "baseLanguage", "mimeTypes", "", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/javascript/DialectOptionHolder;Lcom/intellij/lang/Language;[Ljava/lang/String;)V", "(Ljava/lang/String;Lcom/intellij/lang/javascript/DialectOptionHolder;[Ljava/lang/String;)V", "getOptionHolder", "()Lcom/intellij/lang/javascript/DialectOptionHolder;", "unregisterDialect", "", "language", "isAtLeast", "", "other", "isCaseSensitive", "intellij.javascript.parser"})
public abstract class JSLanguageDialect
extends Language {
    @NotNull
    private final DialectOptionHolder optionHolder;

    protected JSLanguageDialect(@NotNull String id, @NotNull DialectOptionHolder optionHolder, @Nullable Language baseLanguage, String ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)optionHolder, (String)"optionHolder");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        super(baseLanguage, id, Arrays.copyOf(mimeTypes, mimeTypes.length));
        this.optionHolder = optionHolder;
        if (baseLanguage != JavascriptLanguage.INSTANCE && this != JavascriptLanguage.INSTANCE) {
            JavascriptLanguage.INSTANCE.registerDialect(this);
        }
    }

    @NotNull
    public final DialectOptionHolder getOptionHolder() {
        return this.optionHolder;
    }

    protected JSLanguageDialect(@NotNull String id, @NotNull DialectOptionHolder optionHolder, String ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)optionHolder, (String)"optionHolder");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        this(id, optionHolder, JavascriptLanguage.INSTANCE, Arrays.copyOf(mimeTypes, mimeTypes.length));
    }

    public void unregisterDialect(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super.unregisterDialect(language);
        if (this != JavascriptLanguage.INSTANCE) {
            JavascriptLanguage.INSTANCE.unregisterDialect(language);
        }
    }

    public boolean isAtLeast(@NotNull JSLanguageDialect other) {
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        if (this == other) {
            return true;
        }
        Language baseLanguage = this.getBaseLanguage();
        return baseLanguage instanceof JSLanguageDialect && ((JSLanguageDialect)baseLanguage).isAtLeast(other);
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

