/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.JSXXmlTokensParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptXmlTokensParser;", "Lcom/intellij/lang/javascript/ecmascript6/JSXXmlTokensParser;", "parser", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "lookbehindSkipWhitespaces", "Lcom/intellij/psi/tree/IElementType;", "parseSpecialTagEntity", "", "firstTokenType", "parseTagGenericArgumentsBody", "", "intellij.javascript.parser"})
public final class TypeScriptXmlTokensParser
extends JSXXmlTokensParser {
    public TypeScriptXmlTokensParser(@NotNull JavaScriptParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
    }

    private final IElementType lookbehindSkipWhitespaces() {
        int i = -1;
        IElementType elementType = null;
        while (JSElementTypes.COMMENTS_AND_WHITESPACES.contains(elementType = this.getBuilder().rawLookup(i--))) {
        }
        return elementType;
    }

    @Override
    protected boolean parseSpecialTagEntity(@Nullable IElementType firstTokenType) {
        if (firstTokenType == JSTokenTypes.LT && this.lookbehindSkipWhitespaces() == JSTokenTypes.XML_TAG_NAME) {
            PsiBuilder.Marker marker = this.getBuilder().mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker genericArguments = marker;
            this.getBuilder().advanceLexer();
            this.parseTagGenericArgumentsBody();
            IElementType afterNameAndGenericArgumentsType = this.getBuilder().getTokenType();
            if (afterNameAndGenericArgumentsType == JSTokenTypes.XML_TAG_END) {
                this.getBuilder().remapCurrentToken(JSTokenTypes.GT);
            } else if (afterNameAndGenericArgumentsType == JSTokenTypes.GT) {
                this.getBuilder().advanceLexer();
            }
            genericArguments.done(BasicTypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENT_LIST);
            return true;
        }
        if (firstTokenType == JSTokenTypes.GT && this.lookbehindSkipWhitespaces() == JSElementTypes.XML_JS_GENERIC_ARG_SCRIPT) {
            this.getBuilder().advanceLexer();
            return true;
        }
        return false;
    }

    private final void parseTagGenericArgumentsBody() {
        PsiBuilder.Marker marker = this.getBuilder().mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker genericArgument = marker;
        IElementType tokenType = this.getBuilder().getTokenType();
        int ltGtBalance = 1;
        int braceBalance = 0;
        int parenBalance = 0;
        int bracketBalance = 0;
        while (tokenType != null && tokenType != JSTokenTypes.XML_TAG_END) {
            if (tokenType == JSTokenTypes.LBRACE) {
                ++braceBalance;
            } else if (tokenType == JSTokenTypes.RBRACE) {
                --braceBalance;
            } else if (tokenType == JSTokenTypes.XML_LBRACE) {
                ++braceBalance;
            } else if (tokenType == JSTokenTypes.XML_RBRACE) {
                --braceBalance;
            } else if (tokenType == JSTokenTypes.LBRACKET) {
                ++bracketBalance;
            } else if (tokenType == JSTokenTypes.RBRACKET) {
                --bracketBalance;
            } else if (tokenType == JSTokenTypes.LPAR) {
                ++parenBalance;
            } else if (tokenType == JSTokenTypes.RPAR) {
                --parenBalance;
            } else if (tokenType == JSTokenTypes.LT) {
                ++ltGtBalance;
            } else if (tokenType == JSTokenTypes.GT) {
                if (--ltGtBalance == 0) {
                    genericArgument.collapse(JSElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
                    return;
                }
            } else if (tokenType == JSTokenTypes.COMMA && ltGtBalance == 1 && braceBalance == 0 && parenBalance == 0 && bracketBalance == 0) {
                genericArgument.collapse(JSElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
                this.getBuilder().advanceLexer();
                tokenType = this.getBuilder().getTokenType();
                Intrinsics.checkNotNullExpressionValue((Object)this.getBuilder().mark(), (String)"mark(...)");
                continue;
            }
            this.getBuilder().advanceLexer();
            tokenType = this.getBuilder().getTokenType();
        }
        genericArgument.collapse(JSElementTypes.XML_JS_GENERIC_ARG_SCRIPT);
    }
}

