/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.javascript.parsing.GrammarKitRecognizerState;
import com.intellij.lang.javascript.parsing.Marker;
import com.intellij.lang.javascript.parsing.MarkerImpl;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00018\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/lang/javascript/parsing/GrammarKitRecognizerStateImpl;", "RecognizeResult", "Lcom/intellij/lang/javascript/parsing/GrammarKitRecognizerState;", "pullToken", "Lkotlin/Function0;", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "tokens", "", "offset", "", "getOffset", "()I", "setOffset", "(I)V", "lastElementType", "getLastElementType", "()Ljava/lang/Object;", "setLastElementType", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "mark", "Lcom/intellij/lang/javascript/parsing/Marker;", "elementType", "(Ljava/lang/Object;)Lcom/intellij/lang/javascript/parsing/Marker;", "advanceLexer", "", "prepareNextToken", "nextToken", "getNextToken", "()Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
public abstract class GrammarKitRecognizerStateImpl<RecognizeResult>
implements GrammarKitRecognizerState<RecognizeResult> {
    @NotNull
    private final Function0<IElementType> pullToken;
    @NotNull
    private final List<IElementType> tokens;
    private int offset;
    @Nullable
    private RecognizeResult lastElementType;

    public GrammarKitRecognizerStateImpl(@NotNull Function0<? extends IElementType> pullToken) {
        Intrinsics.checkNotNullParameter(pullToken, (String)"pullToken");
        this.pullToken = pullToken;
        this.tokens = new ArrayList();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    @Override
    @Nullable
    public RecognizeResult getLastElementType() {
        return this.lastElementType;
    }

    public void setLastElementType(@Nullable RecognizeResult RecognizeResult) {
        this.lastElementType = RecognizeResult;
    }

    @Override
    @NotNull
    public Marker<RecognizeResult> mark(@Nullable RecognizeResult elementType) {
        return new MarkerImpl<RecognizeResult>(this, elementType);
    }

    @Override
    public void advanceLexer() {
        this.prepareNextToken();
        int n = this.getOffset();
        this.setOffset(n + 1);
    }

    private final void prepareNextToken() {
        if (this.getOffset() == this.tokens.size()) {
            try {
                IElementType type = (IElementType)this.pullToken.invoke();
                this.tokens.add(type);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public IElementType getNextToken() {
        this.prepareNextToken();
        return this.tokens.get(this.getOffset());
    }
}

