/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSTagOrGenericUtil;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/parsing/JSTagOrGenericsFlowHelper;", "", "<init>", "()V", "parseFlowParameterList", "", "state", "Lcom/intellij/lang/javascript/parsing/JSTagOrGenericUtil$State;", "isFlowGenericObjectDestructuringLambda", "checkFlowToken", "next", "Lcom/intellij/psi/tree/IElementType;", "skipCommentsAndWhitespaces", "intellij.javascript.parser"})
public final class JSTagOrGenericsFlowHelper {
    @NotNull
    public static final JSTagOrGenericsFlowHelper INSTANCE = new JSTagOrGenericsFlowHelper();

    private JSTagOrGenericsFlowHelper() {
    }

    @JvmStatic
    public static final boolean parseFlowParameterList(@NotNull JSTagOrGenericUtil.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IElementType next = state.getNextToken();
        int balance = 1;
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            if (next == JSTokenTypes.LBRACKET) {
                return true;
            }
            return INSTANCE.isFlowGenericObjectDestructuringLambda(state);
        }
        boolean wasIdentifier = false;
        if (next == JSTokenTypes.IDENTIFIER) {
            wasIdentifier = true;
            next = INSTANCE.skipCommentsAndWhitespaces(state);
            if (next == JSTokenTypes.QUEST) {
                next = INSTANCE.skipCommentsAndWhitespaces(state);
            }
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return wasIdentifier;
        }
        if (next == JSTokenTypes.LPAR) {
            return true;
        }
        boolean isLt = next == JSTokenTypes.LT;
        next = INSTANCE.skipCommentsAndWhitespaces(state);
        if (isLt && JSTagOrGenericUtil.INSTANCE.startsWithDiv(next)) {
            return false;
        }
        if (next != JSTokenTypes.LT) {
            while (balance > 0 && next != null) {
                if (next == JSTokenTypes.LPAR) {
                    ++balance;
                }
                if (next == JSTokenTypes.RPAR) {
                    --balance;
                }
                isLt = next == JSTokenTypes.LT;
                next = INSTANCE.skipCommentsAndWhitespaces(state);
                if (!isLt || !JSTagOrGenericUtil.INSTANCE.startsWithDiv(next)) continue;
                return false;
            }
        }
        if (next != JSTokenTypes.LT) {
            return true;
        }
        next = INSTANCE.skipCommentsAndWhitespaces(state);
        return INSTANCE.checkFlowToken(state, next);
    }

    private final boolean isFlowGenericObjectDestructuringLambda(JSTagOrGenericUtil.State state) {
        IElementType next = this.skipCommentsAndWhitespaces(state);
        int balance = 1;
        while (next != null) {
            if (next == JSTokenTypes.LBRACE) {
                ++balance;
            }
            if (next == JSTokenTypes.RBRACE && --balance == 0) break;
            next = this.skipCommentsAndWhitespaces(state);
        }
        if (balance != 0) {
            return true;
        }
        next = this.skipCommentsAndWhitespaces(state);
        if (next != JSTokenTypes.RPAR) {
            return true;
        }
        next = this.skipCommentsAndWhitespaces(state);
        return JSTokenTypes.ARROWS.contains(next);
    }

    private final boolean checkFlowToken(JSTagOrGenericUtil.State state, IElementType next) {
        IElementType next2 = next;
        if (next2 != JSTokenTypes.IDENTIFIER) {
            return next2 != JSTokenTypes.REGEXP_LITERAL;
        }
        next2 = this.skipCommentsAndWhitespaces(state);
        return next2 != JSTokenTypes.COMMA && next2 != JSTokenTypes.EXTENDS_KEYWORD && next2 != JSTokenTypes.GT;
    }

    private final IElementType skipCommentsAndWhitespaces(JSTagOrGenericUtil.State state) {
        state.advanceLexer();
        return state.getNextToken();
    }
}

