/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSFunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.types.JSBlockStatementElementTypeFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\\\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 r*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001rB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u0012\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\nH\u0014J\b\u0010\u001c\u001a\u00020\bH\u0014J\b\u0010$\u001a\u00020\bH\u0014J\b\u0010%\u001a\u00020\u0013H\u0014J\u0006\u0010&\u001a\u00020\nJ\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0013H\u0014J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0013H\u0014J\u0010\u0010+\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0013H\u0014J\u000e\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u000eJ\b\u0010.\u001a\u00020\nH\u0014J\b\u0010/\u001a\u00020\bH\u0002J\b\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020\bH\u0002J\b\u00103\u001a\u00020\nH\u0002J\b\u00104\u001a\u00020\bH\u0002J\b\u00105\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020\bH\u0002J\b\u00107\u001a\u00020\bH\u0002J\b\u00108\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010:\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020\bH\u0002J\b\u0010<\u001a\u00020\nH\u0016J\b\u0010=\u001a\u00020\nH\u0004J\b\u0010>\u001a\u00020\bH\u0002J\b\u0010?\u001a\u00020\bH\u0002J\b\u0010@\u001a\u00020\bH\u0002J\u0006\u0010A\u001a\u00020\bJ\b\u0010B\u001a\u00020\bH\u0004J\u0018\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u0013H\u0004J\u0010\u0010F\u001a\u00020\b2\u0006\u0010D\u001a\u00020\nH\u0004J\u0006\u0010G\u001a\u00020\nJ\u0006\u0010H\u001a\u00020\bJ\u001e\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020\nJ\u0010\u0010O\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u0013H\u0014J\u0010\u0010P\u001a\u00020\b2\u0006\u0010L\u001a\u00020\nH\u0004J\b\u0010Q\u001a\u00020\nH\u0016J\b\u0010R\u001a\u00020\nH\u0004J\b\u0010S\u001a\u00020\nH\u0004J\b\u0010T\u001a\u00020\bH\u0004J\b\u0010U\u001a\u00020\bH\u0002J\b\u0010V\u001a\u00020\nH\u0014J\u0010\u0010V\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\b\u0010X\u001a\u00020\bH\u0014J\u0012\u0010Y\u001a\u00020\n2\b\u0010Z\u001a\u0004\u0018\u00010\u000eH\u0014J\u0012\u0010[\u001a\u00020\n2\b\u0010Z\u001a\u0004\u0018\u00010\u000eH\u0014J\b\u0010\\\u001a\u00020\nH\u0004J\b\u0010]\u001a\u00020\bH\u0004J\b\u0010^\u001a\u00020\bH\u0004J\u0010\u0010_\u001a\u00020\b2\u0006\u0010`\u001a\u00020\nH\u0004J\u0018\u0010a\u001a\u00020\n2\u0006\u0010`\u001a\u00020\n2\u0006\u0010b\u001a\u00020\nH\u0002J \u0010c\u001a\u00020\n2\u0006\u0010d\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\nH\u0014J\b\u0010e\u001a\u00020\bH\u0002J\u0010\u0010f\u001a\u00020\b2\u0006\u0010g\u001a\u00020\u0013H\u0004J\u0010\u0010i\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010j\u001a\u00020\bH\u0014J\b\u0010k\u001a\u00020\bH\u0004J\b\u0010l\u001a\u00020\nH\u0016J\u000e\u0010m\u001a\u00020\b2\u0006\u0010n\u001a\u00020\nJ\u0014\u0010o\u001a\u000e\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020\n0pH\u0002R\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\u0014\u0010M\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001fR\u0014\u0010W\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010\u0010R\u0014\u0010h\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010\u0010\u00a8\u0006s"}, d2={"Lcom/intellij/lang/javascript/parsing/StatementParser;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parseStatement", "", "isUsingDeclaration", "", "forLoop", "isPossibleStartStatementModifier", "token", "Lcom/intellij/psi/tree/IElementType;", "isExportDefault", "()Z", "parseDialectSpecificSourceElements", "marker", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseClassNoMarker", "block", "mayOmitName", "isExpression", "canProceedClassParsing", "elementType", "isPossibleClassName", "firstElement", "parseReferencesList", "classElementType", "getClassElementType", "()Lcom/intellij/psi/tree/IElementType;", "classExpressionElementType", "getClassExpressionElementType", "classExtendListElementType", "getClassExtendListElementType", "parseClassMember", "startAttributeListOwner", "parseExpressionStatement", "parseClassOrInterfaceNoMarker", "clazz", "parseES6DecoratorDeclaration", "decoratorMark", "parseInterfaceNoMarker", "parseReferenceList", "doneToken", "parseReferenceListMember", "parseTryStatement", "parseCatchBlock", "parseThrowStatement", "parseSwitchStatement", "checkLParBeforeBlock", "parseCaseOrDefaultClause", "parseWithStatement", "parseReturnStatement", "parseBreakStatement", "parseContinueStatement", "parseBreakAndContinue", "parseIterationStatement", "parseForStatement", "parseForLoopHeader", "parseForLoopHeaderCondition", "parseWhileStatement", "parseDoWhileStatement", "parseIfStatement", "parseIfStatementHeader", "parseEmptyStatement", "parseVarStatementNoMarker", "inForInitializationContext", "variable", "parseVarList", "checkForSemicolon", "forceCheckForSemicolon", "parseVarDeclaration", "varType", "allowTypeDeclaration", "allowIn", "variableElementType", "getVariableElementType", "parseVarName", "parseVariableInitializer", "parseFunctionBody", "checkIdentifier", "checkIdentifierName", "parseES6FromDeclaration", "parseWithClause", "tryParseES6ExportStatement", "isExportDefaultBinding", "parseES6ImportStatement", "shouldParseTypeExports", "type", "shouldParseTypeImports", "parseES6ImportClause", "parseES6ImportedBinding", "parseES6NamespaceImport", "parseES6ImportOrExportNamedList", "isImportClause", "tryParseES6ImportOrExportNamedList", "stopOnFirstError", "parseES6ImportOrExportSpecifier", "isImport", "advanceIfAt", "parseES6ExportDeclarationBody", "exportDeclaration", "isNamespaceExport", "parseES6ExportDefaultAssignmentNoMarker", "parseES6ExportDefaultAssignmentBody", "parseBlockAndAttachStatementsDirectly", "parseBlock", "parseBlockBodyDeeply", "stopAfterFirstRBrace", "findParserPosToParseBlockUntil", "Lcom/intellij/openapi/util/Pair;", "", "Companion", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nStatementParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementParser.kt\ncom/intellij/lang/javascript/parsing/StatementParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1463:1\n13#2:1464\n*S KotlinDebug\n*F\n+ 1 StatementParser.kt\ncom/intellij/lang/javascript/parsing/StatementParser\n*L\n1437#1:1464\n*E\n"})
public class StatementParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Logger LOG;
    @JvmField
    @NotNull
    public static final Key<String> withinInterfaceKey;
    @JvmField
    @NotNull
    public static final Key<Boolean> IS_BLOCK_BODY_CONTEXT;
    @NotNull
    private static final TokenSet USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP;
    @JvmField
    @NotNull
    protected static final TokenSet EXPORTABLE_ELEMENTS_KEYWORDS;

    public StatementParser(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void parseStatement() {
        startOffset = this.builder.getCurrentOffset();
        firstToken = this.builder.getTokenType();
        if (firstToken == null) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            return;
        }
        if (firstToken == JSTokenTypes.LBRACE) {
            this.parseBlock();
            return;
        }
        if (firstToken == JSTokenTypes.SEMICOLON) {
            this.parseEmptyStatement();
            return;
        }
        if (firstToken == JSTokenTypes.IF_KEYWORD) {
            this.parseIfStatement();
            return;
        }
        if (firstToken == JSTokenTypes.DO_KEYWORD || firstToken == JSTokenTypes.WHILE_KEYWORD || firstToken == JSTokenTypes.FOR_KEYWORD) {
            this.parseIterationStatement();
            return;
        }
        if (firstToken == JSTokenTypes.CONTINUE_KEYWORD) {
            this.parseContinueStatement();
            return;
        }
        if (firstToken == JSTokenTypes.BREAK_KEYWORD) {
            this.parseBreakStatement();
            return;
        }
        if (firstToken == JSTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement();
            return;
        }
        if (firstToken == JSTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement();
            return;
        }
        if (firstToken == JSTokenTypes.YIELD_KEYWORD) {
            this.parseExpressionStatement();
            return;
        }
        if (firstToken == JSTokenTypes.SWITCH_KEYWORD) {
            this.parseSwitchStatement();
            return;
        }
        if (firstToken == JSTokenTypes.THROW_KEYWORD) {
            this.parseThrowStatement();
            return;
        }
        if (firstToken == JSTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == JSTokenTypes.DEBUGGER_KEYWORD) {
            v0 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"mark(...)");
            stmt = v0;
            this.builder.advanceLexer();
            this.forceCheckForSemicolon();
            stmt.done(JSElementTypes.DEBUGGER_STATEMENT);
            return;
        }
        functionParser = this.parser.getFunctionParser();
        if (JSTokenTypes.IDENTIFIER == firstToken || this.isPossibleStartStatementModifier(firstToken) || JSTokenTypes.AT == firstToken && functionParser.hasSupportDecorators()) {
            v1 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"mark(...)");
            marker = v1;
            methodEmptiness = (JSFunctionParser.MethodEmptiness)this.builder.getUserData(JSFunctionParser.methodsEmptinessKey);
            if (!functionParser.parseAttributesList()) {
                marker.rollbackTo();
            } else {
                try {
                    if (this.builder.eof()) {
                        marker.drop();
                        return;
                    }
                    tokenType = this.builder.getTokenType();
                    if (tokenType == JSTokenTypes.FUNCTION_KEYWORD) {
                        functionParser.parseFunctionNoMarker(JSFunctionParser.Context.SOURCE_ELEMENT, marker);
                        return;
                    }
                    if (this.isExportDefault()) {
                        this.parseES6ExportDefaultAssignmentNoMarker(marker);
                        return;
                    }
                    if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(tokenType)) {
                        this.parseVarStatementNoMarker(false, marker);
                        return;
                    }
                    if (this.parseDialectSpecificSourceElements(marker)) {
                        return;
                    }
                    if (tokenType == JSTokenTypes.CLASS_KEYWORD || tokenType == JSTokenTypes.INTERFACE_KEYWORD) {
                        this.parseClassOrInterfaceNoMarker(marker);
                        return;
                    }
                    if (tokenType == JSTokenTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AT) {
                        this.parseES6DecoratorDeclaration(marker);
                        return;
                    }
                    this.builder.putUserData(JSFunctionParser.methodsEmptinessKey, null);
                    if (firstToken == JSTokenTypes.IDENTIFIER) {
                        marker.rollbackTo();
                    }
                    if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                        marker.rollbackTo();
                        if (!this.parseExpressionStatement()) ** GOTO lbl118
                        return;
                    }
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.declaration", new Object[0]));
                    marker.drop();
                }
                finally {
                    this.builder.putUserData(JSFunctionParser.methodsEmptinessKey, (Object)methodEmptiness);
                }
            }
        } else {
            if (firstToken == JSTokenTypes.CLASS_KEYWORD || firstToken == JSTokenTypes.INTERFACE_KEYWORD) {
                marker = this.startAttributeListOwner();
                this.parseClassOrInterfaceNoMarker(marker);
                return;
            }
            if (firstToken == JSTokenTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AT) {
                marker = this.startAttributeListOwner();
                this.parseES6DecoratorDeclaration(marker);
                return;
            }
            if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(firstToken) || this.isUsingDeclaration(false)) {
                marker = this.startAttributeListOwner();
                this.parseVarStatementNoMarker(false, marker);
                return;
            }
        }
lbl118:
        // 6 sources

        if (functionParser.isFunctionDeclarationStart()) {
            functionParser.parseFunctionDeclaration();
            return;
        }
        if (this.isIdentifierToken(firstToken)) {
            v2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"mark(...)");
            labeledStatement = v2;
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.parseStatement();
                labeledStatement.done(JSElementTypes.LABELED_STATEMENT);
                return;
            }
            labeledStatement.rollbackTo();
        }
        if (firstToken != JSTokenTypes.FUNCTION_KEYWORD && this.parseExpressionStatement()) {
            return;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
        if (this.builder.getCurrentOffset() == startOffset && (this.builder.getTokenType() != JSTokenTypes.RBRACE || this.builder.getUserData(StatementParser.IS_BLOCK_BODY_CONTEXT) == null)) {
            this.builder.advanceLexer();
        }
    }

    private final boolean isUsingDeclaration(boolean forLoop) {
        TokenSet bindingIdentifierToken = forLoop ? USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP : JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET;
        return this.builder.getTokenType() == JSTokenTypes.USING_KEYWORD && !JavaScriptParserBase.Companion.hasLineTerminator(this.builder, 1) && bindingIdentifierToken.contains(this.builder.lookAhead(1)) || this.builder.getTokenType() == JSTokenTypes.AWAIT_KEYWORD && !JavaScriptParserBase.Companion.hasLineTerminator(this.builder, 1) && this.builder.lookAhead(1) == JSTokenTypes.USING_KEYWORD && !JavaScriptParserBase.Companion.hasLineTerminator(this.builder, 2) && bindingIdentifierToken.contains(this.builder.lookAhead(2));
    }

    protected boolean isPossibleStartStatementModifier(@Nullable IElementType token) {
        return JSTokenTypes.MODIFIERS.contains(token);
    }

    public final boolean isExportDefault() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD;
    }

    protected boolean parseDialectSpecificSourceElements(@NotNull PsiBuilder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        return false;
    }

    public final void parseClassNoMarker(@NotNull PsiBuilder.Marker block, boolean mayOmitName, boolean isExpression) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!this.isJSorTS() && !this.isIdentifierToken(this.builder.lookAhead(1))) {
            block.drop();
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            this.builder.advanceLexer();
            return;
        }
        LOG.assertTrue(JSTokenTypes.CLASS_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        IElementType classStartToken = this.builder.getTokenType();
        if (this.isPossibleClassName(classStartToken, mayOmitName)) {
            this.parser.builder.advanceLexer();
        } else if (!mayOmitName) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (!this.canProceedClassParsing(classStartToken)) {
                block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
                return;
            }
        }
        this.parser.getTypeParser().tryParseTypeParameterList();
        this.parseReferencesList();
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        } else {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                    break;
                }
                this.parseClassMember();
            }
            this.builder.advanceLexer();
        }
        block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
        block.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public boolean canProceedClassParsing(@Nullable IElementType elementType) {
        return elementType == JSTokenTypes.EXTENDS_KEYWORD || elementType == JSTokenTypes.LBRACE;
    }

    protected boolean isPossibleClassName(@Nullable IElementType firstElement, boolean mayOmitName) {
        return this.isIdentifierToken(firstElement);
    }

    protected void parseReferencesList() {
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
        if (this.builder.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
            this.parseReferenceList(JSElementTypes.IMPLEMENTS_LIST);
        }
    }

    @NotNull
    protected IElementType getClassElementType() {
        return JSElementTypes.CLASS;
    }

    @NotNull
    protected IElementType getClassExpressionElementType() {
        return JSElementTypes.CLASS_EXPRESSION;
    }

    @NotNull
    protected IElementType getClassExtendListElementType() {
        return JSElementTypes.ES6_EXTENDS_LIST;
    }

    protected void parseClassMember() {
        StatementParser statementParser = new ES6Parser(this.builder).getStatementParser();
        statementParser.parseClassMember();
    }

    @NotNull
    protected PsiBuilder.Marker startAttributeListOwner() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        PsiBuilder.Marker marker3 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
        PsiBuilder.Marker modifierListMarker = marker3;
        modifierListMarker.done(this.parser.getFunctionParser().getAttributeListElementType());
        return marker2;
    }

    public final boolean parseExpressionStatement() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker exprStatement = marker;
        if (ExpressionParser.parseExpressionOptional$default(this.parser.getExpressionParser(), false, 1, null)) {
            this.forceCheckForSemicolon();
            exprStatement.done(JSElementTypes.EXPRESSION_STATEMENT);
            exprStatement.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        exprStatement.drop();
        return false;
    }

    protected void parseClassOrInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
            this.parseClassNoMarker(clazz, false, false);
        } else {
            boolean bl;
            boolean bl2 = bl = this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.parseInterfaceNoMarker(clazz);
        }
    }

    protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
        Intrinsics.checkNotNullParameter((Object)decoratorMark, (String)"decoratorMark");
        decoratorMark.drop();
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
        this.builder.advanceLexer();
    }

    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        clazz.drop();
        if (!this.parseExpressionStatement()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            this.builder.advanceLexer();
        }
    }

    public final void parseReferenceList(@NotNull IElementType doneToken) {
        Intrinsics.checkNotNullParameter((Object)doneToken, (String)"doneToken");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker referenceList = marker;
        this.builder.advanceLexer();
        if (this.parseReferenceListMember()) {
            while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (!this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
                } else if (this.parseReferenceListMember()) continue;
                break;
            }
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
        }
        referenceList.done(doneToken);
    }

    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker startRefMember = marker;
        boolean result = this.parser.getTypeParser().parseQualifiedTypeName();
        if (result) {
            startRefMember.done(JSElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            startRefMember.drop();
        }
        return result;
    }

    private final void parseTryStatement() {
        boolean parseResources;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        boolean bl = parseResources = tokenType == JSTokenTypes.LPAR;
        if (parseResources) {
            this.builder.advanceLexer();
            IElementType type = this.builder.getTokenType();
            if (type == JSTokenTypes.CONST_KEYWORD || type == JSTokenTypes.LET_KEYWORD) {
                PsiBuilder.Marker marker2 = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                this.parseVarStatementNoMarker(true, marker2);
            } else {
                this.parser.getExpressionParser().parseExpression();
            }
            IElementType elementType = this.builder.getTokenType();
            if (elementType != JSTokenTypes.RPAR) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rparen", new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
        }
        this.parseBlock();
        while (this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD) {
            this.parseCatchBlock();
        }
        if (!parseResources && this.builder.getTokenType() == JSTokenTypes.FINALLY_KEYWORD) {
            this.builder.advanceLexer();
            this.parseBlock();
        }
        statement.done(JSElementTypes.TRY_STATEMENT);
    }

    private final void parseCatchBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker block = marker;
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.builder.advanceLexer();
            IElementType identifierType = this.builder.getTokenType();
            IElementType parameterElementType = this.parser.getFunctionParser().getParameterType();
            if (this.parser.getFunctionParser().willParseDestructuringAssignment()) {
                this.parser.getExpressionParser().parseDestructuringElement(parameterElementType, false, false);
            } else if (this.isIdentifierToken(identifierType)) {
                PsiBuilder.Marker marker2 = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                PsiBuilder.Marker param = marker2;
                this.builder.advanceLexer();
                if (!this.parser.getTypeParser().tryParseType() && this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                    this.builder.advanceLexer();
                    IElementType iElementType = identifierType;
                    Intrinsics.checkNotNull((Object)iElementType);
                    JavaScriptParserBase.Companion.checkMatches(this.builder, iElementType, "javascript.parser.message.expected.identifier");
                    JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.INSTANCEOF_KEYWORD, "javascript.parser.message.expected.instanceof");
                    JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.identifier");
                }
                param.done(parameterElementType);
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.parameter.name", new Object[0]));
            }
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        this.parseBlock();
        block.done(JSElementTypes.CATCH_BLOCK);
    }

    private final void parseThrowStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.THROW_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        if (!JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            this.parser.getExpressionParser().parseExpression();
            this.checkForSemicolon();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        statement.done(JSElementTypes.THROW_STATEMENT);
    }

    private final void parseSwitchStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SWITCH_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        if (this.checkLParBeforeBlock()) {
            this.parser.getExpressionParser().parseExpression();
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        boolean hadLBrace = JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace");
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.unexpected.end.of.file", new Object[0]));
                statement.done(JSElementTypes.SWITCH_STATEMENT);
                return;
            }
            this.parseCaseOrDefaultClause();
        }
        if (hadLBrace) {
            this.builder.advanceLexer();
        }
        statement.done(JSElementTypes.SWITCH_STATEMENT);
    }

    private final boolean checkLParBeforeBlock() {
        return JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen") || this.builder.getTokenType() != JSTokenTypes.LBRACE;
    }

    private final void parseCaseOrDefaultClause() {
        IElementType token;
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker clause = marker;
        if (firstToken != JSTokenTypes.CASE_KEYWORD && firstToken != JSTokenTypes.DEFAULT_KEYWORD) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.case.or.default", new Object[0]));
        }
        this.builder.advanceLexer();
        if (firstToken == JSTokenTypes.CASE_KEYWORD) {
            this.parser.getExpressionParser().parseExpression();
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        while ((token = this.builder.getTokenType()) != null && token != JSTokenTypes.CASE_KEYWORD && token != JSTokenTypes.DEFAULT_KEYWORD && token != JSTokenTypes.RBRACE) {
            this.parseStatement();
        }
        clause.done(JSElementTypes.CASE_CLAUSE);
    }

    private final void parseWithStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WITH_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        this.parser.getExpressionParser().parseExpression();
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.parseStatement();
        statement.done(JSElementTypes.WITH_STATEMENT);
    }

    private final void parseReturnStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        boolean hasNewLine = JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder);
        if (!hasNewLine) {
            ExpressionParser.parseExpressionOptional$default(this.parser.getExpressionParser(), false, 1, null);
        }
        this.forceCheckForSemicolon();
        statement.done(JSElementTypes.RETURN_STATEMENT);
    }

    private final void parseBreakStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BREAK_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.BREAK_STATEMENT);
    }

    private final void parseContinueStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CONTINUE_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.CONTINUE_STATEMENT);
    }

    private final void parseBreakAndContinue(IElementType elementType) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        if (!JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder) && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        this.forceCheckForSemicolon();
        statement.done(elementType);
    }

    private final void parseIterationStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.DO_KEYWORD) {
            this.parseDoWhileStatement();
        } else if (tokenType == JSTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
        } else if (tokenType == JSTokenTypes.FOR_KEYWORD) {
            this.parseForStatement();
        } else {
            LOG.error("Unknown iteration statement");
        }
    }

    private final void parseForStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        boolean forin = this.parseForLoopHeader();
        this.parseStatement();
        statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
    }

    public boolean parseForLoopHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        this.builder.advanceLexer();
        return this.parseForLoopHeaderCondition();
    }

    protected final boolean parseForLoopHeaderCondition() {
        if (!this.checkLParBeforeBlock()) {
            return false;
        }
        boolean empty2 = false;
        IElementType firstToken = this.builder.getTokenType();
        boolean isUsingDeclaration = this.isUsingDeclaration(true);
        if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(firstToken) || isUsingDeclaration) {
            this.parseVarStatementNoMarker(true, this.startAttributeListOwner());
            empty2 = false;
        } else {
            empty2 = !this.parser.getExpressionParser().parseExpressionOptional(false);
        }
        boolean forInOrOf = false;
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            ExpressionParser.parseExpressionOptional$default(this.parser.getExpressionParser(), false, 1, null);
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.semicolon", new Object[0]));
            }
            ExpressionParser.parseExpressionOptional$default(this.parser.getExpressionParser(), false, 1, null);
        } else if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD || this.builder.getTokenType() == JSTokenTypes.OF_KEYWORD) {
            forInOrOf = true;
            if (empty2) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.left.hand.side.expression.or.variable.declaration", new Object[0]));
            }
            if (isUsingDeclaration && this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.using.not.allowed.in.for-in", new Object[0]));
            }
            this.builder.advanceLexer();
            this.parser.getExpressionParser().parseExpression();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.in.or.semicolon", new Object[0]));
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        return forInOrOf;
    }

    private final void parseWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        if (this.checkLParBeforeBlock()) {
            this.parser.getExpressionParser().parseExpression();
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        this.parseStatement();
        statement.done(JSElementTypes.WHILE_STATEMENT);
    }

    private final void parseDoWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        this.parseStatement();
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.WHILE_KEYWORD, "javascript.parser.message.expected.while.keyword");
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        this.parser.getExpressionParser().parseExpression();
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.checkForSemicolon();
        statement.done(JSElementTypes.DOWHILE_STATEMENT);
    }

    private final void parseIfStatement() {
        int n;
        PsiBuilder.Marker ifStatement;
        List ifMarkers;
        block5: {
            ifMarkers = null;
            while (true) {
                LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
                Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
                this.parseIfStatementHeader();
                this.parseStatement();
                if (this.builder.getTokenType() != JSTokenTypes.ELSE_KEYWORD) break block5;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSTokenTypes.IF_KEYWORD) break;
                if (ifMarkers == null) {
                    ifMarkers = new ArrayList();
                }
                if (ifMarkers.size() < JavaScriptParserBase.MAX_TREE_DEPTH) {
                    ifMarkers.add(ifStatement);
                    continue;
                }
                ifStatement.drop();
            }
            this.parseStatement();
        }
        ifStatement.done(JSElementTypes.IF_STATEMENT);
        if (ifMarkers != null && 0 <= (n = ((Collection)ifMarkers).size() + -1)) {
            do {
                int i = n--;
                ((PsiBuilder.Marker)ifMarkers.get(i)).done(JSElementTypes.IF_STATEMENT);
            } while (0 <= n);
        }
    }

    public final void parseIfStatementHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
        this.builder.advanceLexer();
        if (!this.checkLParBeforeBlock()) {
            return;
        }
        this.parser.getExpressionParser().parseExpression();
        while (this.builder.getTokenType() == JSTokenTypes.OROR || this.builder.getTokenType() == JSTokenTypes.EQEQ) {
            this.builder.advanceLexer();
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected final void parseEmptyStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SEMICOLON);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker statement = marker;
        this.builder.advanceLexer();
        statement.done(JSElementTypes.EMPTY_STATEMENT);
    }

    protected final void parseVarStatementNoMarker(boolean inForInitializationContext, @NotNull PsiBuilder.Marker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        boolean isAwait = JSTokenTypes.AWAIT_KEYWORD == this.builder.getTokenType();
        LOG.assertTrue(JSTokenTypes.VAR_MODIFIERS.contains(this.builder.getTokenType()) || isAwait && JSTokenTypes.USING_KEYWORD == this.builder.lookAhead(1));
        if (this.builder.getUserData(withinInterfaceKey) != null) {
            this.builder.error(JavaScriptParserBundle.message("interface.should.have.no.variable.declarations", new Object[0]));
        }
        this.builder.advanceLexer();
        if (isAwait && this.builder.getTokenType() == JSTokenTypes.USING_KEYWORD) {
            this.builder.advanceLexer();
        }
        this.parseVarList(inForInitializationContext);
        if (!inForInitializationContext) {
            this.forceCheckForSemicolon();
        }
        variable.done(JSElementTypes.VAR_STATEMENT);
        variable.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected final void parseVarList(boolean inForInitializationContext) {
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            this.parseVarDeclaration(this.getVariableElementType(), true, !inForInitializationContext);
        } while (this.builder.getTokenType() == JSTokenTypes.COMMA);
    }

    public final boolean checkForSemicolon() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public final void forceCheckForSemicolon() {
        boolean b = this.checkForSemicolon();
        if (!b && !JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.newline.or.semicolon", new Object[0]));
        }
    }

    public final void parseVarDeclaration(@NotNull IElementType varType, boolean allowTypeDeclaration, boolean allowIn) {
        Intrinsics.checkNotNullParameter((Object)varType, (String)"varType");
        if (this.parser.getFunctionParser().willParseDestructuringAssignment()) {
            this.parser.getExpressionParser().parseDestructuringElement(varType, true, false);
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker variable = marker;
        if (!this.parseVarName(variable)) {
            return;
        }
        if (allowTypeDeclaration) {
            this.parser.getTypeParser().tryParseType();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(allowIn);
        }
        variable.done(varType);
        variable.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    public IElementType getVariableElementType() {
        return JSElementTypes.VARIABLE;
    }

    protected boolean parseVarName(@NotNull PsiBuilder.Marker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.variable.name", new Object[0]));
            this.builder.advanceLexer();
            variable.drop();
            return false;
        }
        this.builder.advanceLexer();
        return true;
    }

    protected final void parseVariableInitializer(boolean allowIn) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EQ);
        this.builder.advanceLexer();
        if (!this.parser.getExpressionParser().parseAssignmentExpression(allowIn)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public boolean parseFunctionBody() {
        return this.parseBlock();
    }

    protected final boolean checkIdentifier() {
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        return false;
    }

    protected final boolean checkIdentifierName() {
        IElementType type = this.builder.getTokenType();
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
        return false;
    }

    protected final void parseES6FromDeclaration() {
        if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.from", new Object[0]));
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        if (!JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.string.literal", new Object[0]));
            marker2.done(JSElementTypes.FROM_CLAUSE);
            return;
        }
        String string = this.builder.getTokenText();
        Intrinsics.checkNotNull((Object)string);
        String literalError = ExpressionParser.Companion.validateLiteralText(string);
        this.builder.advanceLexer();
        if (literalError != null) {
            this.builder.error(literalError);
        }
        marker2.done(JSElementTypes.FROM_CLAUSE);
    }

    private final void parseWithClause() {
        if (JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            return;
        }
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.ASSERT_KEYWORD && firstToken != JSTokenTypes.WITH_KEYWORD) {
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker withClause = marker;
        this.builder.advanceLexer();
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            withClause.done(JSElementTypes.WITH_CLAUSE);
            return;
        }
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            PsiBuilder.Marker withEntry;
            Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
            IElementType assertionKey = this.builder.getTokenType();
            if (assertionKey != JSTokenTypes.STRING_LITERAL && !this.parser.isIdentifierName(assertionKey)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.rbrace", new Object[0]));
                withEntry.done(JSElementTypes.WITH_ENTRY);
                break;
            }
            this.builder.advanceLexer();
            if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon")) {
                withEntry.done(JSElementTypes.WITH_ENTRY);
                break;
            }
            if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.STRING_LITERAL, "javascript.parser.message.expected.string.literal")) {
                withEntry.done(JSElementTypes.WITH_ENTRY);
                break;
            }
            withEntry.done(JSElementTypes.WITH_ENTRY);
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        withClause.done(JSElementTypes.WITH_CLAUSE);
    }

    protected boolean tryParseES6ExportStatement() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        return this.tryParseES6ExportStatement(marker);
    }

    protected final boolean tryParseES6ExportStatement(@NotNull PsiBuilder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        IElementType lookAhead = this.builder.lookAhead(1);
        boolean parseTypeExports = this.shouldParseTypeExports(lookAhead);
        if (parseTypeExports) {
            lookAhead = this.builder.lookAhead(2);
        }
        if (lookAhead == JSTokenTypes.MULT || lookAhead == JSTokenTypes.LBRACE || this.isExportDefaultBinding()) {
            this.builder.advanceLexer();
            if (parseTypeExports) {
                this.builder.advanceLexer();
            }
            this.parseES6ExportDeclarationBody(marker);
            return true;
        }
        if (lookAhead == JSTokenTypes.DEFAULT_KEYWORD) {
            this.parseES6ExportDefaultAssignmentNoMarker(marker);
            return true;
        }
        marker.drop();
        return false;
    }

    protected boolean isExportDefaultBinding() {
        IElementType identifier = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(identifier) && identifier != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        IElementType lookAhead = this.builder.lookAhead(2);
        return lookAhead == JSTokenTypes.FROM_KEYWORD || lookAhead == JSTokenTypes.COMMA;
    }

    protected void parseES6ImportStatement() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        boolean needError = false;
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            needError = false;
            String string = this.builder.getTokenText();
            Intrinsics.checkNotNull((Object)string);
            String literalError = ExpressionParser.Companion.validateLiteralText(string);
            this.builder.advanceLexer();
            if (literalError != null) {
                this.builder.error(literalError);
            }
            this.parseWithClause();
        } else {
            if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD || !JSTokenTypes.STRING_LITERALS.contains(this.builder.lookAhead(1))) {
                needError = !this.parseES6ImportClause();
            } else {
                needError = false;
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.import.value", new Object[0]));
            }
            this.parseES6FromDeclaration();
            this.parseWithClause();
        }
        if (needError) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.lbrace", new Object[0]));
        }
        this.forceCheckForSemicolon();
        marker2.done(JSElementTypes.IMPORT_DECLARATION);
    }

    protected boolean shouldParseTypeExports(@Nullable IElementType type) {
        return false;
    }

    protected boolean shouldParseTypeImports(@Nullable IElementType type) {
        return false;
    }

    protected final boolean parseES6ImportClause() {
        if (this.shouldParseTypeImports(this.builder.getTokenType())) {
            IElementType secondToken = this.builder.lookAhead(1);
            boolean bl = secondToken == JSTokenTypes.FROM_KEYWORD ? this.builder.lookAhead(2) != JSTokenTypes.STRING_LITERAL : secondToken == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE || this.isIdentifierToken(secondToken);
            if (bl) {
                this.builder.advanceLexer();
            }
        } else {
            if (Intrinsics.areEqual((Object)this.builder.getTokenType(), (Object)JSTokenTypes.DEFER_KEYWORD) && Intrinsics.areEqual((Object)this.builder.lookAhead(1), (Object)JSTokenTypes.MULT)) {
                this.builder.advanceLexer();
                this.parseES6NamespaceImport();
                return true;
            }
            if (Intrinsics.areEqual((Object)this.builder.getTokenType(), (Object)JSTokenTypes.SOURCE_KEYWORD) && this.isIdentifierToken(this.builder.lookAhead(1)) && Intrinsics.areEqual((Object)this.builder.lookAhead(2), (Object)JSTokenTypes.FROM_KEYWORD) && Intrinsics.areEqual((Object)this.builder.lookAhead(3), (Object)JSTokenTypes.STRING_LITERAL)) {
                this.builder.advanceLexer();
                this.parseES6ImportedBinding();
                return true;
            }
        }
        boolean parsedAnything = false;
        boolean expectedComma = false;
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            parsedAnything = true;
            this.parseES6ImportedBinding();
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                expectedComma = true;
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE || this.builder.getTokenType() == JSTokenTypes.MULT) {
            parsedAnything = true;
            if (expectedComma) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker list = marker;
                this.parseES6ImportOrExportNamedList(true);
                list.done(JSElementTypes.NAMED_IMPORTS);
            } else {
                this.parseES6NamespaceImport();
            }
        }
        return parsedAnything;
    }

    protected final void parseES6ImportedBinding() {
        LOG.assertTrue(this.isIdentifierToken(this.builder.getTokenType()));
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker importedBinding = marker;
        this.builder.advanceLexer();
        importedBinding.done(JSElementTypes.IMPORTED_BINDING);
    }

    protected final void parseES6NamespaceImport() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MULT);
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker importedBinding = marker;
        this.builder.advanceLexer();
        if (JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.AS_KEYWORD, "javascript.parser.message.expected.as")) {
            this.checkIdentifier();
        }
        importedBinding.done(JSElementTypes.IMPORTED_BINDING);
    }

    protected final void parseES6ImportOrExportNamedList(boolean isImportClause) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        if (!this.tryParseES6ImportOrExportNamedList(isImportClause, false)) {
            marker2.rollbackTo();
            this.tryParseES6ImportOrExportNamedList(isImportClause, true);
        } else {
            marker2.drop();
        }
    }

    private final boolean tryParseES6ImportOrExportNamedList(boolean isImportClause, boolean stopOnFirstError) {
        boolean bl;
        boolean bl2 = bl = this.builder.getTokenType() == JSTokenTypes.LBRACE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.builder.advanceLexer();
        while (true) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.import.specifier", new Object[0]));
                this.builder.advanceLexer();
                continue;
            }
            this.advanceIfAt();
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            if (!this.parseES6ImportOrExportSpecifier(isImportClause, marker, stopOnFirstError)) {
                return false;
            }
            IElementType nextToken = this.builder.getTokenType();
            if (nextToken == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                continue;
            }
            if (nextToken == JSTokenTypes.RBRACE) continue;
            if (stopOnFirstError) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma.or.rbrace", new Object[0]));
                break;
            }
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
        }
        return true;
    }

    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        IElementType firstToken = this.builder.getTokenType();
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken) || firstToken == JSTokenTypes.STRING_LITERAL) {
            boolean aliasRequired;
            boolean bl = aliasRequired = !this.isIdentifierToken(firstToken) && firstToken != JSTokenTypes.DEFAULT_KEYWORD;
            if (stopOnFirstError && aliasRequired && this.builder.lookAhead(1) != JSTokenTypes.AS_KEYWORD) {
                marker.drop();
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                return false;
            }
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
                PsiBuilder.Marker marker2 = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                PsiBuilder.Marker alias = marker2;
                this.builder.advanceLexer();
                this.advanceIfAt();
                if (isImport) {
                    this.checkIdentifier();
                } else if (this.builder.getTokenType() == JSTokenTypes.STRING_LITERAL) {
                    this.builder.advanceLexer();
                } else {
                    this.checkIdentifierName();
                }
                alias.done(isImport ? JSElementTypes.IMPORT_SPECIFIER_ALIAS : JSElementTypes.EXPORT_SPECIFIER_ALIAS);
            } else if (aliasRequired) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.as", new Object[0]));
            }
            marker.done(isImport ? JSElementTypes.IMPORT_SPECIFIER : JSElementTypes.EXPORT_SPECIFIER);
            marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        marker.drop();
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
        return false;
    }

    private final void advanceIfAt() {
        if (this.builder.getTokenType() == JSTokenTypes.AT && JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
    }

    protected final void parseES6ExportDeclarationBody(@NotNull PsiBuilder.Marker exportDeclaration) {
        Intrinsics.checkNotNullParameter((Object)exportDeclaration, (String)"exportDeclaration");
        boolean isFromRequired = false;
        boolean isNextElementRequired = true;
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker exportedDefaultBinding = marker;
            this.builder.advanceLexer();
            exportedDefaultBinding.done(JSElementTypes.EXPORTED_DEFAULT_BINDING);
            isFromRequired = true;
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                isNextElementRequired = false;
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.MULT) {
            isFromRequired = true;
            if (this.isNamespaceExport()) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker namespaceExport = marker;
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.checkIdentifierName();
                namespaceExport.done(JSElementTypes.NAMESPACE_EXPORT);
            } else {
                this.builder.advanceLexer();
            }
        } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.parseES6ImportOrExportNamedList(false);
        } else if (isNextElementRequired) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.mult.or.lbrace", new Object[0]));
        }
        if (isFromRequired || this.builder.getTokenType() == JSTokenTypes.FROM_KEYWORD) {
            this.parseES6FromDeclaration();
            this.parseWithClause();
        }
        this.forceCheckForSemicolon();
        exportDeclaration.done(JSElementTypes.EXPORT_DECLARATION);
    }

    protected final boolean isNamespaceExport() {
        return this.builder.lookAhead(1) == JSTokenTypes.AS_KEYWORD;
    }

    private final void parseES6ExportDefaultAssignmentNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
        this.builder.advanceLexer();
        this.parseES6ExportDefaultAssignmentBody();
        this.forceCheckForSemicolon();
        marker.done(JSElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseES6ExportDefaultAssignmentBody() {
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker classMarker = marker;
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            PsiBuilder.Marker modifierList = marker2;
            modifierList.done(this.parser.getFunctionParser().getAttributeListElementType());
            this.parseClassNoMarker(classMarker, true, true);
        } else if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD) {
            this.parser.getFunctionParser().parseFunctionExpression();
        } else {
            this.parser.getExpressionParser().parseAssignmentExpression(false);
        }
    }

    protected final void parseBlockAndAttachStatementsDirectly() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return;
        }
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                return;
            }
            this.parseStatement();
        }
        this.builder.advanceLexer();
    }

    public boolean parseBlock() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return false;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker block = marker;
        Pair<Integer, Boolean> result = this.findParserPosToParseBlockUntil();
        Integer pos = (Integer)result.first;
        Boolean completeBlocks = (Boolean)result.second;
        Intrinsics.checkNotNull((Object)pos);
        this.builder.rawAdvanceLexer(pos.intValue());
        if (!completeBlocks.booleanValue()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
        }
        IElementType blockElementType = JSBlockStatementElementTypeFactory.Companion.getBlockStatementElementType(this.parser.getLanguage$intellij_javascript_parser(), JSParsingContextUtil.isAsyncContext(this.builder), JSParsingContextUtil.isGeneratorContext(this.builder));
        block.collapse(blockElementType);
        Intrinsics.checkNotNull((Object)completeBlocks);
        return completeBlocks;
    }

    public final void parseBlockBodyDeeply(boolean stopAfterFirstRBrace) {
        int stopAfterOffset;
        int n = stopAfterOffset = stopAfterFirstRBrace ? 0 : Integer.MAX_VALUE;
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        }
        this.builder.advanceLexer();
        Boolean prevIsBlockBodyContext = (Boolean)this.builder.getUserData(IS_BLOCK_BODY_CONTEXT);
        this.builder.putUserData(IS_BLOCK_BODY_CONTEXT, (Object)true);
        boolean rBraceFound = false;
        while (!this.builder.eof()) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                rBraceFound = true;
                if (this.builder.getCurrentOffset() <= stopAfterOffset) continue;
                break;
            }
            this.parseStatement();
        }
        this.builder.putUserData(IS_BLOCK_BODY_CONTEXT, (Object)prevIsBlockBodyContext);
        if (!rBraceFound) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
        }
    }

    private final Pair<Integer, Boolean> findParserPosToParseBlockUntil() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            Pair pair = Pair.pair((Object)0, (Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"pair(...)");
            return pair;
        }
        Ref.IntRef pos = new Ref.IntRef();
        Iterator iterator2 = SequencesKt.iterator((Function2)((Function2)new Function2<SequenceScope<? super IElementType>, Continuation<? super Unit>, Object>(this, pos, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StatementParser<T> this$0;
            final /* synthetic */ Ref.IntRef $pos;
            {
                this.this$0 = $receiver;
                this.$pos = $pos;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        type = this.this$0.builder.rawLookup(this.$pos.element);
lbl7:
                        // 2 sources

                        while (type != null) {
                            var4_5 = this.$pos.element;
                            this.$pos.element = var4_5 + 1;
                            this.L$0 = $this$iterator;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)type);
                            this.label = 1;
                            v0 = $this$iterator.yield((Object)type, (Continuation)this);
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        type = (IElementType)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        type = this.this$0.builder.rawLookup(this.$pos.element);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super IElementType> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean completeBlocks = JSLexerUtil.advanceBlockStatement(iterator2);
        Pair pair = Pair.pair((Object)pos.element, (Object)completeBlocks);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"pair(...)");
        return pair;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StatementParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"within.interface");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        withinInterfaceKey = key;
        Key key2 = Key.create((String)"js.block.body.context");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_BLOCK_BODY_CONTEXT = key2;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.OF_KEYWORD};
        TokenSet tokenSet = TokenSet.andNot((TokenSet)JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET, (TokenSet)TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"andNot(...)");
        USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP = tokenSet;
        iElementTypeArray = new TokenSet[2];
        iElementTypeArray[0] = JSTokenTypes.VAR_MODIFIERS;
        IElementType[] iElementTypeArray2 = new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.CLASS_KEYWORD, JSTokenTypes.ASYNC_KEYWORD, JSTokenTypes.TYPE_KEYWORD, JSTokenTypes.OPAQUE_KEYWORD};
        iElementTypeArray[1] = TokenSet.create((IElementType[])iElementTypeArray2);
        TokenSet tokenSet2 = TokenSet.orSet((TokenSet[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"orSet(...)");
        EXPORTABLE_ELEMENTS_KEYWORDS = tokenSet2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\f8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/parsing/StatementParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "withinInterfaceKey", "Lcom/intellij/openapi/util/Key;", "", "IS_BLOCK_BODY_CONTEXT", "", "USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "EXPORTABLE_ELEMENTS_KEYWORDS", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

