/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSRecursiveNodeVisitor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedDataBuilder;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSAsyncReturnType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualTypeOfImpl;
import com.intellij.lang.javascript.psi.types.JSGeneratorReturnType;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionNodesVisitor
extends JSRecursiveNodeVisitor {
    private final JSFunctionBaseImpl<?> myBase;
    private final JSFunctionCachedDataBuilder myCachedData;
    private final List<? super JSFunction> myNestedFuns;
    private final LinkedHashMap<String, UnqualifiedNamesUsages> myUnqualifiedNamesUsages;
    private final List<Pair<ASTNode, JSExpression>> myEvaluatedReturnTypesContexts;
    private final List<Pair<ASTNode, JSYieldExpression>> myYieldReturnTypesContexts;
    private final List<Pair<ASTNode, JSExpression>> myEvaluatedGeneratorReturnTypesContexts;

    public JSFunctionNodesVisitor(JSFunctionBaseImpl<?> base, JSFunctionCachedDataBuilder cachedData, List<? super JSFunction> nestedFuns) {
        this.myBase = base;
        this.myCachedData = cachedData;
        this.myNestedFuns = nestedFuns;
        this.myEvaluatedReturnTypesContexts = new SmartList();
        this.myEvaluatedGeneratorReturnTypesContexts = new SmartList();
        this.myYieldReturnTypesContexts = new SmartList();
        this.myUnqualifiedNamesUsages = new LinkedHashMap();
    }

    public void appendReturnType(@NotNull ASTNode context, @Nullable JSExpression expression) {
        if (context == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(0);
        }
        this.visitExpressionInReturn(expression);
        this.myEvaluatedReturnTypesContexts.add((Pair<ASTNode, JSExpression>)Pair.create((Object)context, (Object)expression));
    }

    @Override
    public void visitAttributeList(ASTNode node) {
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    @Override
    protected void visitDestructuringParameter(ASTNode node) {
        super.visitElement(node);
    }

    @Override
    public void visitParameter(ASTNode node) {
        ASTNode child = JSParameterImpl.findParameterNameIdentifier(node);
        if (child == null) {
            child = node.getFirstChildNode();
        }
        UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
        nameUsages.hasDeclaredParameter = true;
    }

    @Override
    public void visitVariable(ASTNode node) {
        super.visitVariable(node);
        ASTNode child = JSVariableBaseImpl.findVariableNameIdentifier(node);
        if (child != null) {
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
            nameUsages.hasDeclaredVariable = true;
        }
    }

    @Override
    public void visitReferenceExpression(ASTNode node) {
        ASTNode childNode;
        if (node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS) == null && JSFunctionBaseImpl.isInJS(node) && (childNode = node.getFirstChildNode()) != null && childNode.getTreeNext() == null) {
            String nodeText = childNode.getText();
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(nodeText);
            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(node.getPsi());
            if (access != ReadWriteAccessDetector.Access.Write) {
                nameUsages.hasRead = true;
            }
            if (access != ReadWriteAccessDetector.Access.Read) {
                nameUsages.hasWrite = true;
            }
            return;
        }
        super.visitReferenceExpression(node);
    }

    @Override
    public void visitThisExpression(ASTNode node) {
        this.myCachedData.referencesThis = true;
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
        this.myNestedFuns.add((JSFunction)node.getPsi());
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
        this.myNestedFuns.add((JSFunction)node.getPsi());
        ASTNode child = JSPsiImplUtils.findNameIdentifierOfFunction(node);
        if (child != null) {
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
            nameUsages.hasDeclaredVariable = true;
        }
    }

    @Override
    public void visitFunctionProperty(ASTNode node) {
        this.myNestedFuns.add((JSFunction)node.getPsi());
    }

    @Override
    protected void visitYieldExpression(ASTNode node) {
        if (this.myBase.isGenerator()) {
            JSYieldExpression yieldExpression = (JSYieldExpression)node.getPsi();
            this.visitExpressionInReturn(yieldExpression);
            this.myYieldReturnTypesContexts.add((Pair<ASTNode, JSYieldExpression>)Pair.create((Object)node, (Object)yieldExpression));
        }
        super.visitYieldExpression(node);
    }

    @Override
    public void visitReturnStatement(ASTNode node) {
        List<Pair<ASTNode, JSExpression>> pairs = this.myBase.isGenerator() ? this.myEvaluatedGeneratorReturnTypesContexts : this.myEvaluatedReturnTypesContexts;
        JSExpression expression = ((JSReturnStatement)node.getPsi()).getExpression();
        pairs.add((Pair<ASTNode, JSExpression>)Pair.create((Object)node, (Object)expression));
        this.visitExpressionInReturn(expression);
        super.visitReturnStatement(node);
    }

    private void visitExpressionInReturn(@Nullable JSExpression expression) {
        String text;
        JSExpression invoked;
        if (expression instanceof JSNewExpression && (invoked = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)invoked).getQualifier() == null && (text = invoked.getText()).equals(this.myBase.getName())) {
            UnqualifiedNamesUsages value = this.getOrCreateUnqualifiedNameUsages(text);
            value.isReturnedInNew = true;
        }
    }

    @Nullable
    protected JSType getTypeFromReturnedExpression(@NotNull ASTNode context, @Nullable JSExpression expression) {
        if (context == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(1);
        }
        return JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).getTypeHelper().getTypeForIndexing(expression, context.getPsi());
    }

    private static void addTypeToReturnTypeCollection(@NotNull JSType returnType, @NotNull List<JSType> typeCollection) {
        if (returnType == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(2);
        }
        if (typeCollection == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(3);
        }
        List<JSType> newTypes = JSTypeUtils.addPossibleOption(new HashSet<JSType>(typeCollection), returnType);
        typeCollection.addAll(newTypes);
    }

    @Nullable
    public JSType getReturnTypeFromEvaluated() {
        SmartList returnTypes = new SmartList();
        this.toTypes(this.myEvaluatedReturnTypesContexts).forEach(arg_0 -> JSFunctionNodesVisitor.lambda$getReturnTypeFromEvaluated$0((List)returnTypes, arg_0));
        this.fillYieldReturnTypes((List<JSType>)returnTypes);
        SmartList yieldExpectedTypes = new SmartList();
        this.fillYieldExpectedTypes((List<JSType>)yieldExpectedTypes);
        SmartList generators = new SmartList();
        this.toTypes(this.myEvaluatedGeneratorReturnTypesContexts).forEach(arg_0 -> JSFunctionNodesVisitor.lambda$getReturnTypeFromEvaluated$1((List)generators, arg_0));
        return this.wrapTypeIfNeeded(this.addReturnTypeFromEvaluated((List<JSType>)returnTypes, true), this.addReturnTypeFromEvaluated((List<JSType>)generators, false), JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)yieldExpectedTypes, JSTypeSourceFactory.createTypeSource(this.myBase, true)));
    }

    private void fillYieldExpectedTypes(@NotNull List<JSType> types) {
        if (types == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(4);
        }
        for (Pair<ASTNode, JSYieldExpression> context : this.myYieldReturnTypesContexts) {
            JSYieldExpression expression = (JSYieldExpression)context.second;
            if (expression == null) continue;
            JSContextualTypeOfImpl type = new JSContextualTypeOfImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            JSFunctionNodesVisitor.addTypeToReturnTypeCollection(expression.isIterable() ? new JSIterableComponentTypeImpl(type, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : type, types);
        }
    }

    private void fillYieldReturnTypes(@NotNull List<JSType> returnTypes) {
        if (returnTypes == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(5);
        }
        for (Pair<ASTNode, JSYieldExpression> context : this.myYieldReturnTypesContexts) {
            JSType type;
            ASTNode node = (ASTNode)context.first;
            JSYieldExpression yieldExpression = (JSYieldExpression)context.second;
            JSExpression expression = yieldExpression.getExpression();
            if (expression == null || (type = this.getTypeFromReturnedExpression(node, expression)) == null) continue;
            JSFunctionNodesVisitor.addTypeToReturnTypeCollection(yieldExpression.isIterable() ? new JSIterableComponentTypeImpl(type, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : type, returnTypes);
        }
    }

    @NotNull
    private List<JSType> toTypes(@NotNull List<Pair<ASTNode, JSExpression>> contexts) {
        if (contexts == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.mapNotNull(contexts, el -> this.getTypeFromReturnedExpression((ASTNode)el.first, (JSExpression)el.second));
        if (list == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private JSType wrapTypeIfNeeded(@Nullable JSType type, @Nullable JSType typeForGenerator, @NotNull JSType typeForYield) {
        if (typeForYield == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(8);
        }
        boolean isGenerator = this.myBase.isGenerator();
        boolean isAsync = this.myBase.isAsync();
        if (isAsync && !isGenerator) {
            return new JSAsyncReturnType(JSTypeSourceFactory.createTypeSource(this.myBase, true), type == null ? JSAnyType.get(this.myBase) : type);
        }
        if (isGenerator) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource(this.myBase, true), type, typeForGenerator, typeForYield, isAsync);
        }
        return type;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    protected JSType addReturnTypeFromEvaluated(List<JSType> types, boolean canBeVoid) {
        block10: {
            if (this.myBase.isSetProperty()) {
                return null;
            }
            if (this.myBase.isShorthandArrowFunction()) {
                if (types.isEmpty()) {
                    return null;
                }
                return JSFunctionNodesVisitor.allowLiteralWidening(types.get(0));
            }
            element = this.myBase.getBlock();
            if (element == null) {
                return null;
            }
            statements = element.getStatementListItems();
            if (statements.length == 0 && !DialectDetector.isTypeScript(this.myBase)) {
                return null;
            }
            if (!types.isEmpty() && (this.myBase.isGenerator() || DialectDetector.isTypeScript(this.myBase) || !JSFunctionNodesVisitor.hasImplicitReturnStatement(element))) break block10;
            if (!canBeVoid) {
                return null;
            }
            source = JSTypeSourceFactory.createTypeSource(this.myBase, true);
            if (!types.isEmpty()) ** GOTO lbl-1000
            if (JSFunctionNodesVisitor.getExitPoints(element).allMatch((Predicate<JSStatement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/intellij/lang/javascript/psi/JSStatement;)Z)(JSThrowStatement.class))) {
                v0 /* !! */  = DialectDetector.isTypeScript(this.myBase) && !(this.myBase instanceof JSFunctionExpression) ? new JSVoidType(source, true) : JSNamedTypeFactory.createNeverType(source);
            } else lbl-1000:
            // 2 sources

            {
                v0 /* !! */  = new JSVoidType(source);
            }
            type = v0 /* !! */ ;
            types.add(type);
        }
        if (types.size() == 1) {
            return JSFunctionNodesVisitor.allowLiteralWidening(types.get(0));
        }
        if (ContainerUtil.all(types, (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/intellij/lang/javascript/psi/JSType;)Z)(JSVoidType.class))) {
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        return JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(this.myBase, true), JSFunctionNodesVisitor.convertVoidToUndefined(types));
    }

    @NotNull
    private static List<JSType> convertVoidToUndefined(@NotNull List<JSType> types) {
        if (types == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.map(types, el -> el instanceof JSVoidType ? JSNamedTypeFactory.createUndefinedType(el.getSource()) : el);
        if (list == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static boolean hasImplicitReturnStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(11);
        }
        return JSFunctionNodesVisitor.getExitPoints(element).anyMatch(exitPoint -> !(exitPoint instanceof JSReturnStatement) && !(exitPoint instanceof JSSwitchStatement));
    }

    @NotNull
    private static @NotNull Stream<@NotNull JSStatement> getExitPoints(@NotNull PsiElement element) {
        if (element == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(12);
        }
        if (element instanceof JSBlockStatement) {
            PsiElement lastChild;
            for (lastChild = element.getLastChild(); lastChild != null && !(lastChild instanceof JSStatement); lastChild = lastChild.getPrevSibling()) {
            }
            Stream<JSStatement> stream = lastChild != null ? JSFunctionNodesVisitor.getExitPoints(lastChild) : Stream.of((JSBlockStatement)element);
            if (stream == null) {
                JSFunctionNodesVisitor.$$$reportNull$$$0(13);
            }
            return stream;
        }
        if (element instanceof JSIfStatement) {
            JSStatement then = (JSStatement)((JSIfStatement)element).getThenBranch();
            JSStatement anElse = (JSStatement)((JSIfStatement)element).getElseBranch();
            Stream<JSStatement> thenExitPoints = then != null ? JSFunctionNodesVisitor.getExitPoints((PsiElement)then) : Stream.of((JSIfStatement)element);
            Stream<JSStatement> elseExitPoints = anElse != null ? JSFunctionNodesVisitor.getExitPoints((PsiElement)anElse) : Stream.of((JSIfStatement)element);
            Stream<JSStatement> stream = Stream.concat(thenExitPoints, elseExitPoints);
            if (stream == null) {
                JSFunctionNodesVisitor.$$$reportNull$$$0(14);
            }
            return stream;
        }
        if (element instanceof JSStatement) {
            Stream<JSStatement> stream = Stream.of((JSStatement)element);
            if (stream == null) {
                JSFunctionNodesVisitor.$$$reportNull$$$0(15);
            }
            return stream;
        }
        Stream<JSStatement> stream = Stream.empty();
        if (stream == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(16);
        }
        return stream;
    }

    private static JSType allowLiteralWidening(JSType type) {
        return type instanceof JSLiteralType ? ((JSLiteralType)type).copyWithAllowWidening(true) : type;
    }

    void summarizeNamesUsages() {
        for (Map.Entry<String, UnqualifiedNamesUsages> entry : this.myUnqualifiedNamesUsages.entrySet()) {
            String name = entry.getKey();
            UnqualifiedNamesUsages namesUsages = entry.getValue();
            if (namesUsages.hasDeclaredParameter) {
                this.myCachedData.declaredParameters.add(name);
            }
            if (namesUsages.hasDeclaredVariable) {
                this.myCachedData.declaredVariableNames.add(name);
            }
            if ((namesUsages.hasRead || namesUsages.hasWrite) && !namesUsages.hasDeclaredVariable && !namesUsages.hasDeclaredParameter) {
                EnumSet<JSFunctionCachedData.ReferenceStatus> currentStatus = this.myCachedData.referencedVariableNames.get(name);
                if (currentStatus == null) {
                    currentStatus = EnumSet.noneOf(JSFunctionCachedData.ReferenceStatus.class);
                    this.myCachedData.referencedVariableNames.put(name, currentStatus);
                }
                if (namesUsages.hasRead) {
                    currentStatus.add(JSFunctionCachedData.ReferenceStatus.Read);
                }
                if (namesUsages.hasWrite) {
                    currentStatus.add(JSFunctionCachedData.ReferenceStatus.Write);
                }
            }
            if (!namesUsages.isReturnedInNew || namesUsages.hasDeclaredParameter || namesUsages.hasDeclaredVariable) continue;
            this.myCachedData.constructorCanBeInvokedWithoutNew = this.myCachedData.referencesThis;
        }
    }

    @NotNull
    private UnqualifiedNamesUsages getOrCreateUnqualifiedNameUsages(@NotNull String name) {
        UnqualifiedNamesUsages value;
        if (name == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(17);
        }
        if ((value = this.myUnqualifiedNamesUsages.get(name)) == null) {
            value = new UnqualifiedNamesUsages();
            this.myUnqualifiedNamesUsages.put(name, value);
        }
        UnqualifiedNamesUsages unqualifiedNamesUsages = value;
        if (unqualifiedNamesUsages == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(18);
        }
        return unqualifiedNamesUsages;
    }

    private static /* synthetic */ void lambda$getReturnTypeFromEvaluated$1(List generators, JSType el) {
        JSFunctionNodesVisitor.addTypeToReturnTypeCollection(el, generators);
    }

    private static /* synthetic */ void lambda$getReturnTypeFromEvaluated$0(List returnTypes, JSType el) {
        JSFunctionNodesVisitor.addTypeToReturnTypeCollection(el, returnTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 13, 14, 15, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCollection";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionNodesVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeForYield";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionNodesVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertVoidToUndefined";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitPoints";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUnqualifiedNameUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendReturnType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromReturnedExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeToReturnTypeCollection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillYieldExpectedTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillYieldReturnTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toTypes";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapTypeIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertVoidToUndefined";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitReturnStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExitPoints";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateUnqualifiedNameUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 13, 14, 15, 16, 18 -> new IllegalStateException(string);
        };
    }

    private static final class UnqualifiedNamesUsages {
        boolean hasDeclaredParameter;
        boolean hasDeclaredVariable;
        boolean hasRead;
        boolean hasWrite;
        boolean isReturnedInNew;

        private UnqualifiedNamesUsages() {
        }
    }
}

