/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSNamespaceProviderStubBasedExpressionType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeInfo {
    public static final JSContextLevel GLOBAL_CONTEXT_LEVEL = new JSContextLevel(new JSTopLevelNamespace(JSTypeSource.EXPLICITLY_DECLARED, false, JSTypeContext.STATIC), 0);
    @NotNull
    public final List<JSContextLevel> myContextLevels;
    @Nullable
    public Collection<JSRecordType> myRecordTypes;
    private boolean myTypeWasProcessed;
    @NotNull
    private final GlobalStatusHint myContextGlobalStatusHint;
    private boolean myForcedUnknownContext;

    public JSTypeInfo(@NotNull GlobalStatusHint contextGlobalStatusHint) {
        if (contextGlobalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(0);
        }
        this.myContextLevels = new ArrayList<JSContextLevel>();
        this.myContextGlobalStatusHint = contextGlobalStatusHint;
        if (contextGlobalStatusHint == GlobalStatusHint.GLOBAL) {
            this.addGlobalType();
        }
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        JSQualifiedName qualifiedName;
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(1);
        }
        if ((qualifiedName = namespace.getQualifiedName()) == null && !(namespace instanceof JSNamespaceProviderStubBasedExpressionType)) {
            if (!namespace.isSourceStrict()) {
                return;
            }
            if (!namespace.isLocal() && !(namespace instanceof JSAnyType)) {
                this.addGlobalType();
            }
            return;
        }
        if (qualifiedName != null && BaseJSSymbolProcessor.canBeResolvedToUnqualified(qualifiedName, namespace.getJSContext())) {
            this.addGlobalType();
        }
        int relativeLevel = this.getRelativeLevel(isTopClassInHierarchy, qualifiedName);
        ProcessingContext context = new ProcessingContext();
        for (int i = 0; i < this.myContextLevels.size(); ++i) {
            JSContextLevel contextLevel = this.myContextLevels.get(i);
            if (!contextLevel.myNamespace.isEquivalentTo(namespace, context, false)) continue;
            if (relativeLevel < contextLevel.myRelativeLevel) {
                this.myContextLevels.set(i, new JSContextLevel(namespace, relativeLevel));
            }
            return;
        }
        this.myContextLevels.add(new JSContextLevel(namespace, relativeLevel));
    }

    private int getRelativeLevel(boolean isTopClassInHierarchy, @Nullable JSQualifiedName qualifiedName) {
        if (qualifiedName != null && qualifiedName.getParent() == null && JSCommonTypeNames.OBJECT_FUNCTION_CLASS_NAMES.contains(qualifiedName.getName())) {
            return 20;
        }
        return isTopClassInHierarchy || this.myContextLevels.isEmpty() ? 0 : this.myContextLevels.getLast().myRelativeLevel + 1;
    }

    public void addGlobalType() {
        for (JSContextLevel level : this.myContextLevels) {
            if (level != GLOBAL_CONTEXT_LEVEL) continue;
            return;
        }
        this.myContextLevels.add(GLOBAL_CONTEXT_LEVEL);
    }

    public void addBaseObjectType() {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Object", null);
        JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)name, JSContext.INSTANCE, null, false);
        this.myContextLevels.add(new JSContextLevel(namespace, 20));
    }

    public boolean isEmpty() {
        return this.myContextLevels.isEmpty();
    }

    public void setTypeWasProcessed() {
        this.myTypeWasProcessed = true;
    }

    public boolean typeWasProcessed() {
        return !this.myContextLevels.isEmpty() || this.myTypeWasProcessed;
    }

    public boolean hasExplicitNamespace() {
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (contextLevel.myRelativeLevel != 0 || !contextLevel.myNamespace.isSourceStrict()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchedNamespace(@Nullable JSQualifiedName namespace, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSTypeInfo.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            return this.myContextLevels.isEmpty() || this.isGlobalContext();
        }
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (!ComparatorUtil.equalsNullable((Object)namespace, (Object)contextLevel.myNamespace.getQualifiedName()) || !jsContext.isCompatibleWith(contextLevel.myNamespace.getJSContext())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<JSRecordType> getRecordTypes() {
        Collection<Object> collection = this.myRecordTypes != null ? this.myRecordTypes : Collections.emptyList();
        if (collection == null) {
            JSTypeInfo.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void addRecordType(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeInfo.$$$reportNull$$$0(4);
        }
        if (this.myRecordTypes == null) {
            this.myRecordTypes = new SmartList();
        }
        this.myRecordTypes.add(recordType);
    }

    public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(5);
        }
        this.addType(namespace, isTopClassInHierarchy);
    }

    public void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(6);
        }
        JSQualifiedNameImpl qualifiedName = StringUtil.isQuotedString((String)type) ? JSQualifiedNameImpl.create(type, null) : JSQualifiedNameImpl.fromNamepath(type);
        JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)qualifiedName, staticOrInstance, null, isExplicitlyDeclared);
        this.addNamespace(namespace, isTopClassInHierarchy);
    }

    public void buildIndexListFromQNameAndCorrectQName(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(7);
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, true);
    }

    public void buildIndexListFromQNameAndCorrectQName(@NotNull String type) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(8);
        }
        this.buildIndexListFromQNameAndCorrectQName(type, false, JSContext.UNKNOWN);
    }

    void addAllParentScopes(@NotNull String qName) {
        if (qName == null) {
            JSTypeInfo.$$$reportNull$$$0(9);
        }
        int lastIndexOfDot = qName.length();
        while (lastIndexOfDot > 0) {
            qName = qName.substring(0, lastIndexOfDot);
            this.buildIndexListFromQNameAndCorrectQName(qName);
            lastIndexOfDot = qName.lastIndexOf(".");
        }
        this.addGlobalType();
    }

    public boolean isGlobalContext() {
        return this.getContextGlobalStatusHint() == GlobalStatusHint.GLOBAL;
    }

    public boolean isNonGlobalContext() {
        return this.getGlobalStatusHint() == GlobalStatusHint.NONGLOBAL;
    }

    @NotNull
    private GlobalStatusHint getGlobalStatusHint() {
        if (this.myForcedUnknownContext) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(10);
            }
            return globalStatusHint;
        }
        boolean onlyGlobal = true;
        boolean onlyNonGlobal = true;
        boolean hasGlobal = false;
        boolean hasNonGlobal = false;
        for (JSContextLevel level : this.myContextLevels) {
            GlobalStatusHint contextLevelHint = JSTypeInfo.getContextLevelGlobalStatusHint(level);
            onlyGlobal &= contextLevelHint == GlobalStatusHint.GLOBAL;
            onlyNonGlobal &= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            hasGlobal |= contextLevelHint == GlobalStatusHint.GLOBAL;
            hasNonGlobal |= contextLevelHint == GlobalStatusHint.NONGLOBAL;
        }
        if (onlyGlobal && (hasGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.GLOBAL)) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(11);
            }
            return globalStatusHint;
        }
        if (hasNonGlobal && onlyNonGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.NONGLOBAL && !hasGlobal) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(12);
            }
            return globalStatusHint;
        }
        GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(13);
        }
        return globalStatusHint;
    }

    @NotNull
    public GlobalStatusHint getContextGlobalStatusHint() {
        GlobalStatusHint globalStatusHint = this.myContextGlobalStatusHint;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(14);
        }
        return globalStatusHint;
    }

    private static GlobalStatusHint getContextLevelGlobalStatusHint(@NotNull JSContextLevel level) {
        if (level == null) {
            JSTypeInfo.$$$reportNull$$$0(15);
        }
        if (level == GLOBAL_CONTEXT_LEVEL) {
            return GlobalStatusHint.GLOBAL;
        }
        if (level.myNamespace.hasQualifiedName()) {
            return GlobalStatusHint.NONGLOBAL;
        }
        return GlobalStatusHint.UNKNOWN;
    }

    public void setForcedUnknownContext() {
        this.myForcedUnknownContext = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextGlobalStatusHint";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalStatusHint";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextGlobalStatusHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchedNamespace";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRecordType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildIndexListFromQNameAndCorrectQName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllParentScopes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContextLevelGlobalStatusHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static enum GlobalStatusHint {
        GLOBAL,
        NONGLOBAL,
        UNKNOWN;

    }
}

