/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.css.util.CssClassUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssClassMarker;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolveProcessor
extends JSResolveProcessorBase
implements JSResolveProcessorEx {
    public static final Key<ProcessingOptions> PROCESSING_OPTIONS = Key.create((String)"PROCESSING_OPTIONS");
    private final Set<JSClass> visitedClasses = new HashSet<JSClass>();
    private final Set<JSClass> visitedClassesStatic = new HashSet<JSClass>();
    private boolean toProcessHierarchy;
    private boolean toSkipClassDeclarationOnce;
    private boolean toProcessMembers = true;
    private boolean toProcessActionScriptImplicits = true;
    private boolean myTypeContext;
    private boolean localResolve;
    protected boolean isWalkingUpTree;
    protected final PsiElement place;
    public static final Key<Boolean> skipResolveKey = Key.create((String)"skip.package.local.check");
    private boolean myNeedsAllVariants;
    private boolean myForceImportsForPlace;
    private final List<Integer> inheritedClassesNestingLevelStack = new ArrayList<Integer>();
    public static final PsiScopeProcessor.Event SCOPE_CHANGE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_STARTED = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_FINISHED = new PsiScopeProcessor.Event(){};
    private ProcessingOptions myProcessingOptions = DEFAULT_RESOLVE;
    public static final ProcessingOptions DEFAULT_RESOLVE = new ProcessingOptions(){};
    protected final AccessibilityProcessingHandler accessibilityProcessingHandler;

    public ResolveProcessor(@Nullable String name) {
        this(name, null);
    }

    public ResolveProcessor(@Nullable String name, @Nullable PsiElement _place) {
        super(name);
        ProcessingOptions processingOptionsOverride;
        this.place = _place;
        this.accessibilityProcessingHandler = JSDialectSpecificHandlersFactory.forElement(_place).createAccessibilityProcessingHandler(this.place);
        if (this.place != null && (processingOptionsOverride = (ProcessingOptions)this.place.getContainingFile().getOriginalFile().getUserData(PROCESSING_OPTIONS)) != null) {
            this.setProcessingOptions(processingOptionsOverride);
        }
    }

    public static boolean completeConstructorName(PsiElement place) {
        PsiElement placeParent = place.getParent();
        return placeParent instanceof JSNewExpression && ((JSNewExpression)placeParent).getMethodExpression() == place;
    }

    @Nullable
    public static String getName(PsiElement element) {
        String name;
        if (element instanceof JSNamedElementBase) {
            return ((JSNamedElementBase)element).getName();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttributeValue("name");
        }
        if (element instanceof XmlToken) {
            return element.getText();
        }
        if (element instanceof CssClassMarker && (name = ((PsiNamedElement)element).getName()) != null) {
            return CssClassUtil.kebabToCamelCase((String)name);
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            ResolveProcessor.$$$reportNull$$$0(0);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER) {
            boolean toProcessParent = true;
            if (associated instanceof JSClass && this.toSkipClassDeclarationOnce) {
                toProcessParent = false;
            }
            if (toProcessParent) {
                this.startingParent((PsiElement)associated);
            }
        } else if (event == INHERITED_CLASSES_STARTED) {
            ResultSink resultSink;
            this.accessibilityProcessingHandler.setProcessingInheritedClasses(true);
            ResolveProcessor resolveProcessor = this;
            if (resolveProcessor instanceof SinkResolveProcessor) {
                SinkResolveProcessor sinkResolveProcessor = (SinkResolveProcessor)resolveProcessor;
                resultSink = (ResultSink)sinkResolveProcessor.getResultSink();
            } else {
                resultSink = null;
            }
            ResultSink sink = resultSink;
            this.inheritedClassesNestingLevelStack.add(sink != null ? sink.getNestingLevel() : 0);
            if (sink != null) {
                int n;
                if (associated instanceof Integer) {
                    Integer i = (Integer)associated;
                    n = i;
                } else {
                    n = 1;
                }
                int newLevel = n;
                sink.setNestingLevel(Math.max(sink.getNestingLevel(), newLevel));
            }
        } else if (event == INHERITED_CLASSES_FINISHED) {
            ResolveProcessor resolveProcessor;
            int level = this.inheritedClassesNestingLevelStack.removeLast();
            if (this.inheritedClassesNestingLevelStack.isEmpty()) {
                this.accessibilityProcessingHandler.setProcessingInheritedClasses(false);
            }
            if ((resolveProcessor = this) instanceof SinkResolveProcessor) {
                SinkResolveProcessor sinkResolveProcessor = (SinkResolveProcessor)resolveProcessor;
                ((ResultSink)sinkResolveProcessor.getResultSink()).setNestingLevel(level);
            }
        }
    }

    protected void startingParent(PsiElement associated) {
        this.accessibilityProcessingHandler.startingParent(associated);
    }

    @Override
    public boolean isToProcessHierarchy() {
        return this.toProcessHierarchy;
    }

    @Override
    public void setToProcessHierarchy(boolean toProcessHierarchy) {
        this.toProcessHierarchy = toProcessHierarchy;
    }

    @Override
    public boolean isToProcessActionScriptImplicits() {
        return this.toProcessActionScriptImplicits;
    }

    @Override
    public void setToProcessActionScriptImplicits(boolean toProcessActionScriptImplicits) {
        this.toProcessActionScriptImplicits = toProcessActionScriptImplicits;
    }

    @Override
    public boolean isToSkipClassDeclarationOnce() {
        return this.toSkipClassDeclarationOnce;
    }

    @Override
    public void setToSkipClassDeclarationsOnce(boolean toSkipClassDeclarationOnce) {
        this.toSkipClassDeclarationOnce = toSkipClassDeclarationOnce;
    }

    @Override
    public void setTypeContext(boolean b) {
        this.myTypeContext = b;
    }

    @Override
    public boolean isTypeContext() {
        return this.myTypeContext;
    }

    @Override
    public boolean isToProcessMembers() {
        return this.toProcessMembers;
    }

    @Override
    public void setToProcessMembers(boolean toProcessMembers) {
        this.toProcessMembers = toProcessMembers;
    }

    @Override
    public boolean checkVisited(@NotNull JSClass clazz) {
        if (clazz == null) {
            ResolveProcessor.$$$reportNull$$$0(1);
        }
        Set<JSClass> visited = this.accessibilityProcessingHandler.isProcessStatics() ? this.visitedClassesStatic : this.visitedClasses;
        return !visited.add(clazz);
    }

    @Override
    public boolean isLocalResolve() {
        return this.localResolve;
    }

    @Override
    public boolean setWalkingUpTree(boolean isWalkingUpTree) {
        boolean wasWalkingUpTree = this.isWalkingUpTree;
        this.isWalkingUpTree = isWalkingUpTree;
        return wasWalkingUpTree;
    }

    @Override
    public void setLocalResolve(boolean localResolve) {
        this.localResolve = localResolve;
    }

    public boolean specificallyAskingToResolveQualifiedNames() {
        return false;
    }

    @Override
    public String getQualifiedNameToImport() {
        return null;
    }

    @Override
    public boolean lookingForUseNamespaces() {
        return false;
    }

    @Override
    public boolean isEncounteredDynamicClasses() {
        return false;
    }

    public static void setSkipPackageLocalCheck(PsiElement el, boolean state) {
        el.putUserData(skipResolveKey, (Object)(state ? Boolean.TRUE : null));
    }

    public static boolean toSkipPackageLocalCheck(PsiElement el) {
        return el.getUserData(skipResolveKey) != null;
    }

    public void setNeedsAllVariants() {
        this.myNeedsAllVariants = true;
    }

    @Override
    public boolean needsAllVariants() {
        return this.myNeedsAllVariants || this.specificallyAskingToResolveQualifiedNames();
    }

    @Override
    public boolean isForceImportsForPlace() {
        return this.myForceImportsForPlace;
    }

    public void setForceImportsForPlace(boolean forceImportsForPlace) {
        this.myForceImportsForPlace = forceImportsForPlace;
    }

    @Override
    public boolean needPackages() {
        return this.myProcessingOptions.needPackages();
    }

    @Override
    @NotNull
    public ProcessingOptions getProcessingOptions() {
        ProcessingOptions processingOptions = this.myProcessingOptions;
        if (processingOptions == null) {
            ResolveProcessor.$$$reportNull$$$0(2);
        }
        return processingOptions;
    }

    public void setProcessingOptions(@NotNull ProcessingOptions processingOptions) {
        if (processingOptions == null) {
            ResolveProcessor.$$$reportNull$$$0(3);
        }
        this.myProcessingOptions = processingOptions;
    }

    @NotNull
    public AccessibilityProcessingHandler getAccessibilityProcessingHandler() {
        AccessibilityProcessingHandler accessibilityProcessingHandler = this.accessibilityProcessingHandler;
        if (accessibilityProcessingHandler == null) {
            ResolveProcessor.$$$reportNull$$$0(4);
        }
        return accessibilityProcessingHandler;
    }

    @Override
    public void configureClassScope(@Nullable JSClass clazzOfContext) {
        this.accessibilityProcessingHandler.configureClassScope(clazzOfContext);
    }

    @Override
    public void setAllowUnqualifiedStaticsFromInstance(boolean b) {
        this.accessibilityProcessingHandler.setAllowUnqualifiedStaticsFromInstance(b);
    }

    @Override
    public void setTypeName(String qualifiedName) {
    }

    @Override
    public boolean skipTopLevelItems() {
        assert (this.myName != null || this.place == null);
        return false;
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        assert (this.myName != null || this.place == null);
        return true;
    }

    @Override
    public boolean isProcessStatics() {
        return this.getAccessibilityProcessingHandler().isProcessStatics();
    }

    @Override
    public void setProcessStatics(boolean value) {
        this.getAccessibilityProcessingHandler().setProcessStatics(value);
    }

    @Override
    @Nullable
    public PsiElement getPlace() {
        return this.place;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibilityProcessingHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVisited";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProcessingOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static abstract class ProcessingOptions {
        public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
            if (fun == null) {
                ProcessingOptions.$$$reportNull$$$0(0);
            }
            return lastParent != null && lastParent.getContext() == fun;
        }

        public boolean toProcessFunctionArguments() {
            return true;
        }

        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null && packageStatement == lastParent.getParent();
        }

        public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return false;
        }

        public boolean needPackages() {
            return false;
        }

        @Nullable
        public Condition<JSClass> getFilter() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor$ProcessingOptions", "toProcessFunctionBodyDeclarations"));
        }
    }
}

