/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.module.Module;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemActionUtil {
    public static void executeAction(String actionId, InputEvent e) {
        ExternalSystemActionUtil.executeAction(actionId, "", e);
    }

    public static void executeAction(String actionId, @NotNull String place, InputEvent e) {
        ActionManager actionManager;
        AnAction action2;
        if (place == null) {
            ExternalSystemActionUtil.$$$reportNull$$$0(0);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
            ActionUtil.invokeAction((AnAction)action2, (Component)e.getComponent(), (String)place, (InputEvent)e, null);
        }
    }

    @Nullable
    public static Module getModule(DataContext context) {
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(context);
        return module != null ? module : (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<? extends E> all, Collection<E> selected, Comparator<? super E> comparator) {
        List selection = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<? extends E> sorted = new TreeSet<E>(comparator);
        sorted.addAll(all);
        for (Object e : sorted) {
            chooser.addElement(e, selected.contains(e));
        }
        chooser.selectElements((Collection)selection);
    }

    @NotNull
    public static ExternalTaskExecutionInfo buildTaskInfo(@NotNull TaskData task) {
        if (task == null) {
            ExternalSystemActionUtil.$$$reportNull$$$0(1);
        }
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task.getDescription()));
        settings.setExternalSystemIdString(task.getOwner().toString());
        return new ExternalTaskExecutionInfo(settings, "Run");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTaskInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

