/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerExtension;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerViewImpl;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.AbstractDependencyList;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.AbstractDependencyTree;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.DependencyGroup;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.DependencyList;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.DependencyTree;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.DependencyUiUtilKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.ExternalProjectSelector;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.ScopeItem;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.SearchScopeSelector;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.UiUtilsKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.util.UsagesTree;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.ui.ExternalSystemIconProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTraceUtil;
import com.intellij.openapi.observable.operation.core.OperationUtilKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.BindUtil;
import com.intellij.openapi.observable.util.BindUtilKt;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u008c\u00012\u00020\u0001:\u0004\u008b\u0001\u008c\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u0016J\u0018\u0010b\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010c\u001a\u00020dH\u0016J \u0010b\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\u0019H\u0016J\u001e\u0010b\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020d0\u001bH\u0016J&\u0010b\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020d0\u001b2\u0006\u0010e\u001a\u00020\u0019H\u0016J\u001e\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020_0hH\u0002J\u001e\u0010i\u001a\u0004\u0018\u00010#2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001e0kH\u0002J\u001e\u0010l\u001a\u0004\u0018\u00010\u00172\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e0kH\u0002J\f\u0010m\u001a\b\u0012\u0004\u0012\u00020#0\u001bJ\u0010\u0010n\u001a\u00020_2\u0006\u0010o\u001a\u00020pH\u0016J\b\u0010q\u001a\u00020_H\u0002J\u0018\u0010r\u001a\b\u0012\u0004\u0012\u00020#0\u001b*\b\u0012\u0004\u0012\u00020#0sH\u0002J\b\u0010t\u001a\u00020_H\u0002J\b\u0010u\u001a\u00020_H\u0002J\b\u0010v\u001a\u00020_H\u0002J\b\u0010w\u001a\u00020_H\u0002J\b\u0010x\u001a\u00020_H\u0002J\b\u0010y\u001a\u00020_H\u0002J\b\u0010z\u001a\u00020_H\u0002J\u0016\u0010{\u001a\u00020_2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020_0hH\u0002J0\u0010}\u001a\u00020_\"\u0004\b\u0000\u0010~2\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u0002H~0h2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u0002H~\u0012\u0004\u0012\u00020_0kH\u0002J\u0017\u0010\u0080\u0001\u001a\u00020_2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020_0hH\u0002J\u001b\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00012\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020#0sH\u0002J\u001a\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u00020#0\u0085\u0001*\b\u0012\u0004\u0012\u00020#0sH\u0002J\u0017\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020#0\u001b2\u0006\u0010I\u001a\u00020#H\u0002J\r\u0010\u0087\u0001\u001a\u00020\u0019*\u00020dH\u0002J\u0019\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020!0\u001b*\b\u0012\u0004\u0012\u00020#0sH\u0002J\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010(\u001a\u0004\u0018\u00010\u00172\b\u0010'\u001a\u0004\u0018\u00010\u00178B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.*\u0004\b)\u0010*R+\u0010/\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00198B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b1\u00102\"\u0004\b3\u00104*\u0004\b0\u0010*R7\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b7\u00108\"\u0004\b9\u0010:*\u0004\b6\u0010*R+\u0010;\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@*\u0004\b<\u0010*R+\u0010A\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bC\u0010>\"\u0004\bD\u0010@*\u0004\bB\u0010*R7\u0010E\u001a\b\u0012\u0004\u0012\u00020!0\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0\u001b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bG\u00108\"\u0004\bH\u0010:*\u0004\bF\u0010*R/\u0010I\u001a\u0004\u0018\u00010#2\b\u0010'\u001a\u0004\u0018\u00010#8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bK\u0010L\"\u0004\bM\u0010N*\u0004\bJ\u0010*R+\u0010O\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00198B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bQ\u00102\"\u0004\bR\u00104*\u0004\bP\u0010*R+\u0010S\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00198B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bU\u00102\"\u0004\bV\u00104*\u0004\bT\u0010*R\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00170XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Y\u001a\b\u0012\u0004\u0012\u00020!0ZX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008d\u0001"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerView;", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/Disposable;)V", "iconsProvider", "Lcom/intellij/openapi/externalSystem/ui/ExternalSystemIconProvider;", "contributor", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dependencyLoadingOperation", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "dependencyLoadingProperty", "Lcom/intellij/openapi/observable/properties/ObservableBooleanProperty;", "externalProjectProperty", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "dependencyDataFilterProperty", "", "dependencyScopeFilterProperty", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/util/ScopeItem;", "showDependencyWarningsProperty", "", "showDependencyGroupIdProperty", "dependencyModelProperty", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/util/DependencyGroup;", "dependencyProperty", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "showDependencyTreeProperty", "dependencyEmptyTextProperty", "usagesTitleProperty", "<set-?>", "externalProject", "getExternalProject$delegate", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl;)Ljava/lang/Object;", "getExternalProject", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "setExternalProject", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;)V", "dependencyDataFilter", "getDependencyDataFilter$delegate", "getDependencyDataFilter", "()Ljava/lang/String;", "setDependencyDataFilter", "(Ljava/lang/String;)V", "dependencyScopeFilter", "getDependencyScopeFilter$delegate", "getDependencyScopeFilter", "()Ljava/util/List;", "setDependencyScopeFilter", "(Ljava/util/List;)V", "showDependencyWarnings", "getShowDependencyWarnings$delegate", "getShowDependencyWarnings", "()Z", "setShowDependencyWarnings", "(Z)V", "showDependencyGroupId", "getShowDependencyGroupId$delegate", "getShowDependencyGroupId", "setShowDependencyGroupId", "dependencyModel", "getDependencyModel$delegate", "getDependencyModel", "setDependencyModel", "dependency", "getDependency$delegate", "getDependency", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "setDependency", "(Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;)V", "dependencyEmptyState", "getDependencyEmptyState$delegate", "getDependencyEmptyState", "setDependencyEmptyState", "usagesTitle", "getUsagesTitle$delegate", "getUsagesTitle", "setUsagesTitle", "externalProjects", "Ljava/util/ArrayList;", "dependencyListModel", "Lcom/intellij/ui/CollectionListModel;", "dependencyTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "usagesTreeModel", "setSelectedExternalProject", "", "module", "Lcom/intellij/openapi/module/Module;", "setSelectedDependency", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "scope", "path", "onReady", "Lkotlin/Function0;", "findDependency", "predicate", "Lkotlin/Function1;", "findExternalProject", "getDependencies", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateViewModel", "filterDependencies", "", "updateExternalProjectsModel", "updateScopesModel", "updateDependencyModel", "updateFilteredDependencyModel", "updateDependencyEmptyState", "updateUsagesTitle", "updateUsagesModel", "executeLoadingTaskOnEdt", "onUiThread", "executeLoadingTask", "R", "onBackgroundThread", "whenLoadingOperationCompleted", "buildTree", "Ljavax/swing/tree/DefaultMutableTreeNode;", "dependencies", "collectAllDependencies", "", "getTreePath", "getGroup", "createDependencyGroups", "createComponent", "Ljavax/swing/JComponent;", "DependencyDataComparator", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDependencyAnalyzerViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyAnalyzerViewImpl.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,517:1\n1391#2:518\n1480#2,5:519\n1391#2:524\n1480#2,5:525\n1391#2:530\n1480#2,5:531\n777#2:536\n873#2,2:537\n1586#2:539\n1661#2,3:540\n777#2:543\n873#2,2:544\n777#2:546\n873#2,2:547\n777#2:549\n873#2,2:550\n1391#2:552\n1480#2,5:553\n777#2:559\n873#2,2:560\n1391#2:570\n1480#2,5:571\n1391#2:576\n1480#2,5:577\n1512#2:582\n1538#2,3:583\n1541#2,3:593\n1586#2:600\n1661#2,3:601\n1586#2:604\n1661#2,3:605\n1205#2,2:608\n1282#2,4:610\n1586#2:617\n1661#2,3:618\n1586#2:621\n1661#2,3:622\n1#3:558\n13#4:562\n383#5,7:563\n383#5,7:586\n129#6:596\n158#6,3:597\n173#6,3:614\n*S KotlinDebug\n*F\n+ 1 DependencyAnalyzerViewImpl.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl\n*L\n133#1:518\n133#1:519,5\n134#1:524\n134#1:525,5\n145#1:530\n145#1:531,5\n164#1:536\n164#1:537,2\n165#1:539\n165#1:540,3\n167#1:543\n167#1:544,2\n168#1:546\n168#1:547,2\n169#1:549\n169#1:550,2\n222#1:552\n222#1:553,5\n283#1:559\n283#1:560,2\n306#1:570\n306#1:571,5\n318#1:576\n318#1:577,5\n338#1:582\n338#1:583,3\n338#1:593,3\n113#1:600\n113#1:601,3\n119#1:604\n119#1:605,3\n193#1:608,2\n193#1:610,4\n195#1:617\n195#1:618,3\n243#1:621\n243#1:622,3\n288#1:562\n295#1:563,7\n338#1:586,7\n339#1:596\n339#1:597,3\n194#1:614,3\n*E\n"})
public final class DependencyAnalyzerViewImpl
implements DependencyAnalyzerView {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final ExternalSystemIconProvider iconsProvider;
    @NotNull
    private final DependencyAnalyzerContributor contributor;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final AtomicOperationTrace dependencyLoadingOperation;
    @NotNull
    private final ObservableBooleanProperty dependencyLoadingProperty;
    @NotNull
    private final AtomicProperty<DependencyAnalyzerProject> externalProjectProperty;
    @NotNull
    private final AtomicProperty<String> dependencyDataFilterProperty;
    @NotNull
    private final AtomicProperty<List<ScopeItem>> dependencyScopeFilterProperty;
    @NotNull
    private final AtomicProperty<Boolean> showDependencyWarningsProperty;
    @NotNull
    private final AtomicProperty<Boolean> showDependencyGroupIdProperty;
    @NotNull
    private final AtomicProperty<List<DependencyGroup>> dependencyModelProperty;
    @NotNull
    private final AtomicProperty<DependencyAnalyzerDependency> dependencyProperty;
    @NotNull
    private final AtomicProperty<Boolean> showDependencyTreeProperty;
    @NotNull
    private final AtomicProperty<String> dependencyEmptyTextProperty;
    @NotNull
    private final AtomicProperty<String> usagesTitleProperty;
    @NotNull
    private final ArrayList<DependencyAnalyzerProject> externalProjects;
    @NotNull
    private final CollectionListModel<DependencyGroup> dependencyListModel;
    @NotNull
    private final DefaultTreeModel dependencyTreeModel;
    @NotNull
    private final DefaultTreeModel usagesTreeModel;
    @NotNull
    private static final String SEARCH_HISTORY_PROPERTY = "ExternalSystem.DependencyAnalyzerView.search";
    @NotNull
    private static final String SHOW_GROUP_ID_PROPERTY = "ExternalSystem.DependencyAnalyzerView.showGroupId";
    @NotNull
    private static final String SHOW_AS_TREE_PROPERTY = "ExternalSystem.DependencyAnalyzerView.showAsTree";
    @NotNull
    private static final String SPLIT_VIEW_PROPORTION_PROPERTY = "ExternalSystem.DependencyAnalyzerView.splitProportion";

    public DependencyAnalyzerViewImpl(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.systemId = systemId;
        this.parentDisposable = parentDisposable;
        this.iconsProvider = ExternalSystemIconProvider.Companion.getExtension(this.systemId);
        this.contributor = DependencyAnalyzerExtension.Companion.getExtension(this.systemId).createContributor(this.project, this.parentDisposable);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DependencyAnalyzerView.backgroundExecutor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.backgroundExecutor = executorService;
        this.dependencyLoadingOperation = new AtomicOperationTrace("DA: Dependency loading");
        this.dependencyLoadingProperty = OperationUtilKt.getOperationInProgressProperty((ObservableOperationTrace)((ObservableOperationTrace)this.dependencyLoadingOperation));
        this.externalProjectProperty = new AtomicProperty(null);
        this.dependencyDataFilterProperty = new AtomicProperty((Object)"");
        this.dependencyScopeFilterProperty = new AtomicProperty((Object)CollectionsKt.emptyList());
        this.showDependencyWarningsProperty = new AtomicProperty((Object)false);
        this.showDependencyGroupIdProperty = (AtomicProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)new AtomicProperty((Object)false)), (String)SHOW_GROUP_ID_PROPERTY);
        this.dependencyModelProperty = new AtomicProperty((Object)CollectionsKt.emptyList());
        this.dependencyProperty = new AtomicProperty(null);
        this.showDependencyTreeProperty = (AtomicProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)new AtomicProperty((Object)false)), (String)SHOW_AS_TREE_PROPERTY);
        this.dependencyEmptyTextProperty = new AtomicProperty((Object)"");
        this.usagesTitleProperty = new AtomicProperty((Object)"");
        this.externalProjects = new ArrayList();
        this.dependencyListModel = new CollectionListModel((Object[])new DependencyGroup[0]);
        this.dependencyTreeModel = new DefaultTreeModel(null);
        this.usagesTreeModel = new DefaultTreeModel(null);
        this.externalProjectProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$0(this, arg_0));
        this.externalProjectProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$1(this, arg_0));
        this.dependencyModelProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$2(this, arg_0));
        this.dependencyDataFilterProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$3(this, arg_0));
        this.dependencyScopeFilterProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$4(this, arg_0));
        this.showDependencyWarningsProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$5(this, arg_0));
        this.showDependencyGroupIdProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$6(this, arg_0));
        this.dependencyProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$7(this, arg_0));
        this.dependencyProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$8(this, arg_0));
        this.showDependencyGroupIdProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$9(this, arg_0));
        this.dependencyLoadingProperty.afterChange(arg_0 -> DependencyAnalyzerViewImpl._init_$lambda$10(this, arg_0));
        this.contributor.whenDataChanged((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((DependencyAnalyzerViewImpl)this.receiver).updateViewModel();
            }
        }, this.parentDisposable);
        this.updateViewModel();
    }

    private final DependencyAnalyzerProject getExternalProject() {
        return (DependencyAnalyzerProject)this.externalProjectProperty.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setExternalProject(DependencyAnalyzerProject dependencyAnalyzerProject) {
        this.externalProjectProperty.setValue((Object)this, $$delegatedProperties[0], (Object)dependencyAnalyzerProject);
    }

    private static Object getExternalProject$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.externalProjectProperty;
    }

    private final String getDependencyDataFilter() {
        return (String)this.dependencyDataFilterProperty.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setDependencyDataFilter(String string) {
        this.dependencyDataFilterProperty.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    private static Object getDependencyDataFilter$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.dependencyDataFilterProperty;
    }

    private final List<ScopeItem> getDependencyScopeFilter() {
        return (List)this.dependencyScopeFilterProperty.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setDependencyScopeFilter(List<ScopeItem> list) {
        this.dependencyScopeFilterProperty.setValue((Object)this, $$delegatedProperties[2], list);
    }

    private static Object getDependencyScopeFilter$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.dependencyScopeFilterProperty;
    }

    private final boolean getShowDependencyWarnings() {
        return (Boolean)this.showDependencyWarningsProperty.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setShowDependencyWarnings(boolean bl) {
        this.showDependencyWarningsProperty.setValue((Object)this, $$delegatedProperties[3], (Object)bl);
    }

    private static Object getShowDependencyWarnings$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.showDependencyWarningsProperty;
    }

    private final boolean getShowDependencyGroupId() {
        return (Boolean)this.showDependencyGroupIdProperty.getValue((Object)this, $$delegatedProperties[4]);
    }

    private final void setShowDependencyGroupId(boolean bl) {
        this.showDependencyGroupIdProperty.setValue((Object)this, $$delegatedProperties[4], (Object)bl);
    }

    private static Object getShowDependencyGroupId$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.showDependencyGroupIdProperty;
    }

    private final List<DependencyGroup> getDependencyModel() {
        return (List)this.dependencyModelProperty.getValue((Object)this, $$delegatedProperties[5]);
    }

    private final void setDependencyModel(List<DependencyGroup> list) {
        this.dependencyModelProperty.setValue((Object)this, $$delegatedProperties[5], list);
    }

    private static Object getDependencyModel$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.dependencyModelProperty;
    }

    private final DependencyAnalyzerDependency getDependency() {
        return (DependencyAnalyzerDependency)this.dependencyProperty.getValue((Object)this, $$delegatedProperties[6]);
    }

    private final void setDependency(DependencyAnalyzerDependency dependencyAnalyzerDependency) {
        this.dependencyProperty.setValue((Object)this, $$delegatedProperties[6], (Object)dependencyAnalyzerDependency);
    }

    private static Object getDependency$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.dependencyProperty;
    }

    private final String getDependencyEmptyState() {
        return (String)this.dependencyEmptyTextProperty.getValue((Object)this, $$delegatedProperties[7]);
    }

    private final void setDependencyEmptyState(String string) {
        this.dependencyEmptyTextProperty.setValue((Object)this, $$delegatedProperties[7], (Object)string);
    }

    private static Object getDependencyEmptyState$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.dependencyEmptyTextProperty;
    }

    private final String getUsagesTitle() {
        return (String)this.usagesTitleProperty.getValue((Object)this, $$delegatedProperties[8]);
    }

    private final void setUsagesTitle(String string) {
        this.usagesTitleProperty.setValue((Object)this, $$delegatedProperties[8], (Object)string);
    }

    private static Object getUsagesTitle$delegate(DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl) {
        return dependencyAnalyzerViewImpl.usagesTitleProperty;
    }

    public void setSelectedExternalProject(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.setSelectedExternalProject(module, (Function0<Unit>)((Function0)DependencyAnalyzerViewImpl::setSelectedExternalProject$lambda$0));
    }

    public void setSelectedDependency(@NotNull Module module, @NotNull DependencyAnalyzerDependency.Data data) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setSelectedExternalProject(module, (Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$0(this, data)));
    }

    public void setSelectedDependency(@NotNull Module module, @NotNull DependencyAnalyzerDependency.Data data, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.setSelectedExternalProject(module, (Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$1(this, data, scope)));
    }

    public void setSelectedDependency(@NotNull Module module, @NotNull List<? extends DependencyAnalyzerDependency.Data> path) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.setSelectedExternalProject(module, (Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$2(this, path)));
    }

    public void setSelectedDependency(@NotNull Module module, @NotNull List<? extends DependencyAnalyzerDependency.Data> path, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.setSelectedExternalProject(module, (Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$3(this, scope, path)));
    }

    private final void setSelectedExternalProject(Module module, Function0<Unit> onReady) {
        this.whenLoadingOperationCompleted((Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedExternalProject$lambda$1(this, module, onReady)));
    }

    private final DependencyAnalyzerDependency findDependency(Function1<? super DependencyAnalyzerDependency, Boolean> predicate) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency;
        Collection<Object> collection;
        Iterable list$iv$iv;
        DependencyGroup it;
        Object element$iv$iv;
        Iterator iterator;
        Iterable $this$flatMapTo$iv$iv;
        boolean $i$f$flatMapTo;
        Collection<Object> destination$iv$iv2;
        Iterable $this$flatMap$iv;
        block5: {
            List list = this.dependencyListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            $this$flatMap$iv = list;
            boolean $i$f$flatMap22 = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (DependencyGroup)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getVariances();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable $i$f$flatMap22 = (List)destination$iv$iv2;
            for (Collection<Object> destination$iv$iv2 : $i$f$flatMap22) {
                if (!((Boolean)predicate.invoke((Object)destination$iv$iv2)).booleanValue()) continue;
                collection = destination$iv$iv2;
                break block5;
            }
            collection = null;
        }
        if ((dependencyAnalyzerDependency = (DependencyAnalyzerDependency)collection) == null) {
            Object v3;
            block6: {
                $this$flatMap$iv = this.getDependencyModel();
                boolean $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$flatMapTo = false;
                iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    it = (DependencyGroup)element$iv$iv;
                    boolean bl = false;
                    list$iv$iv = it.getVariances();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv2;
                for (Object e : iterable) {
                    if (!((Boolean)predicate.invoke(e)).booleanValue()) continue;
                    v3 = e;
                    break block6;
                }
                v3 = null;
            }
            dependencyAnalyzerDependency = v3;
        }
        return dependencyAnalyzerDependency;
    }

    private final DependencyAnalyzerProject findExternalProject(Function1<? super DependencyAnalyzerProject, Boolean> predicate) {
        Object v0;
        block1: {
            Iterable iterable = this.externalProjects;
            for (Object t : iterable) {
                if (!((Boolean)predicate.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DependencyAnalyzerDependency> getDependencies() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getDependencyModel();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DependencyGroup it = (DependencyGroup)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getVariances();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(DependencyAnalyzerView.Companion.getVIEW(), (Object)this);
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        sink.set(dataKey, (Object)this.project);
        DataKey<ProjectSystemId> dataKey2 = ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"EXTERNAL_SYSTEM_ID");
        sink.set(dataKey2, (Object)this.systemId);
        DataKey dataKey3 = PlatformCoreDataKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"MODULE");
        DependencyAnalyzerProject dependencyAnalyzerProject = this.getExternalProject();
        sink.set(dataKey3, dependencyAnalyzerProject != null ? dependencyAnalyzerProject.getModule() : null);
    }

    private final void updateViewModel() {
        this.executeLoadingTaskOnEdt((Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.updateViewModel$lambda$0(this)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyAnalyzerDependency> filterDependencies(Iterable<? extends DependencyAnalyzerDependency> $this$filterDependencies) {
        Iterable $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ScopeItem it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        String dependencyDataFilter = this.getDependencyDataFilter();
        Iterable iterable = this.getDependencyScopeFilter();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (ScopeItem)element$iv$iv;
            boolean bl = false;
            if (!it.isSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ScopeItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getScope());
        }
        List dependencyScopeFilter = (List)destination$iv$iv;
        boolean showDependencyWarnings = this.getShowDependencyWarnings();
        Iterable $this$filter$iv2 = $this$filterDependencies;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyAnalyzerDependency dependency = (DependencyAnalyzerDependency)element$iv$iv;
            boolean bl = false;
            String string = DependencyUiUtilKt.getDisplayText(dependency.getData(), this.getShowDependencyGroupId());
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            string = dependencyDataFilter;
            Locale locale2 = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
            String string3 = string.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyAnalyzerDependency dependency = (DependencyAnalyzerDependency)element$iv$iv;
            boolean bl = false;
            if (!dependencyScopeFilter.contains(dependency.getScope())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyAnalyzerDependency dependency = (DependencyAnalyzerDependency)element$iv$iv;
            boolean bl = false;
            if (!(showDependencyWarnings ? DependencyGroup.Companion.getHasWarnings$intellij_platform_externalSystem_impl(dependency) : true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final void updateExternalProjectsModel() {
        this.externalProjects.clear();
        this.executeLoadingTask(() -> DependencyAnalyzerViewImpl.updateExternalProjectsModel$lambda$0(this), arg_0 -> DependencyAnalyzerViewImpl.updateExternalProjectsModel$lambda$1(this, arg_0));
    }

    private final void updateScopesModel() {
        this.executeLoadingTask(() -> DependencyAnalyzerViewImpl.updateScopesModel$lambda$0(this), arg_0 -> DependencyAnalyzerViewImpl.updateScopesModel$lambda$1(this, arg_0));
    }

    private final void updateDependencyModel() {
        this.setDependencyModel(CollectionsKt.emptyList());
        this.executeLoadingTask(() -> DependencyAnalyzerViewImpl.updateDependencyModel$lambda$0(this), arg_0 -> DependencyAnalyzerViewImpl.updateDependencyModel$lambda$1(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFilteredDependencyModel() {
        DependencyAnalyzerDependency dependencyAnalyzerDependency;
        Object v0;
        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl;
        List filteredDependencies;
        block3: {
            void $this$flatMapTo$iv$iv;
            List filteredDependencyGroups = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getDependencyModel()), arg_0 -> DependencyAnalyzerViewImpl.updateFilteredDependencyModel$lambda$0(this, arg_0)), DependencyAnalyzerViewImpl::updateFilteredDependencyModel$lambda$1), DependencyAnalyzerViewImpl::updateFilteredDependencyModel$lambda$2));
            this.dependencyListModel.replaceAll(filteredDependencyGroups);
            Iterable $this$flatMap$iv = filteredDependencyGroups;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DependencyGroup it = (DependencyGroup)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getVariances();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            filteredDependencies = (List)destination$iv$iv;
            this.dependencyTreeModel.setRoot(this.buildTree(filteredDependencies));
            Iterable iterable2 = filteredDependencies;
            dependencyAnalyzerViewImpl = this;
            iterable = iterable2;
            for (Object t : iterable) {
                DependencyAnalyzerDependency it = (DependencyAnalyzerDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)this.getDependency())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((dependencyAnalyzerDependency = (DependencyAnalyzerDependency)v0) == null) {
            dependencyAnalyzerDependency = (DependencyAnalyzerDependency)CollectionsKt.firstOrNull((List)filteredDependencies);
        }
        dependencyAnalyzerViewImpl.setDependency(dependencyAnalyzerDependency);
    }

    private final void updateDependencyEmptyState() {
        String string;
        if (OperationUtilKt.isOperationInProgress((ObservableOperationTrace)((ObservableOperationTrace)this.dependencyLoadingOperation))) {
            string = "";
        } else {
            String string2 = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.resolved.empty", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        this.setDependencyEmptyState(string);
    }

    private final void updateUsagesTitle() {
        String string;
        String text;
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this.getDependency();
        String string2 = dependencyAnalyzerDependency != null && (dependencyAnalyzerDependency = dependencyAnalyzerDependency.getData()) != null ? DependencyUiUtilKt.getDisplayText((DependencyAnalyzerDependency.Data)dependencyAnalyzerDependency, this.getShowDependencyGroupId()) : (text = null);
        if (text == null) {
            string = "";
        } else {
            Object[] objectArray = new Object[]{text};
            String string3 = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.usages.title", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        this.setUsagesTitle(string);
    }

    private final void updateUsagesModel() {
        Iterable dependencies = SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getDependencyModel()), arg_0 -> DependencyAnalyzerViewImpl.updateUsagesModel$lambda$0(this, arg_0)), DependencyAnalyzerViewImpl::updateUsagesModel$lambda$1));
        this.usagesTreeModel.setRoot(this.buildTree(dependencies));
    }

    private final void executeLoadingTaskOnEdt(Function0<Unit> onUiThread) {
        MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)this.dependencyLoadingOperation), null, (int)1, null);
        ActionsKt.runInEdt$default(null, () -> DependencyAnalyzerViewImpl.executeLoadingTaskOnEdt$lambda$0(onUiThread, this), (int)1, null);
    }

    private final <R> void executeLoadingTask(Function0<? extends R> onBackgroundThread, Function1<? super R, Unit> onUiThread) {
        MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)this.dependencyLoadingOperation), null, (int)1, null);
        BackgroundTaskUtil.execute((Executor)this.backgroundExecutor, (Disposable)this.parentDisposable, () -> DependencyAnalyzerViewImpl.executeLoadingTask$lambda$0(onBackgroundThread, onUiThread, this));
    }

    private final void whenLoadingOperationCompleted(Function0<Unit> onUiThread) {
        ObservableOperationTraceUtil.withCompletedOperation((ObservableOperationTrace)((ObservableOperationTrace)this.dependencyLoadingOperation), (Disposable)this.parentDisposable, () -> DependencyAnalyzerViewImpl.whenLoadingOperationCompleted$lambda$0(onUiThread));
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultMutableTreeNode buildTree(Iterable<? extends DependencyAnalyzerDependency> dependencies) {
        Object key$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set<DependencyAnalyzerDependency> dependenciesForTree = this.collectAllDependencies(dependencies);
        if (dependenciesForTree.isEmpty()) {
            return null;
        }
        Iterable iterable = dependenciesForTree;
        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyAnalyzerDependency it = (DependencyAnalyzerDependency)element$iv$iv;
            boolean bl = false;
            if (!(it.getParent() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        DependencyGroup rootDependencyGroup = (DependencyGroup)CollectionsKt.singleOrNull(dependencyAnalyzerViewImpl.createDependencyGroups((List)destination$iv$iv));
        if (rootDependencyGroup == null) {
            String rawTree = CollectionsKt.joinToString$default((Iterable)dependenciesForTree, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DependencyAnalyzerView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot determine root of dependency tree:\n" + rawTree);
            return null;
        }
        LinkedHashMap nodeMap = new LinkedHashMap();
        for (DependencyAnalyzerDependency dependency : dependenciesForTree) {
            Object object;
            void $this$getOrPut$iv;
            DependencyAnalyzerDependency usage;
            if (dependency.getParent() == null) continue;
            Map map = nodeMap;
            key$iv = usage;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List children = (List)object;
            children.add(dependency);
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootDependencyGroup);
        ArrayDeque<DefaultMutableTreeNode> queue = new ArrayDeque<DefaultMutableTreeNode>();
        queue.addLast(rootNode);
        while (!((Collection)queue).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)queue.removeFirst();
            Object object = node.getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.dependency.analyzer.util.DependencyGroup");
            DependencyGroup dependencyGroup = (DependencyGroup)object;
            key$iv = dependencyGroup.getVariances();
            dependencyAnalyzerViewImpl = this;
            boolean $i$f$flatMap = false;
            void value$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DependencyAnalyzerDependency it = (DependencyAnalyzerDependency)element$iv$iv;
                boolean bl = false;
                List list = (List)nodeMap.get(it);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List<DependencyGroup> children = dependencyAnalyzerViewImpl.createDependencyGroups((List)destination$iv$iv2);
            for (DependencyGroup child : children) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                node.add(childNode);
                queue.addLast(childNode);
            }
        }
        return rootNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DependencyAnalyzerDependency> collectAllDependencies(Iterable<? extends DependencyAnalyzerDependency> $this$collectAllDependencies) {
        void $this$flatMapTo$iv$iv;
        Iterable<? extends DependencyAnalyzerDependency> $this$flatMap$iv = $this$collectAllDependencies;
        boolean $i$f$flatMap = false;
        Iterable<? extends DependencyAnalyzerDependency> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DependencyAnalyzerDependency it = (DependencyAnalyzerDependency)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getTreePath(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final List<DependencyAnalyzerDependency> getTreePath(DependencyAnalyzerDependency dependency) {
        ArrayList<DependencyAnalyzerDependency> dependencyPath = new ArrayList<DependencyAnalyzerDependency>();
        for (DependencyAnalyzerDependency current = dependency; current != null; current = current.getParent()) {
            dependencyPath.add(current);
        }
        return dependencyPath;
    }

    private final String getGroup(DependencyAnalyzerDependency.Data $this$getGroup) {
        Object object;
        DependencyAnalyzerDependency.Data data = $this$getGroup;
        if (data instanceof DependencyAnalyzerDependency.Data.Module) {
            object = ((DependencyAnalyzerDependency.Data.Module)$this$getGroup).getName();
        } else if (data instanceof DependencyAnalyzerDependency.Data.Artifact) {
            object = ((DependencyAnalyzerDependency.Data.Artifact)$this$getGroup).getGroupId() + ":" + ((DependencyAnalyzerDependency.Data.Artifact)$this$getGroup).getArtifactId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyGroup> createDependencyGroups(Iterable<? extends DependencyAnalyzerDependency> $this$createDependencyGroups) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Object it;
        Map $this$groupByTo$iv$iv;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> DependencyAnalyzerViewImpl.createDependencyGroups$lambda$1(DependencyAnalyzerViewImpl::createDependencyGroups$lambda$0, arg_0), new DependencyDataComparator(this.getShowDependencyGroupId()));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith($this$createDependencyGroups, comparator);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object t = iterator.next();
            it = (DependencyAnalyzerDependency)t;
            bl = false;
            String key$iv$iv = this.getGroup(it.getData());
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            it = entry;
            Object object = destination$iv$iv;
            bl = false;
            object.add(new DependencyGroup((List)it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final JComponent createComponent() {
        SimpleToolWindowPanel simpleToolWindowPanel;
        JBLoadingPanel jBLoadingPanel;
        AnAction anAction;
        SearchTextField searchTextField;
        ExternalProjectSelector externalProjectSelector = (ExternalProjectSelector)BindUtil.bindEnabled((Component)new ExternalProjectSelector((ObservableMutableProperty<DependencyAnalyzerProject>)((ObservableMutableProperty)this.externalProjectProperty), (List<? extends DependencyAnalyzerProject>)this.externalProjects, this.iconsProvider), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        SearchTextField $this$createComponent_u24lambda_u240 = searchTextField = new SearchTextField(SEARCH_HISTORY_PROPERTY);
        boolean bl = false;
        BindUtil.bind((JTextComponent)((JTextComponent)$this$createComponent_u24lambda_u240.getTextEditor()), (ObservableMutableProperty)((ObservableMutableProperty)this.dependencyDataFilterProperty));
        SearchTextField dataFilterField = (SearchTextField)BindUtil.bindEnabled((Component)((Component)searchTextField), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        SearchScopeSelector scopeFilterSelector = (SearchScopeSelector)BindUtil.bindEnabled((Component)new SearchScopeSelector((ObservableMutableProperty<List<ScopeItem>>)((ObservableMutableProperty)this.dependencyScopeFilterProperty)), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        DefaultActionGroup $this$createComponent_u24lambda_u241 = bl = UiUtilsKt.toggleAction((ObservableMutableProperty<Boolean>)((ObservableMutableProperty)this.showDependencyWarningsProperty));
        boolean bl2 = false;
        $this$createComponent_u24lambda_u241.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.conflicts.show", (Object[])new Object[0]));
        DefaultActionGroup $this$createComponent_u24lambda_u242 = bl;
        boolean bl3 = false;
        $this$createComponent_u24lambda_u242.getTemplatePresentation().setIcon(AllIcons.General.ShowWarning);
        ActionButton dependencyInspectionFilterButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton((AnAction)bl, "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        DefaultActionGroup $this$createComponent_u24lambda_u243 = $this$createComponent_u24lambda_u242 = UiUtilsKt.toggleAction((ObservableMutableProperty<Boolean>)((ObservableMutableProperty)this.showDependencyGroupIdProperty));
        boolean bl4 = false;
        $this$createComponent_u24lambda_u243.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.groupId.show", (Object[])new Object[0]));
        DefaultActionGroup showDependencyGroupIdAction = $this$createComponent_u24lambda_u242;
        $this$createComponent_u24lambda_u243 = new DefaultActionGroup[]{showDependencyGroupIdAction};
        DefaultActionGroup $this$createComponent_u24lambda_u244 = $this$createComponent_u24lambda_u243 = UiUtilsKt.popupActionGroup((AnAction[])$this$createComponent_u24lambda_u243);
        boolean bl5 = false;
        $this$createComponent_u24lambda_u244.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        DefaultActionGroup $this$createComponent_u24lambda_u245 = $this$createComponent_u24lambda_u243;
        boolean bl6 = false;
        $this$createComponent_u24lambda_u245.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.view.options", (Object[])new Object[0]));
        ActionButton viewOptionsButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton((AnAction)$this$createComponent_u24lambda_u243, "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        ObservableProperty reloadNotificationProperty = DependencyAnalyzerViewImpl.Companion.isNotificationVisibleProperty(this.project, this.systemId, this.parentDisposable);
        JLabel projectReloadSeparator = (JLabel)BindUtil.bindVisible((Component)UiUtilsKt.separator(), (ObservableProperty)reloadNotificationProperty);
        AnAction $this$createComponent_u24lambda_u247 = anAction = UiUtilsKt.action((Function1<? super AnActionEvent, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$6(this, arg_0)));
        boolean $i$a$-apply-DependencyAnalyzerViewImpl$createComponent$projectReloadAction$32 = false;
        $this$createComponent_u24lambda_u247.getTemplatePresentation().setIcon(AllIcons.Actions.BuildLoadChanges);
        ActionButton projectReloadAction = (ActionButton)BindUtil.bindVisible((Component)((Component)UiUtilsKt.asActionButton(anAction, "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)reloadNotificationProperty);
        String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.resolved.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JLabel dependencyTitle = UiUtilsKt.label(string);
        CollectionListModel<DependencyGroup> $i$a$-apply-DependencyAnalyzerViewImpl$createComponent$projectReloadAction$32 = this.dependencyListModel;
        Object object = this.showDependencyGroupIdProperty;
        AbstractDependencyList dependencyList2 = (AbstractDependencyList)((Object)BindUtil.bindEnabled((Component)((Component)((Object)(BindUtil.bindEmptyText((ComponentWithEmptyText)((ComponentWithEmptyText)new DependencyList(this, $i$a$-apply-DependencyAnalyzerViewImpl$createComponent$projectReloadAction$32, (AtomicProperty<Boolean>)object){
            final /* synthetic */ DependencyAnalyzerViewImpl this$0;
            {
                this.this$0 = $receiver;
                super((ListModel)$super_call_param$1, (ObservableProperty<Boolean>)((ObservableProperty)$super_call_param$2));
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.this$0);
            }
        }), (ObservableProperty)((ObservableProperty)this.dependencyEmptyTextProperty))).bindDependency((ObservableMutableProperty<DependencyAnalyzerDependency>)((ObservableMutableProperty)this.dependencyProperty)))), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty))));
        object = this.dependencyTreeModel;
        AtomicProperty<Boolean> atomicProperty = this.showDependencyGroupIdProperty;
        AbstractDependencyTree dependencyTree2 = (AbstractDependencyTree)((Object)BindUtil.bindEnabled((Component)((Component)((Object)(BindUtil.bindEmptyText((ComponentWithEmptyText)((ComponentWithEmptyText)new DependencyTree(this, (DefaultTreeModel)object, atomicProperty){
            final /* synthetic */ DependencyAnalyzerViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (ObservableProperty<Boolean>)((ObservableProperty)$super_call_param$2));
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.this$0);
            }
        }), (ObservableProperty)((ObservableProperty)this.dependencyEmptyTextProperty))).bindDependency((ObservableMutableProperty<DependencyAnalyzerDependency>)((ObservableMutableProperty)this.dependencyProperty)))), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty))));
        CardLayoutPanel dependencyPanel = BindUtilKt.bindSelected(UiUtilsKt.cardPanel(arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$8(dependencyTree2, dependencyList2, arg_0)), (ObservableProperty)((ObservableProperty)this.showDependencyTreeProperty));
        JBLoadingPanel $this$createComponent_u24lambda_u249 = jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.parentDisposable, 0, 4, null);
        boolean bl7 = false;
        $this$createComponent_u24lambda_u249.add((Component)dependencyPanel, (Object)"Center");
        JBLoadingPanel $this$createComponent_u24lambda_u2410 = jBLoadingPanel;
        boolean bl8 = false;
        $this$createComponent_u24lambda_u2410.setLoadingText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.dependency.loading", (Object[])new Object[0]));
        JBLoadingPanel dependencyLoadingPanel = BindUtil.bindLoading((JBLoadingPanel)jBLoadingPanel, (ObservableBooleanProperty)this.dependencyLoadingProperty);
        JBLoadingPanel $this$createComponent_u24lambda_u2411 = $this$createComponent_u24lambda_u2410 = UiUtilsKt.toggleAction((ObservableMutableProperty<Boolean>)((ObservableMutableProperty)this.showDependencyTreeProperty));
        boolean bl9 = false;
        $this$createComponent_u24lambda_u2411.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.resolved.tree.show", (Object[])new Object[0]));
        JBLoadingPanel $this$createComponent_u24lambda_u2412 = $this$createComponent_u24lambda_u2410;
        boolean bl10 = false;
        $this$createComponent_u24lambda_u2412.getTemplatePresentation().setIcon(AllIcons.Actions.ShowAsTree);
        ActionButton showDependencyTreeButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton((AnAction)$this$createComponent_u24lambda_u2410, "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        ActionButton expandDependencyTreeButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton(UiUtilsKt.expandTreeAction((JTree)((Object)dependencyTree2)), "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.and((ObservableProperty)((ObservableProperty)this.showDependencyTreeProperty), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty))));
        ActionButton collapseDependencyTreeButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton(UiUtilsKt.collapseTreeAction((JTree)((Object)dependencyTree2)), "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.and((ObservableProperty)((ObservableProperty)this.showDependencyTreeProperty), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty))));
        JLabel usagesTitle = UiUtilsKt.label((ObservableProperty<String>)((ObservableProperty)this.usagesTitleProperty));
        Object object2 = this.usagesTreeModel;
        AtomicProperty<Boolean> atomicProperty2 = this.showDependencyGroupIdProperty;
        Object $this$createComponent_u24lambda_u2413 = object2 = new UsagesTree(this, (DefaultTreeModel)object2, atomicProperty2){
            final /* synthetic */ DependencyAnalyzerViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (ObservableProperty<Boolean>)((ObservableProperty)$super_call_param$2));
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.this$0);
            }
        };
        boolean bl11 = false;
        $this$createComponent_u24lambda_u2413.getEmptyText().setText("");
        createComponent.usagesTree.1 usagesTree2 = (Object)BindUtil.bindEnabled((Component)((Component)object2), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        ActionButton expandUsagesTreeButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton(UiUtilsKt.expandTreeAction((JTree)((Object)usagesTree2)), "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        ActionButton collapseUsagesTreeButton = (ActionButton)BindUtil.bindEnabled((Component)((Component)UiUtilsKt.asActionButton(UiUtilsKt.collapseTreeAction((JTree)((Object)usagesTree2)), "ExternalSystem.DependencyAnalyzerView.ActionPlace")), (ObservableProperty)PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this.dependencyLoadingProperty)));
        SimpleToolWindowPanel it = simpleToolWindowPanel = UiUtilsKt.toolWindowPanel((Function1<? super SimpleToolWindowPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14(externalProjectSelector, dataFilterField, scopeFilterSelector, dependencyInspectionFilterButton, viewOptionsButton, projectReloadSeparator, projectReloadAction, dependencyLoadingPanel, dependencyTitle, showDependencyTreeButton, expandDependencyTreeButton, collapseDependencyTreeButton, usagesTree2, usagesTitle, expandUsagesTreeButton, collapseUsagesTreeButton, arg_0)));
        boolean bl12 = false;
        UiUtils.addPreferredFocusedComponent((JComponent)((JComponent)it), (JComponent)((JComponent)dataFilterField));
        return (JComponent)simpleToolWindowPanel;
    }

    private static final Unit setSelectedExternalProject$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean setSelectedDependency$lambda$0$0(DependencyAnalyzerDependency.Data $data, DependencyAnalyzerDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getData(), (Object)$data);
    }

    private static final Unit setSelectedDependency$lambda$0(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerDependency.Data $data) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this$0.findDependency((Function1<? super DependencyAnalyzerDependency, Boolean>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$0$0($data, arg_0)));
        if (dependencyAnalyzerDependency == null) {
            dependencyAnalyzerDependency = this$0.getDependency();
        }
        this$0.setDependency(dependencyAnalyzerDependency);
        return Unit.INSTANCE;
    }

    private static final boolean setSelectedDependency$lambda$1$0(DependencyAnalyzerDependency.Data $data, String $scope, DependencyAnalyzerDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getData(), (Object)$data) && Intrinsics.areEqual((Object)it.getScope().getName(), (Object)$scope);
    }

    private static final Unit setSelectedDependency$lambda$1(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerDependency.Data $data, String $scope) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this$0.findDependency((Function1<? super DependencyAnalyzerDependency, Boolean>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$1$0($data, $scope, arg_0)));
        if (dependencyAnalyzerDependency == null) {
            dependencyAnalyzerDependency = this$0.getDependency();
        }
        this$0.setDependency(dependencyAnalyzerDependency);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean setSelectedDependency$lambda$2$0(DependencyAnalyzerViewImpl this$0, List $path, DependencyAnalyzerDependency d) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Iterable $this$map$iv = this$0.getTreePath(d);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        return Intrinsics.areEqual((Object)((List)destination$iv$iv), (Object)$path);
    }

    private static final Unit setSelectedDependency$lambda$2(DependencyAnalyzerViewImpl this$0, List $path) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this$0.findDependency((Function1<? super DependencyAnalyzerDependency, Boolean>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$2$0(this$0, $path, arg_0)));
        if (dependencyAnalyzerDependency == null) {
            dependencyAnalyzerDependency = this$0.getDependency();
        }
        this$0.setDependency(dependencyAnalyzerDependency);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean setSelectedDependency$lambda$3$0(String $scope, DependencyAnalyzerViewImpl this$0, List $path, DependencyAnalyzerDependency d) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (!Intrinsics.areEqual((Object)d.getScope().getName(), (Object)$scope)) return false;
        Iterable $this$map$iv = this$0.getTreePath(d);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        if (!Intrinsics.areEqual((Object)((List)destination$iv$iv), (Object)$path)) return false;
        return true;
    }

    private static final Unit setSelectedDependency$lambda$3(DependencyAnalyzerViewImpl this$0, String $scope, List $path) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this$0.findDependency((Function1<? super DependencyAnalyzerDependency, Boolean>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.setSelectedDependency$lambda$3$0($scope, this$0, $path, arg_0)));
        if (dependencyAnalyzerDependency == null) {
            dependencyAnalyzerDependency = this$0.getDependency();
        }
        this$0.setDependency(dependencyAnalyzerDependency);
        return Unit.INSTANCE;
    }

    private static final boolean setSelectedExternalProject$lambda$1$0(Module $module, DependencyAnalyzerProject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getModule(), (Object)$module);
    }

    private static final Unit setSelectedExternalProject$lambda$1$1(Function0 $onReady) {
        $onReady.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit setSelectedExternalProject$lambda$1(DependencyAnalyzerViewImpl this$0, Module $module, Function0 $onReady) {
        DependencyAnalyzerProject dependencyAnalyzerProject = this$0.findExternalProject((Function1<? super DependencyAnalyzerProject, Boolean>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.setSelectedExternalProject$lambda$1$0($module, arg_0)));
        if (dependencyAnalyzerProject == null) {
            dependencyAnalyzerProject = this$0.getExternalProject();
        }
        this$0.setExternalProject(dependencyAnalyzerProject);
        this$0.whenLoadingOperationCompleted((Function0<Unit>)((Function0)() -> DependencyAnalyzerViewImpl.setSelectedExternalProject$lambda$1$1($onReady)));
        return Unit.INSTANCE;
    }

    private static final Unit updateViewModel$lambda$0(DependencyAnalyzerViewImpl this$0) {
        this$0.updateExternalProjectsModel();
        return Unit.INSTANCE;
    }

    private static final List updateExternalProjectsModel$lambda$0(DependencyAnalyzerViewImpl this$0) {
        return this$0.contributor.getProjects();
    }

    private static final Unit updateExternalProjectsModel$lambda$1(DependencyAnalyzerViewImpl this$0, List projects) {
        DependencyAnalyzerProject dependencyAnalyzerProject;
        Object v0;
        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
            this$0.externalProjects.addAll(projects);
            Iterable iterable = this$0.externalProjects;
            dependencyAnalyzerViewImpl = this$0;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                DependencyAnalyzerProject it = (DependencyAnalyzerProject)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)this$0.getExternalProject())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((dependencyAnalyzerProject = (DependencyAnalyzerProject)v0) == null) {
            dependencyAnalyzerProject = (DependencyAnalyzerProject)CollectionsKt.firstOrNull((List)this$0.externalProjects);
        }
        dependencyAnalyzerViewImpl.setExternalProject(dependencyAnalyzerProject);
        return Unit.INSTANCE;
    }

    private static final List updateScopesModel$lambda$0(DependencyAnalyzerViewImpl this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getExternalProject();
                if (object == null) break block2;
                DependencyAnalyzerProject dependencyAnalyzerProject = object;
                DependencyAnalyzerContributor dependencyAnalyzerContributor = this$0.contributor;
                DependencyAnalyzerProject p0 = dependencyAnalyzerProject;
                boolean bl = false;
                List list = dependencyAnalyzerContributor.getDependencyScopes(p0);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateScopesModel$lambda$1(DependencyAnalyzerViewImpl this$0, List scopes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Object $this$all$iv;
        Map scopesIndex;
        Map map;
        Iterator $this$associateTo$iv$iv;
        Object destination$iv$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
            Iterable $this$associate$iv = this$0.getDependencyScopeFilter();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            Iterator iterator = $this$associateTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                map = destination$iv$iv;
                ScopeItem it = (ScopeItem)element$iv$iv;
                boolean bl2 = false;
                it = TuplesKt.to((Object)it.getScope(), (Object)it.isSelected());
                map.put(it.getFirst(), it.getSecond());
            }
            scopesIndex = destination$iv$iv;
            $this$all$iv = scopesIndex;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                $this$associateTo$iv$iv = $this$all$iv.entrySet().iterator();
                while ($this$associateTo$iv$iv.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = $this$associateTo$iv$iv.next();
                    boolean bl3 = false;
                    if (((Boolean)it.getValue()).booleanValue()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean isAny = bl;
        $this$all$iv = scopes;
        DependencyAnalyzerViewImpl dependencyAnalyzerViewImpl = this$0;
        boolean $i$f$map = false;
        $this$associateTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            map = (DependencyAnalyzerDependency.Scope)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl4 = false;
            Boolean bl5 = (Boolean)scopesIndex.get(it);
            object.add(new ScopeItem((DependencyAnalyzerDependency.Scope)it, bl5 != null ? bl5 : isAny));
        }
        dependencyAnalyzerViewImpl.setDependencyScopeFilter((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final List updateDependencyModel$lambda$0(DependencyAnalyzerViewImpl this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getExternalProject();
                if (object == null) break block2;
                DependencyAnalyzerProject dependencyAnalyzerProject = object;
                DependencyAnalyzerContributor dependencyAnalyzerContributor = this$0.contributor;
                DependencyAnalyzerProject p0 = dependencyAnalyzerProject;
                boolean bl = false;
                List list = dependencyAnalyzerContributor.getDependencies(p0);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final Unit updateDependencyModel$lambda$1(DependencyAnalyzerViewImpl this$0, List dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        this$0.setDependencyModel(this$0.createDependencyGroups((Iterable<? extends DependencyAnalyzerDependency>)this$0.collectAllDependencies(dependencies)));
        return Unit.INSTANCE;
    }

    private static final List updateFilteredDependencyModel$lambda$0(DependencyAnalyzerViewImpl this$0, DependencyGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.filterDependencies((Iterable<? extends DependencyAnalyzerDependency>)it.getVariances());
    }

    private static final boolean updateFilteredDependencyModel$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Collection)it).isEmpty();
    }

    private static final DependencyGroup updateFilteredDependencyModel$lambda$2(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DependencyGroup(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean updateUsagesModel$lambda$0(DependencyAnalyzerViewImpl this$0, DependencyGroup group) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Iterable $this$map$iv = group.getVariances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this$0.getDependency();
        return CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)(dependencyAnalyzerDependency != null ? dependencyAnalyzerDependency.getData() : null));
    }

    private static final Iterable updateUsagesModel$lambda$1(DependencyGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVariances();
    }

    private static final Unit executeLoadingTaskOnEdt$lambda$0(Function0 $onUiThread, DependencyAnalyzerViewImpl this$0) {
        $onUiThread.invoke();
        MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)this$0.dependencyLoadingOperation), null, null, (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit executeLoadingTask$lambda$0$0(Function1 $onUiThread, Object $result, DependencyAnalyzerViewImpl this$0) {
        $onUiThread.invoke($result);
        MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)this$0.dependencyLoadingOperation), null, null, (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void executeLoadingTask$lambda$0(Function0 $onBackgroundThread, Function1 $onUiThread, DependencyAnalyzerViewImpl this$0) {
        Object result = $onBackgroundThread.invoke();
        ActionsKt.invokeLater$default(null, () -> DependencyAnalyzerViewImpl.executeLoadingTask$lambda$0$0($onUiThread, result, this$0), (int)1, null);
    }

    private static final Unit whenLoadingOperationCompleted$lambda$0$0(Function0 $onUiThread) {
        $onUiThread.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit whenLoadingOperationCompleted$lambda$0(Function0 $onUiThread) {
        ActionsKt.runInEdt$default(null, () -> DependencyAnalyzerViewImpl.whenLoadingOperationCompleted$lambda$0$0($onUiThread), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final DependencyAnalyzerDependency.Data createDependencyGroups$lambda$0(DependencyAnalyzerDependency it) {
        return it.getData();
    }

    private static final DependencyAnalyzerDependency.Data createDependencyGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (DependencyAnalyzerDependency.Data)$tmp0.invoke(p0);
    }

    private static final Unit createComponent$lambda$14$1$0$0(JLabel $dependencyTitle, ActionButton $showDependencyTreeButton, ActionButton $expandDependencyTreeButton, ActionButton $collapseDependencyTreeButton, BorderLayoutPanel $this$toolbarPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolbarPanel, (String)"$this$toolbarPanel");
        $this$toolbarPanel.addToLeft((Component)$dependencyTitle);
        JComponent[] jComponentArray = new JComponent[]{$showDependencyTreeButton, UiUtilsKt.separator(), $expandDependencyTreeButton, $collapseDependencyTreeButton};
        $this$toolbarPanel.addToRight((Component)UiUtilsKt.horizontalPanel(jComponentArray));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$1$1$0(JLabel $usagesTitle, ActionButton $expandUsagesTreeButton, ActionButton $collapseUsagesTreeButton, BorderLayoutPanel $this$toolbarPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolbarPanel, (String)"$this$toolbarPanel");
        $this$toolbarPanel.addToLeft((Component)$usagesTitle);
        JComponent[] jComponentArray = new JComponent[]{$expandUsagesTreeButton, $collapseUsagesTreeButton};
        $this$toolbarPanel.addToRight((Component)UiUtilsKt.horizontalPanel(jComponentArray));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$1$0(JBLoadingPanel $dependencyLoadingPanel, JLabel $dependencyTitle, ActionButton $showDependencyTreeButton, ActionButton $expandDependencyTreeButton, ActionButton $collapseDependencyTreeButton, SimpleToolWindowPanel $this$toolWindowPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolWindowPanel, (String)"$this$toolWindowPanel");
        $this$toolWindowPanel.setToolbar((JComponent)UiUtilsKt.toolbarPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$1$0$0($dependencyTitle, $showDependencyTreeButton, $expandDependencyTreeButton, $collapseDependencyTreeButton, arg_0))));
        $this$toolWindowPanel.setContent((JComponent)$dependencyLoadingPanel);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$1$1(createComponent.usagesTree.1 $usagesTree, JLabel $usagesTitle, ActionButton $expandUsagesTreeButton, ActionButton $collapseUsagesTreeButton, SimpleToolWindowPanel $this$toolWindowPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolWindowPanel, (String)"$this$toolWindowPanel");
        $this$toolWindowPanel.setToolbar((JComponent)UiUtilsKt.toolbarPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$1$1$0($usagesTitle, $expandUsagesTreeButton, $collapseUsagesTreeButton, arg_0))));
        $this$toolWindowPanel.setContent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)$usagesTree)), (boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$0(ExternalProjectSelector $externalProjectSelector, SearchTextField $dataFilterField, SearchScopeSelector $scopeFilterSelector, ActionButton $dependencyInspectionFilterButton, ActionButton $viewOptionsButton, JLabel $projectReloadSeparator, ActionButton $projectReloadAction, BorderLayoutPanel $this$toolbarPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolbarPanel, (String)"$this$toolbarPanel");
        JComponent[] jComponentArray = new JComponent[]{$externalProjectSelector, $dataFilterField, $scopeFilterSelector, UiUtilsKt.separator(), $dependencyInspectionFilterButton, $viewOptionsButton, $projectReloadSeparator, $projectReloadAction};
        $this$toolbarPanel.addToLeft((Component)UiUtilsKt.horizontalPanel(jComponentArray));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$1(JBLoadingPanel $dependencyLoadingPanel, JLabel $dependencyTitle, ActionButton $showDependencyTreeButton, ActionButton $expandDependencyTreeButton, ActionButton $collapseDependencyTreeButton, createComponent.usagesTree.1 $usagesTree, JLabel $usagesTitle, ActionButton $expandUsagesTreeButton, ActionButton $collapseUsagesTreeButton, OnePixelSplitter $this$horizontalSplitPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$horizontalSplitPanel, (String)"$this$horizontalSplitPanel");
        $this$horizontalSplitPanel.setFirstComponent((JComponent)UiUtilsKt.toolWindowPanel((Function1<? super SimpleToolWindowPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$1$0($dependencyLoadingPanel, $dependencyTitle, $showDependencyTreeButton, $expandDependencyTreeButton, $collapseDependencyTreeButton, arg_0))));
        $this$horizontalSplitPanel.setSecondComponent((JComponent)UiUtilsKt.toolWindowPanel((Function1<? super SimpleToolWindowPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$1$1($usagesTree, $usagesTitle, $expandUsagesTreeButton, $collapseUsagesTreeButton, arg_0))));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6(DependencyAnalyzerViewImpl this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProjectRefreshAction.Manager.INSTANCE.refreshProject(this$0.project);
        return Unit.INSTANCE;
    }

    private static final JComponent createComponent$lambda$8(AbstractDependencyTree $dependencyTree, AbstractDependencyList $dependencyList, boolean it) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)(it ? $dependencyTree : $dependencyList)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    private static final Unit createComponent$lambda$14(ExternalProjectSelector $externalProjectSelector, SearchTextField $dataFilterField, SearchScopeSelector $scopeFilterSelector, ActionButton $dependencyInspectionFilterButton, ActionButton $viewOptionsButton, JLabel $projectReloadSeparator, ActionButton $projectReloadAction, JBLoadingPanel $dependencyLoadingPanel, JLabel $dependencyTitle, ActionButton $showDependencyTreeButton, ActionButton $expandDependencyTreeButton, ActionButton $collapseDependencyTreeButton, createComponent.usagesTree.1 $usagesTree, JLabel $usagesTitle, ActionButton $expandUsagesTreeButton, ActionButton $collapseUsagesTreeButton, SimpleToolWindowPanel $this$toolWindowPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolWindowPanel, (String)"$this$toolWindowPanel");
        $this$toolWindowPanel.setToolbar((JComponent)UiUtilsKt.toolbarPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$0($externalProjectSelector, $dataFilterField, $scopeFilterSelector, $dependencyInspectionFilterButton, $viewOptionsButton, $projectReloadSeparator, $projectReloadAction, arg_0))));
        $this$toolWindowPanel.setContent((JComponent)UiUtilsKt.horizontalSplitPanel(SPLIT_VIEW_PROPORTION_PROPERTY, 0.5f, (Function1<? super OnePixelSplitter, Unit>)((Function1)arg_0 -> DependencyAnalyzerViewImpl.createComponent$lambda$14$1($dependencyLoadingPanel, $dependencyTitle, $showDependencyTreeButton, $expandDependencyTreeButton, $collapseDependencyTreeButton, $usagesTree, $usagesTitle, $expandUsagesTreeButton, $collapseUsagesTreeButton, arg_0))));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerProject it) {
        this$0.updateScopesModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerProject it) {
        this$0.updateDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(DependencyAnalyzerViewImpl this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFilteredDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(DependencyAnalyzerViewImpl this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFilteredDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(DependencyAnalyzerViewImpl this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFilteredDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(DependencyAnalyzerViewImpl this$0, boolean it) {
        this$0.updateFilteredDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(DependencyAnalyzerViewImpl this$0, boolean it) {
        this$0.updateFilteredDependencyModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerDependency it) {
        this$0.updateUsagesTitle();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(DependencyAnalyzerViewImpl this$0, DependencyAnalyzerDependency it) {
        this$0.updateUsagesModel();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(DependencyAnalyzerViewImpl this$0, boolean it) {
        this$0.updateUsagesTitle();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(DependencyAnalyzerViewImpl this$0, boolean it) {
        this$0.updateDependencyEmptyState();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "externalProject", "getExternalProject()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "dependencyDataFilter", "getDependencyDataFilter()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "dependencyScopeFilter", "getDependencyScopeFilter()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "showDependencyWarnings", "getShowDependencyWarnings()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "showDependencyGroupId", "getShowDependencyGroupId()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "dependencyModel", "getDependencyModel()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "dependency", "getDependency()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "dependencyEmptyState", "getDependencyEmptyState()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DependencyAnalyzerViewImpl.class, "usagesTitle", "getUsagesTitle()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$Companion;", "", "<init>", "()V", "SEARCH_HISTORY_PROPERTY", "", "SHOW_GROUP_ID_PROPERTY", "SHOW_AS_TREE_PROPERTY", "SPLIT_VIEW_PROPORTION_PROPERTY", "isNotificationVisibleProperty", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final ObservableProperty<Boolean> isNotificationVisibleProperty(Project project, ProjectSystemId systemId, Disposable parentDisposable) {
            ExternalSystemProjectNotificationAware notificationAware = ExternalSystemProjectNotificationAware.Companion.getInstance(project);
            AtomicProperty property = new AtomicProperty((Object)notificationAware.isNotificationVisible(systemId));
            ApplicationKt.getApplication().getMessageBus().connect(parentDisposable).subscribe(ExternalSystemProjectNotificationAware.TOPIC, (Object)new ExternalSystemProjectNotificationAware.Listener((AtomicProperty<Boolean>)property, notificationAware, systemId){
                final /* synthetic */ AtomicProperty<Boolean> $property;
                final /* synthetic */ ExternalSystemProjectNotificationAware $notificationAware;
                final /* synthetic */ ProjectSystemId $systemId;
                {
                    this.$property = $property;
                    this.$notificationAware = $notificationAware;
                    this.$systemId = $systemId;
                }

                public void onNotificationChanged(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    this.$property.set((Object)this.$notificationAware.isNotificationVisible(this.$systemId));
                }
            });
            return (ObservableProperty)property;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerViewImpl$DependencyDataComparator;", "Ljava/util/Comparator;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "showDependencyGroupId", "", "<init>", "(Z)V", "compare", "", "o1", "o2", "intellij.platform.externalSystem.impl"})
    private static final class DependencyDataComparator
    implements Comparator<DependencyAnalyzerDependency.Data> {
        private final boolean showDependencyGroupId;

        public DependencyDataComparator(boolean showDependencyGroupId) {
            this.showDependencyGroupId = showDependencyGroupId;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int compare(@NotNull DependencyAnalyzerDependency.Data o1, @NotNull DependencyAnalyzerDependency.Data o2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            String text1 = DependencyUiUtilKt.getDisplayText(o1, this.showDependencyGroupId);
            String text2 = DependencyUiUtilKt.getDisplayText(o2, this.showDependencyGroupId);
            DependencyAnalyzerDependency.Data data = o1;
            if (data instanceof DependencyAnalyzerDependency.Data.Module) {
                DependencyAnalyzerDependency.Data data2 = o2;
                if (data2 instanceof DependencyAnalyzerDependency.Data.Module) {
                    n = NaturalComparator.INSTANCE.compare(text1, text2);
                    return n;
                }
                if (!(data2 instanceof DependencyAnalyzerDependency.Data.Artifact)) throw new NoWhenBranchMatchedException();
                return -1;
            }
            if (!(data instanceof DependencyAnalyzerDependency.Data.Artifact)) throw new NoWhenBranchMatchedException();
            DependencyAnalyzerDependency.Data data3 = o2;
            if (data3 instanceof DependencyAnalyzerDependency.Data.Module) {
                return 1;
            }
            if (!(data3 instanceof DependencyAnalyzerDependency.Data.Artifact)) throw new NoWhenBranchMatchedException();
            n = NaturalComparator.INSTANCE.compare(text1, text2);
            return n;
        }
    }
}

