/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.internal;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalExternalProjectInfo
implements ExternalProjectInfo {
    @NotNull
    private final ProjectSystemId projectSystemId;
    @NotNull
    private final String externalProjectPath;
    @Nullable
    private final DataNode<ProjectData> externalProjectStructure;
    private long lastSuccessfulImportTimestamp;
    private long lastImportTimestamp;
    private final String buildNumber;

    public InternalExternalProjectInfo(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath, @Nullable DataNode<ProjectData> externalProjectStructure) {
        if (projectSystemId == null) {
            InternalExternalProjectInfo.$$$reportNull$$$0(0);
        }
        if (externalProjectPath == null) {
            InternalExternalProjectInfo.$$$reportNull$$$0(1);
        }
        this.lastSuccessfulImportTimestamp = -1L;
        this.lastImportTimestamp = -1L;
        this.projectSystemId = projectSystemId;
        this.externalProjectPath = externalProjectPath;
        this.externalProjectStructure = externalProjectStructure;
        this.buildNumber = ApplicationInfo.getInstance().getBuild().asString();
    }

    private InternalExternalProjectInfo() {
        this.lastSuccessfulImportTimestamp = -1L;
        this.lastImportTimestamp = -1L;
        this.projectSystemId = ProjectSystemId.IDE;
        this.externalProjectPath = "";
        this.externalProjectStructure = null;
        this.buildNumber = ApplicationManager.getApplication() == null ? "" : ApplicationInfo.getInstance().getBuild().asString();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.projectSystemId;
        if (projectSystemId == null) {
            InternalExternalProjectInfo.$$$reportNull$$$0(2);
        }
        return projectSystemId;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.externalProjectPath;
        if (string == null) {
            InternalExternalProjectInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getNullSafeExternalProjectPath() {
        return this.externalProjectPath;
    }

    @Nullable
    public DataNode<ProjectData> getExternalProjectStructure() {
        return this.externalProjectStructure;
    }

    public long getLastSuccessfulImportTimestamp() {
        return this.lastSuccessfulImportTimestamp;
    }

    public long getLastImportTimestamp() {
        return this.lastImportTimestamp;
    }

    public void setLastSuccessfulImportTimestamp(long value) {
        this.lastSuccessfulImportTimestamp = value;
    }

    public void setLastImportTimestamp(long value) {
        this.lastImportTimestamp = value;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public ExternalProjectInfo copy() {
        InternalExternalProjectInfo copy = new InternalExternalProjectInfo(this.projectSystemId, this.externalProjectPath, this.externalProjectStructure != null ? this.externalProjectStructure.graphCopy() : null);
        copy.setLastImportTimestamp(this.lastImportTimestamp);
        copy.setLastSuccessfulImportTimestamp(this.lastSuccessfulImportTimestamp);
        return copy;
    }

    public String toString() {
        return "InternalExternalProjectInfo{myProjectSystemId=" + String.valueOf(this.projectSystemId) + ", externalProjectPath='" + this.externalProjectPath + "', externalProjectStructure=" + String.valueOf(this.externalProjectStructure) + ", lastSuccessfulImportTimestamp=" + this.lastSuccessfulImportTimestamp + ", lastImportTimestamp=" + this.lastImportTimestamp + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

