/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.ExternalSystemTaskProgressIndicatorUpdater;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger LOG = Logger.getInstance(AbstractExternalSystemTask.class);
    private final AtomicReference<ExternalSystemTaskState> myState;
    private final AtomicReference<Throwable> myError;
    @NotNull
    private final transient Project myIdeProject;
    @NotNull
    private final ExternalSystemTaskId myId;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectPath;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id, @NotNull ExternalSystemTaskType type, @NotNull Project project, @NotNull String externalProjectPath) {
        if (id == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(2);
        }
        if (externalProjectPath == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(3);
        }
        this.myState = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
        this.myError = new AtomicReference();
        this.myExternalSystemId = id;
        this.myIdeProject = project;
        this.myId = ExternalSystemTaskId.create((ProjectSystemId)id, (ExternalSystemTaskType)type, (Project)this.myIdeProject);
        this.myExternalProjectPath = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(4);
        }
        return projectSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.myId;
        if (externalSystemTaskId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(5);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        ExternalSystemTaskState externalSystemTaskState = this.myState.get();
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(6);
        }
        return externalSystemTaskState;
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(7);
        }
        this.myState.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update2) {
        if (expect == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(8);
        }
        if (update2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(9);
        }
        return this.myState.compareAndSet(expect, update2);
    }

    public Throwable getError() {
        return this.myError.get();
    }

    @NotNull
    public Project getIdeProject() {
        Project project = this.myIdeProject;
        if (project == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.myExternalProjectPath;
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            try {
                ExternalSystemFacadeManager manager = ExternalSystemFacadeManager.getInstance();
                RemoteExternalSystemFacade facade = manager.getFacade(this.myIdeProject, this.myExternalProjectPath, this.myExternalSystemId);
                this.setState(facade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable e) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.myError.set(e);
                if (this.myIdeProject.isDisposed()) break block3;
                LOG.warn(e);
            }
        }
    }

    protected abstract void doExecute() throws Exception;

    protected abstract boolean doCancel() throws Exception;

    public void execute(@NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(12);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(13);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListener listener2 = this.getProgressIndicatorListener(indicator);
        this.execute((ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)listener2));
    }

    public boolean cancel(@NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(14);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(15);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListener listener2 = this.getProgressIndicatorListener(indicator);
        return this.cancel((ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)listener2));
    }

    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(16);
        }
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        try {
            this.addProgressListeners(listeners);
            this.withProcessingManager(() -> this.withExecutionProgressManager((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.withExecutionState((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.doExecute())))));
        }
        catch (CancellationException __) {
            LOG.info(String.format("The execution %s was cancelled", this.myId));
        }
        catch (Exception e) {
            LOG.warn(String.valueOf(this.myId) + ": Task execution failed", (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState currentTaskState;
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(17);
        }
        if ((currentTaskState = this.getState()).isStopped()) {
            return true;
        }
        if (!this.compareAndSetState(currentTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        try {
            this.addProgressListeners(listeners);
            return this.withCancellationProgressManager((ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> this.withCancellationState((ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> this.doCancel()))));
        }
        catch (NotSupportedException e) {
            this.showCancellationFailedNotification(e);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return false;
    }

    private void showCancellationFailedNotification(@NotNull NotSupportedException exception) {
        if (exception == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(18);
        }
        NotificationData notification = new NotificationData(ExternalSystemBundle.message((String)"progress.cancel.failed", (Object[])new Object[0]), exception.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
        notification.setBalloonNotification(true);
        ExternalSystemNotificationManager notificationManager = ExternalSystemNotificationManager.getInstance(this.getIdeProject());
        notificationManager.showNotification(this.getExternalSystemId(), notification);
    }

    private void addProgressListeners(ExternalSystemTaskNotificationListener ... listeners) {
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(19);
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
    }

    private void withProcessingManager(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(20);
        }
        ExternalSystemProcessingManager processingManager = ExternalSystemProcessingManager.getInstance();
        try {
            processingManager.add(this);
            runnable.run();
        }
        finally {
            processingManager.release(this.getId());
        }
    }

    private void withExecutionProgressManager(@NotNull ThrowableRunnable<Exception> runnable) {
        if (runnable == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(21);
        }
        String projectPath = this.myExternalProjectPath;
        ExternalSystemTaskId id = this.myId;
        ExternalSystemProgressNotificationManagerImpl progressManager = ExternalSystemProgressNotificationManagerImpl.getInstanceImpl();
        try {
            progressManager.onStart(projectPath, id);
            runnable.run();
            progressManager.onSuccess(projectPath, id);
        }
        catch (ProcessCanceledException exception) {
            progressManager.onCancel(projectPath, id);
            Throwable cause = exception.getCause();
            if (cause == null || cause instanceof ExternalSystemException) {
                throw exception;
            }
            throw new ProcessCanceledException((Throwable)new ExternalSystemException(cause));
        }
        catch (ExternalSystemException exception) {
            progressManager.onFailure(projectPath, id, (Exception)((Object)exception));
            throw exception;
        }
        catch (Exception exception) {
            progressManager.onFailure(projectPath, id, exception);
            throw new ExternalSystemException((Throwable)exception);
        }
        catch (Throwable throwable) {
            ExternalSystemException exception = new ExternalSystemException(throwable);
            progressManager.onFailure(projectPath, id, (Exception)((Object)exception));
            throw exception;
        }
        finally {
            progressManager.onEnd(projectPath, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withCancellationProgressManager(@NotNull ThrowableComputable<Boolean, Exception> runnable) throws Exception {
        if (runnable == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(22);
        }
        ExternalSystemProgressNotificationManagerImpl progressManager = ExternalSystemProgressNotificationManagerImpl.getInstanceImpl();
        try {
            progressManager.beforeCancel(this.getId());
            boolean bl = (Boolean)runnable.compute();
            return bl;
        }
        finally {
            progressManager.onCancel(this.myExternalProjectPath, this.getId());
        }
    }

    private void withExecutionState(@NotNull ThrowableRunnable<Exception> runnable) throws Exception {
        if (runnable == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(23);
        }
        try {
            runnable.run();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (ProcessCanceledException exception) {
            this.setState(ExternalSystemTaskState.CANCELED);
            this.myError.set(exception);
            throw exception;
        }
        catch (Throwable exception) {
            this.setState(ExternalSystemTaskState.FAILED);
            this.myError.set(exception);
            throw exception;
        }
    }

    private boolean withCancellationState(@NotNull ThrowableComputable<Boolean, Exception> runnable) throws Exception {
        if (runnable == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(24);
        }
        try {
            Boolean isCancelled = (Boolean)runnable.compute();
            if (isCancelled.booleanValue()) {
                this.setState(ExternalSystemTaskState.CANCELED);
            }
            return isCancelled;
        }
        catch (ProcessCanceledException exception) {
            this.setState(ExternalSystemTaskState.CANCELED);
            this.myError.set(exception);
            throw exception;
        }
        catch (Throwable exception) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.myError.set(exception);
            throw exception;
        }
    }

    @NlsContexts.ProgressText
    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        if (text == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(25);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text});
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(26);
        }
        return string;
    }

    public int hashCode() {
        return this.myId.hashCode() + this.myExternalSystemId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalSystemTask task = (AbstractExternalSystemTask)((Object)o);
        return this.myId.equals((Object)task.myId) && this.myExternalSystemId.equals((Object)task.myExternalSystemId);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.myExternalSystemId.getReadableName(), this.myId, this.myState);
    }

    @ApiStatus.Internal
    protected void putUserDataTo(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(27);
        }
        KeyFMap userMap = this.getUserMap();
        for (Key key : userMap.getKeys()) {
            dataHolder.putUserData(key, userMap.get(key));
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected static ExternalSystemTaskNotificationListener wrapWithListener(final @NotNull ExternalSystemProgressNotificationManagerImpl manager) {
        if (manager == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(28);
        }
        return new ExternalSystemTaskNotificationListener(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                manager.onStatusChange(event);
            }

            public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, @NotNull ProcessOutputType processOutputType) {
                if (id == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (processOutputType == null) {
                    1.$$$reportNull$$$0(3);
                }
                manager.onTaskOutput(id, text, processOutputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processOutputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStatusChange";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTaskOutput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private ExternalSystemTaskNotificationListener getProgressIndicatorListener(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(29);
        }
        final ExternalSystemTaskProgressIndicatorUpdater updater = ExternalSystemTaskProgressIndicatorUpdater.getInstanceOrDefault(this.myExternalSystemId);
        return new ExternalSystemTaskNotificationListener(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                updater.updateIndicator(event, indicator, text -> AbstractExternalSystemTask.this.wrapProgressText((String)text));
            }

            public void onEnd(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                if (projectPath == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (id == null) {
                    2.$$$reportNull$$$0(2);
                }
                updater.onTaskEnd(id);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStatusChange";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEnd";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 11, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetState";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showCancellationFailedNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addProgressListeners";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withProcessingManager";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionProgressManager";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withCancellationProgressManager";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionState";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withCancellationState";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProgressIndicatorListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 11, 26 -> new IllegalStateException(string);
        };
    }
}

