/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J-\u0010\u000e\u001a\u00020\u0005*\u00020\r2\u001f\u0010\u000f\u001a\u001b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\b\u0012H\u0002J9\u0010\u0013\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0014\u0018\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00050\u0010H\u0082\bJ0\u0010\u0017\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J2\u0010\u0019\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J=\u0010\u001b\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u001f\u0010\u000f\u001a\u001b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\b\u0012H\u0002J0\u0010\u001c\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J.\u0010\u001e\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u001fH\u0002J(\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0\u0011*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/EncodingConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "<init>", "()V", "onSuccessImport", "", "project", "Lcom/intellij/openapi/project/Project;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "onEncodingBlock", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "on", "T", "name", "", "onBomPolicy", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files;", "onCharset", "Ljava/nio/charset/Charset;", "onMap", "onBoolean", "", "forEachCharsetMapping", "Lkotlin/Function2;", "getCharsetProjectMapping", "Lcom/intellij/openapi/vfs/VirtualFile;", "encodingManager", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEncodingConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncodingConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/EncodingConfigurationHandler\n*L\n1#1,134:1\n58#1,7:135\n58#1,7:142\n58#1,7:149\n58#1,7:156\n*S KotlinDebug\n*F\n+ 1 EncodingConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/EncodingConfigurationHandler\n*L\n66#1:135,7\n79#1:142,7\n92#1:149,7\n94#1:156,7\n*E\n"})
public final class EncodingConfigurationHandler
implements ConfigurationHandler {
    public void onSuccessImport(@NotNull Project project, @Nullable ProjectData projectData, @NotNull IdeModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.onEncodingBlock(configuration, arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0(project, this, arg_0));
    }

    private final void onEncodingBlock(ConfigurationData $this$onEncodingBlock, Function1<? super Map<?, ?>, Unit> action2) {
        Object data = $this$onEncodingBlock.find("encodings");
        if (!(data instanceof Map)) {
            return;
        }
        action2.invoke(data);
    }

    private final /* synthetic */ <T> void on(Map<?, ?> $this$on, String name, Function1<? super T, Unit> action2) {
        boolean $i$f$on = false;
        Object obj = $this$on.get(name);
        if (obj == null) {
            return;
        }
        Object data = obj;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!(data instanceof Object)) {
            RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data.getClass().getName() + " of " + name + " encoding configuration, skipping");
            return;
        }
        action2.invoke(data);
    }

    /*
     * WARNING - void declaration
     */
    private final void onBomPolicy(Map<?, ?> $this$onBomPolicy, String name, Function1<? super EncodingProjectManagerImpl.BOMForNewUTF8Files, Unit> action2) {
        block13: {
            EncodingProjectManagerImpl.BOMForNewUTF8Files bOMForNewUTF8Files;
            Object data$iv;
            block14: {
                void $this$on$iv;
                EncodingConfigurationHandler encodingConfigurationHandler = this;
                Map<?, ?> map = $this$onBomPolicy;
                String name$iv = name;
                boolean $i$f$on = false;
                Object v = $this$on$iv.get(name$iv);
                if (v == null) break block13;
                data$iv = v;
                if (data$iv instanceof String) break block14;
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name$iv + " encoding configuration, skipping");
                break block13;
            }
            String it = (String)data$iv;
            boolean bl = false;
            switch (it) {
                case "WITH_BOM": {
                    bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.ALWAYS;
                    break;
                }
                case "WITH_NO_BOM": {
                    bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.NEVER;
                    break;
                }
                case "WITH_BOM_ON_WINDOWS": {
                    bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.WINDOWS_ONLY;
                    break;
                }
                default: {
                    RunConfigurationHandlerKt.getLOG().warn("unsupported BOM policy " + it + " of encoding configuration, skipping");
                    break block13;
                }
            }
            EncodingProjectManagerImpl.BOMForNewUTF8Files option = bOMForNewUTF8Files;
            action2.invoke((Object)option);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCharset(Map<?, ?> $this$onCharset, String name, Function1<? super Charset, Unit> action2) {
        void $this$on$iv;
        EncodingConfigurationHandler encodingConfigurationHandler = this;
        Map<?, ?> map = $this$onCharset;
        String name$iv = name;
        boolean $i$f$on = false;
        Object v = $this$on$iv.get(name$iv);
        if (v != null) {
            Object data$iv = v;
            if (!(data$iv instanceof String)) {
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name$iv + " encoding configuration, skipping");
            } else {
                String it = (String)data$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)"<System Default>")) {
                    action2.invoke(null);
                } else {
                    Charset charset = CharsetToolkit.forName((String)it);
                    if (charset == null) {
                        RunConfigurationHandlerKt.getLOG().warn("unsupported charset " + it + " of " + name + " encoding configuration, skipping");
                    } else {
                        action2.invoke((Object)charset);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onMap(Map<?, ?> $this$onMap, String name, Function1<? super Map<?, ?>, Unit> action2) {
        void $this$on$iv;
        EncodingConfigurationHandler encodingConfigurationHandler = this;
        Map<?, ?> map = $this$onMap;
        String name$iv = name;
        boolean $i$f$on = false;
        Object v = $this$on$iv.get(name$iv);
        if (v != null) {
            Object data$iv = v;
            if (!(data$iv instanceof Map)) {
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name$iv + " encoding configuration, skipping");
            } else {
                action2.invoke(data$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onBoolean(Map<?, ?> $this$onBoolean, String name, Function1<? super Boolean, Unit> action2) {
        void $this$on$iv;
        EncodingConfigurationHandler encodingConfigurationHandler = this;
        Map<?, ?> map = $this$onBoolean;
        String name$iv = name;
        boolean $i$f$on = false;
        Object v = $this$on$iv.get(name$iv);
        if (v != null) {
            Object data$iv = v;
            if (!(data$iv instanceof Boolean)) {
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name$iv + " encoding configuration, skipping");
            } else {
                action2.invoke(data$iv);
            }
        }
    }

    private final void forEachCharsetMapping(Map<?, ?> $this$forEachCharsetMapping, Function2<? super String, ? super String, Unit> action2) {
        this.onMap($this$forEachCharsetMapping, "mapping", arg_0 -> EncodingConfigurationHandler.forEachCharsetMapping$lambda$0(action2, arg_0));
    }

    private final Map<VirtualFile, Charset> getCharsetProjectMapping(Map<?, ?> $this$getCharsetProjectMapping, EncodingProjectManagerImpl encodingManager) {
        Map map = encodingManager.getAllMappings();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllMappings(...)");
        Map mapping = MapsKt.toMutableMap((Map)map);
        this.forEachCharsetMapping($this$getCharsetProjectMapping, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> EncodingConfigurationHandler.getCharsetProjectMapping$lambda$0(mapping, arg_0, arg_1)));
        return mapping;
    }

    private static final Unit onSuccessImport$lambda$0$0$2$0(EncodingProjectManagerImpl $encodingManager, Charset it) {
        $encodingManager.setDefaultCharsetForPropertiesFiles(null, it);
        return Unit.INSTANCE;
    }

    private static final Unit onSuccessImport$lambda$0$0$2$1(EncodingProjectManagerImpl $encodingManager, boolean it) {
        $encodingManager.setNative2AsciiForPropertiesFiles(null, it);
        return Unit.INSTANCE;
    }

    private static final Unit onSuccessImport$lambda$0$0$0(EncodingProjectManagerImpl $encodingManager, Charset it) {
        Object object = it;
        if (object == null || (object = ((Charset)object).name()) == null) {
            object = "";
        }
        $encodingManager.setDefaultCharsetName((String)object);
        return Unit.INSTANCE;
    }

    private static final Unit onSuccessImport$lambda$0$0$1(EncodingProjectManagerImpl $encodingManager, EncodingProjectManagerImpl.BOMForNewUTF8Files it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $encodingManager.setBOMForNewUtf8Files(it);
        return Unit.INSTANCE;
    }

    private static final Unit onSuccessImport$lambda$0$0$2(EncodingConfigurationHandler this$0, EncodingProjectManagerImpl $encodingManager, Map $this$onMap) {
        Intrinsics.checkNotNullParameter((Object)$this$onMap, (String)"$this$onMap");
        this$0.onCharset($this$onMap, "encoding", (Function1<? super Charset, Unit>)((Function1)arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0$2$0($encodingManager, arg_0)));
        this$0.onBoolean($this$onMap, "transparentNativeToAsciiConversion", (Function1<? super Boolean, Unit>)((Function1)arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0$2$1($encodingManager, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void onSuccessImport$lambda$0$0(EncodingProjectManagerImpl $encodingManager, Map $mapping, EncodingConfigurationHandler this$0, Map $this_onEncodingBlock) {
        $encodingManager.setMapping($mapping);
        this$0.onCharset($this_onEncodingBlock, "encoding", (Function1<? super Charset, Unit>)((Function1)arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0$0($encodingManager, arg_0)));
        this$0.onBomPolicy($this_onEncodingBlock, "bomPolicy", (Function1<? super EncodingProjectManagerImpl.BOMForNewUTF8Files, Unit>)((Function1)arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0$1($encodingManager, arg_0)));
        this$0.onMap($this_onEncodingBlock, "properties", arg_0 -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0$2(this$0, $encodingManager, arg_0));
    }

    private static final Unit onSuccessImport$lambda$0(Project $project, EncodingConfigurationHandler this$0, Map $this$onEncodingBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$onEncodingBlock, (String)"$this$onEncodingBlock");
        EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)$project);
        Intrinsics.checkNotNull((Object)encodingProjectManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)encodingProjectManager;
        Map<VirtualFile, Charset> mapping = this$0.getCharsetProjectMapping($this$onEncodingBlock, encodingManager);
        ApplicationManager.getApplication().invokeAndWait(() -> EncodingConfigurationHandler.onSuccessImport$lambda$0$0(encodingManager, mapping, this$0, $this$onEncodingBlock));
        return Unit.INSTANCE;
    }

    private static final Unit forEachCharsetMapping$lambda$0(Function2 $action, Map $this$onMap) {
        Intrinsics.checkNotNullParameter((Object)$this$onMap, (String)"$this$onMap");
        for (Map.Entry entry : $this$onMap.entrySet()) {
            Object path = entry.getKey();
            Object charsetName = entry.getValue();
            if (!(path instanceof String)) {
                Object object;
                RunConfigurationHandlerKt.getLOG().warn("unexpected path type " + ((object = path) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ", skipping");
                continue;
            }
            if (!(charsetName instanceof String)) {
                Object object;
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + ((object = charsetName) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + " of " + path + " encoding configuration, skipping");
                continue;
            }
            $action.invoke(path, charsetName);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getCharsetProjectMapping$lambda$0(Map $mapping, String path, String charsetName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        String string = VfsUtilCore.pathToUrl((String)FileUtil.toCanonicalPath((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
        String url = string;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        VirtualFile virtualFile = virtualFileManager2.findFileByUrl(url);
        if (virtualFile == null) {
            RunConfigurationHandlerKt.getLOG().warn("mappings file " + path + " not found, skipping");
            return Unit.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)charsetName, (Object)"<System Default>")) {
            $mapping.remove(virtualFile);
            return Unit.INSTANCE;
        }
        Charset charset = CharsetToolkit.forName((String)charsetName);
        if (charset == null) {
            RunConfigurationHandlerKt.getLOG().warn("unsupported charset " + charsetName + " of " + path + " encoding configuration, skipping");
            return Unit.INSTANCE;
        }
        $mapping.put(virtualFile, charset);
        return Unit.INSTANCE;
    }
}

