/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ExternalSystemUiUtil {
    public static final int INSETS = 5;
    private static final int BALLOON_FADEOUT_TIME = 5000;

    private ExternalSystemUiUtil() {
    }

    public static void showBalloon(@NotNull JComponent component, @NotNull MessageType messageType, @NotNull @Nls String message) {
        Balloon.Position position;
        int x;
        int y;
        if (component == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(0);
        }
        if (messageType == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(1);
        }
        if (message == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(2);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType, null).setDisposable((Disposable)ApplicationManager.getApplication()).setFadeoutTime(5000L);
        Balloon balloon = builder.createBalloon();
        Dimension size = component.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon.show(new RelativePoint((Component)component, new Point(x, y)), position);
    }

    @NotNull
    public static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(3);
        }
        return gridBag;
    }

    @NotNull
    public static GridBag getFillLineConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().weightx(1.0).coverLine().fillCellHorizontally().anchor(17).insets((Insets)insets);
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(4);
        }
        return gridBag;
    }

    @NotNull
    public static GridBag getCommentConstraints(int indentLevel) {
        GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints(indentLevel);
        constraints.insets.top = 0;
        GridBag gridBag = constraints;
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(5);
        }
        return gridBag;
    }

    @NotNull
    public static GridBag getCheckBoxCommentConstraints(int indentLevel, @NotNull JCheckBox checkBox) {
        if (checkBox == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(6);
        }
        GridBag constraints = ExternalSystemUiUtil.getCommentConstraints(indentLevel);
        constraints.insets.left += UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)checkBox);
        GridBag gridBag = constraints;
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(7);
        }
        return gridBag;
    }

    public static void fillBottom(@NotNull JComponent component) {
        if (component == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(8);
        }
        component.add(Box.createVerticalGlue(), new GridBag().weightx(1.0).weighty(1.0).fillCell().coverLine());
    }

    public static void showUi(@NotNull Object o, boolean show) {
        if (o == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(9);
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    ((JComponent)v).setVisible(show);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static void disposeUi(@NotNull Object o) {
        if (o == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(10);
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    field.set(o, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public static ExternalSystemUiAware getUiAware(@NotNull ProjectSystemId externalSystemId) {
        ExternalSystemManager manager;
        if (externalSystemId == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(11);
        }
        DefaultExternalSystemUiAware defaultExternalSystemUiAware = (manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId)) instanceof ExternalSystemUiAware ? (ExternalSystemUiAware)manager : DefaultExternalSystemUiAware.INSTANCE;
        if (defaultExternalSystemUiAware == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(12);
        }
        return defaultExternalSystemUiAware;
    }

    public static void executeAction(@NotNull String actionId, @NotNull InputEvent e) {
        ActionManager actionManager;
        AnAction action2;
        if (actionId == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(14);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) == null) {
            return;
        }
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext(e.getComponent());
        AnActionEvent event = new AnActionEvent(e, context, "", presentation, actionManager, 0);
        action2.update(event);
        if (presentation.isEnabled()) {
            action2.actionPerformed(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelConstraints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFillLineConstraints";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentConstraints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxCommentConstraints";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxCommentConstraints";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillBottom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showUi";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "disposeUi";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUiAware";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 12 -> new IllegalStateException(string);
        };
    }
}

