/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BY\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u000b\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u00070\u0007\u00a2\u0006\u0002\b\bJ\u000f\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u001cH\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0013j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0007`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/dvcs/MultiMessage;", "Aspect", "", "allValues", "", "logPresentation", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/Nls;", "shortPresentation", "aspectInPrefix", "", "html", "<init>", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ZZ)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "messages", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "lineSeparator", "append", "aspect", "message", "(Ljava/lang/Object;Ljava/lang/String;)Lcom/intellij/dvcs/MultiMessage;", "asString", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nMultiMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiMessage.kt\ncom/intellij/dvcs/MultiMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,60:1\n1512#2:61\n1538#2,3:62\n1541#2,3:72\n1586#2:75\n1661#2,3:76\n383#3,7:65\n*S KotlinDebug\n*F\n+ 1 MultiMessage.kt\ncom/intellij/dvcs/MultiMessage\n*L\n42#1:61\n42#1:62,3\n42#1:72,3\n45#1:75\n45#1:76,3\n42#1:65,7\n*E\n"})
public class MultiMessage<Aspect> {
    @NotNull
    private final Collection<Aspect> allValues;
    @NotNull
    private final Function1<Aspect, String> logPresentation;
    @NotNull
    private final Function1<Aspect, String> shortPresentation;
    private final boolean aspectInPrefix;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final LinkedHashMap<Aspect, String> messages;
    @NlsSafe
    @NotNull
    private final String lineSeparator;

    public MultiMessage(@NotNull Collection<? extends Aspect> allValues, @NotNull Function1<? super Aspect, String> logPresentation, @NotNull Function1<? super Aspect, String> shortPresentation, boolean aspectInPrefix, boolean html) {
        Intrinsics.checkNotNullParameter(allValues, (String)"allValues");
        Intrinsics.checkNotNullParameter(logPresentation, (String)"logPresentation");
        Intrinsics.checkNotNullParameter(shortPresentation, (String)"shortPresentation");
        this.allValues = allValues;
        this.logPresentation = logPresentation;
        this.shortPresentation = shortPresentation;
        this.aspectInPrefix = aspectInPrefix;
        Logger logger = Logger.getInstance(MultiMessage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.messages = new LinkedHashMap();
        this.lineSeparator = html ? "<br/>\n" : "\n";
    }

    public /* synthetic */ MultiMessage(Collection collection, Function1 function1, Function1 function12, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(collection, function1, function12, bl, bl2);
    }

    @NotNull
    public final MultiMessage<Aspect> append(Aspect aspect, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.allValues.contains(aspect)) {
            this.LOG.error("The aspect value " + this.logPresentation.invoke(aspect) + " is unexpected: " + this.allValues);
            return this;
        }
        if (this.messages.containsKey(aspect)) {
            this.LOG.error("Duplicate aspect value " + this.logPresentation.invoke(aspect) + " reporting message [" + message + "]");
        }
        this.messages.put(aspect, message);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String asString() {
        void $this$groupByTo$iv$iv;
        if (this.messages.isEmpty()) {
            return "";
        }
        if (this.allValues.size() == 1) {
            Collection<String> collection = this.messages.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Object object = CollectionsKt.first((Iterable)collection);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            return (String)object;
        }
        Set<Aspect> set = this.messages.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            String string = this.messages.get(it);
            Intrinsics.checkNotNull((Object)string);
            String key$iv$iv = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map grouped = destination$iv$iv;
        if (grouped.size() == 1 && this.allValues.size() == this.messages.size()) {
            Collection<String> collection = this.messages.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Object object = CollectionsKt.first((Iterable)collection);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            return (String)object;
        }
        return CollectionsKt.joinToString$default((Iterable)grouped.keySet(), (CharSequence)this.lineSeparator, null, null, (int)0, null, arg_0 -> MultiMessage.asString$lambda$1(grouped, this, arg_0), (int)30, null);
    }

    @NotNull
    public String toString() {
        String string = this.messages.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence asString$lambda$1(Map $grouped, MultiMessage this$0, String it) {
        CharSequence charSequence;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] $this$map$iv = (Object[])MapsKt.getValue((Map)$grouped, (Object)it);
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)this$0.shortPresentation.invoke((Object)it2));
        }
        List presentableNames = (List)destination$iv$iv;
        String string = DvcsUtil.joinWithAnd(presentableNames, 5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joinWithAnd(...)");
        String names = string;
        if (this$0.aspectInPrefix) {
            objectArray = new Object[]{names, it};
            String string2 = DvcsBundle.message((String)"multi.message.line.prefix.form", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string2);
            charSequence = string2;
        } else {
            objectArray = new Object[]{names, it};
            String string3 = DvcsBundle.message((String)"multi.message.line.suffix.form", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string3);
            charSequence = string3;
        }
        return charSequence;
    }
}

