/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.devcontainers.cli.output;

import com.intellij.clouds.docker.devcontainers.cli.logging.LogRecord;
import com.intellij.clouds.docker.devcontainers.cli.output.OutputRecord;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0005H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"json", "Lkotlinx/serialization/json/Json$Default;", "logRecord", "", "level", "Lorg/slf4j/event/Level;", "message", "stackTrace", "toLogRecordLevel", "Lcom/intellij/clouds/docker/devcontainers/cli/logging/LogRecord$Level;", "terminalOutput", "line", "buildSucceeded", "containerId", "buildFailed", "throwable", "", "intellij.clouds.docker.devcontainers.cli"})
public final class OutputRecordsKt {
    @NotNull
    private static final Json.Default json = Json.Default;

    @NotNull
    public static final String logRecord(@NotNull Level level, @NotNull String message, @Nullable String stackTrace) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return json.encodeToString((SerializationStrategy)OutputRecord.Companion.serializer(), (Object)new OutputRecord.Logging(new LogRecord(OutputRecordsKt.toLogRecordLevel(level), message, stackTrace)));
    }

    private static final LogRecord.Level toLogRecordLevel(Level $this$toLogRecordLevel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toLogRecordLevel.ordinal()]) {
            case 1 -> LogRecord.Level.ERROR;
            case 2 -> LogRecord.Level.WARN;
            case 3 -> LogRecord.Level.INFO;
            case 4 -> LogRecord.Level.DEBUG;
            case 5 -> LogRecord.Level.TRACE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String terminalOutput(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return json.encodeToString((SerializationStrategy)OutputRecord.Companion.serializer(), (Object)new OutputRecord.TerminalOutput(line));
    }

    @NotNull
    public static final String buildSucceeded(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return json.encodeToString((SerializationStrategy)OutputRecord.Companion.serializer(), (Object)new OutputRecord.BuildState.Success(containerId));
    }

    @NotNull
    public static final String buildFailed(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        SerializationStrategy serializationStrategy = (SerializationStrategy)OutputRecord.Companion.serializer();
        String string = throwable.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
        return json.encodeToString(serializationStrategy, (Object)new OutputRecord.BuildState.Failure(string, ExceptionsKt.stackTraceToString((Throwable)throwable)));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.TRACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

