/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.target.HostPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.MultiLoaderObjectInputStream;
import com.intellij.openapi.externalSystem.util.wsl.WSLUtilKt;
import com.intellij.openapi.progress.ProgressManager;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.SocketInetAddress;
import org.gradle.internal.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.provider.action.BuildActionSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetup;
import org.jetbrains.plugins.gradle.execution.target.GradleToolingProxyClassloaderHolder;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.tooling.proxy.IntermediateResult;
import org.jetbrains.plugins.gradle.tooling.proxy.Output;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetBuildParameters;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetIntermediateResultHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J/\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u001d\u0010\u0013\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\t0\u0014\u00a2\u0006\u0002\b\u0017H\u0002J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u001b\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00160\u00152\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector;", "", "hostPort", "Lcom/intellij/execution/target/HostPort;", "classloaderHolder", "Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;", "<init>", "(Lcom/intellij/execution/target/HostPort;Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;)V", "collectAllEvents", "", "targetBuildParameters", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "buildEventConsumer", "Lorg/gradle/initialization/BuildEventConsumer;", "intermediateResultHandler", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIntermediateResultHandler;", "withConnection", "handler", "Lkotlin/Function1;", "Lorg/gradle/internal/remote/internal/RemoteConnection;", "Lorg/gradle/launcher/daemon/protocol/Message;", "Lkotlin/ExtensionFunctionType;", "processMessages", "", "message", "listen", "deserializeIfNeeded", "value", "Companion", "ToolingProxyConnectorFactory", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nToolingProxyConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolingProxyConnector.kt\norg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n13#2:179\n*S KotlinDebug\n*F\n+ 1 ToolingProxyConnector.kt\norg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector\n*L\n33#1:179\n*E\n"})
public final class ToolingProxyConnector {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HostPort hostPort;
    @NotNull
    private final GradleToolingProxyClassloaderHolder classloaderHolder;
    @NotNull
    private static final Logger log;

    public ToolingProxyConnector(@NotNull HostPort hostPort, @NotNull GradleToolingProxyClassloaderHolder classloaderHolder) {
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        Intrinsics.checkNotNullParameter((Object)classloaderHolder, (String)"classloaderHolder");
        this.hostPort = hostPort;
        this.classloaderHolder = classloaderHolder;
    }

    public final void collectAllEvents(@NotNull TargetBuildParameters targetBuildParameters, @NotNull ResultHandler<Object> resultHandler, @NotNull BuildEventConsumer buildEventConsumer, @NotNull TargetIntermediateResultHandler intermediateResultHandler) {
        Intrinsics.checkNotNullParameter((Object)targetBuildParameters, (String)"targetBuildParameters");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        Intrinsics.checkNotNullParameter((Object)buildEventConsumer, (String)"buildEventConsumer");
        Intrinsics.checkNotNullParameter((Object)intermediateResultHandler, (String)"intermediateResultHandler");
        try {
            this.withConnection(this.hostPort, (Function1<? super RemoteConnection<Message>, Unit>)((Function1)arg_0 -> ToolingProxyConnector.collectAllEvents$lambda$0(targetBuildParameters, this, resultHandler, buildEventConsumer, intermediateResultHandler, arg_0)));
        }
        catch (CancellationException e) {
            resultHandler.onFailure((GradleConnectionException)new BuildCancelledException("Build cancelled."));
            throw e;
        }
        catch (Exception e) {
            resultHandler.onFailure(new GradleConnectionException("An error occurred", (Throwable)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withConnection(HostPort hostPort, Function1<? super RemoteConnection<Message>, Unit> handler) {
        InetAddress inetAddress = InetAddress.getByName(hostPort.getHost());
        Object object = WSLUtilKt.connectRetrying$default((long)5000L, (long)0L, () -> ToolingProxyConnector.withConnection$lambda$0(inetAddress, hostPort), (int)2, null);
        Intrinsics.checkNotNull((Object)object);
        ConnectCompletion connectCompletion = (ConnectCompletion)object;
        Serializer serializer = DaemonMessageSerializer.create((Serializer)BuildActionSerializer.create());
        RemoteConnection connection = connectCompletion.create(Serializers.stateful((Serializer)serializer));
        try {
            Intrinsics.checkNotNull((Object)connection);
            handler.invoke((Object)connection);
        }
        finally {
            connection.stop();
            log.info("The connection to " + hostPort + " was closed");
        }
    }

    private final boolean processMessages(Message message, ResultHandler<Object> resultHandler, BuildEventConsumer buildEventConsumer, TargetIntermediateResultHandler intermediateResultHandler) {
        Message message2 = message;
        if (message2 instanceof Success) {
            Object value = this.deserializeIfNeeded(((Success)message).getValue());
            resultHandler.onComplete(value);
            return true;
        }
        if (message2 instanceof Failure) {
            Object object = ((Failure)message).getValue();
            GradleConnectionException gradleConnectionException = object instanceof GradleConnectionException ? (GradleConnectionException)((Object)object) : null;
            if (gradleConnectionException == null) {
                gradleConnectionException = new GradleConnectionException(((Throwable)((Failure)message).getValue()).getMessage());
            }
            resultHandler.onFailure(gradleConnectionException);
            return true;
        }
        if (message2 instanceof BuildEvent) {
            buildEventConsumer.dispatch(((BuildEvent)message).getPayload());
            return false;
        }
        if (message2 instanceof Output) {
            buildEventConsumer.dispatch((Object)message);
            return false;
        }
        if (message2 instanceof IntermediateResult) {
            Object value = this.deserializeIfNeeded(((IntermediateResult)message).getValue());
            intermediateResultHandler.onResult(((IntermediateResult)message).getType(), value);
            return false;
        }
        log.warn("An unexpected message of type [" + message.getClass() + "] was received from the daemon");
        return true;
    }

    private final void listen(RemoteConnection<Message> $this$listen, ResultHandler<Object> resultHandler, BuildEventConsumer buildEventConsumer, TargetIntermediateResultHandler intermediateResultHandler) {
        while (true) {
            ProgressManager.checkCanceled();
            Message message = (Message)$this$listen.receive();
            if (message != null) {
                try {
                    if (this.processMessages(message, resultHandler, buildEventConsumer, intermediateResultHandler)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    log.error("Unexpected error during communication with Tooling proxy", (Throwable)e);
                }
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object deserializeIfNeeded(Object value) {
        Object object;
        byte[] byArray = value instanceof byte[] ? (byte[])value : null;
        if (byArray == null) {
            return value;
        }
        byte[] bytes = byArray;
        Closeable closeable = (Closeable)new MultiLoaderObjectInputStream((InputStream)new ByteArrayInputStream(bytes), this.classloaderHolder.getClassloaders());
        Throwable throwable = null;
        try {
            MultiLoaderObjectInputStream it = (MultiLoaderObjectInputStream)closeable;
            boolean bl = false;
            object = it.readObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object deserialized = object;
        return deserialized;
    }

    private static final Unit collectAllEvents$lambda$0(TargetBuildParameters $targetBuildParameters, ToolingProxyConnector this$0, ResultHandler $resultHandler, BuildEventConsumer $buildEventConsumer, TargetIntermediateResultHandler $intermediateResultHandler, RemoteConnection $this$withConnection) {
        Intrinsics.checkNotNullParameter((Object)$this$withConnection, (String)"$this$withConnection");
        $this$withConnection.dispatch((Object)new BuildEvent((Object)$targetBuildParameters));
        $this$withConnection.flush();
        this$0.listen((RemoteConnection<Message>)$this$withConnection, (ResultHandler<Object>)$resultHandler, $buildEventConsumer, $intermediateResultHandler);
        $this$withConnection.dispatch((Object)new BuildEvent((Object)"ack"));
        $this$withConnection.flush();
        return Unit.INSTANCE;
    }

    private static final ConnectCompletion withConnection$lambda$0(InetAddress $inetAddress, HostPort $hostPort) {
        ProgressManager.checkCanceled();
        return new TcpOutgoingConnector().connect((Address)new SocketInetAddress($inetAddress, $hostPort.getPort()));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolingProxyConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector$ToolingProxyConnectorFactory;", "", "classloaderHolder", "Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;", "configurationProvider", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;)V", "getConnector", "Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector;", "host", "", "port", "", "resolveRemoteAddress", "Lcom/intellij/execution/target/HostPort;", "intellij.gradle"})
    public static final class ToolingProxyConnectorFactory {
        @NotNull
        private final GradleToolingProxyClassloaderHolder classloaderHolder;
        @NotNull
        private final GradleServerEnvironmentSetup serverEnvironmentSetup;
        @Nullable
        private final GradleServerConfigurationProvider configurationProvider;
        @Nullable
        private final ExternalSystemTaskId taskId;

        public ToolingProxyConnectorFactory(@NotNull GradleToolingProxyClassloaderHolder classloaderHolder, @NotNull GradleServerEnvironmentSetup serverEnvironmentSetup, @Nullable GradleServerConfigurationProvider configurationProvider, @Nullable ExternalSystemTaskId taskId) {
            Intrinsics.checkNotNullParameter((Object)classloaderHolder, (String)"classloaderHolder");
            Intrinsics.checkNotNullParameter((Object)serverEnvironmentSetup, (String)"serverEnvironmentSetup");
            this.classloaderHolder = classloaderHolder;
            this.serverEnvironmentSetup = serverEnvironmentSetup;
            this.configurationProvider = configurationProvider;
            this.taskId = taskId;
        }

        @NotNull
        public final ToolingProxyConnector getConnector(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            HostPort address = this.resolveRemoteAddress(host, port);
            return new ToolingProxyConnector(address, this.classloaderHolder);
        }

        private final HostPort resolveRemoteAddress(String host, int port) {
            Integer targetPort;
            Promise serverBindingPort = this.serverEnvironmentSetup.getServerBindingPort();
            Promise promise = serverBindingPort;
            Integer localPort2 = promise != null && (promise = promise.getLocalValue()) != null ? (Integer)promise.blockingGet(0) : null;
            Promise promise2 = serverBindingPort;
            Integer n = targetPort = promise2 != null && (promise2 = promise2.getTargetValue()) != null ? (Integer)promise2.blockingGet(0) : null;
            int n2 = port;
            HostPort hostPort = n != null && n == n2 && localPort2 != null ? new HostPort(host, localPort2.intValue()) : new HostPort(host, port);
            GradleServerConfigurationProvider gradleServerConfigurationProvider = this.configurationProvider;
            HostPort communicationAddress = gradleServerConfigurationProvider != null ? gradleServerConfigurationProvider.getClientCommunicationAddress(this.taskId, this.serverEnvironmentSetup.getEnvironmentConfiguration(), hostPort) : null;
            HostPort hostPort2 = communicationAddress;
            if (hostPort2 == null) {
                hostPort2 = hostPort;
            }
            return hostPort2;
        }
    }
}

