/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\n*\u00020\u000b\u00a8\u0006\r"}, d2={"parseCommandLine", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "tasksAndArguments", "", "", "arguments", "getTestPatterns", "", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTask;", "isTestPattern", "", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption;", "isWildcardTestPattern", "intellij.gradle"})
@JvmName(name="GradleCommandLineUtil")
@SourceDebugExtension(value={"SMAP\nGradleCommandLineUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineUtil.kt\norg/jetbrains/plugins/gradle/service/execution/GradleCommandLineUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n777#2:38\n873#2,2:39\n1391#2:41\n1480#2,5:42\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineUtil.kt\norg/jetbrains/plugins/gradle/service/execution/GradleCommandLineUtil\n*L\n25#1:38\n25#1:39,2\n26#1:41\n26#1:42,5\n*E\n"})
public final class GradleCommandLineUtil {
    @NotNull
    public static final GradleCommandLine parseCommandLine(@NotNull List<String> tasksAndArguments, @Nullable String arguments) {
        Intrinsics.checkNotNullParameter(tasksAndArguments, (String)"tasksAndArguments");
        String string = arguments;
        if (string == null) {
            string = "";
        }
        List<String> sortedArguments = GradleCommandLine.Companion.parse(string).getTokens();
        return GradleCommandLine.Companion.parse(CollectionsKt.plus((Collection)tasksAndArguments, (Iterable)sortedArguments));
    }

    @NotNull
    public static final GradleCommandLine parseCommandLine(@NotNull List<String> tasksAndArguments, @NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter(tasksAndArguments, (String)"tasksAndArguments");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        List<String> sortedArguments = GradleCommandLine.Companion.parse(arguments).getTokens();
        return GradleCommandLine.Companion.parse(CollectionsKt.plus((Collection)tasksAndArguments, (Iterable)sortedArguments));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getTestPatterns(@NotNull GradleCommandLineTask $this$getTestPatterns) {
        void $this$flatMapTo$iv$iv;
        GradleCommandLineOption it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getTestPatterns, (String)"<this>");
        Iterable $this$filter$iv = $this$getTestPatterns.getOptions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GradleCommandLineOption)element$iv$iv;
            boolean bl = false;
            if (!GradleCommandLineUtil.isTestPattern(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GradleCommandLineOption)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getValues();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final boolean isTestPattern(@NotNull GradleCommandLineOption $this$isTestPattern) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestPattern, (String)"<this>");
        return Intrinsics.areEqual((Object)"--tests", (Object)$this$isTestPattern.getName());
    }

    public static final boolean isWildcardTestPattern(@NotNull GradleCommandLineOption $this$isWildcardTestPattern) {
        Intrinsics.checkNotNullParameter((Object)$this$isWildcardTestPattern, (String)"<this>");
        return GradleCommandLineUtil.isTestPattern($this$isWildcardTestPattern) && $this$isWildcardTestPattern.getValues().size() == 1 && Intrinsics.areEqual((Object)StringUtil.unquoteString((String)$this$isWildcardTestPattern.getValues().get(0)), (Object)"*");
    }
}

