/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.common.formatting;

import com.intellij.editorconfig.common.formatting.EditorConfigFormattingBlock;
import com.intellij.editorconfig.common.syntax.EditorConfigLanguage;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\n \r*\u0004\u0018\u00010\t0\t*\u00060\u000eR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/editorconfig/common/formatting/EditorConfigFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "<init>", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "createSpacingBuilder", "Lcom/intellij/formatting/SpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "strictSpaces", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "needSpace", "", "toInt", "", "intellij.editorconfig.common"})
public final class EditorConfigFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        SpacingBuilder spacingBuilder = this.createSpacingBuilder(settings);
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean shouldAlignSeparators = commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS;
        ASTNode aSTNode = formattingContext.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        EditorConfigFormattingBlock root = new EditorConfigFormattingBlock(aSTNode, spacingBuilder, shouldAlignSeparators, null, 8, null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)formattingContext.getContainingFile(), (Block)((Block)root), (CodeStyleSettings)settings);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"createFormattingModelForPsiFile(...)");
        return formattingModel;
    }

    private final SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        boolean beforeComma = commonSettings.SPACE_BEFORE_COMMA;
        boolean afterComma = commonSettings.SPACE_AFTER_COMMA;
        boolean beforeColon = commonSettings.SPACE_BEFORE_COLON;
        boolean afterColon = commonSettings.SPACE_AFTER_COLON;
        boolean aroundSeparator = commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        SpacingBuilder.RuleBuilder ruleBuilder = new SpacingBuilder(settings, (Language)EditorConfigLanguage.INSTANCE).around(EditorConfigElementTypes.SEPARATOR);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"around(...)");
        SpacingBuilder.RuleBuilder ruleBuilder2 = this.strictSpaces(ruleBuilder, aroundSeparator).before(EditorConfigElementTypes.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder2, (String)"before(...)");
        SpacingBuilder.RuleBuilder ruleBuilder3 = this.strictSpaces(ruleBuilder2, beforeComma).after(EditorConfigElementTypes.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder3, (String)"after(...)");
        SpacingBuilder.RuleBuilder ruleBuilder4 = this.strictSpaces(ruleBuilder3, afterComma).around(EditorConfigElementTypes.DOT);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder4, (String)"around(...)");
        SpacingBuilder.RuleBuilder ruleBuilder5 = this.strictSpaces(ruleBuilder4, false).before(EditorConfigElementTypes.COLON);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder5, (String)"before(...)");
        SpacingBuilder.RuleBuilder ruleBuilder6 = this.strictSpaces(ruleBuilder5, beforeColon).after(EditorConfigElementTypes.COLON);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder6, (String)"after(...)");
        SpacingBuilder spacingBuilder = this.strictSpaces(ruleBuilder6, afterColon).around(EditorConfigElementTypes.LINE_COMMENT).spaces(1).around(EditorConfigElementTypes.OPTION).lineBreakInCode().around(EditorConfigElementTypes.ROOT_DECLARATION).blankLines(1).around(EditorConfigElementTypes.SECTION).blankLines(1);
        Intrinsics.checkNotNullExpressionValue((Object)spacingBuilder, (String)"blankLines(...)");
        return spacingBuilder;
    }

    private final SpacingBuilder strictSpaces(SpacingBuilder.RuleBuilder $this$strictSpaces, boolean needSpace) {
        return $this$strictSpaces.spacing(this.toInt(needSpace), this.toInt(needSpace), 0, false, 0);
    }

    private final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }
}

