/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SocketUtils {
    private static final Logger LOG = Logger.getInstance(SocketUtils.class);

    private SocketUtils() {
    }

    public static boolean shouldPatchSocketsOnMacForIPv6(String host) {
        if (!SocketUtils.systemIsPatchable()) {
            return false;
        }
        try {
            boolean bl;
            InetAddress inetAddress = InetAddress.getByName(host);
            boolean bl2 = bl = inetAddress instanceof Inet6Address && !StringUtil.isEmptyOrSpaces((String)SocketUtils.i());
            if (bl) {
                LOG.debug("Socket patching needed for " + host);
            }
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean systemIsPatchable() {
        return SystemInfo.isMac;
    }

    public static InetAddress getProperAddressIfNeeded(@NotNull InetAddress inetAddress) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        if (inetAddress == null) {
            SocketUtils.i(0);
        }
        if (SocketUtils.systemIsPatchable() && inetAddress instanceof Inet6Address && (networkInterface = SocketUtils.findProperIpv6HostNetworkInterface()) != null) {
            return SocketUtils.i(networkInterface, (Inet6Address)inetAddress);
        }
        return null;
    }

    @Nullable
    public static NetworkInterface findProperIpv6HostNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        String string = SocketUtils.i();
        NetworkInterface networkInterface = null;
        NetworkInterface networkInterface2 = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface3 = enumeration.nextElement();
            if (string.contains(networkInterface3.getName())) continue;
            if (!networkInterface3.isUp()) {
                LOG.debug("Interface " + String.valueOf(networkInterface3) + " is down ");
                continue;
            }
            for (InterfaceAddress interfaceAddress : networkInterface3.getInterfaceAddresses()) {
                InetAddress inetAddress = interfaceAddress.getAddress();
                if (!(inetAddress instanceof Inet6Address)) continue;
                if (networkInterface3.isLoopback()) {
                    networkInterface2 = networkInterface3;
                    break;
                }
                if (!inetAddress.isLinkLocalAddress()) {
                    LOG.debug("Using interface " + String.valueOf(networkInterface3));
                    return networkInterface3;
                }
                if (networkInterface != null) continue;
                networkInterface = networkInterface3;
            }
            LOG.debug("No ipv6 addresses for " + String.valueOf(networkInterface3));
        }
        if (networkInterface != null) {
            LOG.debug("Using link-local interface " + String.valueOf(networkInterface));
            return networkInterface;
        }
        if (networkInterface2 != null) {
            LOG.debug("Using loopback interface " + String.valueOf(networkInterface2));
            return networkInterface2;
        }
        return null;
    }

    @NotNull
    private static InetAddress i(@NotNull NetworkInterface networkInterface, Inet6Address inet6Address) throws UnknownHostException {
        if (networkInterface == null) {
            SocketUtils.i(1);
        }
        Inet6Address inet6Address2 = Inet6Address.getByAddress(inet6Address.getHostAddress(), inet6Address.getAddress(), networkInterface.getIndex());
        if (inet6Address2 == null) {
            SocketUtils.i(2);
        }
        return inet6Address2;
    }

    @NotNull
    private static String i() {
        String string = Registry.get((String)"deployment.macOs.bannedInterfaces").asString();
        if (string == null) {
            SocketUtils.i(3);
        }
        return string;
    }

    private static /* synthetic */ void i(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inetAddress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddressForInterface";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBannedInterfaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperAddressIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAddressForInterface";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

