/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffLightVirtualFile;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.actions.ImmutableDocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffNotificationProvider;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformer;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformers;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@ApiStatus.Internal
public final class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(0);
        }
        DocumentContent documentContent = this.create(null, text);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(1);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(2);
        }
        DocumentContent documentContent = this.create(null, text, type);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(3);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(4);
        }
        DocumentContent documentContent = this.create(null, text, type, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(6);
        }
        DocumentContent documentContent = this.create(null, text, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(7);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(8);
        }
        DocumentContent documentContent = this.create(null, text, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(9);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(10);
        }
        DocumentContent documentContent = this.create(project, text, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(11);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(12);
        }
        DocumentContent documentContent = this.create(project, text, type, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(13);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(14);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFileType(type).buildFromText(text, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(15);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FilePath filePath) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(16);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(17);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(18);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(19);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(20);
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text);
            if (documentContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(21);
            }
            return documentContent;
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByReferent(referent).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(22);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createEditable(@Nullable Project project, @NotNull String text, @Nullable FileType fileType) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(23);
        }
        DocumentContent documentContent = this.documentContent(project, false).contextByFileType(fileType).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(24);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(25);
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(26);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(27);
        }
        DocumentContent documentContent = this.create(project, document, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(28);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(29);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) != null) {
            return new FileDocumentContentImpl(project, document, file);
        }
        return new DocumentContentImpl(project, document, fileType);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(30);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) != null && file.equals(highlightFile)) {
            return new FileDocumentContentImpl(project, document, file);
        }
        if (highlightFile == null) {
            return new DocumentContentImpl(document);
        }
        return new FileReferentDocumentContent(project, document, highlightFile);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(31);
        }
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new ContentReferentDocumentContent(project, document, referent);
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(32);
        }
        return DiffContentFactoryImpl.createContentFromFile(project, file);
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file, @Nullable VirtualFile highlightFile) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(33);
        }
        return DiffContentFactoryImpl.createContentFromFile(project, file, highlightFile);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(34);
        }
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project, file), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(35);
        }
        if (file.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(36);
        }
        if (range == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(37);
        }
        DocumentContent content = this.create(project, document);
        DocumentContent documentContent = this.createFragment(project, content, range);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(38);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull DocumentContent content, @NotNull TextRange range) {
        Document document;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(39);
        }
        if (range == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(40);
        }
        if ((document = content.getDocument()) instanceof DocumentImpl && ((DocumentImpl)document).acceptsSlashR()) {
            LOG.warn("Create immutable fragment content - can't handle CR");
            return new ImmutableDocumentFragmentContent(content, range);
        }
        return new DocumentFragmentContent(project, content, range);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(41);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(42);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project) {
        DocumentContent documentContent = this.createClipboardContent(project, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(43);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project, @Nullable DocumentContent referent) {
        String text = StringUtil.notNullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        DocumentContent documentContent = this.documentContent(project, false).contextByReferent(referent).withFileName("Clipboard.txt").buildFromText(text, false);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(44);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FilePath filePath) throws IOException {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(45);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(46);
        }
        DiffContent diffContent = this.createFromBytes(project, content, filePath, null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(47);
        }
        return diffContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) throws IOException {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(48);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(49);
        }
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content, filePath.getFileType(), filePath.getPath(), filePath.getVirtualFile());
        }
        return this.createDocumentFromBytes(project, content, filePath, defaultCharset);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(50);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(51);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(52);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, fileType)) {
            DiffContent diffContent = this.createBinary(project, content, fileType, fileName);
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(53);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content, fileType, fileName);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(54);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(55);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(56);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content, highlightFile.getFileType(), highlightFile.getPath(), highlightFile);
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(57);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FileType fileType, @NotNull String fileName) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(58);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(59);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(60);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFileType(fileType).withFileName(fileName).buildFromBytes(content);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(61);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FilePath filePath) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(62);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(63);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromBytes(content);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(64);
        }
        return documentContent;
    }

    @NotNull
    private DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(65);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(66);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).withDefaultCharset(defaultCharset).buildFromBytes(content);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(67);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content, @NotNull VirtualFile highlightFile) {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(68);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(69);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromBytes(content);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(70);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, byte @NotNull [] content, @NotNull FileType type, @NotNull String fileName) throws IOException {
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(71);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(72);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(73);
        }
        return DiffContentFactoryImpl.createBinaryImpl(project, content, type, fileName, null);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(74);
        }
        return DiffContentFactoryImpl.createContentFromFile(project, file, file);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file, @Nullable VirtualFile highlightFile) {
        if (file == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(75);
        }
        if (file.isDirectory()) {
            return new DirectoryContentImpl(project, file, highlightFile);
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
        if (document != null) {
            return new FileDocumentContentImpl(project, document, file, highlightFile);
        }
        return new FileContentImpl(project, file, highlightFile);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project, byte @NotNull [] content, @NotNull FileType type, @NotNull @NonNls @SystemIndependent String lightFilePath, @Nullable VirtualFile highlightFile) throws IOException {
        Object file;
        boolean useTemporalFile;
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(76);
        }
        if (lightFilePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(77);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(78);
        }
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
        if (useTemporalFile) {
            file = DiffContentFactoryImpl.createTemporalFile(PathUtil.getFileName((String)lightFilePath), content);
        } else {
            file = new MyBinaryLightVirtualFile(lightFilePath, type, content);
            file.setWritable(false);
        }
        file.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        return DiffContentFactoryImpl.createContentFromFile(project, file, highlightFile);
    }

    @NotNull
    private static VirtualFile createTemporalFile(@NonNls @NotNull String suffix, byte @NotNull [] content) throws IOException {
        VirtualFile file;
        if (suffix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(79);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(80);
        }
        File tempFile = FileUtil.createTempFile((String)"tmp_", (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(81);
        }
        return virtualFile;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project, @NotNull String content, @Nullable FileType fileType, @NotNull @NonNls @SystemIndependent String lightFilePath, boolean readOnly) {
        Document document;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(82);
        }
        if (lightFilePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(83);
        }
        if ((document = DiffContentFactoryImpl.createPsiDocument(project, content, fileType, lightFilePath, readOnly)) == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)content);
            document.setReadOnly(readOnly);
        }
        Document document2 = document;
        if (document2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(84);
        }
        return document2;
    }

    @Nullable
    private static Document createPsiDocument(@Nullable Project project, @NotNull String content, @Nullable FileType fileType, @NotNull @NonNls @SystemIndependent String lightFilePath, boolean readOnly) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(85);
        }
        if (lightFilePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(86);
        }
        if (project == null || project.isDefault()) {
            return null;
        }
        if (fileType != null && fileType.isBinary()) {
            return null;
        }
        MyLightVirtualFile file = new MyLightVirtualFile(lightFilePath, fileType, content);
        TextPresentationTransformers transformersManager = (TextPresentationTransformers)ApplicationManager.getApplication().getService(TextPresentationTransformers.class);
        TextPresentationTransformer transformer = (TextPresentationTransformer)transformersManager.forFileType(file.getFileType());
        if (transformer != null) {
            String convertedText = transformer.fromPersistent((CharSequence)content, (VirtualFile)file).toString();
            file = new MyLightVirtualFile(lightFilePath, fileType, convertedText);
        }
        file.setWritable(!readOnly);
        MyLightVirtualFile finalFile = file;
        return (Document)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)finalFile, project);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return document;
        });
    }

    @ApiStatus.Internal
    public static boolean isBinaryContent(byte @NotNull [] content, @NotNull FileType fileType) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(87);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(88);
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        if (!fileType.isBinary()) {
            return false;
        }
        if (UnknownFileType.INSTANCE.equals((Object)fileType) || fileType instanceof INativeFileType || Registry.is((String)"diff.use.aggressive.text.file.detection")) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        return true;
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content, @NotNull FilePath filePath) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(89);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(90);
        }
        return DiffContentFactoryImpl.guessCharset(project, content, filePath.getFileType(), filePath.getPath(), filePath.getVirtualFile(), null);
    }

    @NotNull
    private static Charset guessCharset(@Nullable Project project, byte @NotNull [] content, @Nullable FileType fileType, @NotNull @NonNls @SystemIndependent String lightFilePath, @Nullable VirtualFile highlightFile, @Nullable Charset defaultCharset) {
        Charset fileTypeCharset;
        Charset bomCharset;
        if (lightFilePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(91);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(92);
        }
        if ((bomCharset = CharsetToolkit.guessFromBOM((byte[])content)) != null) {
            Charset charset = bomCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(93);
            }
            return charset;
        }
        if (defaultCharset != null) {
            Charset charset = defaultCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(94);
            }
            return charset;
        }
        if (fileType != null && !fileType.isBinary() && (fileTypeCharset = DiffContentFactoryImpl.guessFileTypeCharset(project, content, fileType, lightFilePath)) != null) {
            Charset charset = fileTypeCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(95);
            }
            return charset;
        }
        if (highlightFile != null) {
            Charset fileCharset = highlightFile.getCharset();
            return DiffContentFactoryImpl.takeCharsetOrGuessUTF(fileCharset, content);
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset globalCharset = e.getDefaultCharset();
        return DiffContentFactoryImpl.takeCharsetOrGuessUTF(globalCharset, content);
    }

    @NotNull
    private static Charset takeCharsetOrGuessUTF(@NotNull Charset charset, byte @NotNull [] content) {
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(96);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(97);
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            Charset charset2 = charset;
            if (charset2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(98);
            }
            return charset2;
        }
        if (CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset) != null) {
            Charset charset3 = charset;
            if (charset3 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(99);
            }
            return charset3;
        }
        Charset charsetFromContent = DiffContentFactoryImpl.guessCharsetFromContent(content);
        if (charsetFromContent != null) {
            Charset charset4 = charsetFromContent;
            if (charset4 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(100);
            }
            return charset4;
        }
        Charset charset5 = charset;
        if (charset5 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(101);
        }
        return charset5;
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(102);
        }
        if (content.length == 0) {
            return null;
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, Charset.defaultCharset(), false);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        return switch (guessedEncoding) {
            case CharsetToolkit.GuessedEncoding.SEVEN_BIT -> StandardCharsets.US_ASCII;
            case CharsetToolkit.GuessedEncoding.VALID_UTF8 -> StandardCharsets.UTF_8;
            default -> null;
        };
    }

    @Nullable
    private static Charset guessFileTypeCharset(@Nullable Project project, byte @NotNull [] content, @NotNull FileType fileType, @NotNull @NonNls @SystemIndependent String lightFilePath) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(103);
        }
        if (lightFilePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(104);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(105);
        }
        MyBinaryLightVirtualFile file = new MyBinaryLightVirtualFile(lightFilePath, fileType, content);
        if (project != null) {
            try (AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)file, (Project)project);){
                Charset charset = CharsetToolkit.forName((String)fileType.getCharset((VirtualFile)file, content));
                return charset;
            }
        }
        return CharsetToolkit.forName((String)fileType.getCharset((VirtualFile)file, content));
    }

    @NotNull
    private DiffContentFactoryEx.DocumentContentBuilder readOnlyDocumentContent(@Nullable Project project) {
        DiffContentFactoryEx.DocumentContentBuilder documentContentBuilder = this.documentContent(project, true);
        if (documentContentBuilder == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(106);
        }
        return documentContentBuilder;
    }

    @Override
    @NotNull
    public DiffContentFactoryEx.DocumentContentBuilder documentContent(@Nullable Project project, boolean readOnly) {
        DiffContentFactoryEx.DocumentContentBuilder documentContentBuilder = new DocumentContentBuilderImpl(project).withReadOnly(readOnly);
        if (documentContentBuilder == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(107);
        }
        return documentContentBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 22, 24, 26, 28, 38, 41, 42, 43, 44, 47, 53, 54, 57, 61, 64, 67, 70, 81, 84, 93, 94, 95, 98, 99, 100, 101, 106, 107 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 81: 
            case 84: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 39: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 73: 
            case 78: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 90: 
            case 92: 
            case 97: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 45: 
            case 48: 
            case 62: 
            case 65: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 50: 
            case 58: 
            case 87: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 51: 
            case 59: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 55: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightFile";
                break;
            }
            case 71: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 77: 
            case 83: 
            case 86: 
            case 91: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lightFilePath";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardContent";
                break;
            }
            case 47: 
            case 53: 
            case 54: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytes";
                break;
            }
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFromBytes";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporalFile";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCharset";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "takeCharsetOrGuessUTF";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "readOnlyDocumentContent";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "documentContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 81: 
            case 84: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: 
            case 107: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEditable";
                break;
            }
            case 34: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createFragment";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytes";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFromBytes";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createBinary";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createContentFromFile";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryImpl";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createTemporalFile";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createPsiDocument";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryContent";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "guessCharset";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "takeCharsetOrGuessUTF";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "guessFileTypeCharset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 22, 24, 26, 28, 38, 41, 42, 43, 44, 47, 53, 54, 57, 61, 64, 67, 70, 81, 84, 93, 94, 95, 98, 99, 100, 101, 106, 107 -> new IllegalStateException(string);
        };
    }

    private static final class FileReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final VirtualFile myHighlightFile;

        private FileReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile highlightFile) {
            if (document == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (highlightFile == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.myHighlightFile = highlightFile;
        }

        @NotNull
        public FileType getContentType() {
            FileType fileType = this.myHighlightFile.getFileType();
            if (fileType == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(2);
            }
            return fileType;
        }

        @NotNull
        public VirtualFile getHighlightFile() {
            VirtualFile virtualFile = this.myHighlightFile;
            if (virtualFile == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$FileReferentDocumentContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$FileReferentDocumentContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ContentReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final DocumentContent myReferent;

        private ContentReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull DocumentContent referent) {
            if (document == null) {
                ContentReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (referent == null) {
                ContentReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            return this.myReferent.getContentType();
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent.getHighlightFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/DiffContentFactoryImpl$ContentReferentDocumentContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile
    implements DiffLightVirtualFile {
        private final String myPath;

        MyBinaryLightVirtualFile(@NotNull @NonNls @SystemIndependent String path, @Nullable FileType type, byte @NotNull [] content) {
            if (path == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(PathUtil.getFileName((String)path), type, content);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return "DiffContentFactory " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyLightVirtualFile
    extends LightVirtualFile
    implements DiffLightVirtualFile {
        private final String myPath;

        private MyLightVirtualFile(@NotNull @NonNls @SystemIndependent String path, @Nullable FileType fileType, @NotNull String content) {
            if (path == null) {
                MyLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(PathUtil.getFileName((String)path), fileType, (CharSequence)content);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                MyLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return "DiffContentFactory " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class DocumentContentBuilderImpl
    implements DiffContentFactoryEx.DocumentContentBuilder {
        @Nullable
        private final Project project;
        private boolean readOnly;
        @Nullable
        private Context context;
        @Nullable
        private @SystemIndependent String originalFilePath;
        @Nullable
        @NonNls
        private String fileName;
        @Nullable
        @NonNls
        private Charset defaultCharset;

        DocumentContentBuilderImpl(@Nullable Project project) {
            this.project = project;
        }

        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(0);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withFileName(@Nullable String fileName) {
            this.fileName = fileName;
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(1);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withDefaultCharset(@Nullable Charset charset) {
            this.defaultCharset = charset;
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(2);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFileType(@Nullable FileType fileType) {
            if (fileType != null) {
                this.context = new Context.ByFileType(fileType);
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(3);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFilePath(@Nullable FilePath filePath) {
            if (filePath != null) {
                this.context = new Context.ByFilePath(filePath);
                this.originalFilePath = filePath.getPath();
                this.fileName = filePath.getName();
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(4);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByHighlightFile(@Nullable VirtualFile file) {
            if (file != null) {
                this.context = new Context.ByHighlightFile(file);
                this.originalFilePath = file.getPath();
                this.fileName = file.getName();
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(5);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByReferent(@Nullable DocumentContent referent) {
            if (referent != null) {
                this.context = new Context.ByReferent(referent);
                VirtualFile file = referent.getHighlightFile();
                if (file != null) {
                    this.originalFilePath = file.getPath();
                    this.fileName = file.getName();
                }
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(6);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByProvider(@Nullable DiffContentFactoryEx.ContextProvider contextProvider) {
            if (contextProvider != null) {
                contextProvider.passContext(this);
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(7);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DocumentContent buildFromText(@NotNull String text, boolean respectLineSeparators) {
            if (text == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(8);
            }
            FileType fileType = this.guessFileType();
            String lightFilePath = this.constructLightFilePath();
            TextContent textContent = TextContent.fromText(text, respectLineSeparators);
            Document document = DiffContentFactoryImpl.createDocument(this.project, textContent.text, fileType, lightFilePath, this.readOnly);
            return this.build(document, textContent);
        }

        @Override
        @NotNull
        public DocumentContent buildFromBytes(byte @NotNull [] content) {
            if (content == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(9);
            }
            FileType fileType = this.guessFileType();
            String lightFilePath = this.constructLightFilePath();
            VirtualFile highlightFile = this.constructHighlightFile();
            Charset charset = DiffContentFactoryImpl.guessCharset(this.project, content, fileType, lightFilePath, highlightFile, this.defaultCharset);
            TextContent textContent = TextContent.fromBytes(content, charset);
            Document document = DiffContentFactoryImpl.createDocument(this.project, textContent.text, fileType, lightFilePath, this.readOnly);
            return this.build(document, textContent);
        }

        @NotNull
        private DocumentContent build(@NotNull Document document, @NotNull TextContent textContent) {
            if (document == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(10);
            }
            if (textContent == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(11);
            }
            ContextReferentDocumentContent documentContent = new ContextReferentDocumentContent(this.project, document, textContent, this.context);
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            if (file != null && !file.isInLocalFileSystem()) {
                SyntheticPsiFileSupport.markFile((VirtualFile)file, (String)this.originalFilePath);
            }
            if (this.fileName != null) {
                documentContent.putUserData(DiffUserDataKeysEx.FILE_NAME, this.fileName);
            }
            if (textContent.notification != null) {
                DiffUtil.addNotification(textContent.notification, (UserDataHolder)documentContent);
            }
            ContextReferentDocumentContent contextReferentDocumentContent = documentContent;
            if (contextReferentDocumentContent == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(12);
            }
            return contextReferentDocumentContent;
        }

        @Nullable
        private FileType guessFileType() {
            return this.context != null ? this.context.guessContentType() : null;
        }

        @NotNull
        @NonNls
        private String constructLightFilePath() {
            if (this.originalFilePath != null) {
                String string = this.originalFilePath;
                if (string == null) {
                    DocumentContentBuilderImpl.$$$reportNull$$$0(13);
                }
                return string;
            }
            Object name = this.fileName;
            if (name == null) {
                FileType fileType = this.guessFileType();
                name = "diff." + StringUtil.defaultIfEmpty((String)(fileType != null ? fileType.getDefaultExtension() : null), (String)"txt");
            }
            String string = name;
            if (string == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(14);
            }
            return string;
        }

        @Nullable
        private VirtualFile constructHighlightFile() {
            return this.context != null ? this.context.getHighlightFile() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$DocumentContentBuilderImpl";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReadOnly";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFileName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultCharset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByFileType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByFilePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByHighlightFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByReferent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByProvider";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$DocumentContentBuilderImpl";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructLightFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFromText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFromBytes";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }
    }

    private static interface Context {
        @Nullable
        public VirtualFile getHighlightFile();

        @Nullable
        public FileType guessContentType();

        public static class ByFileType
        implements Context {
            private final FileType myFileType;

            public ByFileType(@NotNull FileType fileType) {
                if (fileType == null) {
                    ByFileType.$$$reportNull$$$0(0);
                }
                this.myFileType = fileType;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return null;
            }

            @Override
            @Nullable
            public FileType guessContentType() {
                return this.myFileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl$Context$ByFileType", "<init>"));
            }
        }

        public static class ByFilePath
        implements Context {
            private final FilePath myFilePath;

            public ByFilePath(@NotNull FilePath filePath) {
                if (filePath == null) {
                    ByFilePath.$$$reportNull$$$0(0);
                }
                this.myFilePath = filePath;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myFilePath.getVirtualFile();
            }

            @Override
            @Nullable
            public FileType guessContentType() {
                VirtualFile file = this.myFilePath.getVirtualFile();
                if (file == null) {
                    return FileTypeManager.getInstance().getFileTypeByFileName(this.myFilePath.getName());
                }
                return file.getFileType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl$Context$ByFilePath", "<init>"));
            }
        }

        public static class ByReferent
        implements Context {
            private final DocumentContent myReferent;

            public ByReferent(@NotNull DocumentContent referent) {
                if (referent == null) {
                    ByReferent.$$$reportNull$$$0(0);
                }
                this.myReferent = referent;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myReferent.getHighlightFile();
            }

            @Override
            @Nullable
            public FileType guessContentType() {
                return this.myReferent.getContentType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/diff/DiffContentFactoryImpl$Context$ByReferent", "<init>"));
            }
        }

        public static class ByHighlightFile
        implements Context {
            private final VirtualFile myHighlightFile;

            public ByHighlightFile(@NotNull VirtualFile highlightFile) {
                if (highlightFile == null) {
                    ByHighlightFile.$$$reportNull$$$0(0);
                }
                this.myHighlightFile = highlightFile;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myHighlightFile;
            }

            @Override
            @Nullable
            public FileType guessContentType() {
                return this.myHighlightFile.getFileType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/DiffContentFactoryImpl$Context$ByHighlightFile", "<init>"));
            }
        }
    }

    private static class TextContent {
        @NotNull
        public final String text;
        @Nullable
        public LineSeparator separators;
        @Nullable
        public Charset charset;
        @Nullable
        public Boolean isBom;
        @Nullable
        public DiffNotificationProvider notification;

        TextContent(@NotNull String text) {
            if (text == null) {
                TextContent.$$$reportNull$$$0(0);
            }
            this.text = text;
        }

        @NotNull
        public static TextContent fromText(@NotNull String text, boolean respectLineSeparators) {
            if (text == null) {
                TextContent.$$$reportNull$$$0(1);
            }
            String correctedContent = StringUtil.convertLineSeparators((String)text);
            TextContent textContent = new TextContent(correctedContent);
            if (respectLineSeparators) {
                textContent.separators = StringUtil.detectSeparators((CharSequence)text);
            }
            TextContent textContent2 = textContent;
            if (textContent2 == null) {
                TextContent.$$$reportNull$$$0(2);
            }
            return textContent2;
        }

        @NotNull
        public static TextContent fromBytes(byte @NotNull [] content, @NotNull Charset charset) {
            if (charset == null) {
                TextContent.$$$reportNull$$$0(3);
            }
            if (content == null) {
                TextContent.$$$reportNull$$$0(4);
            }
            boolean isBom = CharsetToolkit.guessFromBOM((byte[])content) != null;
            boolean malformedContent = false;
            String text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
            if (text == null) {
                text = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
                malformedContent = true;
            }
            TextContent textContent = TextContent.fromText(text, true);
            textContent.charset = charset;
            textContent.isBom = isBom;
            if (malformedContent) {
                String notificationText = DiffBundle.message((String)"error.content.decoded.with.wrong.charset", (Object[])new Object[]{charset.name()});
                textContent.notification = DiffNotifications.createNotificationProvider(notificationText, LightColors.RED, EditorNotificationPanel.Status.Error);
            }
            TextContent textContent2 = textContent;
            if (textContent2 == null) {
                TextContent.$$$reportNull$$$0(5);
            }
            return textContent2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$TextContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charset";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$TextContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromText";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromBytes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ContextReferentDocumentContent
    extends DocumentContentBase {
        @Nullable
        private final LineSeparator mySeparator;
        @Nullable
        private final Charset myCharset;
        @Nullable
        private final Boolean myBOM;
        @Nullable
        private final Context myReferent;

        private ContextReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull TextContent content, @Nullable Context referent) {
            if (document == null) {
                ContextReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (content == null) {
                ContextReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.mySeparator = content.separators;
            this.myCharset = content.charset;
            this.myBOM = content.isBom;
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file != null) {
                return file.getFileType();
            }
            if (this.myReferent != null) {
                return this.myReferent.guessContentType();
            }
            return null;
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent != null ? this.myReferent.getHighlightFile() : null;
        }

        @Nullable
        public LineSeparator getLineSeparator() {
            return this.mySeparator;
        }

        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }

        @Nullable
        public Boolean hasBom() {
            return this.myBOM;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/DiffContentFactoryImpl$ContextReferentDocumentContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

