/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.DiffTool;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.impl.DiffRequestPanelImpl;
import com.intellij.diff.impl.DiffWindow;
import com.intellij.diff.merge.BinaryMergeTool;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeWindow;
import com.intellij.diff.merge.TextMergeTool;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.merge.external.AutomaticExternalMergeTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryDiffTool;
import com.intellij.diff.tools.dir.DirDiffTool;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.external.ExternalMergeTool;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DiffManagerImpl
extends DiffManagerEx {
    public void showDiff(@Nullable Project project, @NotNull DiffRequest request) {
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(0);
        }
        this.showDiff(project, request, DiffDialogHints.DEFAULT);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(1);
        }
        if (hints == null) {
            DiffManagerImpl.$$$reportNull$$$0(2);
        }
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiff(project, (DiffRequestChain)requestChain, hints);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        if (requests == null) {
            DiffManagerImpl.$$$reportNull$$$0(3);
        }
        if (hints == null) {
            DiffManagerImpl.$$$reportNull$$$0(4);
        }
        if (ExternalDiffTool.isEnabled() && ExternalDiffTool.showIfNeeded(project, requests, hints)) {
            return;
        }
        this.showDiffBuiltin(project, requests, hints);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request) {
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(5);
        }
        this.showDiffBuiltin(project, request, DiffDialogHints.DEFAULT);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(6);
        }
        if (hints == null) {
            DiffManagerImpl.$$$reportNull$$$0(7);
        }
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiffBuiltin(project, (DiffRequestChain)requestChain, hints);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        DiffEditorTabFilesManager diffEditorTabFilesManager;
        if (requests == null) {
            DiffManagerImpl.$$$reportNull$$$0(8);
        }
        if (hints == null) {
            DiffManagerImpl.$$$reportNull$$$0(9);
        }
        DiffEditorTabFilesManager diffEditorTabFilesManager2 = diffEditorTabFilesManager = project != null ? DiffEditorTabFilesManager.getInstance(project) : null;
        if (diffEditorTabFilesManager != null && !Registry.is((String)"show.diff.as.frame") && DiffUtil.getWindowMode(hints) == WindowWrapper.Mode.FRAME && !DiffManagerImpl.isFromDialog(project) && hints.getWindowConsumer() == null) {
            ChainDiffVirtualFile diffFile = new ChainDiffVirtualFile(requests, DiffBundle.message((String)"label.default.diff.editor.tab.name", (Object[])new Object[0]));
            diffEditorTabFilesManager.showDiffFile((VirtualFile)diffFile, true);
            return;
        }
        new DiffWindow(project, requests, hints).show();
    }

    private static boolean isFromDialog(@Nullable Project project) {
        return DialogWrapper.findInstance((Component)IdeFocusManager.getInstance((Project)project).getFocusOwner()) != null;
    }

    @NotNull
    public DiffRequestPanel createRequestPanel(@Nullable Project project, @NotNull Disposable parent, @Nullable Window window) {
        if (parent == null) {
            DiffManagerImpl.$$$reportNull$$$0(10);
        }
        DiffRequestPanelImpl panel = new DiffRequestPanelImpl(project, window);
        Disposer.register((Disposable)parent, (Disposable)panel);
        DiffRequestPanelImpl diffRequestPanelImpl = panel;
        if (diffRequestPanelImpl == null) {
            DiffManagerImpl.$$$reportNull$$$0(11);
        }
        return diffRequestPanelImpl;
    }

    @NotNull
    public List<DiffTool> getDiffTools() {
        ArrayList<DiffTool> result = new ArrayList<DiffTool>();
        result.addAll(DiffTool.EP_NAME.getExtensionList());
        result.add((DiffTool)SimpleDiffTool.INSTANCE);
        result.add((DiffTool)UnifiedDiffTool.INSTANCE);
        result.add((DiffTool)BinaryDiffTool.INSTANCE);
        result.add((DiffTool)DirDiffTool.INSTANCE);
        ArrayList<DiffTool> arrayList = result;
        if (arrayList == null) {
            DiffManagerImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<MergeTool> getMergeTools() {
        ArrayList<MergeTool> result = new ArrayList<MergeTool>();
        Collections.addAll(result, (MergeTool[])MergeTool.EP_NAME.getExtensions());
        result.add(TextMergeTool.INSTANCE);
        result.add(BinaryMergeTool.INSTANCE);
        ArrayList<MergeTool> arrayList = result;
        if (arrayList == null) {
            DiffManagerImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @RequiresEdt
    public void showMerge(@Nullable Project project, @NotNull MergeRequest request) {
        ThreesideMergeRequest mergeRequest;
        DiffContent outputContent;
        FileType fileType;
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        AutomaticExternalMergeTool tool = (AutomaticExternalMergeTool)AutomaticExternalMergeTool.EP_NAME.findFirstSafe(mergeTool -> mergeTool.canShow(project, request));
        if (tool != null) {
            tool.show(project, request);
            return;
        }
        if (request instanceof ThreesideMergeRequest && (fileType = (outputContent = (mergeRequest = (ThreesideMergeRequest)request).getOutputContent()).getContentType()) != null) {
            ExternalDiffSettings.ExternalTool mergeTool2 = ExternalDiffSettings.findMergeTool(fileType);
            if (ExternalMergeTool.isEnabled() && mergeTool2 != null) {
                ExternalMergeTool.show(project, mergeTool2, request);
                return;
            }
        }
        this.showMergeBuiltin(project, request);
    }

    @RequiresEdt
    public void showMergeBuiltin(@Nullable Project project, @NotNull MergeRequest request) {
        if (request == null) {
            DiffManagerImpl.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        new MergeWindow.ForRequest(project, request, DiffDialogHints.MODAL).show();
    }

    @RequiresEdt
    public void showMergeBuiltin(@Nullable Project project, @NotNull MergeRequestProducer requestProducer, @NotNull DiffDialogHints hints) {
        if (requestProducer == null) {
            DiffManagerImpl.$$$reportNull$$$0(16);
        }
        if (hints == null) {
            DiffManagerImpl.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        new MergeWindow.ForProducer(project, requestProducer, hints).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffManagerImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffManagerImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffTools";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDiffBuiltin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRequestPanel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showMerge";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showMergeBuiltin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

