/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.BlankDiffWindowUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseShowDiffAction
extends DumbAwareAction {
    BaseShowDiffAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseShowDiffAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        boolean canShow = this.isAvailable(e);
        presentation.setEnabled(canShow);
        if (e.isFromContextMenu()) {
            presentation.setVisible(canShow);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseShowDiffAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        DiffRequestChain chain = this.getDiffRequestChain(e);
        if (chain == null) {
            return;
        }
        DiffManager.getInstance().showDiff(project, chain, DiffDialogHints.DEFAULT);
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    protected static boolean hasContent(@NotNull VirtualFile file) {
        if (file == null) {
            BaseShowDiffAction.$$$reportNull$$$0(2);
        }
        return !DiffUtil.isFileWithoutContent(file);
    }

    @Nullable
    protected abstract DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent var1);

    @NotNull
    public static MutableDiffRequestChain createMutableChainFromFiles(@Nullable Project project, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(4);
        }
        return BaseShowDiffAction.createMutableChainFromFiles(project, file1, file2, null);
    }

    @NotNull
    public static MutableDiffRequestChain createMutableChainFromFiles(@Nullable Project project, @NotNull VirtualFile file1, @NotNull VirtualFile file2, @Nullable VirtualFile baseFile) {
        if (file1 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(6);
        }
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DiffRequestFactory requestFactory = DiffRequestFactory.getInstance();
        DiffContent content1 = contentFactory.create(project, file1);
        DiffContent content2 = contentFactory.create(project, file2);
        DiffContent baseContent = baseFile != null ? contentFactory.create(project, baseFile) : null;
        MutableDiffRequestChain chain = content1 instanceof DocumentContent && content2 instanceof DocumentContent && (baseContent == null || baseContent instanceof DocumentContent) ? BlankDiffWindowUtil.createBlankDiffRequestChain((DocumentContent)content1, (DocumentContent)content2, (DocumentContent)baseContent, project) : new MutableDiffRequestChain(content1, baseContent, content2, project);
        if (baseFile != null) {
            chain.setWindowTitle(requestFactory.getTitle(baseFile));
        } else {
            chain.setWindowTitle(requestFactory.getTitleForComparison(file1, file2));
        }
        MutableDiffRequestChain mutableDiffRequestChain = chain;
        if (mutableDiffRequestChain == null) {
            BaseShowDiffAction.$$$reportNull$$$0(7);
        }
        return mutableDiffRequestChain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/BaseShowDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/BaseShowDiffAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutableChainFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMutableChainFromFiles";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

