/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u000b\b'\u0018\u0000 O*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004LMNOB\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010J\u0014\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0007J\b\u0010'\u001a\u00020\u001aH\u0003J\b\u0010(\u001a\u00020\u001aH\u0003J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H%J\b\u0010*\u001a\u00020\u001aH\u0015J\u0015\u0010+\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0010H%\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00028\u0000H\u0015\u00a2\u0006\u0002\u0010/J/\u00100\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0015\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0015JA\u00106\u001a\u00020\u00172\r\u00107\u001a\t\u0018\u000108\u00a2\u0006\u0002\b92\b\u0010:\u001a\u0004\u0018\u0001082\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00172\b\u0010>\u001a\u0004\u0018\u00010\r2\u0006\u0010?\u001a\u00020@J\u0018\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\rH\u0002J\u001e\u0010C\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0 H\u0007J\u001e\u0010F\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0 H\u0007J \u0010G\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020\u0010H\u0002J\u0010\u0010J\u001a\u00020\r2\u0006\u0010K\u001a\u00020\rH\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00178\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/diff/merge/MergeModelBase;", "S", "Lcom/intellij/diff/merge/MergeModelBase$State;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "startLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "endLines", "changesCount", "", "getChangesCount", "()I", "changesToUpdate", "Lit/unimi/dsi/fastutil/ints/IntSet;", "bulkChangeUpdateDepth", "isInsideCommand", "", "isDisposed", "dispose", "", "getLineStart", "index", "getLineEnd", "setChanges", "changes", "", "Lcom/intellij/diff/util/LineRange;", "setLineStart", "line", "setLineEnd", "clearAll", "invalidateHighlighters", "enterBulkChangeUpdateBlock", "exitBulkChangeUpdateBlock", "reinstallHighlighters", "postInstallHighlighters", "storeChangeState", "(I)Lcom/intellij/diff/merge/MergeModelBase$State;", "restoreChangeState", "state", "(Lcom/intellij/diff/merge/MergeModelBase$State;)V", "processDocumentChange", "oldLine1", "oldLine2", "shift", "(IIII)Lcom/intellij/diff/merge/MergeModelBase$State;", "onRangeManuallyEdit", "executeMergeCommand", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "commandGroupId", "confirmationPolicy", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "underBulkUpdate", "affectedChanges", "task", "Ljava/lang/Runnable;", "registerUndoRedo", "undo", "replaceChange", "newContent", "", "appendChange", "moveChangesAfterInsertion", "newOutputStartLine", "newOutputEndLine", "collectAffectedChanges", "directChanges", "DocumentListener", "UndoableAction", "State", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public abstract class MergeModelBase<S extends State>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final UndoManager undoManager;
    @NotNull
    private final IntList startLines;
    @NotNull
    private final IntList endLines;
    @NotNull
    private final IntSet changesToUpdate;
    private int bulkChangeUpdateDepth;
    private boolean isInsideCommand;
    private boolean isDisposed;
    @NotNull
    private static final Logger LOG;

    public MergeModelBase(@Nullable Project project, @NotNull Document document) {
        UndoManager undoManager;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
        if (this.project != null) {
            UndoManager undoManager2 = UndoManager.getInstance((Project)this.project);
            undoManager = undoManager2;
            Intrinsics.checkNotNullExpressionValue((Object)undoManager2, (String)"getInstance(...)");
        } else {
            UndoManager undoManager3 = UndoManager.getGlobalInstance();
            undoManager = undoManager3;
            Intrinsics.checkNotNullExpressionValue((Object)undoManager3, (String)"getGlobalInstance(...)");
        }
        this.undoManager = undoManager;
        this.startLines = (IntList)new IntArrayList();
        this.endLines = (IntList)new IntArrayList();
        this.changesToUpdate = (IntSet)new IntOpenHashSet();
        this.document.addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)new DocumentListener(), (Disposable)this);
    }

    private final int getChangesCount() {
        return this.startLines.size();
    }

    @RequiresEdt
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        LOG.assertTrue(this.bulkChangeUpdateDepth == 0);
        this.clearAll();
    }

    public final int getLineStart(int index) {
        return this.startLines.getInt(index);
    }

    public final int getLineEnd(int index) {
        return this.endLines.getInt(index);
    }

    public final void setChanges(@NotNull List<LineRange> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.clearAll();
        for (LineRange range : changes) {
            this.startLines.add(range.start);
            this.endLines.add(range.end);
        }
    }

    private final void setLineStart(int index, int line) {
        this.startLines.set(index, line);
    }

    private final void setLineEnd(int index, int line) {
        this.endLines.set(index, line);
    }

    private final void clearAll() {
        this.startLines.clear();
        this.endLines.clear();
    }

    @RequiresEdt
    public final void invalidateHighlighters(int index) {
        if (this.bulkChangeUpdateDepth > 0) {
            this.changesToUpdate.add(index);
        } else {
            this.reinstallHighlighters(index);
        }
    }

    @RequiresEdt
    private final void enterBulkChangeUpdateBlock() {
        int n = this.bulkChangeUpdateDepth;
        this.bulkChangeUpdateDepth = n + 1;
    }

    @RequiresEdt
    private final void exitBulkChangeUpdateBlock() {
        int n = this.bulkChangeUpdateDepth;
        this.bulkChangeUpdateDepth = n + -1;
        LOG.assertTrue(this.bulkChangeUpdateDepth >= 0);
        if (this.bulkChangeUpdateDepth == 0) {
            this.changesToUpdate.forEach(arg_0 -> MergeModelBase.exitBulkChangeUpdateBlock$lambda$0(this, arg_0));
            this.changesToUpdate.clear();
            this.postInstallHighlighters();
        }
    }

    @RequiresEdt
    protected abstract void reinstallHighlighters(int var1);

    @RequiresEdt
    protected void postInstallHighlighters() {
    }

    @RequiresEdt
    @NotNull
    protected abstract S storeChangeState(int var1);

    @RequiresEdt
    protected void restoreChangeState(@NotNull S state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.setLineStart(((State)state).getIndex(), ((State)state).getStartLine());
        this.setLineEnd(((State)state).getIndex(), ((State)state).getEndLine());
    }

    @RequiresEdt
    @Nullable
    protected S processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
        boolean rangeManuallyEdit;
        int line1 = this.getLineStart(index);
        int line2 = this.getLineEnd(index);
        DiffUtil.UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        Intrinsics.checkNotNullExpressionValue((Object)updatedLineRange, (String)"updateRangeOnModification(...)");
        DiffUtil.UpdatedLineRange newRange = updatedLineRange;
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        boolean bl = rangeManuallyEdit = newRange.damaged || oldLine2 > line1 && oldLine1 < line2;
        if (rangeManuallyEdit && !this.isInsideCommand && !this.undoManager.isUndoOrRedoInProgress()) {
            this.onRangeManuallyEdit(index);
        }
        S oldState = rangeAffected ? (S)this.storeChangeState(index) : null;
        this.setLineStart(index, newRange.startLine);
        this.setLineEnd(index, newRange.endLine);
        return oldState;
    }

    @ApiStatus.Internal
    protected void onRangeManuallyEdit(int index) {
    }

    public final boolean executeMergeCommand(@Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @Nullable IntList affectedChanges, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)confirmationPolicy, (String)"confirmationPolicy");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        IntList intList = affectedChanges;
        IntList allAffectedChanges = intList != null ? this.collectAffectedChanges(intList) : IntLists.emptyList();
        return DiffUtil.executeWriteCommand(this.project, this.document, commandName, commandGroupId, confirmationPolicy, underBulkUpdate, () -> MergeModelBase.executeMergeCommand$lambda$0(this, allAffectedChanges, task));
    }

    private final void registerUndoRedo(boolean undo, IntList affectedChanges) {
        List states = null;
        if (!((Collection)affectedChanges).isEmpty()) {
            states = new ArrayList(affectedChanges.size());
            affectedChanges.forEach(arg_0 -> MergeModelBase.registerUndoRedo$lambda$0(states, this, arg_0));
        } else {
            states = new ArrayList(this.getChangesCount());
            int n = this.getChangesCount();
            for (int index = 0; index < n; ++index) {
                ((ArrayList)states).add(this.storeChangeState(index));
            }
        }
        this.undoManager.undoableActionPerformed((com.intellij.openapi.command.undo.UndoableAction)new UndoableAction(this, states, undo));
    }

    @RequiresWriteLock
    public final void replaceChange(int index, @NotNull List<? extends CharSequence> newContent) {
        Intrinsics.checkNotNullParameter(newContent, (String)"newContent");
        LOG.assertTrue(this.isInsideCommand);
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.document, outputStartLine, outputEndLine, newContent);
        if (outputStartLine == outputEndLine) {
            int newOutputEndLine = outputStartLine + newContent.size();
            this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
        }
    }

    @RequiresWriteLock
    public final void appendChange(int index, @NotNull List<? extends CharSequence> newContent) {
        Intrinsics.checkNotNullParameter(newContent, (String)"newContent");
        LOG.assertTrue(this.isInsideCommand);
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.document, outputEndLine, outputEndLine, newContent);
        int newOutputEndLine = outputEndLine + newContent.size();
        this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
    }

    private final void moveChangesAfterInsertion(int index, int newOutputStartLine, int newOutputEndLine) {
        LOG.assertTrue(this.isInsideCommand);
        if (this.getLineStart(index) != newOutputStartLine || this.getLineEnd(index) != newOutputEndLine) {
            this.setLineStart(index, newOutputStartLine);
            this.setLineEnd(index, newOutputEndLine);
            this.invalidateHighlighters(index);
        }
        boolean beforeChange = true;
        int n = this.getChangesCount();
        for (int otherIndex = 0; otherIndex < n; ++otherIndex) {
            int newEndLine;
            int startLine = this.getLineStart(otherIndex);
            int endLine = this.getLineEnd(otherIndex);
            if (endLine < newOutputStartLine) continue;
            if (startLine > newOutputEndLine) break;
            if (index == otherIndex) {
                beforeChange = false;
                continue;
            }
            int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : newOutputEndLine;
            int n2 = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
            if (startLine == newStartLine && endLine == newEndLine) continue;
            this.setLineStart(otherIndex, newStartLine);
            this.setLineEnd(otherIndex, newEndLine);
            this.invalidateHighlighters(otherIndex);
        }
    }

    @RequiresEdt
    private final IntList collectAffectedChanges(IntList directChanges) {
        IntList result = (IntList)new IntArrayList(directChanges.size());
        int directArrayIndex = 0;
        int otherIndex = 0;
        while (directArrayIndex < directChanges.size() && otherIndex < this.getChangesCount()) {
            int directIndex = directChanges.getInt(directArrayIndex);
            if (directIndex == otherIndex) {
                result.add(directIndex);
                ++otherIndex;
                continue;
            }
            int directStart = this.getLineStart(directIndex);
            int directEnd = this.getLineEnd(directIndex);
            int otherStart = this.getLineStart(otherIndex);
            int otherEnd = this.getLineEnd(otherIndex);
            if (otherEnd < directStart) {
                ++otherIndex;
                continue;
            }
            if (otherStart > directEnd) {
                ++directArrayIndex;
                continue;
            }
            result.add(otherIndex);
            ++otherIndex;
        }
        LOG.assertTrue(directChanges.size() <= result.size());
        return result;
    }

    private static final void exitBulkChangeUpdateBlock$lambda$0(MergeModelBase this$0, int index) {
        this$0.reinstallHighlighters(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void executeMergeCommand$lambda$0(MergeModelBase this$0, IntList $allAffectedChanges, Runnable $task) {
        LOG.assertTrue(!this$0.isInsideCommand);
        this$0.isInsideCommand = true;
        this$0.enterBulkChangeUpdateBlock();
        try {
            Intrinsics.checkNotNull((Object)$allAffectedChanges);
            this$0.registerUndoRedo(true, $allAffectedChanges);
            try {
                $task.run();
            }
            finally {
                this$0.registerUndoRedo(false, $allAffectedChanges);
            }
        }
        finally {
            this$0.exitBulkChangeUpdateBlock();
            this$0.isInsideCommand = false;
        }
    }

    private static final void registerUndoRedo$lambda$0(List $states, MergeModelBase this$0, int index) {
        ((ArrayList)$states).add(this$0.storeChangeState(index));
    }

    static {
        Logger logger = Logger.getInstance(MergeModelBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diff/merge/MergeModelBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/merge/MergeModelBase$DocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/diff/merge/MergeModelBase;)V", "beforeDocumentChange", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "intellij.platform.diff.impl"})
    private final class DocumentListener
    implements com.intellij.openapi.editor.event.DocumentListener {
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (MergeModelBase.this.isDisposed) {
                return;
            }
            MergeModelBase.this.enterBulkChangeUpdateBlock();
            if (MergeModelBase.this.getChangesCount() == 0) {
                return;
            }
            LineRange lineRange = DiffUtil.getAffectedLineRange(e);
            Intrinsics.checkNotNullExpressionValue((Object)lineRange, (String)"getAffectedLineRange(...)");
            LineRange lineRange2 = lineRange;
            int shift = DiffUtil.countLinesShift(e);
            List corruptedStates = (List)new SmartList();
            int n = MergeModelBase.this.getChangesCount();
            for (int index = 0; index < n; ++index) {
                Object oldState = MergeModelBase.this.processDocumentChange(index, lineRange2.start, lineRange2.end, shift);
                if (oldState == null) continue;
                MergeModelBase.this.invalidateHighlighters(index);
                if (MergeModelBase.this.isInsideCommand) continue;
                corruptedStates.add(oldState);
            }
            if (!corruptedStates.isEmpty()) {
                MergeModelBase.this.undoManager.undoableActionPerformed((com.intellij.openapi.command.undo.UndoableAction)new UndoableAction(MergeModelBase.this, corruptedStates, true));
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (MergeModelBase.this.isDisposed) {
                return;
            }
            MergeModelBase.this.exitBulkChangeUpdateBlock();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/merge/MergeModelBase$State;", "", "index", "", "startLine", "endLine", "<init>", "(III)V", "getIndex", "()I", "getStartLine", "getEndLine", "intellij.platform.diff.impl"})
    public static class State {
        private final int index;
        private final int startLine;
        private final int endLine;

        public State(int index, int startLine, int endLine) {
            this.index = index;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getEndLine() {
            return this.endLine;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0014\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/merge/MergeModelBase$UndoableAction;", "Lcom/intellij/openapi/command/undo/BasicUndoableAction;", "model", "Lcom/intellij/diff/merge/MergeModelBase;", "states", "", "Lcom/intellij/diff/merge/MergeModelBase$State;", "isUndo", "", "<init>", "(Lcom/intellij/diff/merge/MergeModelBase;Ljava/util/List;Z)V", "modelRef", "Ljava/lang/ref/WeakReference;", "undo", "", "redo", "restoreStates", "intellij.platform.diff.impl"})
    private static final class UndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final List<State> states;
        private final boolean isUndo;
        @NotNull
        private final WeakReference<MergeModelBase<?>> modelRef;

        public UndoableAction(@NotNull MergeModelBase<?> model, @NotNull List<? extends State> states, boolean isUndo) {
            Intrinsics.checkNotNullParameter(model, (String)"model");
            Intrinsics.checkNotNullParameter(states, (String)"states");
            Document[] documentArray = new Document[]{((MergeModelBase)model).document};
            super(documentArray);
            this.states = states;
            this.isUndo = isUndo;
            this.modelRef = new WeakReference(model);
        }

        public void undo() {
            MergeModelBase mergeModelBase = (MergeModelBase)this.modelRef.get();
            if (mergeModelBase == null) {
                return;
            }
            MergeModelBase model = mergeModelBase;
            if (this.isUndo) {
                this.restoreStates(model);
            }
        }

        public void redo() {
            MergeModelBase mergeModelBase = (MergeModelBase)this.modelRef.get();
            if (mergeModelBase == null) {
                return;
            }
            MergeModelBase model = mergeModelBase;
            if (!this.isUndo) {
                this.restoreStates(model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void restoreStates(MergeModelBase<?> model) {
            if (((MergeModelBase)model).isDisposed) {
                return;
            }
            if (((MergeModelBase)model).getChangesCount() == 0) {
                return;
            }
            ((MergeModelBase)model).enterBulkChangeUpdateBlock();
            try {
                Intrinsics.checkNotNull(model, (String)"null cannot be cast to non-null type com.intellij.diff.merge.MergeModelBase<com.intellij.diff.merge.MergeModelBase.State>");
                for (State state : this.states) {
                    model.restoreChangeState(state);
                    model.invalidateHighlighters(state.getIndex());
                }
            }
            finally {
                ((MergeModelBase)model).exitBulkChangeUpdateBlock();
            }
        }
    }
}

