/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result, final @NotNull MergeRequest request, final @NotNull MergeContext context, final @NotNull MergeTool.MergeViewer viewer, final boolean contentWasModified) {
        if (result == null) {
            MergeUtil.$$$reportNull$$$0(0);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(2);
        }
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(3);
        }
        String caption = MergeUtil.getResolveActionTitle(result, request, context);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request, context, contentWasModified)) {
                    return;
                }
                context.finishMerge(result);
            }
        };
    }

    @Nls
    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result, @Nullable MergeRequest request, @Nullable MergeContext context) {
        Function<MergeResult, String> getter;
        String message;
        if (result == null) {
            MergeUtil.$$$reportNull$$$0(4);
        }
        String string = message = (getter = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS)) != null ? (String)getter.fun((Object)result) : null;
        if (message != null) {
            String string2 = message;
            if (string2 == null) {
                MergeUtil.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = DiffBundle.message((String)(switch (result) {
            default -> throw new MatchException(null, null);
            case MergeResult.CANCEL -> "button.merge.resolve.cancel";
            case MergeResult.LEFT -> "button.merge.resolve.accept.left";
            case MergeResult.RIGHT -> "button.merge.resolve.accept.right";
            case MergeResult.RESOLVED -> "button.merge.resolve.apply";
        }), (Object[])new Object[0]);
        if (string3 == null) {
            MergeUtil.$$$reportNull$$$0(6);
        }
        return string3;
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            MergeUtil.$$$reportNull$$$0(7);
        }
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]));
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]));
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        List<String> list = Arrays.asList(left, base, right);
        if (list == null) {
            MergeUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request, @NotNull MergeContext context, boolean contentWasModified) {
        Condition<MergeTool.MergeViewer> customHandler;
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(9);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(11);
        }
        if ((customHandler = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER)) != null) {
            return customHandler.value((Object)viewer);
        }
        return !contentWasModified || MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request, context);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component2, @NotNull MergeRequest request, @NotNull MergeContext context) {
        Couple<String> customMessage;
        if (component2 == null) {
            MergeUtil.$$$reportNull$$$0(12);
        }
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(14);
        }
        if ((customMessage = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE)) != null) {
            String title = (String)customMessage.first;
            String message = (String)customMessage.second;
            return MessageDialogBuilder.yesNo((String)title, (String)message).ask((Component)component2);
        }
        return MergeUtil.showConfirmDiscardChangesDialog(component2, DiffBundle.message((String)"button.cancel.merge", (Object[])new Object[0]), true);
    }

    public static boolean showConfirmDiscardChangesDialog(@NotNull JComponent parent, @NotNull @Nls String actionName, boolean contentWasModified) {
        if (parent == null) {
            MergeUtil.$$$reportNull$$$0(15);
        }
        if (actionName == null) {
            MergeUtil.$$$reportNull$$$0(16);
        }
        if (!contentWasModified) {
            return true;
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)actionName, (String)DiffBundle.message((String)"label.merge.unsaved.changes.discard.and.do.anyway", (Object[])new Object[]{actionName.toLowerCase(DynamicBundle.getLocale())})).yesText(DiffBundle.message((String)"button.discard.changes.and.do", (Object[])new Object[]{actionName}))).noText(DiffBundle.message((String)"button.continue.merge", (Object[])new Object[0]))).ask((Component)parent);
    }

    public static boolean shouldRestoreOriginalContentOnCancel(@NotNull MergeRequest request) {
        MergeCallback callback;
        if (request == null) {
            MergeUtil.$$$reportNull$$$0(17);
        }
        if ((callback = MergeCallback.getCallback((MergeRequest)request)).checkIsValid()) {
            return true;
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.conflict.is.outdated", (Object[])new Object[0])).yesText(CommonBundle.message((String)"button.without.mnemonic.restore", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.without.mnemonic.do.nothing", (Object[])new Object[0]))).guessWindowAndAsk();
    }

    public static void reportProjectFileChangeIfNeeded(@Nullable Project project, @Nullable VirtualFile file) {
        if (project != null && file != null && MergeUtil.isProjectFile(file)) {
            StoreReloadManager.Companion.getInstance(project).saveChangedProjectFile(file);
        }
    }

    private static boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            MergeUtil.$$$reportNull$$$0(18);
        }
        if (file.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file);
        return importProvider != null && importProvider.lookForProjectsInDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContentTitles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveActionTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullizeContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleResolveAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolveActionTitle";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNullizeContentTitles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showExitWithoutApplyingChangesDialog";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showConfirmDiscardChangesDialog";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreOriginalContentOnCancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                ProxyDiffContext.$$$reportNull$$$0(0);
            }
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocusedInWindow() {
            return this.myMergeContext.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            this.myMergeContext.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(1);
            }
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(2);
            }
            this.myMergeContext.putUserData(key, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeUtil$ProxyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

