/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    @Nls
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file, @NlsContexts.DialogTitle @Nullable String title) {
        if (file == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(0);
        }
        this(file.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName, @NlsContexts.DialogTitle @Nullable String title) {
        if (fileName == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(1);
        }
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(@NotNull DiffContext context) {
        if (context == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(2);
        }
        return UnknownFileTypeDiffRequest.createComponent(this.myFileName, context);
    }

    @NotNull
    public static JComponent createComponent(@Nullable String fileName, @Nullable DiffContext context) {
        String message = DiffBundle.message((String)"error.cant.show.diff.for.unknown.file", (Object[])new Object[0]);
        if (fileName == null) {
            JPanel jPanel = DiffUtil.createMessagePanel(message);
            if (jPanel == null) {
                UnknownFileTypeDiffRequest.$$$reportNull$$$0(3);
            }
            return jPanel;
        }
        JComponent jComponent = ErrorDiffTool.createReloadMessagePanel(context, message, DiffBundle.message((String)"button.associate.file.type", (Object[])new Object[0]), () -> FileTypeChooser.associateFileType((String)fileName));
        if (jComponent == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

