/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0014H\u0005J\b\u0010\u0016\u001a\u00020\u0014H\u0005J\b\u0010\u0017\u001a\u00020\u0014H\u0005J\b\u0010\u0018\u001a\u00020\u0014H\u0005J\b\u0010\u0019\u001a\u00020\u0014H\u0015J\b\u0010\u001a\u001a\u00020\u0014H\u0005J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H&J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H&J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H$J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020-J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0004J\u0010\u0010/\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00060"}, d2={"Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "", "conflictType", "Lcom/intellij/diff/util/MergeConflictType;", "<init>", "(Lcom/intellij/diff/util/MergeConflictType;)V", "getConflictType", "()Lcom/intellij/diff/util/MergeConflictType;", "setConflictType", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "innerHighlighters", "operations", "Lcom/intellij/diff/util/DiffGutterOperation;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "getInnerFragments", "()Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "destroy", "", "installHighlighters", "installInnerHighlighters", "destroyHighlighters", "destroyInnerHighlighters", "installOperations", "destroyOperations", "updateGutterActions", "force", "", "getStartLine", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "getEndLine", "isResolved", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "isConflict", "()Z", "isChange", "Lcom/intellij/diff/util/Side;", "createHighlighter", "createInnerHighlighter", "intellij.platform.diff.impl"})
public abstract class ThreesideDiffChangeBase {
    @NotNull
    private MergeConflictType conflictType;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @JvmField
    @NotNull
    protected final List<RangeHighlighter> innerHighlighters;
    @JvmField
    @NotNull
    protected final List<DiffGutterOperation> operations;

    public ThreesideDiffChangeBase(@NotNull MergeConflictType conflictType) {
        Intrinsics.checkNotNullParameter((Object)conflictType, (String)"conflictType");
        this.conflictType = conflictType;
        this.highlighters = new ArrayList();
        this.innerHighlighters = new ArrayList();
        this.operations = new ArrayList();
    }

    @NotNull
    public final MergeConflictType getConflictType() {
        return this.conflictType;
    }

    public final void setConflictType(@NotNull MergeConflictType mergeConflictType) {
        Intrinsics.checkNotNullParameter((Object)mergeConflictType, (String)"<set-?>");
        this.conflictType = mergeConflictType;
    }

    @Nullable
    protected abstract MergeInnerDifferences getInnerFragments();

    @RequiresEdt
    public final void destroy() {
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
        this.destroyOperations();
    }

    @RequiresEdt
    protected final void installHighlighters() {
        boolean bl = this.highlighters.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.createHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    protected final void installInnerHighlighters() {
        boolean bl = this.innerHighlighters.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.createInnerHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createInnerHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createInnerHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    protected final void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        this.highlighters.clear();
    }

    @RequiresEdt
    protected final void destroyInnerHighlighters() {
        for (RangeHighlighter highlighter : this.innerHighlighters) {
            highlighter.dispose();
        }
        this.innerHighlighters.clear();
    }

    @RequiresEdt
    protected void installOperations() {
    }

    @RequiresEdt
    protected final void destroyOperations() {
        for (DiffGutterOperation operation : this.operations) {
            operation.dispose();
        }
        this.operations.clear();
    }

    public final void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.operations) {
            operation.update(force);
        }
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    public abstract boolean isResolved(@NotNull ThreeSide var1);

    @NotNull
    protected abstract Editor getEditor(@NotNull ThreeSide var1);

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getDiffType(this.conflictType);
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"getDiffType(...)");
        return textDiffType;
    }

    public final boolean isConflict() {
        return this.conflictType.getType() == MergeConflictType.Type.CONFLICT;
    }

    public final boolean isChange(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.conflictType.isChange(side);
    }

    public final boolean isChange(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.conflictType.isChange(side);
    }

    protected final void createHighlighter(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Editor editor = this.getEditor(side);
        TextDiffType type = this.getDiffType();
        int startLine = this.getStartLine(side);
        int endLine = this.getEndLine(side);
        boolean resolved = this.isResolved(side);
        boolean ignored = !resolved && this.getInnerFragments() != null;
        boolean shouldHideWithoutLineNumbers = side == ThreeSide.BASE && !this.isChange(Side.LEFT) && this.isChange(Side.RIGHT);
        List<RangeHighlighter> list = new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(shouldHideWithoutLineNumbers).withHideStripeMarkers(side == ThreeSide.BASE).done();
        Intrinsics.checkNotNullExpressionValue(list, (String)"done(...)");
        this.highlighters.addAll((Collection<RangeHighlighter>)list);
    }

    protected final void createInnerHighlighter(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (this.isResolved(side)) {
            return;
        }
        MergeInnerDifferences innerFragments = this.getInnerFragments();
        if (innerFragments == null) {
            return;
        }
        List<TextRange> ranges = innerFragments.get(side);
        if (ranges == null) {
            return;
        }
        Editor editor = this.getEditor(side);
        int start = DiffUtil.getLinesRange(editor.getDocument(), this.getStartLine(side), this.getEndLine(side)).getStartOffset();
        for (TextRange fragment : ranges) {
            int innerStart = start + fragment.getStartOffset();
            int innerEnd = start + fragment.getEndOffset();
            List<RangeHighlighter> list = DiffDrawUtil.createInlineHighlighter(editor, innerStart, innerEnd, this.getDiffType());
            Intrinsics.checkNotNullExpressionValue(list, (String)"createInlineHighlighter(...)");
            this.innerHighlighters.addAll((Collection<RangeHighlighter>)list);
        }
    }
}

