/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.MouseEventAdapter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffSplitter
extends JBSplitter {
    @Nullable
    private Painter myPainter;
    @Nullable
    private AnAction myTopAction;
    @Nullable
    private AnAction myBottomAction;

    public DiffSplitter() {
        this.setDividerWidth(JBUIScale.scale((int)Registry.intValue((String)"diff.divider.width")));
    }

    protected Divider createDivider() {
        return new Splitter.DividerImpl(){

            public void setOrientation(boolean isVerticalSplit) {
                int width;
                this.removeAll();
                this.setCursor(Cursor.getPredefinedCursor(10));
                List<JComponent> actionComponents = Arrays.asList(DiffSplitter.createActionComponent(DiffSplitter.this.myTopAction), DiffSplitter.createActionComponent(DiffSplitter.this.myBottomAction));
                List<JComponent> syncComponents = DiffUtil.createSyncHeightComponents(actionComponents);
                GridBag bag = new GridBag();
                JComponent button1 = syncComponents.get(0);
                JComponent button2 = syncComponents.get(1);
                if (button1 != null) {
                    width = button1.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button2 != null) {
                    width = button2.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button1 != null) {
                    this.add(button1, bag.nextLine());
                }
                if (button1 != null && button2 != null) {
                    this.add(Box.createVerticalStrut(JBUIScale.scale((int)20)), bag.nextLine());
                }
                if (button2 != null) {
                    this.add(button2, bag.nextLine());
                }
                this.revalidate();
                this.repaint();
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DiffSplitter.this.myPainter != null) {
                    DiffSplitter.this.myPainter.paint(g, (JComponent)((Object)this));
                }
            }
        };
    }

    public void setTopAction(@Nullable AnAction value) {
        this.myTopAction = value;
        this.setOrientation(false);
    }

    public void setBottomAction(@Nullable AnAction value) {
        this.myBottomAction = value;
        this.setOrientation(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPainter(@Nullable Painter painter) {
        void painter2;
        ThreadingAssertions.assertEventDispatchThread();
        this.myPainter = painter2;
    }

    public void repaintDivider() {
        this.getDivider().repaint();
    }

    @Nullable
    private static JComponent createActionComponent(@Nullable AnAction action2) {
        if (action2 == null) {
            return null;
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffSplitter", (ActionGroup)new DefaultActionGroup(new AnAction[]{action2}), true);
        toolbar.setTargetComponent(toolbar.getComponent());
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setCursor(Cursor.getDefaultCursor());
        return toolbar.getComponent();
    }

    public void redispatchWheelEventsTo(@Nullable EditorHolder holder) {
        DiffSplitter.redispatchWheelEventsToDivider((JPanel)this.myDivider, holder);
    }

    static void redispatchWheelEventsToDivider(@NotNull JPanel divider, @Nullable EditorHolder holder) {
        if (divider == null) {
            DiffSplitter.$$$reportNull$$$0(0);
        }
        if (holder instanceof TextEditorHolder) {
            final TextEditorHolder textEditorHolder = (TextEditorHolder)holder;
            divider.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    EditorEx editor = textEditorHolder.getEditor();
                    JScrollPane scrollPane2 = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)editor.getContentComponent());
                    MouseEventAdapter.redispatch((MouseEvent)e, (Component)scrollPane2);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/DiffSplitter", "redispatchWheelEventsToDivider"));
    }

    public static interface Painter {
        public void paint(@NotNull Graphics var1, @NotNull JComponent var2);
    }
}

