/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffViewerEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements DiffViewerEx,
UiCompatibleDataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @NotNull
    private final List<DiffViewerListener> listeners;
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final DiffTaskQueue myTaskExecutor;
    @NotNull
    private final Alarm taskAlarm;
    private boolean pendingRediff;
    private volatile boolean isDisposed;

    public DiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            DiffViewerBase.$$$reportNull$$$0(0);
        }
        if (request == null) {
            DiffViewerBase.$$$reportNull$$$0(1);
        }
        this.listeners = new SmartList();
        this.myTaskExecutor = new DiffTaskQueue();
        this.taskAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, null, null, null);
        this.pendingRediff = true;
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        if (LOG.isDebugEnabled() && !ApplicationManager.getApplication().isHeadlessEnvironment() && (this.getComponent().getWidth() <= 0 || this.getComponent().getHeight() <= 0)) {
            LOG.warn("Diff shown for a hidden component, initial scroll position might be invalid", new Throwable());
        }
        this.processContextHints();
        this.onInit();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        this.fireEvent(EventType.INIT);
        DiffUtil.installShowNotifyListener(this.getComponent(), new Activatable(){
            private boolean wasNotShownYet = true;

            public void showNotify() {
                DiffViewerBase.this.rediff(this.wasNotShownYet);
                this.wasNotShownYet = false;
            }

            public void hideNotify() {
                DiffViewerBase.this.abortRediff();
            }
        });
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            DiffViewerBase.$$$reportNull$$$0(2);
        }
        return toolbarComponents;
    }

    @RequiresEdt
    public final void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
            this.abortRediff();
            this.updateContextHints();
            this.fireEvent(EventType.DISPOSE);
            this.onDispose();
        });
    }

    @RequiresEdt
    protected void processContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void updateContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    public final void scheduleRediff() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        if (UIUtil.isShowing((Component)this.getComponent())) {
            this.taskAlarm.addRequest(() -> this.rediff(), 300L);
        }
    }

    @RequiresEdt
    public final void abortRediff() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myTaskExecutor.abort();
        this.taskAlarm.cancelAllRequests();
        this.fireEvent(EventType.REDIFF_ABORTED);
    }

    @RequiresEdt
    public final void rediff() {
        ThreadingAssertions.assertEventDispatchThread();
        this.rediff(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void rediff(boolean bl) {
        void trySync;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.pendingRediff = true;
        this.fireEvent(EventType.BEFORE_REDIFF);
        this.onBeforeRediff();
        boolean forceEDT = this.forceRediffSynchronously();
        long waitMillis = trySync != false || this.tryRediffSynchronously() ? 300L : 0L;
        this.myTaskExecutor.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            Runnable callback = this.performRediff((ProgressIndicator)indicator);
            return () -> {
                callback.run();
                this.pendingRediff = false;
                this.onAfterRediff();
                this.fireEvent(EventType.AFTER_REDIFF);
            };
        }), this::onSlowRediff, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            DiffViewerBase.$$$reportNull$$$0(3);
        }
        return contentDiffRequest;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            DiffViewerBase.$$$reportNull$$$0(4);
        }
        return diffContext;
    }

    @RequiresEdt
    public boolean hasPendingRediff() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.pendingRediff;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    @RequiresEdt
    protected boolean tryRediffSynchronously() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myContext.isWindowFocused();
    }

    @RequiresEdt
    protected boolean forceRediffSynchronously() {
        ThreadingAssertions.assertEventDispatchThread();
        return ApplicationManager.getApplication().isWriteAccessAllowed();
    }

    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(ActionManager.getInstance().getAction("Diff.ViewerToolbar"));
        return group;
    }

    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(ActionManager.getInstance().getAction("Diff.ViewerPopupMenu"));
        return group;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    @RequiresEdt
    protected void onInit() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void onSlowRediff() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void onBeforeRediff() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void onAfterRediff() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresBackgroundThread
    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
        Disposer.dispose((Disposable)this.taskAlarm);
    }

    @RequiresEdt
    public void addListener(@NotNull DiffViewerListener listener) {
        if (listener == null) {
            DiffViewerBase.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.listeners.add(listener);
    }

    @RequiresEdt
    public void removeListener(@NotNull DiffViewerListener listener) {
        if (listener == null) {
            DiffViewerBase.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.listeners.remove(listener);
    }

    @RequiresEdt
    @NotNull
    protected List<DiffViewerListener> getListeners() {
        ThreadingAssertions.assertEventDispatchThread();
        List<DiffViewerListener> list = this.listeners;
        if (list == null) {
            DiffViewerBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @RequiresEdt
    private void fireEvent(@NotNull EventType type) {
        if (type == null) {
            DiffViewerBase.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (DiffViewerListener listener : this.listeners) {
            switch (type.ordinal()) {
                case 0: {
                    listener.onInit();
                    break;
                }
                case 1: {
                    listener.onDispose();
                    break;
                }
                case 2: {
                    listener.onBeforeRediff();
                    break;
                }
                case 3: {
                    listener.onAfterRediff();
                    break;
                }
                case 4: {
                    listener.onRediffAborted();
                }
            }
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DiffViewerBase.$$$reportNull$$$0(9);
        }
        sink.set(DiffDataKeys.NAVIGATABLE, (Object)((Navigatable)EditorThreading.compute(() -> this.getNavigatable())));
        sink.set(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE, (Object)this.getDifferenceIterable());
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/DiffViewerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/DiffViewerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    private static enum EventType {
        INIT,
        DISPOSE,
        BEFORE_REDIFF,
        AFTER_REDIFF,
        REDIFF_ABORTED;

    }
}

