/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.InvisibleWrapper;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DiffContentLayoutPanel
extends JBPanel<DiffContentLayoutPanel> {
    final Wrapper myTitle;
    final Wrapper myTopBreadcrumbs;
    final JComponent myContent;
    final Wrapper myBottomBreadcrumbs;

    public DiffContentLayoutPanel(@NotNull JComponent content) {
        if (content == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(0);
        }
        this.myTitle = new InvisibleWrapper();
        this.myTopBreadcrumbs = new InvisibleWrapper();
        this.myBottomBreadcrumbs = new InvisibleWrapper();
        this.myContent = content;
        DiffContentLayoutPanel.initLayout(this, (JComponent)this.myTitle, (JComponent)this.myTopBreadcrumbs, this.myContent, (JComponent)this.myBottomBreadcrumbs);
    }

    @NotNull
    public JComponent getContent() {
        JComponent jComponent = this.myContent;
        if (jComponent == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getTitle() {
        Wrapper wrapper = this.myTitle;
        if (wrapper == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(2);
        }
        return wrapper;
    }

    @NotNull
    public JComponent getTopBreadcrumbs() {
        Wrapper wrapper = this.myTopBreadcrumbs;
        if (wrapper == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(3);
        }
        return wrapper;
    }

    @NotNull
    public JComponent getBottomBreadcrumbs() {
        Wrapper wrapper = this.myBottomBreadcrumbs;
        if (wrapper == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(4);
        }
        return wrapper;
    }

    public void setTitle(@Nullable JComponent titles) {
        this.myTitle.setContent(titles);
    }

    public void setTopBreadcrumbs(@Nullable JComponent breadcrumbs) {
        this.myTopBreadcrumbs.setContent(breadcrumbs);
    }

    public void setBottomBreadcrumbs(@Nullable JComponent breadcrumbs) {
        this.myBottomBreadcrumbs.setContent(breadcrumbs);
    }

    private static void initLayout(@NotNull DiffContentLayoutPanel contentPanel2, @NotNull JComponent title, @NotNull JComponent topBreadcrumbs, @NotNull JComponent content, @NotNull JComponent bottomBreadcrumbs) {
        if (contentPanel2 == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(5);
        }
        if (title == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(6);
        }
        if (topBreadcrumbs == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(7);
        }
        if (content == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(8);
        }
        if (bottomBreadcrumbs == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(9);
        }
        contentPanel2.removeAll();
        contentPanel2.setLayout((LayoutManager)((Object)new DiffContentLayout(title, topBreadcrumbs, content, bottomBreadcrumbs)));
        contentPanel2.add(title);
        contentPanel2.add(topBreadcrumbs);
        contentPanel2.add(content);
        contentPanel2.add(bottomBreadcrumbs);
    }

    public static void syncTitleHeights(@NotNull List<? extends DiffContentLayoutPanel> panels) {
        if (panels == null) {
            DiffContentLayoutPanel.$$$reportNull$$$0(10);
        }
        List titles = ContainerUtil.map(panels, it -> it.myTitle);
        List topBreadcrumbs = ContainerUtil.map(panels, it -> it.myTopBreadcrumbs);
        List<JComponent> syncTitles = DiffUtil.createSyncHeightComponents(titles);
        List<JComponent> syncTopBreadcrumbs = DiffUtil.createSyncHeightComponents(topBreadcrumbs);
        for (int i = 0; i < panels.size(); ++i) {
            DiffContentLayoutPanel contentPanel2 = panels.get(i);
            JComponent title = syncTitles.get(i);
            JComponent topBreadcrumb = syncTopBreadcrumbs.get(i);
            DiffContentLayoutPanel.initLayout(contentPanel2, title, topBreadcrumb, contentPanel2.myContent, (JComponent)contentPanel2.myBottomBreadcrumbs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/DiffContentLayoutPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topBreadcrumbs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomBreadcrumbs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/DiffContentLayoutPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopBreadcrumbs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomBreadcrumbs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initLayout";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncTitleHeights";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class DiffContentLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myTitle;
        @NotNull
        private final JComponent myTopBreadcrumbs;
        @NotNull
        private final JComponent myContent;
        @NotNull
        private final JComponent myBottomBreadcrumbs;

        DiffContentLayout(@NotNull JComponent title, @NotNull JComponent topBreadcrumbs, @NotNull JComponent content, @NotNull JComponent bottomBreadcrumbs) {
            if (title == null) {
                DiffContentLayout.$$$reportNull$$$0(0);
            }
            if (topBreadcrumbs == null) {
                DiffContentLayout.$$$reportNull$$$0(1);
            }
            if (content == null) {
                DiffContentLayout.$$$reportNull$$$0(2);
            }
            if (bottomBreadcrumbs == null) {
                DiffContentLayout.$$$reportNull$$$0(3);
            }
            this.myTitle = title;
            this.myTopBreadcrumbs = topBreadcrumbs;
            this.myContent = content;
            this.myBottomBreadcrumbs = bottomBreadcrumbs;
        }

        public Dimension preferredLayoutSize(Container parent) {
            int totalWidth = 0;
            int totalHeight = 0;
            for (JComponent component2 : Arrays.asList(this.myTitle, this.myTopBreadcrumbs, this.myContent, this.myBottomBreadcrumbs)) {
                Dimension size = DiffContentLayout.getPreferredSize(component2);
                totalWidth = Math.max(size.width, totalWidth);
                totalHeight += size.height;
                if (component2 != this.myTitle || size.height == 0) continue;
                totalHeight += DiffUtil.TITLE_GAP.get();
            }
            return new Dimension(totalWidth, totalHeight);
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                DiffContentLayout.$$$reportNull$$$0(4);
            }
            int y = 0;
            int width = parent.getWidth();
            int totalHeight = parent.getHeight();
            Dimension titleSize = DiffContentLayout.getPreferredSize(this.myTitle);
            Dimension topSize = DiffContentLayout.getPreferredSize(this.myTopBreadcrumbs);
            Dimension bottomSize = DiffContentLayout.getPreferredSize(this.myBottomBreadcrumbs);
            int bottomY = totalHeight - bottomSize.height;
            this.myTitle.setBounds(0, y, width, titleSize.height);
            y += titleSize.height;
            if (titleSize.height != 0) {
                y += DiffUtil.TITLE_GAP.get();
            }
            this.myTopBreadcrumbs.setBounds(0, y, width, topSize.height);
            this.myContent.setBounds(0, y += topSize.height, width, Math.max(0, bottomY - y));
            this.myBottomBreadcrumbs.setBounds(0, bottomY, width, bottomSize.height);
        }

        @NotNull
        private static Dimension getPreferredSize(@NotNull JComponent component2) {
            if (component2 == null) {
                DiffContentLayout.$$$reportNull$$$0(5);
            }
            return component2.isVisible() ? component2.getPreferredSize() : new Dimension();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topBreadcrumbs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bottomBreadcrumbs";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/side/DiffContentLayoutPanel$DiffContentLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPreferredSize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

