/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffErrorElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.ComparableDiffElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.SortedList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DTree {
    private static final Logger LOG = Logger.getInstance(DTree.class);
    private static final Comparator<DTree> COMPARATOR = (o1, o2) -> {
        boolean b1 = o1.isContainer();
        boolean b2 = o2.isContainer();
        return b1 && b2 || !b1 && !b2 ? o1.getName().compareToIgnoreCase(o2.getName()) : (b1 ? 1 : -1);
    };
    private boolean myExpanded;
    @Nullable
    private final DTree myParent;
    private HashMap<String, DTree> myChildren;
    private final String myName;
    private final boolean isContainer;
    private SortedList<DTree> myChildrenList;
    private DiffElement<?> mySource;
    private DiffElement<?> myTarget;
    private DiffType myType;
    private boolean myVisible;
    private String myPath;
    private String myRelativePath;

    public DTree(@Nullable DTree parent, @NotNull String name, boolean container, @Nullable String relativePath) {
        if (name == null) {
            DTree.$$$reportNull$$$0(0);
        }
        this.myExpanded = true;
        this.myVisible = true;
        this.myPath = null;
        this.myParent = parent;
        this.myName = name;
        this.myRelativePath = relativePath;
        this.isContainer = container;
    }

    @NotNull
    public Collection<DTree> getChildren() {
        this.init();
        if (this.myChildrenList == null) {
            this.myChildrenList = new SortedList(COMPARATOR);
            this.myChildrenList.addAll(this.myChildren.values());
        }
        SortedList<DTree> sortedList = this.myChildrenList;
        if (sortedList == null) {
            DTree.$$$reportNull$$$0(1);
        }
        return sortedList;
    }

    public DTree addChild(@NotNull DiffElement element, boolean source, String replacementName) {
        DTree node;
        if (element == null) {
            DTree.$$$reportNull$$$0(2);
        }
        this.init();
        this.myChildrenList = null;
        String name = element.getName();
        if (replacementName != null && this.myChildren.containsKey(replacementName)) {
            node = this.myChildren.get(replacementName);
        } else if (this.myChildren.containsKey(name)) {
            node = this.myChildren.get(name);
        } else {
            node = new DTree(this, element.getPresentableName(), element.isContainer(), element.getFilterablePath());
            this.myChildren.put(name, node);
        }
        if (source) {
            node.setSource(element);
        } else {
            node.setTarget(element);
        }
        return node;
    }

    public DiffElement<?> getSource() {
        return this.mySource;
    }

    public void setSource(DiffElement<?> source) {
        this.mySource = source;
    }

    public DiffElement<?> getTarget() {
        return this.myTarget;
    }

    public void setTarget(DiffElement<?> target) {
        this.myTarget = target;
    }

    private void init() {
        if (this.myChildren == null) {
            this.myChildren = new HashMap();
        }
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public DTree getParent() {
        return this.myParent;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public String toString() {
        return this.myName;
    }

    private void prepare() {
        DiffElement<?> src = this.getSource();
        DiffElement<?> trg = this.getTarget();
        if (src instanceof ComparableDiffElement) {
            ((ComparableDiffElement)src).prepare(trg);
        }
        if (trg instanceof ComparableDiffElement) {
            ((ComparableDiffElement)trg).prepare(src);
        }
        for (DTree tree2 : this.getChildren()) {
            tree2.prepare();
        }
    }

    public void update(DirDiffSettings settings) {
        this.prepare();
        this.updateChildren(settings);
    }

    private void updateChildren(DirDiffSettings settings) {
        for (DTree tree2 : this.getChildren()) {
            DiffElement<?> src = tree2.getSource();
            DiffElement<?> trg = tree2.getTarget();
            if (src instanceof DiffErrorElement || trg instanceof DiffErrorElement) {
                tree2.setType(DiffType.ERROR);
            } else if (src == null && trg != null) {
                tree2.setType(DiffType.TARGET);
            } else if (src != null && trg == null) {
                tree2.setType(DiffType.SOURCE);
            } else {
                assert (src != null);
                Boolean equals = null;
                if (src instanceof ComparableDiffElement) {
                    equals = ((ComparableDiffElement)src).isContentEqual(trg);
                }
                if (equals == null && trg instanceof ComparableDiffElement) {
                    equals = ((ComparableDiffElement)trg).isContentEqual(src);
                }
                if (equals == null) {
                    equals = switch (settings.compareMode) {
                        default -> throw new MatchException(null, null);
                        case DirDiffSettings.CompareMode.CONTENT -> DTree.isEqualContents(src, trg);
                        case DirDiffSettings.CompareMode.TEXT -> DTree.isEqualContentsAsText(src, trg);
                        case DirDiffSettings.CompareMode.SIZE -> DTree.isEqualSizes(src, trg);
                        case DirDiffSettings.CompareMode.TIMESTAMP -> DTree.isEqualTimestamps(src, trg, settings);
                    };
                }
                tree2.setType(equals != false ? DiffType.EQUAL : DiffType.CHANGED);
            }
            tree2.updateChildren(settings);
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void updateVisibility(DirDiffSettings settings) {
        if (this.getChildren().isEmpty()) {
            if (this.myType == DiffType.ERROR) {
                this.myVisible = true;
                return;
            }
            if (this.myType != DiffType.SEPARATOR && !"".equals(settings.getFilter()) && !settings.getDirDiffFilter().pathMatches((CharSequence)this.myRelativePath)) {
                this.myVisible = false;
                return;
            }
            if (this.myType == null) {
                this.myVisible = true;
            } else {
                this.myVisible = switch (this.myType) {
                    default -> throw new MatchException(null, null);
                    case DiffType.SOURCE -> settings.showNewOnSource;
                    case DiffType.TARGET -> settings.showNewOnTarget;
                    case DiffType.SEPARATOR, DiffType.ERROR -> true;
                    case DiffType.CHANGED -> settings.showDifferent;
                    case DiffType.EQUAL -> settings.showEqual;
                };
            }
        } else {
            this.myVisible = false;
            for (DTree child : this.myChildren.values()) {
                child.updateVisibility(settings);
                this.myVisible = this.myVisible || child.isVisible();
            }
        }
    }

    public void reset() {
        this.myChildren.clear();
    }

    public void remove(DTree node) {
        this.init();
        boolean removed = this.myChildrenList.remove((Object)node);
        if (removed) {
            for (String key : this.myChildren.keySet()) {
                if (this.myChildren.get(key) != node) continue;
                this.myChildren.remove(key);
                return;
            }
        }
    }

    private static boolean isEqualSizes(DiffElement<?> file1, DiffElement<?> file2) {
        return file1.getSize() == file2.getSize();
    }

    private static boolean isEqualTimestamps(DiffElement<?> src, DiffElement<?> trg, DirDiffSettings settings) {
        if (src.getSize() != trg.getSize()) {
            return false;
        }
        return (double)Math.abs(src.getTimeStamp() - trg.getTimeStamp()) <= settings.compareTimestampAccuracy;
    }

    private static boolean isEqualContents(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getSize() != file2.getSize()) {
            return false;
        }
        try {
            return DiffUtil.compareStreams((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> file1.getContentStream()), (ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> file2.getContentStream()));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean isEqualContentsAsText(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getFileType().isBinary() || file2.getFileType().isBinary()) {
            return DTree.isEqualContents(file1, file2);
        }
        try {
            byte[] content1 = file1.getContent();
            byte[] content2 = file2.getContent();
            if (Arrays.equals(content1, content2)) {
                return true;
            }
            if (content1 == null || content2 == null) {
                return false;
            }
            String text1 = CharsetToolkit.tryDecodeString((byte[])content1, (Charset)file1.getCharset());
            if (text1 == null) {
                return false;
            }
            String text2 = CharsetToolkit.tryDecodeString((byte[])content2, (Charset)file2.getCharset());
            if (text2 == null) {
                return false;
            }
            String convertedText1 = StringUtil.convertLineSeparators((String)text1);
            String convertedText2 = StringUtil.convertLineSeparators((String)text2);
            return StringUtil.equals((CharSequence)convertedText1, (CharSequence)convertedText2);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public DiffType getType() {
        return this.myType;
    }

    public void setType(DiffType type) {
        this.myType = type;
    }

    @NlsSafe
    public String getPath() {
        if (this.myPath == null) {
            DTree parent = this.getParent();
            this.myPath = parent != null ? parent.getPath() + this.getName() + (this.isContainer ? DiffElement.getSeparator() : "") : this.getName();
        }
        return this.myPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

