/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.panels;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.ui.JBFont;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.remote.LocalRecentConnectionUiData;
import com.jetbrains.gateway.remote.LocalRecentConnectionsAdapter;
import com.jetbrains.gateway.ssh.HostDeployContext;
import com.jetbrains.gateway.ssh.LocalRecentConnectionsManager;
import com.jetbrains.gateway.ssh.panels.RemoteRecentConnectionsPanel;
import com.jetbrains.gateway.ssh.panels.recentConnections.CommonActionsKt;
import com.jetbrains.gateway.ssh.panels.recentConnections.RecentProjectsPanel;
import com.jetbrains.gateway.station.StationPromoProvider;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import com.jetbrains.gateway.welcomeScreen.WslPromoPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0002:\u0001+Bk\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010#\u001a\u00020\nH\u0002J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\nH\u0002J\u0016\u0010'\u001a\u00020\n*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010 H\u0002J\b\u0010*\u001a\u00020 H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel;", "TConfig", "", "THostDeployContext", "Lcom/jetbrains/gateway/ssh/HostDeployContext;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "setViewPortView", "Lkotlin/Function1;", "Ljavax/swing/JComponent;", "", "setContentCallback", "Ljava/awt/Component;", "adapter", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;", "ui", "Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;", "canDisplayToolboxPromo", "", "switchToProjectsTab", "Lkotlin/Function0;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/jetbrains/gateway/remote/LocalRecentConnectionsAdapter;Lcom/jetbrains/gateway/remote/LocalRecentConnectionUiData;ZLkotlin/jvm/functions/Function0;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSetViewPortView", "()Lkotlin/jvm/functions/Function1;", "getSetContentCallback", "recents", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager$RecentConnection;", "recentProjectsPanel", "Ljavax/swing/JPanel;", "emptyPanel", "containerPanel", "refreshRecentPanels", "createMainPanel", "createContainerPanel", "adviseUIUpdate", "addPromo", "Lcom/intellij/ui/dsl/builder/Panel;", "panel", "createEmptyRecentProjectsPanel", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshRecentConnections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshRecentConnections.kt\ncom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,331:1\n13#2:332\n*S KotlinDebug\n*F\n+ 1 SshRecentConnections.kt\ncom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel\n*L\n99#1:332\n*E\n"})
public final class RemoteRecentConnectionsPanel<TConfig, THostDeployContext extends HostDeployContext<TConfig>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Function1<JComponent, Unit> setViewPortView;
    @NotNull
    private final Function1<Component, Unit> setContentCallback;
    @NotNull
    private final LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter;
    @NotNull
    private final LocalRecentConnectionUiData ui;
    private final boolean canDisplayToolboxPromo;
    @NotNull
    private final Function0<Unit> switchToProjectsTab;
    @NotNull
    private final ViewableList<LocalRecentConnectionsManager.RecentConnection<TConfig>> recents;
    private JPanel recentProjectsPanel;
    private JPanel emptyPanel;
    private JPanel containerPanel;
    @NotNull
    private static final Logger logger;

    public RemoteRecentConnectionsPanel(@NotNull Lifetime lifetime, @NotNull Function1<? super JComponent, Unit> setViewPortView, @NotNull Function1<? super Component, Unit> setContentCallback, @NotNull LocalRecentConnectionsAdapter<TConfig, THostDeployContext> adapter, @NotNull LocalRecentConnectionUiData ui, boolean canDisplayToolboxPromo, @NotNull Function0<Unit> switchToProjectsTab) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(setViewPortView, (String)"setViewPortView");
        Intrinsics.checkNotNullParameter(setContentCallback, (String)"setContentCallback");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter(switchToProjectsTab, (String)"switchToProjectsTab");
        this.lifetime = lifetime;
        this.setViewPortView = setViewPortView;
        this.setContentCallback = setContentCallback;
        this.adapter = adapter;
        this.ui = ui;
        this.canDisplayToolboxPromo = canDisplayToolboxPromo;
        this.switchToProjectsTab = switchToProjectsTab;
        this.recents = this.adapter.getRecentConnectionsManager().getRecents();
        this.refreshRecentPanels();
        this.adviseUIUpdate();
    }

    public /* synthetic */ RemoteRecentConnectionsPanel(Lifetime lifetime, Function1 function1, Function1 function12, LocalRecentConnectionsAdapter localRecentConnectionsAdapter, LocalRecentConnectionUiData localRecentConnectionUiData, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            function0 = RemoteRecentConnectionsPanel::_init_$lambda$0;
        }
        this(lifetime, (Function1<? super JComponent, Unit>)function1, (Function1<? super Component, Unit>)function12, localRecentConnectionsAdapter, localRecentConnectionUiData, bl, (Function0<Unit>)function0);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function1<JComponent, Unit> getSetViewPortView() {
        return this.setViewPortView;
    }

    @NotNull
    public final Function1<Component, Unit> getSetContentCallback() {
        return this.setContentCallback;
    }

    private final void refreshRecentPanels() {
        this.emptyPanel = this.createEmptyRecentProjectsPanel();
        this.recentProjectsPanel = new RecentProjectsPanel<TConfig, THostDeployContext>(this.lifetime, this.adapter, this.ui, this.canDisplayToolboxPromo, this.setContentCallback, this.switchToProjectsTab, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                RemoteRecentConnectionsPanel.access$refreshRecentPanels((RemoteRecentConnectionsPanel)this.receiver);
            }
        }));
        this.containerPanel = this.createContainerPanel();
        JPanel jPanel = this.containerPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerPanel");
            jPanel = null;
        }
        this.setViewPortView.invoke((Object)jPanel);
    }

    private final JPanel createMainPanel() {
        JPanel jPanel;
        if (this.recents.isEmpty()) {
            logger.info("Recent projects are empty, empty panel is shown");
            jPanel = this.emptyPanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emptyPanel");
                jPanel = null;
            }
        } else {
            logger.info("Showing recent projects panel");
            jPanel = this.recentProjectsPanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentProjectsPanel");
                jPanel = null;
            }
        }
        return jPanel;
    }

    private final JPanel createContainerPanel() {
        return StationPromoProvider.Companion.getInstance().createSshRecentPromoWrapper(this.lifetime, this.createMainPanel(), this.canDisplayToolboxPromo);
    }

    private final void adviseUIUpdate() {
        this.adapter.reportNumberOfHosts(this.recents.size());
        this.recents.advise(this.lifetime, arg_0 -> RemoteRecentConnectionsPanel.adviseUIUpdate$lambda$0(this, arg_0));
    }

    private final void addPromo(Panel $this$addPromo, JPanel panel2) {
        if (panel2 == null) {
            return;
        }
        $this$addPromo.panel(arg_0 -> RemoteRecentConnectionsPanel.addPromo$lambda$0(panel2, arg_0));
    }

    private final JPanel createEmptyRecentProjectsPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createEmptyRecentProjectsPanel_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createEmptyRecentProjectsPanel_u24lambda_u241.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        $this$createEmptyRecentProjectsPanel_u24lambda_u241.setBorder(BorderFactory.createEmptyBorder(20, 24, 0, 24));
        return (JPanel)dialogPanel;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit adviseUIUpdate$lambda$0(RemoteRecentConnectionsPanel this$0, IViewableList.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdCoroutinesUtilKt.launchOnUiAllowInlining$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RemoteRecentConnectionsPanel.access$setContainerPanel$p(this.this$0, RemoteRecentConnectionsPanel.access$createContainerPanel(this.this$0));
                        Function1<JComponent, Unit> function1 = this.this$0.getSetViewPortView();
                        JPanel jPanel = RemoteRecentConnectionsPanel.access$getContainerPanel$p(this.this$0);
                        if (jPanel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"containerPanel");
                            jPanel = null;
                        }
                        function1.invoke((Object)jPanel);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit addPromo$lambda$0$0$0(JPanel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit addPromo$lambda$0$0(JPanel $panel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$panel).align((Align)AlignX.FILL.INSTANCE).applyToComponent(RemoteRecentConnectionsPanel::addPromo$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit addPromo$lambda$0(JPanel $panel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RemoteRecentConnectionsPanel.addPromo$lambda$0$0($panel, arg_0), (int)1, null).bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$0$0$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.h3().asBold());
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$0$0(RemoteRecentConnectionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.ui.getPanelHeader()).applyToComponent(RemoteRecentConnectionsPanel::createEmptyRecentProjectsPanel$lambda$0$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$1$2$0(JBOptionButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        $this$applyToComponent.putClientProperty((Object)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)true);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$1$0(RemoteRecentConnectionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.icon(this$0.ui.getIcon()).align((Align)AlignX.CENTER.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$1$1(String $line, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($line).align((Align)AlignX.CENTER.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)0, (int)15, null));
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$1$2(RemoteRecentConnectionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GatewayBundle.INSTANCE.message("ssh.new.host", new Object[0]);
        AbstractAction newHost2 = new AbstractAction(this$0, string){
            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                CommonActionsKt.navigateToHostSelection(this.this$0.getLifetime(), RemoteRecentConnectionsPanel.access$getAdapter$p(this.this$0), this.this$0.getSetContentCallback());
            }
        };
        String string2 = GatewayBundle.INSTANCE.message("ssh.new.project", new Object[0]);
        AbstractAction newProject2 = new AbstractAction(this$0, string2){
            final /* synthetic */ RemoteRecentConnectionsPanel<TConfig, THostDeployContext> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                GatewayConnector gatewayConnector = RemoteRecentConnectionsPanel.access$getAdapter$p(this.this$0).getGatewayConnector();
                if (gatewayConnector == null) {
                    return;
                }
                GatewayConnector connector = gatewayConnector;
                GatewayUsagesCollector.INSTANCE.onConnectLeftClick(connector.getClass());
                JComponent component2 = (JComponent)WriteIntentReadAction.compute(() -> createEmptyRecentProjectsPanel.1.3.3.newProject.1.actionPerformed$lambda$0(connector, this.this$0));
                Function1<Component, Unit> function1 = this.this$0.getSetContentCallback();
                Intrinsics.checkNotNull((Object)component2);
                function1.invoke((Object)component2);
            }

            private static final JComponent actionPerformed$lambda$0(GatewayConnector $connector, RemoteRecentConnectionsPanel this$0) {
                return $connector.createView(this$0.getLifetime()).getComponent();
            }
        };
        Action[] actionArray = new Action[]{newHost2};
        JBOptionButton newProjectOrHost = new JBOptionButton((Action)newProject2, actionArray);
        $this$row.cell((JComponent)newProjectOrHost).applyToComponent(RemoteRecentConnectionsPanel::createEmptyRecentProjectsPanel$lambda$0$1$2$0).align((Align)AlignX.CENTER.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$0(RemoteRecentConnectionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$0$0(this$0, arg_0), (int)1, null).topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0$1(RemoteRecentConnectionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$1$0(this$0, arg_0), (int)1, null);
        Row lastWelcomeRow = null;
        for (String line : this$0.ui.getWelcomeLines()) {
            lastWelcomeRow = Panel.row$default((Panel)$this$panel, null, arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$1$1(line, arg_0), (int)1, null);
        }
        Row row = lastWelcomeRow;
        if (row != null) {
            row.bottomGap(BottomGap.MEDIUM);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$1$2(this$0, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyRecentProjectsPanel$lambda$0(RemoteRecentConnectionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (this$0.canDisplayToolboxPromo) {
            if (Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled")) {
                this$0.addPromo($this$panel, StationPromoProvider.Companion.getInstance().createPromoPanel(this$0.lifetime.getCoroutineScope()));
            }
        } else if (WslPromoPanel.Companion.shouldShow()) {
            this$0.addPromo($this$panel, (JPanel)((Object)new WslPromoPanel(this$0.switchToProjectsTab, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

                public final void invoke() {
                    RemoteRecentConnectionsPanel.access$refreshRecentPanels((RemoteRecentConnectionsPanel)this.receiver);
                }
            }))));
        }
        $this$panel.panel(arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$0(this$0, arg_0));
        $this$panel.panel(arg_0 -> RemoteRecentConnectionsPanel.createEmptyRecentProjectsPanel$lambda$0$1(this$0, arg_0)).customize(UnscaledGapsKt.UnscaledGaps((int)137, (int)150, (int)0, (int)150));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$refreshRecentPanels(RemoteRecentConnectionsPanel $this) {
        $this.refreshRecentPanels();
    }

    public static final /* synthetic */ void access$setContainerPanel$p(RemoteRecentConnectionsPanel $this, JPanel jPanel) {
        $this.containerPanel = jPanel;
    }

    public static final /* synthetic */ JPanel access$createContainerPanel(RemoteRecentConnectionsPanel $this) {
        return $this.createContainerPanel();
    }

    public static final /* synthetic */ JPanel access$getContainerPanel$p(RemoteRecentConnectionsPanel $this) {
        return $this.containerPanel;
    }

    public static final /* synthetic */ LocalRecentConnectionsAdapter access$getAdapter$p(RemoteRecentConnectionsPanel $this) {
        return $this.adapter;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteRecentConnectionsPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteRecentConnectionsPanel.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/ssh/panels/RemoteRecentConnectionsPanel$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

