/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.FileName;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/BinFiles;", "", "<init>", "()V", "BIN_FILES_DIR_NAME", "", "lock", "tempDir", "Lkotlin/Lazy;", "Ljava/nio/file/Path;", "devFilesDir", "getDevFilesDir", "()Ljava/nio/file/Path;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getBinFile", "fileName", "Lcom/intellij/util/FileName;", "clazz", "Ljava/lang/Class;", "getBinFile-kDy-24E", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/nio/file/Path;", "intellij.platform.util.ex"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBinFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinFiles.kt\ncom/intellij/util/BinFiles\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n23#2:73\n*S KotlinDebug\n*F\n+ 1 BinFiles.kt\ncom/intellij/util/BinFiles\n*L\n46#1:73\n*E\n"})
public final class BinFiles {
    @NotNull
    public static final BinFiles INSTANCE = new BinFiles();
    @NotNull
    private static final String BIN_FILES_DIR_NAME = "IJBinFiles";
    @NotNull
    private static final Object lock = new Object();
    @NotNull
    private static final Lazy<Path> tempDir = LazyKt.lazy(BinFiles::tempDir$lambda$0);
    @NotNull
    private static final Logger logger;

    private BinFiles() {
    }

    @NotNull
    public final Path getDevFilesDir() {
        Path path = PathManager.getSystemDir().resolve(BIN_FILES_DIR_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path getBinFile-kDy-24E(@NotNull String fileName, @NotNull Class<?> clazz) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = lock;
        synchronized (object) {
            Path path2;
            boolean bl = false;
            Path devFile = INSTANCE.getDevFilesDir().resolve(FileName.getRelativePath-impl$intellij_platform_util_ex(fileName));
            Intrinsics.checkNotNull((Object)devFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(devFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("Using dev " + devFile);
                path2 = devFile;
            } else {
                Path localCopyOfFile = ((Path)tempDir.getValue()).resolve(FileName.getRelativePath-impl$intellij_platform_util_ex(fileName));
                Intrinsics.checkNotNull((Object)localCopyOfFile);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(localCopyOfFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    path2 = localCopyOfFile;
                } else {
                    URL uRL = clazz.getClassLoader().getResource(FileName.getRelativePath-impl$intellij_platform_util_ex(fileName));
                    if (uRL == null) {
                        throw new IllegalArgumentException(FileName.toString-impl(fileName) + " is not in the class path");
                    }
                    URL resource = uRL;
                    Closeable closeable = resource.openStream();
                    Throwable throwable = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable;
                        boolean bl2 = false;
                        Closeable closeable2 = PathKt.outputStream(localCopyOfFile);
                        Throwable throwable2 = null;
                        try {
                            OutputStream output = (OutputStream)closeable2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)input);
                            l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    path2 = localCopyOfFile;
                }
            }
            path = path2;
        }
        return path;
    }

    private static final Path tempDir$lambda$0() {
        Path path = FileUtil.createTempDirectory((String)BIN_FILES_DIR_NAME, null, (boolean)true).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    static {
        BinFiles $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BinFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BinFiles.logger = logger;
    }
}

