/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.sequences;

import com.intellij.database.util.sequences.MatSequence;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0096\u0082\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/util/sequences/ConcatMatSequence;", "E", "Lcom/intellij/database/util/sequences/MatSequence;", "sequenceA", "sequenceB", "<init>", "(Lcom/intellij/database/util/sequences/MatSequence;Lcom/intellij/database/util/sequences/MatSequence;)V", "getSequenceA", "()Lcom/intellij/database/util/sequences/MatSequence;", "getSequenceB", "isNotEmpty", "", "()Z", "isEmpty", "iterator", "", "size", "", "getSize", "()I", "intellij.database.util"})
public final class ConcatMatSequence<E>
implements MatSequence<E> {
    @NotNull
    private final MatSequence<E> sequenceA;
    @NotNull
    private final MatSequence<E> sequenceB;

    public ConcatMatSequence(@NotNull MatSequence<? extends E> sequenceA, @NotNull MatSequence<? extends E> sequenceB) {
        Intrinsics.checkNotNullParameter(sequenceA, (String)"sequenceA");
        Intrinsics.checkNotNullParameter(sequenceB, (String)"sequenceB");
        this.sequenceA = sequenceA;
        this.sequenceB = sequenceB;
    }

    @NotNull
    public final MatSequence<E> getSequenceA() {
        return this.sequenceA;
    }

    @NotNull
    public final MatSequence<E> getSequenceB() {
        return this.sequenceB;
    }

    @Override
    public boolean isNotEmpty() {
        return this.sequenceA.isNotEmpty() || this.sequenceB.isNotEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.sequenceA.isEmpty() && this.sequenceB.isEmpty();
    }

    @NotNull
    public Iterator<E> iterator() {
        Iterator iterator;
        boolean a = this.sequenceA.isNotEmpty();
        boolean b = this.sequenceB.isNotEmpty();
        if (a && b) {
            Object[] objectArray = new MatSequence[]{this.sequenceA, this.sequenceB};
            iterator = SequencesKt.flatten((Sequence)SequencesKt.sequenceOf((Object[])objectArray)).iterator();
        } else {
            iterator = a ? this.sequenceA.iterator() : (b ? this.sequenceB.iterator() : SequencesKt.emptySequence().iterator());
        }
        return iterator;
    }

    @Override
    public int getSize() {
        return this.sequenceA.getSize() + this.sequenceB.getSize();
    }
}

