/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.intellij.docker.agent.WaitContainerCondition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u00020\u0004H\u0002\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"waitContainerCmdHack", "Lcom/github/dockerjava/api/command/WaitContainerCmd;", "Lcom/github/dockerjava/api/DockerClient;", "containerId", "", "condition", "Lcom/intellij/docker/agent/WaitContainerCondition;", "CONTAINER_ID_WITH_CONDITION_DELIMITER", "", "encodeContainerIdWithCondition", "decodeContainerIdWithOptionalCondition", "Lkotlin/Pair;", "value", "NOT_RUNNING_VALUE", "NEXT_EXIT_VALUE", "REMOVED_VALUE", "toParamValue", "toWaitContainerCondition", "intellij.clouds.docker.agent"})
public final class HackedWaitContainerCmdExecKt {
    private static final char CONTAINER_ID_WITH_CONDITION_DELIMITER = ':';
    @NotNull
    private static final String NOT_RUNNING_VALUE = "not-running";
    @NotNull
    private static final String NEXT_EXIT_VALUE = "next-exit";
    @NotNull
    private static final String REMOVED_VALUE = "removed";

    @NotNull
    public static final WaitContainerCmd waitContainerCmdHack(@NotNull DockerClient $this$waitContainerCmdHack, @NotNull String containerId, @NotNull WaitContainerCondition condition) {
        Intrinsics.checkNotNullParameter((Object)$this$waitContainerCmdHack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
        WaitContainerCmd waitContainerCmd = $this$waitContainerCmdHack.waitContainerCmd(HackedWaitContainerCmdExecKt.encodeContainerIdWithCondition(containerId, condition));
        Intrinsics.checkNotNullExpressionValue((Object)waitContainerCmd, (String)"waitContainerCmd(...)");
        return waitContainerCmd;
    }

    private static final String encodeContainerIdWithCondition(String containerId, WaitContainerCondition condition) {
        return containerId + ":" + HackedWaitContainerCmdExecKt.toParamValue(condition);
    }

    private static final Pair<String, WaitContainerCondition> decodeContainerIdWithOptionalCondition(String value) {
        Pair pair;
        int delimiterIndex = StringsKt.lastIndexOf$default((CharSequence)value, (char)':', (int)0, (boolean)false, (int)6, null);
        if (delimiterIndex == -1) {
            pair = TuplesKt.to((Object)value, null);
        } else {
            String containerId = StringsKt.take((String)value, (int)delimiterIndex);
            String string = value.substring(delimiterIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String conditionString = string;
            WaitContainerCondition waitContainerCondition = HackedWaitContainerCmdExecKt.toWaitContainerCondition(conditionString);
            if (waitContainerCondition == null) {
                throw new IllegalStateException(("Unknown wait condition '" + conditionString + "' in '" + value + "'").toString());
            }
            WaitContainerCondition condition = waitContainerCondition;
            pair = TuplesKt.to((Object)containerId, (Object)((Object)condition));
        }
        return pair;
    }

    private static final String toParamValue(WaitContainerCondition $this$toParamValue) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toParamValue.ordinal()]) {
            case 1 -> NOT_RUNNING_VALUE;
            case 2 -> NEXT_EXIT_VALUE;
            case 3 -> REMOVED_VALUE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final WaitContainerCondition toWaitContainerCondition(String $this$toWaitContainerCondition) {
        return switch ($this$toWaitContainerCondition) {
            case NOT_RUNNING_VALUE -> WaitContainerCondition.NOT_RUNNING;
            case NEXT_EXIT_VALUE -> WaitContainerCondition.NEXT_EXIT;
            case REMOVED_VALUE -> WaitContainerCondition.REMOVED;
            default -> null;
        };
    }

    public static final /* synthetic */ Pair access$decodeContainerIdWithOptionalCondition(String value) {
        return HackedWaitContainerCmdExecKt.decodeContainerIdWithOptionalCondition(value);
    }

    public static final /* synthetic */ String access$toParamValue(WaitContainerCondition $receiver) {
        return HackedWaitContainerCmdExecKt.toParamValue($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WaitContainerCondition.values().length];
            try {
                nArray[WaitContainerCondition.NOT_RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WaitContainerCondition.NEXT_EXIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WaitContainerCondition.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

