/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.toolbox;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.commercial.dependencies.StationDependenciesDownloader;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.station.core.StationBundle;
import com.intellij.station.core.discovery.DiscoveryService;
import com.intellij.station.core.discovery.StationConnection;
import com.intellij.station.core.services.IdeStationServerService;
import com.intellij.station.core.toolbox.ToolboxDiscovery;
import com.intellij.station.core.toolbox.ToolboxInstallationResult;
import com.intellij.station.core.toolbox.ToolboxStatusService;
import com.intellij.util.SystemProperties;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.OS;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\bH\u0002J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u000e\u0010'\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010(J\u000f\u0010)\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b*J\n\u0010+\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010,\u001a\u00020\bH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u00020\bH\u0002J+\u00100\u001a\u0004\u0018\u0001012\u0006\u0010.\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u00102R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/station/core/toolbox/ToolboxDiscovery;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findOrDownloadFreshToolboxInstaller", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/util/BuildNumber;", "allowDownload", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "discoverToolboxInstallerPath", "launchDaemonSafe", "Ljava/lang/ProcessHandle;", "args", "", "", "([Ljava/lang/String;)Ljava/lang/ProcessHandle;", "openToolboxSafe", "", "([Ljava/lang/String;)V", "findOrInstallToolboxSafe", "isFullApp", "openToolbox", "findOrInstallToolbox", "Lcom/intellij/station/core/toolbox/ToolboxInstallationResult;", "installOrUpdate", "installToolbox", "dist", "(Ljava/nio/file/Path;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractDistTo", "target", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupExtractedDist", "listRunningToolboxProcesses", "", "Lcom/intellij/execution/process/ProcessInfo;", "killAllToolboxProcesses", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInstalledBuild", "getInstalledBuild$intellij_station_core", "getInstalledBuildFromDiscovery", "discoverToolboxBinaryDir", "discoverToolboxExecutablePath", "forDaemon", "discoverToolboxAppOnMacOS", "createLaunchToolboxCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Z[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.station.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolboxDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxDiscovery.kt\ncom/intellij/station/core/toolbox/ToolboxDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,512:1\n832#2:513\n862#2,2:514\n1586#2:516\n1661#2,3:517\n214#3,5:520\n3938#4:525\n4474#4,2:526\n42#5,3:528\n1#6:531\n57#7:532\n35#7,2:533\n*S KotlinDebug\n*F\n+ 1 ToolboxDiscovery.kt\ncom/intellij/station/core/toolbox/ToolboxDiscovery\n*L\n62#1:513\n62#1:514,2\n107#1:516\n107#1:517,3\n189#1:520,5\n350#1:525\n350#1:526,2\n433#1:528,3\n47#1:532\n47#1:533,2\n*E\n"})
public final class ToolboxDiscovery {
    @NotNull
    public static final ToolboxDiscovery INSTANCE = new ToolboxDiscovery();
    @NotNull
    private static final Logger LOG;

    private ToolboxDiscovery() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object findOrDownloadFreshToolboxInstaller(boolean allowDownload, @NotNull Continuation<? super kotlin.Pair<? extends Path, BuildNumber>> $completion) {
        block20: {
            if (!($completion instanceof findOrDownloadFreshToolboxInstaller.1)) ** GOTO lbl-1000
            var26_3 = $completion;
            if ((var26_3.label & -2147483648) != 0) {
                var26_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ToolboxDiscovery this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findOrDownloadFreshToolboxInstaller(false, (Continuation<? super kotlin.Pair<? extends Path, BuildNumber>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var27_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    toolbox = this.discoverToolboxInstallerPath();
                    try {
                        var5_7 = PathsKt.listDirectoryEntries$default((Path)toolbox, null, (int)1, null);
                    }
                    catch (IOException <unused var>) {
                        var5_7 = CollectionsKt.emptyList();
                    }
                    bundledFiles = var5_7;
                    if (bundledFiles.size() == 2) {
                        v0 = toolbox.resolve("build.txt");
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
                        buildTxt = v0;
                        v1 = toolbox.resolve("build.txt");
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                        buildTxtContent = PathsKt.readText$default((Path)v1, null, (int)1, null);
                        v2 = BuildNumber.fromString((String)buildTxtContent);
                        if (v2 == null) {
                            throw new IllegalStateException(("Invalid version: " + buildTxtContent).toString());
                        }
                        version = v2;
                        $this$filterNot$iv = bundledFiles;
                        $i$f$filterNot = false;
                        var11_19 = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (Path)element$iv$iv;
                            $i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1 = false;
                            if (Intrinsics.areEqual((Object)it, (Object)buildTxt)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        dist = (Path)CollectionsKt.single((List)((List)destination$iv$iv));
                        return TuplesKt.to((Object)dist, (Object)version);
                    }
                    isRunningFromSources = PluginManagerCore.isRunningFromSources() != false || AppMode.isRunningFromDevBuild() != false ? 1 : 0;
                    buildNumberOverride = Registry.Companion.stringValue("station.toolbox.build.number.override");
                    if (StringsKt.isBlank((CharSequence)buildNumberOverride) == false) {
                        v3 = buildNumberOverride;
                    } else if (isRunningFromSources == 0) {
                        v4 = toolbox.resolve("build.txt");
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"resolve(...)");
                        v3 = PathsKt.readText$default((Path)v4, null, (int)1, null);
                    } else {
                        v5 = Path.of(PathManager.getCommunityHomePath(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"of(...)");
                        communityRoot = new BuildDependenciesCommunityRoot(v5);
                        v3 = StationDependenciesDownloader.INSTANCE.getToolboxBuildNumber(communityRoot);
                    }
                    versionString = v3;
                    v6 = BuildNumber.fromString((String)versionString);
                    if (v6 == null) {
                        throw new IllegalStateException(("Invalid version: " + versionString).toString());
                    }
                    version = v6;
                    if (!allowDownload) {
                        ToolboxDiscovery.LOG.debug("Toolbox discovery is not allowed to download its distribution");
                        return TuplesKt.to(null, (Object)version);
                    }
                    v7 = version.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toString(...)");
                    fileName = StationDependenciesDownloader.INSTANCE.getDownloadFileName(v7);
                    v8 = DownloadableFileService.getInstance().createFileDescription(StationDependenciesDownloader.INSTANCE.getDownloadLink(fileName), fileName);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"createFileDescription(...)");
                    fileInfo = v8;
                    $i$f$filterNotTo = WindowManager.getInstance().getMostRecentFocusedWindow();
                    v9 = $i$f$filterNotTo instanceof IdeFrame != false ? (IdeFrame)$i$f$filterNotTo : null;
                    project = v9 != null ? v9.getProject() : null;
                    tmpDir = Files.createTempDirectory(fileName, new FileAttribute[0]);
                    v10 = DownloadableFileService.getInstance().createDownloader(CollectionsKt.listOf((Object)fileInfo), fileName);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"createDownloader(...)");
                    downloader = v10;
                    if (project == null) break;
                    $i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1 = new Object[]{StringUtil.capitalize((String)fileName)};
                    v11 = IdeCoreBundle.message((String)"progress.download.0.title", (Object[])$i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"message(...)");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolbox);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)bundledFiles);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)buildNumberOverride);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)versionString);
                    $continuation.L$4 = version;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)fileInfo);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)tmpDir);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)downloader);
                    $continuation.Z$0 = allowDownload;
                    $continuation.I$0 = isRunningFromSources;
                    $continuation.label = 1;
                    v12 = TasksKt.withBackgroundProgress((Project)project, (String)v11, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<Pair<File, DownloadableFileDescription>>>, Object>(downloader, tmpDir, null){
                        int label;
                        final /* synthetic */ FileDownloader $downloader;
                        final /* synthetic */ Path $tmpDir;
                        {
                            this.$downloader = $downloader;
                            this.$tmpDir = $tmpDir;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return this.$downloader.download(this.$tmpDir.toFile());
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<Pair<File, DownloadableFileDescription>>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v12 == var27_5) {
                        return var27_5;
                    }
                    ** GOTO lbl117
                }
                case 1: {
                    isRunningFromSources = $continuation.I$0;
                    allowDownload = $continuation.Z$0;
                    downloader = (FileDownloader)$continuation.L$9;
                    tmpDir = (Path)$continuation.L$8;
                    project = (Project)$continuation.L$7;
                    fileInfo = (DownloadableFileDescription)$continuation.L$6;
                    fileName = (String)$continuation.L$5;
                    version = (BuildNumber)$continuation.L$4;
                    versionString = (String)$continuation.L$3;
                    buildNumberOverride = (String)$continuation.L$2;
                    bundledFiles = (List)$continuation.L$1;
                    toolbox = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v12 = $result;
lbl117:
                    // 2 sources

                    v13 = (List)v12;
                    break block20;
                }
            }
            v13 = downloader.download(tmpDir.toFile());
        }
        element$iv$iv /* !! */  = v13;
        Intrinsics.checkNotNull((Object)element$iv$iv /* !! */ );
        element$iv$iv /* !! */  = element$iv$iv /* !! */ ;
        $i$f$map = false;
        $i$a$-filterNot-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$dist$1 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var22_39 = (Pair)item$iv$iv;
            var24_41 = destination$iv$iv;
            $i$a$-map-ToolboxDiscovery$findOrDownloadFreshToolboxInstaller$files$2 = false;
            var24_41.add((File)it.first);
        }
        files = (List)destination$iv$iv;
        if (files.isEmpty()) {
            ToolboxDiscovery.LOG.warn("Failed to download toolbox installer");
            return TuplesKt.to(null, (Object)version);
        }
        return TuplesKt.to((Object)((File)CollectionsKt.first((List)files)).toPath(), (Object)version);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path discoverToolboxInstallerPath() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("com.jetbrains.station"));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Can't find enabled station plugin".toString());
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        Path path = plugin.getPluginPath();
        if (path == null) {
            throw new IllegalStateException("Station plugin path must not be null".toString());
        }
        Path pluginPath = path;
        Path path2 = pluginPath.resolve("toolbox");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @Nullable
    public final ProcessHandle launchDaemonSafe(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        GeneralCommandLine launchToolboxCommand = this.createLaunchToolboxCommand(true, Arrays.copyOf(args, args.length));
        if (launchToolboxCommand != null) {
            ProcessHandle processHandle;
            ProcessBuilder processBuilder = launchToolboxCommand.toProcessBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
            ProcessBuilder builder = processBuilder;
            builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            builder.redirectError(ProcessBuilder.Redirect.DISCARD);
            try {
                processHandle = builder.start().toHandle();
            }
            catch (Exception ex) {
                LOG.error("Failed to launch daemon", (Throwable)ex);
                processHandle = null;
            }
            return processHandle;
        }
        LOG.warn("Unable to launch daemon: can't find the executable");
        return null;
    }

    public final void openToolboxSafe(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            this.openToolbox(Arrays.copyOf(args, args.length));
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.warn("Toolbox opening failed, IO", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Toolbox opening failed with internal error", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findOrInstallToolboxSafe(boolean isFullApp, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof findOrInstallToolboxSafe.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOrInstallToolboxSafe(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.Z$0 = isFullApp;
                $continuation.label = 1;
                v0 = this.findOrInstallToolbox(isFullApp != false, (Continuation<? super ToolboxInstallationResult>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                isFullApp = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (IOException e) {
                    ToolboxDiscovery.LOG.warn("Toolbox installation failed, IO", (Throwable)e);
                }
                catch (Exception e) {
                    ToolboxDiscovery.LOG.warn("Toolbox installation failed with internal error", (Throwable)e);
                }
lbl34:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void openToolbox(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        GeneralCommandLine launchToolboxCommand = this.createLaunchToolboxCommand(false, Arrays.copyOf(args, args.length));
        if (launchToolboxCommand != null) {
            LOG.warn("Launching toolbox command: " + launchToolboxCommand.getCommandLineString());
            ProcessOutput output = new CapturingProcessHandler(launchToolboxCommand).runProcess(5000, false);
            if (output.isTimeout() || output.getExitCode() == 0) {
                String string = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                if (((CharSequence)string).length() == 0) {
                    ToolboxStatusService.Companion.getInstance().rememberAboutInstallationAttempt();
                }
            }
            LOG.warn("Output of the toolbox command: exit code " + output.getExitCode() + ", stderr: " + output.getStderr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object findOrInstallToolbox(boolean isFullApp, @NotNull Continuation<? super ToolboxInstallationResult> $completion) {
        if (!($completion instanceof findOrInstallToolbox.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                boolean Z$1;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOrInstallToolbox(false, (Continuation<? super ToolboxInstallationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$getAndUpdate$iv = ToolboxStatusService.Companion.getInstance().get_toolboxInstalling$intellij_station_core();
                $i$f$getAndUpdate = false;
                do {
                    prevValue$iv = $this$getAndUpdate$iv.getValue();
                    it = (Boolean)prevValue$iv;
                    $i$a$-getAndUpdate-ToolboxDiscovery$findOrInstallToolbox$wasInstalling$1 = false;
                } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Boxing.boxBoolean((boolean)true))));
                wasInstalling = (Boolean)prevValue$iv;
                if (wasInstalling) {
                    ToolboxDiscovery.LOG.debug("Toolbox is already being installed. Skipping another attempt");
                    return ToolboxInstallationResult.Skipped.INSTANCE;
                }
                $continuation.Z$0 = isFullApp;
                $continuation.Z$1 = wasInstalling;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ToolboxInstallationResult>, Object>(isFullApp != false, null){
                    int label;
                    final /* synthetic */ boolean $isFullApp;
                    {
                        this.$isFullApp = $isFullApp;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ToolboxDiscovery.access$installOrUpdate(ToolboxDiscovery.INSTANCE, this.$isFullApp, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ToolboxInstallationResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var11_5) goto lbl32
lbl31:
                // 1 sources

                return var11_5;
lbl32:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                wasInstalling = $continuation.Z$1;
                isFullApp = $continuation.Z$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl40:
                // 2 sources

                var4_6 = v0;
                ToolboxStatusService.Companion.getInstance().get_toolboxInstalling$intellij_station_core().setValue((Object)Boxing.boxBoolean((boolean)false));
                $continuation.L$0 = var4_6;
                $continuation.Z$0 = isFullApp;
                $continuation.Z$1 = wasInstalling;
                $continuation.label = 2;
                v1 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
                if (v1 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl56
            }
            case 2: {
                wasInstalling = $continuation.Z$1;
                isFullApp = $continuation.Z$0;
                var4_6 = $continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                return var4_6;
            }
        }
        catch (Throwable var5_8) {
            ToolboxStatusService.Companion.getInstance().get_toolboxInstalling$intellij_station_core().setValue((Object)Boxing.boxBoolean((boolean)false));
            $continuation.L$0 = var5_8;
            $continuation.Z$0 = isFullApp;
            $continuation.Z$1 = wasInstalling;
            $continuation.label = 3;
            v2 = ToolboxStatusService.Companion.getInstance().updateToolboxStatusSafe((Continuation<? super Unit>)$continuation);
            if (v2 == var11_5) {
                return var11_5;
            }
            ** GOTO lbl73
        }
        {
            case 3: {
                wasInstalling = $continuation.Z$1;
                isFullApp = $continuation.Z$0;
                var5_9 = (Throwable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl73:
                // 2 sources

                throw var5_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object installOrUpdate(boolean isFullApp, Continuation<? super ToolboxInstallationResult> $completion) {
        block12: {
            if (!($completion instanceof installOrUpdate.1)) ** GOTO lbl-1000
            var8_3 = $completion;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ToolboxDiscovery this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ToolboxDiscovery.access$installOrUpdate(this.this$0, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.Z$0 = isFullApp;
                    $continuation.label = 1;
                    v0 = this.findOrDownloadFreshToolboxInstaller(true, (Continuation<? super kotlin.Pair<? extends Path, BuildNumber>>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    isFullApp = $continuation.Z$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    var3_6 = (kotlin.Pair)v0;
                    dist = (Path)var3_6.component1();
                    distVersion = (BuildNumber)var3_6.component2();
                    installedBuild = this.getInstalledBuild$intellij_station_core();
                    if (dist == null) {
                        ToolboxDiscovery.LOG.debug("Toolbox installer distribution was not found. Abort process");
                        throw new IOException(StationBundle.INSTANCE.message("action.InstallOrUpdateToolboxActionWrapper.error.distribution.not.found", new Object[0]));
                    }
                    if (installedBuild != null) break;
                    ToolboxDiscovery.LOG.debug("No Toolbox installation found, will install v" + distVersion + " from " + dist);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
                    $continuation.Z$0 = isFullApp;
                    $continuation.label = 2;
                    v1 = this.installToolbox(dist, isFullApp != false, (Continuation<? super Unit>)$continuation);
                    if (v1 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl47
                }
                case 2: {
                    isFullApp = $continuation.Z$0;
                    installedBuild = (BuildNumber)$continuation.L$2;
                    distVersion = (BuildNumber)$continuation.L$1;
                    dist = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl47:
                    // 2 sources

                    ToolboxDiscovery.LOG.debug("Toolbox installation completed");
                    return ToolboxInstallationResult.Installed.INSTANCE;
                }
            }
            if (installedBuild.compareTo(distVersion) >= 0) break block12;
            ToolboxDiscovery.LOG.debug("Found toolbox v" + installedBuild + ", will update to v" + distVersion + " from " + dist);
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dist);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distVersion);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedBuild);
            $continuation.Z$0 = isFullApp;
            $continuation.label = 3;
            v2 = this.installToolbox(dist, isFullApp != false, (Continuation<? super Unit>)$continuation);
            if (v2 == var9_5) {
                return var9_5;
            }
            ** GOTO lbl67
            {
                case 3: {
                    isFullApp = $continuation.Z$0;
                    installedBuild = (BuildNumber)$continuation.L$2;
                    distVersion = (BuildNumber)$continuation.L$1;
                    dist = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl67:
                    // 2 sources

                    ToolboxDiscovery.LOG.debug("Toolbox update completed");
                    return ToolboxInstallationResult.Updated.INSTANCE;
                }
            }
        }
        ToolboxDiscovery.LOG.debug("Toolbox v" + installedBuild + " is already installed");
        return ToolboxInstallationResult.Skipped.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object installToolbox(@NotNull Path dist, boolean isFullApp, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof installToolbox.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.installToolbox(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = dist;
                $continuation.Z$0 = isFullApp;
                $continuation.label = 1;
                v0 = this.killAllToolboxProcesses((Continuation<? super Boolean>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                isFullApp = $continuation.Z$0;
                dist = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    ToolboxDiscovery.LOG.warn("Failed to kill alive toolbox process");
                    return Unit.INSTANCE;
                }
                preTarget = Files.createTempDirectory("jbapp", new FileAttribute[0]);
                Intrinsics.checkNotNull((Object)preTarget);
                $continuation.L$0 = dist;
                $continuation.L$1 = preTarget;
                $continuation.Z$0 = isFullApp;
                $continuation.label = 2;
                v1 = this.extractDistTo(dist, preTarget, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var19_6) goto lbl38
lbl37:
                // 1 sources

                return var19_6;
lbl38:
                // 1 sources

                ** GOTO lbl47
            }
            case 2: {
                isFullApp = $continuation.Z$0;
                preTarget = (Path)$continuation.L$1;
                dist = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl47:
                    // 2 sources

                    if (var6_8 = isFullApp) {
                        v2 = TuplesKt.to((Object)"jetbrains-toolbox", (Object)"APP");
                    } else if (!var6_8) {
                        v2 = TuplesKt.to((Object)"jetbrainsd", (Object)"DAEMON");
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    var5_10 = v2;
                    executableName = (String)var5_10.component1();
                    installType = (String)var5_10.component2();
                    v3 = OS.CURRENT;
                    switch (v3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                        case 1: {
                            Intrinsics.checkNotNull((Object)preTarget);
                            v4 = preTarget.resolve(executableName + ".exe");
                            v5 = v4;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"resolve(...)");
                            break;
                        }
                        case 2: {
                            Intrinsics.checkNotNull((Object)preTarget);
                            v6 = preTarget.resolve("bin");
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"resolve(...)");
                            v7 = v6.resolve(executableName);
                            v5 = v7;
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"resolve(...)");
                            break;
                        }
                        case 3: {
                            Intrinsics.checkNotNull((Object)preTarget);
                            v8 = preTarget.resolve("JetBrains Toolbox.app");
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"resolve(...)");
                            v9 = v8.resolve("Contents");
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"resolve(...)");
                            v10 = v9.resolve("MacOS");
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"resolve(...)");
                            v11 = v10.resolve("jetbrains-toolbox");
                            v5 = v11;
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"resolve(...)");
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
                        }
                    }
                    executable = v5;
                    options = new ArrayList<E>();
                    ((Collection)options).add("--install");
                    ((Collection)options).add("--install-type=" + installType);
                    if (OS.CURRENT == OS.macOS && isFullApp) {
                        ((Collection)options).add("--install-target=/Applications/JetBrains Toolbox.app");
                    }
                    gcl = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)executable.toAbsolutePath().toString()), (Iterable)options));
                    selfInstallProcess = gcl.toProcessBuilder().start();
                    selfInstallProcess.waitFor(10L, TimeUnit.MINUTES);
                    if (!(selfInstallProcess.isAlive() == false)) {
                        var12_17 = "Failed requirement.";
                        throw new IllegalArgumentException(var12_17.toString());
                    }
                    if (!(selfInstallProcess.exitValue() == 0)) {
                        $i$a$-require-ToolboxDiscovery$installToolbox$2 = false;
                        v12 = selfInstallProcess.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getErrorStream(...)");
                        var13_20 = v12;
                        var14_21 = Charsets.UTF_8;
                        var15_22 = new InputStreamReader(var13_20, var14_21);
                        var16_23 = 8192;
                        var12_19 = "Failed to install " + dist + ": " + TextStreamsKt.readText((Reader)(var15_22 instanceof BufferedReader != false ? (BufferedReader)var15_22 : new BufferedReader(var15_22, var16_23)));
                        throw new IllegalArgumentException(var12_19.toString());
                    }
                    ToolboxDiscovery.LOG.debug(gcl.getPreparedCommandLine() + " returned 0 in time");
                    this.cleanupExtractedDist(dist, preTarget);
                }
                catch (Throwable var5_11) {
                    Intrinsics.checkNotNull((Object)preTarget);
                    this.cleanupExtractedDist(dist, preTarget);
                    throw var5_11;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object extractDistTo(Path dist, Path target, Continuation<? super Unit> $completion) {
        LOG.debug("Installing Toolbox from " + dist);
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{((Object)dist).toString(), "self-extract", ((Object)target.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(stringArray);
                Process installerProcess = gcl.toProcessBuilder().start();
                installerProcess.waitFor(60L, TimeUnit.SECONDS);
                if (!(!installerProcess.isAlive())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(installerProcess.exitValue() == 0)) {
                    boolean $i$a$-require-ToolboxDiscovery$extractDistTo$42 = false;
                    InputStream inputStream = installerProcess.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String $i$a$-require-ToolboxDiscovery$extractDistTo$42 = "Failed to install " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$extractDistTo$42.toString());
                }
                LOG.debug(gcl.getPreparedCommandLine() + " returned 0 in time");
                break;
            }
            case 3: {
                LOG.debug("Mounting " + dist + " as " + target);
                String[] installerProcess = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", ((Object)target.toAbsolutePath()).toString(), ((Object)dist.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(installerProcess);
                Process process2 = gcl.toProcessBuilder().start();
                process2.waitFor(60L, TimeUnit.SECONDS);
                if (!(!process2.isAlive())) {
                    String $i$a$-require-ToolboxDiscovery$extractDistTo$42 = "Failed requirement.";
                    throw new IllegalArgumentException($i$a$-require-ToolboxDiscovery$extractDistTo$42.toString());
                }
                if (!(process2.exitValue() == 0)) {
                    boolean bl = false;
                    InputStream inputStream = process2.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream3 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream3, charset);
                    int n = 8192;
                    String string = "Failed to mount " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException(string.toString());
                }
                LOG.debug("Mounted " + dist + " as " + target);
                break;
            }
            case 2: {
                Decompressor.Tar decompressor = new Decompressor.Tar(dist);
                decompressor.removePrefixPath(StringsKt.removeSuffix((String)PathsKt.getName((Path)dist), (CharSequence)".tar.gz"));
                decompressor.extract(target);
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
        return Unit.INSTANCE;
    }

    private final void cleanupExtractedDist(Path dist, Path target) {
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 3: {
                LOG.debug("Un-mounting " + dist);
                String[] stringArray = new String[]{"hdiutil", "detach", "-force", ((Object)target.toAbsolutePath()).toString()};
                GeneralCommandLine gcl = new GeneralCommandLine(stringArray);
                Process process2 = gcl.toProcessBuilder().start();
                process2.waitFor(60L, TimeUnit.SECONDS);
                if (!(!process2.isAlive())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(process2.exitValue() == 0)) {
                    boolean bl = false;
                    InputStream inputStream = process2.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String string = "Failed to un-mount " + dist + ": " + TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    throw new IllegalArgumentException(string.toString());
                }
                LOG.debug("Un-mounted " + dist);
                break;
            }
            case 1: 
            case 2: {
                PathsKt.deleteRecursively((Path)target);
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessInfo> listRunningToolboxProcesses() {
        void $this$filterTo$iv$iv;
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object[] $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            ProcessInfo it = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            String string = it.getExecutableDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"jetbrains-toolbox", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object killAllToolboxProcesses(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof killAllToolboxProcesses.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxDiscovery this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxDiscovery.access$killAllToolboxProcesses(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    processes = this.listRunningToolboxProcesses();
                    var3_6 = processes.iterator();
                }
                catch (Throwable e) {
                    ToolboxDiscovery.LOG.warn("Failed to kill all toolbox processes", e);
                    return Boxing.boxBoolean((boolean)false);
                }
lbl20:
                // 2 sources

                while (var3_6.hasNext()) {
                    process = (ProcessInfo)var3_6.next();
                    v0 = ProcessHandle.of(process.getPid());
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"of(...)");
                    if ((ProcessHandle)OptionalsKt.getOrNull(v0) == null) {
                        $this$killAllToolboxProcesses_u24lambda_u240 = this;
                        $i$a$-run-ToolboxDiscovery$killAllToolboxProcesses$handle$1 = false;
                        ToolboxDiscovery.LOG.debug("Failed to get handle for " + process + ", can't check if it's alive");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    ToolboxDiscovery.LOG.debug("Terminating process " + process);
                    try {
                        OSProcessUtil.terminateProcessGracefully((int)process.getPid());
                        ToolboxDiscovery.LOG.debug("Process " + process + " was gracefully terminated");
                    }
                    catch (UnsupportedOperationException <unused var>) {
                        ToolboxDiscovery.LOG.debug("Failed to gracefully terminate process " + process + ", killing it");
                        OSProcessUtil.killProcess((int)process.getPid());
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)processes);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = process;
                    $continuation.L$3 = handle;
                    $continuation.label = 1;
                    v1 = TimeoutKt.withTimeout((long)5000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handle, null){
                        int label;
                        final /* synthetic */ ProcessHandle $handle;
                        {
                            this.$handle = $handle;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
lbl5:
                                    // 3 sources

                                    while (this.$handle.isAlive()) {
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                        if (v0 != var2_2) continue;
                                        return var2_2;
                                    }
                                    break;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    ** GOTO lbl5
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var12_4) {
                        return var12_4;
                    }
                    ** GOTO lbl56
                }
                return Boxing.boxBoolean((boolean)true);
            }
            case 1: {
                handle = (ProcessHandle)$continuation.L$3;
                process = (ProcessInfo)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                processes = (List)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl56:
                    // 2 sources

                    if (!(handle.isAlive() == false)) {
                        $i$a$-require-ToolboxDiscovery$killAllToolboxProcesses$4 = false;
                        var7_14 = "Failed to kill process " + process;
                        throw new IllegalArgumentException(var7_14.toString());
                    }
                    ToolboxDiscovery.LOG.debug("Process " + process + " was terminated");
                    ** GOTO lbl20
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final BuildNumber getInstalledBuild$intellij_station_core() {
        BuildNumber discovered = this.getInstalledBuildFromDiscovery();
        if (discovered != null) {
            LOG.debug("Toolbox installation detected at " + discovered + " via discovery");
            return discovered;
        }
        Path binDir = this.discoverToolboxBinaryDir();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(binDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.debug(binDir + " directory not found, assuming no Toolbox installation");
            return null;
        }
        LOG.debug("Toolbox installation detected at " + binDir);
        BuildNumber buildNumber = BuildNumber.fromString((String)"2.6.0.34345");
        Intrinsics.checkNotNull((Object)buildNumber);
        BuildNumber lastVersionWithNoBuildNumber = buildNumber;
        Path path = binDir.resolve("build.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path buildTxt = path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(buildTxt, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            LOG.debug(buildTxt + " file not found, assuming " + lastVersionWithNoBuildNumber + " or earlier");
            return lastVersionWithNoBuildNumber;
        }
        String buildTxtContents = PathsKt.readText$default((Path)buildTxt, null, (int)1, null);
        BuildNumber buildNumber2 = BuildNumber.fromString((String)buildTxtContents);
        if (buildNumber2 == null) {
            throw new IllegalStateException(("Invalid build number: " + buildTxtContents).toString());
        }
        BuildNumber buildNumber3 = buildNumber2;
        if (!(buildNumber3.compareTo(lastVersionWithNoBuildNumber) > 0)) {
            boolean bl = false;
            String string = buildTxt + " contains " + buildNumber3 + ", but it can only be present after " + lastVersionWithNoBuildNumber;
            throw new IllegalArgumentException(string.toString());
        }
        return buildNumber3;
    }

    private final BuildNumber getInstalledBuildFromDiscovery() {
        boolean $i$f$service = false;
        Class<IdeStationServerService> serviceClass$iv = IdeStationServerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        DiscoveryService discoveryService = (DiscoveryService)((IdeStationServerService)object).getDiscoveryService().getValue();
        if (discoveryService == null) {
            return null;
        }
        DiscoveryService discoveryService2 = discoveryService;
        StationConnection stationConnection = (StationConnection)discoveryService2.getConnectionState().getValue();
        if (stationConnection == null) {
            return null;
        }
        StationConnection connectionState = stationConnection;
        LOG.debug("Toolbox installation from discovery: v" + connectionState.getVersion() + ", pid: " + connectionState.getPid());
        return BuildNumber.fromString((String)connectionState.getVersion());
    }

    private final Path discoverToolboxBinaryDir() {
        Path path;
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path2 = NioPathUtil.toNioPathOrNull((String)string);
        Intrinsics.checkNotNull((Object)path2);
        Path userHome = path2;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                String string2 = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKnownFolderPath(...)");
                Path path3 = NioPathUtil.toNioPathOrNull((String)string2);
                if (path3 == null) {
                    Path path4 = userHome.resolve("AppData");
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                    Path path5 = path4.resolve("Local");
                    path3 = path5;
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                }
                Path localAppData = path3;
                Path path6 = localAppData.resolve("JetBrains");
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
                Path path7 = path6.resolve("Toolbox");
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
                Path path8 = path7.resolve("bin");
                path = path8;
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
                break;
            }
            case 3: {
                Path path9 = this.discoverToolboxAppOnMacOS().resolve("Contents");
                path = path9;
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
                break;
            }
            case 2: {
                Path path10 = userHome;
                Path path11 = Path.of(".local/share/JetBrains/Toolbox/bin", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"of(...)");
                Path path12 = path10.resolve(path11);
                path = path12;
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"resolve(...)");
                break;
            }
            default: {
                throw new IllegalStateException(("Not supported: " + OS.CURRENT).toString());
            }
        }
        return path;
    }

    private final Path discoverToolboxExecutablePath(boolean forDaemon) {
        Path initialPath;
        int n;
        String exeName = forDaemon ? "jetbrainsd" : "jetbrains-toolbox";
        OS oS = OS.CURRENT;
        int n2 = n = oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        if (n == 1) {
            Path path = this.discoverToolboxBinaryDir().resolve(exeName + ".exe");
            v3 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        } else if (n == 2) {
            Path path = this.discoverToolboxBinaryDir().resolve(exeName);
            v3 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        } else if (n == 3 && forDaemon) {
            LOG.warn("Can't launch daemon on macOS yet");
            v3 = null;
        } else if (n == 3) {
            v3 = this.discoverToolboxAppOnMacOS();
        } else {
            LOG.debug("Toolbox executable is not available on " + OS.CURRENT);
            v3 = initialPath = null;
        }
        if (initialPath != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(initialPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && forDaemon && Registry.Companion.is("station.daemon.process.allow.default.exe.fallback")) {
                LOG.debug("Daemon binary not found, falling back to normal binary");
                initialPath = this.discoverToolboxExecutablePath(false);
            }
        }
        return initialPath;
    }

    private final Path discoverToolboxAppOnMacOS() {
        Path fallbackPath = Path.of("/Applications/JetBrains Toolbox.app", new String[0]);
        try {
            Object object;
            block6: {
                block5: {
                    String string;
                    String[] stringArray = new String[]{"mdfind", "kMDItemCFBundleIdentifier=\"com.jetbrains.toolbox\""};
                    GeneralCommandLine searchForInstallationDirectoryCommand = new GeneralCommandLine(stringArray);
                    ProcessOutput result = ExecUtil.execAndGetOutput((GeneralCommandLine)searchForInstallationDirectoryCommand);
                    List list = result.getStdoutLines();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
                    String stdoutLine = (String)CollectionsKt.firstOrNull((List)list);
                    LOG.debug("Toolbox installation directory: " + stdoutLine);
                    object = stdoutLine;
                    if (object == null) break block5;
                    String it = string = object;
                    boolean bl = false;
                    object = ((CharSequence)it).length() > 0 ? string : null;
                    if (object != null && (object = NioPathUtil.toNioPathOrNull((String)object)) != null) break block6;
                }
                Intrinsics.checkNotNull((Object)fallbackPath);
                object = fallbackPath;
            }
            return object;
        }
        catch (IOException exception) {
            LOG.warn("Failed to discover Toolbox app on macOS. Falling back to the default path", (Throwable)exception);
            Intrinsics.checkNotNull((Object)fallbackPath);
            return fallbackPath;
        }
    }

    private final GeneralCommandLine createLaunchToolboxCommand(boolean forDaemon, String ... args) {
        Object object = this.discoverToolboxExecutablePath(forDaemon);
        if (object == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
            return null;
        }
        Object exePath = object;
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> {
                SpreadBuilder var4_4 = new SpreadBuilder(2);
                var4_4.add(exePath);
                var4_4.addSpread((Object)args);
                GeneralCommandLine v2 = new GeneralCommandLine((String[])var4_4.toArray((Object[])new String[var4_4.size()]));
                yield v2;
            }
            case 2 -> {
                SpreadBuilder var4_5 = new SpreadBuilder(2);
                var4_5.add(exePath);
                var4_5.addSpread((Object)args);
                GeneralCommandLine v4 = new GeneralCommandLine((String[])var4_5.toArray((Object[])new String[var4_5.size()]));
                yield v4;
            }
            case 3 -> {
                SpreadBuilder var4_6 = new SpreadBuilder(3);
                var4_6.add((Object)"open");
                var4_6.add(exePath);
                var4_6.addSpread((Object)args);
                GeneralCommandLine v5 = new GeneralCommandLine((String[])var4_6.toArray((Object[])new String[var4_6.size()]));
                yield v5;
            }
            default -> {
                LOG.debug("Toolbox is not possible to launch on " + OS.CURRENT);
                yield null;
            }
        };
    }

    public static final /* synthetic */ Object access$installOrUpdate(ToolboxDiscovery $this, boolean isFullApp, Continuation $completion) {
        return $this.installOrUpdate(isFullApp, (Continuation<? super ToolboxInstallationResult>)$completion);
    }

    public static final /* synthetic */ Object access$extractDistTo(ToolboxDiscovery $this, Path dist, Path target, Continuation $completion) {
        return $this.extractDistTo(dist, target, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$killAllToolboxProcesses(ToolboxDiscovery $this, Continuation $completion) {
        return $this.killAllToolboxProcesses((Continuation<? super Boolean>)$completion);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

