/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage;

import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.storage.ProvenanceDatabase;
import com.intellij.code.provenance.core.events.storage.ProvenanceDatabaseService;
import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceDatabaseFactory;
import com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceMvStoreDatabase;
import com.intellij.code.provenance.core.events.storage.mvstore.UtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0082@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010(J(\u0010)\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0086@\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010-\u001a\u00020.H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010%J\u000e\u00101\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u000eH\u0016J\u0006\u00105\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "database", "Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceMvStoreDatabase;", "databaseLock", "Lkotlinx/coroutines/sync/Mutex;", "peekDatabase", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDatabase", "insertEntries", "", "entries", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$OrdinaryEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertMetadata", "entry", "Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "(Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryByFilePath", "Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabase$ProvenanceEntryClosableQuery;", "filePath", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryMetadataEntriesByFilePath", "Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabase$ProvenanceMetadataEntryClosableQuery;", "queryRecentEntries", "limit", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllEntriesAfterTimestamp", "timestampFrom", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllEntriesBetweenTimestamps", "timestampTo", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryDocumentChangesBetweenTimestamps", "path", "(JJLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commit", "getDatabaseForInspection", "Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabase;", "deleteEntriesBeforeTimestamp", "timestamp", "resetDatabaseAfterLvcsCorruption", "getDatabasePath", "Ljava/nio/file/Path;", "dispose", "closeDatabase", "Companion", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nProvenanceDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceDatabaseService.kt\ncom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n116#2,11:194\n116#2,8:205\n125#2,2:214\n116#2,11:216\n1#3:213\n13#4:227\n*S KotlinDebug\n*F\n+ 1 ProvenanceDatabaseService.kt\ncom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService\n*L\n35#1:194,11\n39#1:205,8\n39#1:214,2\n132#1:216,11\n26#1:227\n*E\n"})
public final class ProvenanceDatabaseService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ProvenanceMvStoreDatabase database;
    @NotNull
    private final Mutex databaseLock;
    @NotNull
    private static final Logger log;

    public ProvenanceDatabaseService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.databaseLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object peekDatabase(Continuation<? super ProvenanceMvStoreDatabase> $completion) {
        if (!($completion instanceof peekDatabase.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProvenanceDatabaseService.access$peekDatabase(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.databaseLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-ProvenanceDatabaseService$peekDatabase$2 = false;
                    var6_11 = this.database;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object getDatabase(Continuation<? super ProvenanceMvStoreDatabase> $completion) {
        if (!($completion instanceof getDatabase.1)) ** GOTO lbl-1000
        var15_2 = $completion;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProvenanceDatabaseService.access$getDatabase(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.databaseLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-ProvenanceDatabaseService$getDatabase$2 = false;
                    v1 = this.database;
                    if (v1 == null) {
                        $this$getDatabase_u24lambda_u240_u240 = this;
                        $i$a$-run-ProvenanceDatabaseService$getDatabase$2$1 = false;
                        var8_13 = $this$getDatabase_u24lambda_u240_u240.getDatabasePath();
                        it = var8_13;
                        $i$a$-takeUnless-ProvenanceDatabaseService$getDatabase$2$1$dbPath$1 = false;
                        v2 = ApplicationKt.getApplication().isUnitTestMode() == false ? var8_13 : null;
                        dbPath = v2 != null ? PathKt.createDirectories((Path)v2) : null;
                        ProvenanceDatabaseService.log.info("Creating ProvenanceDatabase at: " + dbPath);
                        try {
                            var8_13 = ProvenanceDatabaseFactory.INSTANCE.open(dbPath, $this$getDatabase_u24lambda_u240_u240.project);
                        }
                        catch (Exception e) {
                            ProvenanceDatabaseService.log.warn("Failed to open ProvenanceDatabase at: " + dbPath + ", creating new database", (Throwable)e);
                            var8_13 = ProvenanceDatabaseFactory.INSTANCE.create(dbPath, $this$getDatabase_u24lambda_u240_u240.project);
                        }
                        $this$getDatabase_u24lambda_u240_u240.database = newDatabase = var8_13;
                        Disposer.register((Disposable)$this$getDatabase_u24lambda_u240_u240, (Disposable)(Disposable)LambdaMetafactory.metafactory(null, null, null, ()V, getDatabase$lambda$0$0$1(com.intellij.code.provenance.core.events.storage.mvstore.ProvenanceMvStoreDatabase ), ()V)((ProvenanceMvStoreDatabase)newDatabase));
                        v1 = newDatabase;
                    }
                    var13_19 = v1;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var13_19;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object insertEntries(@NotNull List<? extends ProvenanceEntry.OrdinaryEvent> entries, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof insertEntries.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.insertEntries(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (entries.isEmpty()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = entries;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                ** if (v0 != var8_5) goto lbl21
lbl20:
                // 1 sources

                return var8_5;
lbl21:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                entries = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    db = (ProvenanceMvStoreDatabase)v0;
                    for (ProvenanceEntry.OrdinaryEvent entry : entries) {
                        db.insert(entry);
                    }
                }
                catch (Exception e) {
                    ProvenanceDatabaseService.log.error("Failed to insert " + entries.size() + " ProvenanceEntries into database", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object insertMetadata(@NotNull ProvenanceEntry.MetadataEntryOfDocumentChange entry, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof insertMetadata.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.insertMetadata(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = entry;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                entry = (ProvenanceEntry.MetadataEntryOfDocumentChange)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    ((ProvenanceMvStoreDatabase)v0).insertMetadataEntry(entry);
                }
                catch (Exception e) {
                    ProvenanceDatabaseService.log.error("Failed to insert metadata entry", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryByFilePath(@NotNull String filePath, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery> $completion) {
        if (!($completion instanceof queryByFilePath.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryByFilePath(null, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = filePath;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                filePath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryByFilePath(filePath);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryMetadataEntriesByFilePath(@NotNull String filePath, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceMetadataEntryClosableQuery> $completion) {
        if (!($completion instanceof queryMetadataEntriesByFilePath.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryMetadataEntriesByFilePath(null, (Continuation<? super ProvenanceDatabase.ProvenanceMetadataEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = filePath;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                filePath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryMetadataEntriesByFilePath(filePath);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryRecentEntries(int limit, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery> $completion) {
        if (!($completion instanceof queryRecentEntries.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryRecentEntries(0, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.I$0 = limit;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                limit = $continuation.I$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryRecentEntries(limit);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryRecentEntries$default(ProvenanceDatabaseService provenanceDatabaseService, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        return provenanceDatabaseService.queryRecentEntries(n, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryAllEntriesAfterTimestamp(long timestampFrom, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery> $completion) {
        if (!($completion instanceof queryAllEntriesAfterTimestamp.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryAllEntriesAfterTimestamp(0L, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.J$0 = timestampFrom;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                timestampFrom = $continuation.J$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryAllEntriesAfterTimestamp(timestampFrom);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryAllEntriesBetweenTimestamps(long timestampFrom, long timestampTo, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery> $completion) {
        if (!($completion instanceof queryAllEntriesBetweenTimestamps.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryAllEntriesBetweenTimestamps(0L, 0L, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.J$0 = timestampFrom;
                $continuation.J$1 = timestampTo;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                timestampTo = $continuation.J$1;
                timestampFrom = $continuation.J$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryAllEntriesBetweenTimestamps(timestampFrom, timestampTo);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryDocumentChangesBetweenTimestamps(long timestampFrom, long timestampTo, @Nullable String path, @NotNull Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery> $completion) {
        if (!($completion instanceof queryDocumentChangesBetweenTimestamps.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                long J$1;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryDocumentChangesBetweenTimestamps(0L, 0L, null, (Continuation<? super ProvenanceDatabase.ProvenanceEntryClosableQuery>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = path;
                $continuation.J$0 = timestampFrom;
                $continuation.J$1 = timestampTo;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                timestampTo = $continuation.J$1;
                timestampFrom = $continuation.J$0;
                path = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                return ((ProvenanceMvStoreDatabase)v0).queryAllDocumentChangesBetweenTimestamps(timestampFrom, timestampTo, path);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object commit(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof commit.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.commit((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.peekDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    v1 = (ProvenanceMvStoreDatabase)v0;
                    if (v1 != null) {
                        v1.commit();
                    }
                }
                catch (Exception e) {
                    ProvenanceDatabaseService.log.warn("Commit failed", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object getDatabaseForInspection(@NotNull Continuation<? super ProvenanceDatabase> $completion) {
        return this.getDatabase($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object deleteEntriesBeforeTimestamp(long timestamp, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof deleteEntriesBeforeTimestamp.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteEntriesBeforeTimestamp(0L, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.J$0 = timestamp;
                $continuation.label = 1;
                v0 = this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$continuation);
                ** if (v0 != var11_5) goto lbl19
lbl18:
                // 1 sources

                return var11_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                timestamp = $continuation.J$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    db = (ProvenanceMvStoreDatabase)v0;
                    var5_8 = this;
                    synchronized (var5_8) {
                        $i$a$-synchronized-ProvenanceDatabaseService$deleteEntriesBeforeTimestamp$2 = false;
                        idsToDelete = db.collectEntriesBeforeTimestamp(timestamp);
                        var6_10 = deletedCount = db.deleteEntriesByIds(idsToDelete);
                    }
                    var4_7 = var6_10;
                }
                catch (Exception e) {
                    ProvenanceDatabaseService.log.error("Failed to delete entries before timestamp " + timestamp, (Throwable)e);
                    var4_7 = 0;
                }
                return Boxing.boxInt((int)var4_7);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object resetDatabaseAfterLvcsCorruption(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof resetDatabaseAfterLvcsCorruption.1)) ** GOTO lbl-1000
        var15_2 = $completion;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProvenanceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resetDatabaseAfterLvcsCorruption((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.databaseLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-ProvenanceDatabaseService$resetDatabaseAfterLvcsCorruption$2 = false;
                    try {
                        db = this.database;
                        if (db != null) ** GOTO lbl37
                        ProvenanceDatabaseService.log.info("No database to reset");
                        ** GOTO lbl63
lbl37:
                        // 1 sources

                        ProvenanceDatabaseService.log.warn("Resetting provenance database after LVCS corruption");
                        try {
                            db.close();
                        }
                        catch (Exception e) {
                            ProvenanceDatabaseService.log.warn("Failed to commit before closing corrupted database", (Throwable)e);
                        }
                        dbPath = this.getDatabasePath();
                        dbFile = UtilKt.getDatabaseFile(dbPath);
                        if (Files.exists(dbFile, new LinkOption[0])) {
                            timestamp = System.currentTimeMillis();
                            backupPath = dbPath.resolve("provenance.mv.db.corrupted." + timestamp);
                            try {
                                Files.move(dbFile, backupPath, new CopyOption[0]);
                                ProvenanceDatabaseService.log.info("Moved corrupted database to: " + backupPath);
                            }
                            catch (Exception e) {
                                ProvenanceDatabaseService.log.warn("Failed to rename corrupted database file", (Throwable)e);
                            }
                        }
                        this.database = null;
                        ProvenanceDatabaseService.log.info("Database reset completed successfully");
                    }
                    catch (Exception e) {
                        ProvenanceDatabaseService.log.error("Failed to reset database after LVCS corruption", (Throwable)e);
                    }
lbl63:
                    // 3 sources

                    var13_19 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path getDatabasePath() {
        Path path;
        String projectBasePath = this.project.getBasePath();
        if (projectBasePath != null) {
            Path projectRoot = Path.of(projectBasePath, new String[0]);
            Intrinsics.checkNotNull((Object)projectRoot);
            String cacheDirectoryName = ProjectUtil.getProjectCacheFileName((Path)projectRoot);
            Path path2 = ProjectUtil.getProjectsDataDir().resolve(cacheDirectoryName).resolve("provenance");
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            Path path3 = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("provenance-" + this.project.getName());
            Intrinsics.checkNotNull((Object)path3);
            path = path3;
        }
        return path;
    }

    public void dispose() {
        this.closeDatabase();
    }

    public final void closeDatabase() {
        try {
            ProvenanceMvStoreDatabase provenanceMvStoreDatabase = this.database;
            if (provenanceMvStoreDatabase != null) {
                provenanceMvStoreDatabase.commit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProvenanceMvStoreDatabase provenanceMvStoreDatabase = this.database;
        if (provenanceMvStoreDatabase != null) {
            provenanceMvStoreDatabase.close();
        }
        this.database = null;
    }

    private static final void getDatabase$lambda$0$0$1(ProvenanceMvStoreDatabase $newDatabase) {
        $newDatabase.close();
    }

    public static final /* synthetic */ Object access$peekDatabase(ProvenanceDatabaseService $this, Continuation $completion) {
        return $this.peekDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$completion);
    }

    public static final /* synthetic */ Object access$getDatabase(ProvenanceDatabaseService $this, Continuation $completion) {
        return $this.getDatabase((Continuation<? super ProvenanceMvStoreDatabase>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProvenanceDatabaseService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core"})
    @SourceDebugExtension(value={"SMAP\nProvenanceDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceDatabaseService.kt\ncom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,193:1\n30#2,2:194\n*S KotlinDebug\n*F\n+ 1 ProvenanceDatabaseService.kt\ncom/intellij/code/provenance/core/events/storage/ProvenanceDatabaseService$Companion\n*L\n28#1:194,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceDatabaseService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProvenanceDatabaseService> serviceClass$iv = ProvenanceDatabaseService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ProvenanceDatabaseService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

