/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.mvstore;

import com.intellij.util.ArrayUtilRt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/code/provenance/core/events/storage/mvstore/ModernStringDataType;", "Lorg/h2/mvstore/type/BasicDataType;", "", "<init>", "()V", "createStorage", "", "size", "", "(I)[Ljava/lang/String;", "compare", "a", "b", "binarySearch", "key", "storageObj", "", "initialGuess", "getMemory", "obj", "read", "buff", "Ljava/nio/ByteBuffer;", "write", "", "Lorg/h2/mvstore/WriteBuffer;", "s", "intellij.code.provenance.core"})
public final class ModernStringDataType
extends BasicDataType<String> {
    @NotNull
    public static final ModernStringDataType INSTANCE = new ModernStringDataType();

    private ModernStringDataType() {
    }

    @NotNull
    public String[] createStorage(int size) {
        String[] stringArray;
        if (size == 0) {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        } else {
            stringArray = new String[size];
        }
        return stringArray;
    }

    public int compare(@NotNull String a, @NotNull String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.compareTo(b);
    }

    public int binarySearch(@NotNull String key, @NotNull Object storageObj, int size, int initialGuess) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)storageObj, (String)"storageObj");
        String[] storage = (String[])storageObj;
        int low = 0;
        int high = size - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            String string = storage[x];
            Intrinsics.checkNotNull((Object)string);
            int compare = key.compareTo(string);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    public int getMemory(@NotNull String obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return 24 + 2 * obj.length();
    }

    @NotNull
    public String read(@NotNull ByteBuffer buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        byte[] bytes = new byte[DataUtils.readVarInt((ByteBuffer)buff)];
        buff.get(bytes);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    public void write(@NotNull WriteBuffer buff, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] bytes = StringsKt.encodeToByteArray((String)s);
        buff.putVarInt(bytes.length).put(bytes);
    }
}

