/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.utils;

import com.intellij.history.core.changes.StructuralChange;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.ApplicationKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\r\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0002*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"PROJECT_DIRECTORY_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "projectDirectory", "Lcom/intellij/openapi/project/Project;", "getProjectDirectory", "(Lcom/intellij/openapi/project/Project;)Ljava/nio/file/Path;", "relativeToProject", "path", "", "findVirtualFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "refresh", "", "isSourceFile", "findSourceFile", "Lcom/intellij/history/core/changes/StructuralChange;", "project", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\npath-utils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 path-utils.kt\ncom/intellij/code/provenance/core/events/utils/Path_utilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class Path_utilsKt {
    @NotNull
    private static final Key<Path> PROJECT_DIRECTORY_KEY;

    @NotNull
    public static final Path getProjectDirectory(@NotNull Project $this$projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$projectDirectory, (String)"<this>");
        Path path = (Path)$this$projectDirectory.getUserData(PROJECT_DIRECTORY_KEY);
        if (path == null) {
            String path2;
            String string;
            String string2;
            Project $this$_get_projectDirectory__u24lambda_u240 = $this$projectDirectory;
            boolean bl = false;
            if (ApplicationKt.getApplication().isUnitTestMode()) {
                string2 = $this$_get_projectDirectory__u24lambda_u240.getBasePath();
            } else {
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$_get_projectDirectory__u24lambda_u240);
                string2 = virtualFile != null ? virtualFile.getPath() : null;
            }
            if ((string = (path2 = string2)) == null) {
                string = "";
            }
            Path path3 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path it = path3;
            boolean bl2 = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Path computed = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? it.toRealPath(new LinkOption[0]) : it;
            $this$_get_projectDirectory__u24lambda_u240.putUserData(PROJECT_DIRECTORY_KEY, (Object)computed);
            Path path4 = computed;
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"run(...)");
        }
        return path;
    }

    @Nullable
    public static final Path relativeToProject(@NotNull Project $this$relativeToProject, @NotNull String path) {
        Path path2;
        Path path3;
        Path path4;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$relativeToProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path it = Path_utilsKt.getProjectDirectory($this$relativeToProject).resolve(path).normalize();
        boolean bl = false;
        Object object2 = $this$relativeToProject;
        try {
            Project $this$relativeToProject_u24lambda_u240_u240 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)it.toRealPath(new LinkOption[0]));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        it = path4 = Result.isFailure-impl((Object)object2) ? it : object2;
        boolean bl3 = false;
        Path path5 = path3 = it.startsWith(Path_utilsKt.getProjectDirectory($this$relativeToProject)) ? path4 : null;
        if (path3 != null) {
            it = path3;
            boolean bl4 = false;
            path2 = Path_utilsKt.getProjectDirectory($this$relativeToProject).relativize(it);
        } else {
            path2 = null;
        }
        return path2;
    }

    @Nullable
    public static final VirtualFile findVirtualFileByPath(@NotNull Project $this$findVirtualFileByPath, @NotNull String filePath, boolean refresh) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$findVirtualFileByPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Path path = Path_utilsKt.getProjectDirectory($this$findVirtualFileByPath).resolve(filePath).normalize();
        if (refresh) {
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)path.toFile()));
        }
        if ((object = LocalFileSystem.getInstance().findFileByNioFile(path)) == null) {
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$findVirtualFileByPath);
            object = virtualFile != null && (virtualFile = virtualFile.getFileSystem()) != null ? virtualFile.findFileByPath(filePath) : null;
        }
        return object;
    }

    public static /* synthetic */ VirtualFile findVirtualFileByPath$default(Project project, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Path_utilsKt.findVirtualFileByPath(project, string, bl);
    }

    public static final boolean isSourceFile(@NotNull VirtualFile $this$isSourceFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceFile, (String)"<this>");
        return VirtualFileUtil.isFile((VirtualFile)$this$isSourceFile) && !$this$isSourceFile.getFileType().isBinary();
    }

    @Nullable
    public static final VirtualFile findSourceFile(@NotNull StructuralChange $this$findSourceFile, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$findSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = $this$findSourceFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        VirtualFile virtualFile = Path_utilsKt.findVirtualFileByPath$default(project, string, false, 2, null);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = Path_utilsKt.isSourceFile(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    static {
        Key key = Key.create((String)"provenance.projectDirectory");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROJECT_DIRECTORY_KEY = key;
    }
}

