/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.NetSubTask;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ReleaseGetter;
import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.CompressorKt;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RecursiveTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0013\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/NetFileTask;", "Ljava/util/concurrent/RecursiveTask;", "", "fileInfo", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileInfo;", "chunks", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunk;", "remoteCompressedChunks", "", "", "releaseGetter", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/ReleaseGetter;", "outputPath", "<init>", "(Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileInfo;Ljava/util/List;Ljava/util/Map;Lcom/jetbrains/rd/platform/codeWithMe/blockmap/ReleaseGetter;Ljava/lang/String;)V", "getChunks", "()Ljava/util/List;", "THRES", "compute", "()Ljava/lang/Integer;", "makeRequests", "output", "Ljava/io/RandomAccessFile;", "write", "", "start", "end", "bytes", "", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nNetTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetTasks.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/NetFileTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1915#2,2:134\n*S KotlinDebug\n*F\n+ 1 NetTasks.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/NetFileTask\n*L\n52#1:134,2\n*E\n"})
public final class NetFileTask
extends RecursiveTask<Integer> {
    @NotNull
    private final FileInfo fileInfo;
    @NotNull
    private final List<Chunk> chunks;
    @NotNull
    private final Map<String, Chunk> remoteCompressedChunks;
    @NotNull
    private final ReleaseGetter releaseGetter;
    @NotNull
    private final String outputPath;
    private final int THRES;

    public NetFileTask(@NotNull FileInfo fileInfo, @NotNull List<Chunk> chunks, @NotNull Map<String, Chunk> remoteCompressedChunks, @NotNull ReleaseGetter releaseGetter, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter(remoteCompressedChunks, (String)"remoteCompressedChunks");
        Intrinsics.checkNotNullParameter((Object)releaseGetter, (String)"releaseGetter");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.fileInfo = fileInfo;
        this.chunks = chunks;
        this.remoteCompressedChunks = remoteCompressedChunks;
        this.releaseGetter = releaseGetter;
        this.outputPath = outputPath;
        this.THRES = 32768;
    }

    @NotNull
    public final List<Chunk> getChunks() {
        return this.chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Integer compute() {
        Object object = new String[]{this.fileInfo.getName()};
        File targetFile = Paths.get(this.outputPath, object).toFile();
        object = new RandomAccessFile(targetFile, "rw");
        Throwable throwable = null;
        try {
            RandomAccessFile output = (RandomAccessFile)object;
            boolean bl = false;
            Integer n = this.makeRequests(output);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final int makeRequests(RandomAccessFile output) {
        int start = 0;
        int end = 0;
        List subTasks = new ArrayList();
        while (end < this.chunks.size()) {
            Chunk endChunk;
            Chunk startChunk = this.remoteCompressedChunks.get(this.chunks.get(start).getHash());
            Chunk chunk = endChunk = this.remoteCompressedChunks.get(this.chunks.get(end).getHash());
            Intrinsics.checkNotNull((Object)chunk);
            int n = chunk.getLength() + endChunk.getOffset();
            Chunk chunk2 = startChunk;
            Intrinsics.checkNotNull((Object)chunk2);
            int distance = n - chunk2.getOffset();
            if (distance >= this.THRES || end == this.chunks.size() - 1) {
                subTasks.add(new NetSubTask(this.chunks, this.remoteCompressedChunks, start, end, this.releaseGetter));
                ((NetSubTask)CollectionsKt.last((List)subTasks)).fork();
                end = start = end + 1;
                continue;
            }
            ++end;
        }
        Iterable $this$forEach$iv = subTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetSubTask it = (NetSubTask)element$iv;
            boolean bl = false;
            byte[] b = (byte[])it.join();
            int n = it.getStart();
            int n2 = it.getEnd();
            Intrinsics.checkNotNull((Object)b);
            this.write(n, n2, b, output);
        }
        int numOfReqs = subTasks.size();
        if (numOfReqs != 0) {
            System.out.println((Object)("Num of reqs: " + numOfReqs + ", chunks: " + this.chunks.size()));
        }
        return numOfReqs;
    }

    private final void write(int start, int end, byte[] bytes, RandomAccessFile output) {
        byte[] buffer = new byte[16384];
        Chunk chunk = this.remoteCompressedChunks.get(this.chunks.get(start).getHash());
        Intrinsics.checkNotNull((Object)chunk);
        Chunk firstCompChunk = chunk;
        int i = start;
        if (i <= end) {
            while (true) {
                Chunk compChunk;
                Chunk chunk2 = this.chunks.get(i);
                Intrinsics.checkNotNull((Object)this.remoteCompressedChunks.get(chunk2.getHash()));
                int compOffset = compChunk.getOffset() - firstCompChunk.getOffset();
                CompressorKt.decompress(bytes, compOffset, compChunk.getLength(), buffer);
                output.seek(chunk2.getOffset());
                output.write(buffer, 0, chunk2.getLength());
                if (i == end) break;
                ++i;
            }
        }
    }
}

