/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPortHandler;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortListeningOptions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.LinuxPortForwardingProcessWatcher;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.PortForwardingProcessWatcher;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0007\u0018\u0000 *2\u00020\u0001:\u0003()*B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher;", "pid", "", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "options", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "<init>", "(JLcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;)V", "socketInodeRegex", "Lkotlin/text/Regex;", "getPortsOfPids", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "pids", "b2", "", "b4", "b8", "b16", "b32", "tcp4LineRegex", "getListeningPortsIPv4", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$TcpLine;", "tcp6LineRegex", "getListeningPortsIPv6", "parseTcpTable", "", "netTcpFile", "Ljava/io/File;", "tcpLineRegex", "wellKnownAddresses", "", "hexStringToBytes", "", "hexString", "toCanonicalOrder", "input", "LinuxTcpState", "TcpLine", "Companion", "intellij.platform.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLinuxPortForwardingProcesssWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxPortForwardingProcesssWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,244:1\n1#2:245\n67#3,4:246\n23#3:250\n*S KotlinDebug\n*F\n+ 1 LinuxPortForwardingProcesssWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher\n*L\n184#1:246,4\n48#1:250\n*E\n"})
public final class LinuxPortForwardingProcessWatcher
extends PortForwardingProcessWatcher {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Regex socketInodeRegex;
    @NotNull
    private final String b2;
    @NotNull
    private final String b4;
    @NotNull
    private final String b8;
    @NotNull
    private final String b16;
    @NotNull
    private final String b32;
    @NotNull
    private final Regex tcp4LineRegex;
    @NotNull
    private final Regex tcp6LineRegex;
    @NotNull
    private final Map<String, String> wellKnownAddresses;
    @NotNull
    private static final Logger logger;

    public LinuxPortForwardingProcessWatcher(long pid, @NotNull ListeningPortHandler handler, @NotNull PortListeningOptions options) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        super(pid, handler, options);
        if (!SystemInfoRt.isLinux) {
            boolean bl = false;
            String string = "LinuxPortForwardingProcessWatcher called not on Linux. This is a programming error";
            throw new IllegalArgumentException(string.toString());
        }
        this.socketInodeRegex = new Regex("socket:\\[(\\d+)]");
        this.b2 = "[0-9a-fA-F]{2}";
        this.b4 = "[0-9a-fA-F]{4}";
        this.b8 = "[0-9a-fA-F]{8}";
        this.b16 = "[0-9a-fA-F]{16}";
        this.b32 = "[0-9a-fA-F]{32}";
        this.tcp4LineRegex = new Regex("^\\s*(?<entryNum>\\d+):\\s+(?<localAddr>" + this.b8 + "):(?<localPort>" + this.b4 + ")\\s+(?<remoteAddr>" + this.b8 + "):(?<remotePort>" + this.b4 + ")\\s+(?<state>" + this.b2 + ")\\s+(?<txQueue>" + this.b8 + "):(?<rxQueue>" + this.b8 + ")\\s+(?<tr>" + this.b2 + "):(?<tmWhen>" + this.b8 + ")\\s+(?<retransmit>" + this.b8 + ")\\s+(?<uid>[0-9a-fA-F]+)\\s+(?<timeout>[0-9a-fA-F]+)\\s+(?<inode>\\d+)\\s+.*");
        this.tcp6LineRegex = new Regex("^\\s*(?<entryNum>\\d+):\\s+(?<localAddr>" + this.b32 + "):(?<localPort>" + this.b4 + ")\\s+(?<remoteAddr>" + this.b32 + "):(?<remotePort>" + this.b4 + ")\\s+(?<state>" + this.b2 + ")\\s+(?<txQueue>" + this.b8 + "):(?<rxQueue>" + this.b8 + ")\\s+(?<tr>" + this.b2 + "):(?<tmWhen>" + this.b8 + ")\\s+(?<retransmit>" + this.b8 + ")\\s+(?<uid>[0-9a-fA-F]+)\\s+(?<timeout>[0-9a-fA-F]+)\\s+(?<inode>\\d+)\\s+.*");
        this.wellKnownAddresses = MapsKt.mapOf((Pair)TuplesKt.to((Object)"0:0:0:0:0:0:0:0", (Object)"0.0.0.0"));
    }

    @Override
    @NotNull
    protected Set<ListeningPort> getPortsOfPids(@NotNull Set<Long> pids) {
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"com/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$getPortsOfPids$InodeWithPid", "", "pid", "", "inode", "<init>", "(JJ)V", "getPid", "()J", "getInode", "component1", "component2", "copy", "(JJ)Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$getPortsOfPids$InodeWithPid;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.split"})
        public final class InodeWithPid {
            private final long pid;
            private final long inode;

            public InodeWithPid(long pid, long inode) {
                this.pid = pid;
                this.inode = inode;
            }

            public final long getPid() {
                return this.pid;
            }

            public final long getInode() {
                return this.inode;
            }

            public final long component1() {
                return this.pid;
            }

            public final long component2() {
                return this.inode;
            }

            public final InodeWithPid copy(long pid, long inode) {
                return new InodeWithPid(pid, inode);
            }

            public static /* synthetic */ InodeWithPid copy$default(InodeWithPid inodeWithPid, long l, long l2, int n, Object object) {
                if ((n & 1) != 0) {
                    l = inodeWithPid.pid;
                }
                if ((n & 2) != 0) {
                    l2 = inodeWithPid.inode;
                }
                return inodeWithPid.copy(l, l2);
            }

            public String toString() {
                return "InodeWithPid(pid=" + this.pid + ", inode=" + this.inode + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.pid);
                result2 = result2 * 31 + Long.hashCode(this.inode);
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InodeWithPid)) {
                    return false;
                }
                InodeWithPid inodeWithPid = (InodeWithPid)other;
                if (this.pid != inodeWithPid.pid) {
                    return false;
                }
                return this.inode == inodeWithPid.inode;
            }
        }
        List e4;
        List pid2;
        Intrinsics.checkNotNullParameter(pids, (String)"pids");
        List inodesWithPid = new ArrayList();
        Iterator<Long> iterator = pids.iterator();
        while (iterator.hasNext()) {
            long pid2 = ((Number)iterator.next()).longValue();
            try {
                File[] fdFiles;
                File fdDir = new File("/proc/" + pid2 + "/fd/");
                if (fdDir.listFiles() == null) {
                    throw new IllegalStateException(("Failed to get file descriptors for " + fdDir.getPath()).toString());
                }
                for (File fdFile : fdFiles) {
                    try {
                        MatchResult match;
                        Path linkTarget = Files.readSymbolicLink(fdFile.toPath());
                        if (this.socketInodeRegex.matchEntire((CharSequence)((Object)linkTarget).toString()) == null) continue;
                        String inodeStr = (String)match.getGroupValues().get(1);
                        long inode = Long.parseLong(inodeStr);
                        inodesWithPid.add(new InodeWithPid(pid2, inode));
                    }
                    catch (NoSuchFileException e2) {
                        logger.debug("Failed to read file " + fdFile, (Throwable)e2);
                    }
                }
            }
            catch (Exception e3) {
                logger.warn("Failed to list ports for pid " + pid2, (Throwable)e3);
            }
        }
        try {
            pid2 = this.getListeningPortsIPv4();
        }
        catch (Exception e4) {
            logger.warn("Failed to get listening ipv4 ports", (Throwable)e4);
            pid2 = new ArrayList();
        }
        List listeningPorts4 = pid2;
        try {
            e4 = this.getListeningPortsIPv6();
        }
        catch (Exception e5) {
            logger.warn("Failed to get listening ipv6 ports", (Throwable)e5);
            e4 = new ArrayList();
        }
        List listeningPorts6 = e4;
        List listeningPorts = CollectionsKt.plus((Collection)listeningPorts4, (Iterable)listeningPorts6);
        Set result2 = new LinkedHashSet();
        for (TcpLine listeningPort : listeningPorts) {
            InodeWithPid matchedPort;
            Object v0;
            block13: {
                Iterable iterable = inodesWithPid;
                for (Object t : iterable) {
                    InodeWithPid it = (InodeWithPid)t;
                    boolean bl = false;
                    if (!(it.getInode() == listeningPort.getInode())) continue;
                    v0 = t;
                    break block13;
                }
                v0 = null;
            }
            if ((matchedPort = (InodeWithPid)v0) == null) continue;
            result2.add(new ListeningPort(new InetSocketAddress(listeningPort.getLocalAddress(), listeningPort.getLocalPort()), PortType.TCP, matchedPort.getPid()));
        }
        return result2;
    }

    private final List<TcpLine> getListeningPortsIPv4() {
        File netTcpFile = new File("/proc/net/tcp");
        return this.parseTcpTable(netTcpFile, this.tcp4LineRegex);
    }

    private final List<TcpLine> getListeningPortsIPv6() {
        File netTcp6File = new File("/proc/net/tcp6");
        return this.parseTcpTable(netTcp6File, this.tcp6LineRegex);
    }

    private final List<TcpLine> parseTcpTable(File netTcpFile, Regex tcpLineRegex) {
        List lines = FilesKt.readLines$default((File)netTcpFile, null, (int)1, null);
        List linesWithoutHeader = CollectionsKt.drop((Iterable)lines, (int)1);
        List result2 = new ArrayList();
        for (String line : linesWithoutHeader) {
            int n;
            long l;
            MatchNamedGroupCollection groups;
            MatchResult match = Regex.find$default((Regex)tcpLineRegex, (CharSequence)line, (int)0, (int)2, null);
            if (match == null) {
                logger.warn("Failed to parse tcp line from " + netTcpFile.getPath() + ", line: '" + line + "'");
                continue;
            }
            MatchGroupCollection matchGroupCollection = match.getGroups();
            MatchNamedGroupCollection matchNamedGroupCollection = groups = matchGroupCollection instanceof MatchNamedGroupCollection ? (MatchNamedGroupCollection)matchGroupCollection : null;
            if (groups == null) {
                logger.warn("Failed to convert match groups into MatchNamedGroupCollection");
                continue;
            }
            MatchGroup matchGroup = groups.get("state");
            Intrinsics.checkNotNull((Object)matchGroup);
            String state = matchGroup.getValue();
            if (!Intrinsics.areEqual((Object)state, (Object)LinuxTcpState.TCP_LISTEN.getHexString())) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if (!$this$trace$iv.isTraceEnabled()) continue;
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("TCP line is not in listening state: '" + line + "'");
                continue;
            }
            MatchGroup matchGroup2 = groups.get("inode");
            Intrinsics.checkNotNull((Object)matchGroup2);
            String inodeStr = matchGroup2.getValue();
            try {
                l = Long.parseLong(inodeStr);
            }
            catch (NumberFormatException e) {
                logger.warn("inode of TCP line in not a number: '" + line + "'");
                continue;
            }
            long inode = l;
            MatchGroup matchGroup3 = groups.get("localAddr");
            Intrinsics.checkNotNull((Object)matchGroup3);
            String localAddrHexStr = matchGroup3.getValue();
            byte[] localAddrBytes = this.toCanonicalOrder(this.hexStringToBytes(localAddrHexStr));
            InetAddress localAddr = InetAddress.getByAddress(localAddrBytes);
            MatchGroup matchGroup4 = groups.get("localPort");
            Intrinsics.checkNotNull((Object)matchGroup4);
            String localPortStr = matchGroup4.getValue();
            try {
                n = Integer.parseInt(localPortStr, CharsKt.checkRadix((int)16));
            }
            catch (NumberFormatException e) {
                logger.warn("local port of TCP line in not a number: '" + line + "'");
                continue;
            }
            int localPort = n;
            String string = this.wellKnownAddresses.get(localAddr.getHostAddress());
            if (string == null) {
                string = localAddr.getHostAddress();
            }
            String resultAddr = string;
            Intrinsics.checkNotNull((Object)resultAddr);
            result2.add(new TcpLine(inode, resultAddr, localPort));
        }
        return result2;
    }

    private final byte[] hexStringToBytes(String hexString) {
        int n;
        int n2 = hexString.length();
        int n3 = n2 % (n = 2);
        if (!(n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] bytes = new byte[hexString.length() / 2];
        n3 = bytes.length;
        for (int i = 0; i < n3; ++i) {
            int index = i * 2;
            String string = hexString.substring(index, index + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int j = Integer.parseInt(string, CharsKt.checkRadix((int)16));
            bytes[i] = (byte)j;
        }
        return bytes;
    }

    private final byte[] toCanonicalOrder(byte[] input) {
        int n = input.length;
        int n2 = 4;
        int n3 = n % n2;
        if (!(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31) == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] output = new byte[input.length];
        n3 = input.length / 4;
        for (int i = 0; i < n3; ++i) {
            output[i * 4] = input[i * 4 + 3];
            output[i * 4 + 1] = input[i * 4 + 2];
            output[i * 4 + 2] = input[i * 4 + 1];
            output[i * 4 + 3] = input[i * 4];
        }
        return output;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LinuxPortForwardingProcessWatcher.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$LinuxTcpState;", "", "hexString", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getHexString", "()Ljava/lang/String;", "TCP_ESTABLISHED", "TCP_SYN_SENT", "TCP_SYN_RECV", "TCP_FIN_WAIT1", "TCP_FIN_WAIT2", "TCP_TIME_WAIT", "TCP_CLOSE", "TCP_CLOSE_WAIT", "TCP_LAST_ACK", "TCP_LISTEN", "TCP_CLOSING", "TCP_NEW_SYN_RECV", "TCP_MAX_STATES", "intellij.platform.split"})
    private static final class LinuxTcpState
    extends Enum<LinuxTcpState> {
        @NotNull
        private final String hexString;
        public static final /* enum */ LinuxTcpState TCP_ESTABLISHED = new LinuxTcpState("01");
        public static final /* enum */ LinuxTcpState TCP_SYN_SENT = new LinuxTcpState("02");
        public static final /* enum */ LinuxTcpState TCP_SYN_RECV = new LinuxTcpState("03");
        public static final /* enum */ LinuxTcpState TCP_FIN_WAIT1 = new LinuxTcpState("04");
        public static final /* enum */ LinuxTcpState TCP_FIN_WAIT2 = new LinuxTcpState("05");
        public static final /* enum */ LinuxTcpState TCP_TIME_WAIT = new LinuxTcpState("06");
        public static final /* enum */ LinuxTcpState TCP_CLOSE = new LinuxTcpState("07");
        public static final /* enum */ LinuxTcpState TCP_CLOSE_WAIT = new LinuxTcpState("08");
        public static final /* enum */ LinuxTcpState TCP_LAST_ACK = new LinuxTcpState("09");
        public static final /* enum */ LinuxTcpState TCP_LISTEN = new LinuxTcpState("0A");
        public static final /* enum */ LinuxTcpState TCP_CLOSING = new LinuxTcpState("0B");
        public static final /* enum */ LinuxTcpState TCP_NEW_SYN_RECV = new LinuxTcpState("0C");
        public static final /* enum */ LinuxTcpState TCP_MAX_STATES = new LinuxTcpState("0D");
        private static final /* synthetic */ LinuxTcpState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LinuxTcpState(String hexString) {
            this.hexString = hexString;
        }

        @NotNull
        public final String getHexString() {
            return this.hexString;
        }

        public static LinuxTcpState[] values() {
            return (LinuxTcpState[])$VALUES.clone();
        }

        public static LinuxTcpState valueOf(String value) {
            return Enum.valueOf(LinuxTcpState.class, value);
        }

        @NotNull
        public static EnumEntries<LinuxTcpState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = linuxTcpStateArray = new LinuxTcpState[]{LinuxTcpState.TCP_ESTABLISHED, LinuxTcpState.TCP_SYN_SENT, LinuxTcpState.TCP_SYN_RECV, LinuxTcpState.TCP_FIN_WAIT1, LinuxTcpState.TCP_FIN_WAIT2, LinuxTcpState.TCP_TIME_WAIT, LinuxTcpState.TCP_CLOSE, LinuxTcpState.TCP_CLOSE_WAIT, LinuxTcpState.TCP_LAST_ACK, LinuxTcpState.TCP_LISTEN, LinuxTcpState.TCP_CLOSING, LinuxTcpState.TCP_NEW_SYN_RECV, LinuxTcpState.TCP_MAX_STATES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/LinuxPortForwardingProcessWatcher$TcpLine;", "", "inode", "", "localAddress", "", "localPort", "", "<init>", "(JLjava/lang/String;I)V", "getInode", "()J", "getLocalAddress", "()Ljava/lang/String;", "getLocalPort", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.split"})
    private static final class TcpLine {
        private final long inode;
        @NotNull
        private final String localAddress;
        private final int localPort;

        public TcpLine(long inode, @NotNull String localAddress, int localPort) {
            Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
            this.inode = inode;
            this.localAddress = localAddress;
            this.localPort = localPort;
        }

        public final long getInode() {
            return this.inode;
        }

        @NotNull
        public final String getLocalAddress() {
            return this.localAddress;
        }

        public final int getLocalPort() {
            return this.localPort;
        }

        public final long component1() {
            return this.inode;
        }

        @NotNull
        public final String component2() {
            return this.localAddress;
        }

        public final int component3() {
            return this.localPort;
        }

        @NotNull
        public final TcpLine copy(long inode, @NotNull String localAddress, int localPort) {
            Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
            return new TcpLine(inode, localAddress, localPort);
        }

        public static /* synthetic */ TcpLine copy$default(TcpLine tcpLine, long l, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = tcpLine.inode;
            }
            if ((n2 & 2) != 0) {
                string = tcpLine.localAddress;
            }
            if ((n2 & 4) != 0) {
                n = tcpLine.localPort;
            }
            return tcpLine.copy(l, string, n);
        }

        @NotNull
        public String toString() {
            return "TcpLine(inode=" + this.inode + ", localAddress=" + this.localAddress + ", localPort=" + this.localPort + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.inode);
            result2 = result2 * 31 + this.localAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.localPort);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TcpLine)) {
                return false;
            }
            TcpLine tcpLine = (TcpLine)other;
            if (this.inode != tcpLine.inode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.localAddress, (Object)tcpLine.localAddress)) {
                return false;
            }
            return this.localPort == tcpLine.localPort;
        }
    }
}

