/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.JupyterExecutionManagerExtensionsKt;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelTask;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.executor.task.JupyterTaskPurpose;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskPriority;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.py.debugger.JupyterDebugCellTask;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.jupyter.py.environment.PythonNotebookEnvironmentStateManager;
import com.intellij.jupyter.py.environment.stores.PythonEnvironmentStateManagersStore;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 .2\u00020\u0001:\u0001.B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u001e\u001a\u00020\u001cH\u0014J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0006\u0010#\u001a\u00020\u001cJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u0012\u0010'\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\r\u0010*\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess;", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "serverSocket", "Ljava/net/ServerSocket;", "executionConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "jupyterDebugProcessHandler", "Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/net/ServerSocket;Lcom/intellij/execution/ui/ExecutionConsole;Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "latestExecutedCell", "getLatestExecutedCell", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "setLatestExecutedCell", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)V", "myEnvironmentUpdater", "Lcom/intellij/jupyter/py/environment/PythonNotebookEnvironmentStateManager;", "myLocalPort", "", "connect", "", "notebookVirtualFile", "afterConnect", "loadFrame", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "executeAfterCell", "isSimplifiedView", "", "sessionInitialized", "showWarning", "warningId", "", "getConsolePromptCount", "()Ljava/lang/Integer;", "createPydevConnectionCommand", "portToConnect", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,199:1\n23#2:200\n*S KotlinDebug\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n*L\n143#1:200\n*E\n"})
public final class JupyterDebugProcess
extends PyDebugProcess {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private NotebookIntervalPointer latestExecutedCell;
    @Nullable
    private final PythonNotebookEnvironmentStateManager myEnvironmentUpdater;
    private final int myLocalPort;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PYDEV_COMMAND_PREFIX = "# pydev_util_command\n";
    @NotNull
    private static final String GET_CONSOLE_PROMPT_COUNT_COMMAND = "get_ipython().execution_count";
    @NotNull
    private static final String DONT_WRITE_BYTECODE;

    public JupyterDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull JupyterDebugProcessHandler jupyterDebugProcessHandler, @NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterDebugProcessHandler), (String)"jupyterDebugProcessHandler");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        super(session, serverSocket, executionConsole, (ProcessHandler)jupyterDebugProcessHandler, false);
        this.cellPointer = cellPointer;
        this.notebookFile = notebookFile;
        this.latestExecutedCell = this.cellPointer;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.myEnvironmentUpdater = PythonEnvironmentStateManagersStore.Companion.getInstance(project).getEnvironmentStateManager(this.notebookFile);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.myPositionConverter = (PyPositionConverter)new JupyterPositionConverter(project2);
        this.myLocalPort = serverSocket.getLocalPort();
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @NotNull
    public final NotebookIntervalPointer getLatestExecutedCell() {
        return this.latestExecutedCell;
    }

    public final void setLatestExecutedCell(@NotNull NotebookIntervalPointer notebookIntervalPointer) {
        Intrinsics.checkNotNullParameter((Object)notebookIntervalPointer, (String)"<set-?>");
        this.latestExecutedCell = notebookIntervalPointer;
    }

    public final void connect(@NotNull BackedNotebookVirtualFile notebookVirtualFile, @NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        int portToConnect = this.myLocalPort;
        JupyterTaskPurpose jupyterTaskPurpose = JupyterTaskPurpose.SERVICE;
        JupyterTaskPriority jupyterTaskPriority = JupyterTaskPriority.Companion.getHIGH();
        JupyterKernelTask.Options jupyterTaskOption = new JupyterKernelTask.Options(jupyterTaskPurpose, jupyterTaskPriority, cellPointer, false, false, true, true, null, 128, null);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterExecutionManager executor = JupyterExecutionManager.Companion.getInstance(project, notebookVirtualFile);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ExecutorService executorService = JupyterDebugSessionManager.Companion.getInstance(project2).getExecutorService();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.forProject(this.getProject())), (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, portToConnect, executor, jupyterTaskOption, null){
            Object L$0;
            int label;
            final /* synthetic */ JupyterDebugProcess this$0;
            final /* synthetic */ int $portToConnect;
            final /* synthetic */ JupyterExecutionManager $executor;
            final /* synthetic */ JupyterKernelTask.Options $jupyterTaskOption;
            {
                this.this$0 = $receiver;
                this.$portToConnect = $portToConnect;
                this.$executor = $executor;
                this.$jupyterTaskOption = $jupyterTaskOption;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String codeToExec = JupyterDebugProcess.access$createPydevConnectionCommand(this.this$0, this.$portToConnect);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)codeToExec);
                        this.label = 1;
                        Object object2 = JupyterExecutionManagerExtensionsKt.submitAndWait((JupyterExecutionManager)this.$executor, (String)codeToExec, (JupyterKernelTask.Options)this.$jupyterTaskOption, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        String codeToExec = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    protected void afterConnect() {
        super.afterConnect();
        if (this.isConnected()) {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CompletableDeferred<JupyterTaskExecutorResult>>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ JupyterDebugProcess this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Project project = this.this$0.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            BackedNotebookVirtualFile backedNotebookVirtualFile = this.this$0.getNotebookFile();
                            XDebugSession xDebugSession = this.this$0.getSession();
                            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                            JupyterDebugCellTask task = new JupyterDebugCellTask(project, backedNotebookVirtualFile, xDebugSession, JupyterDebugProcess.access$getCellPointer$p(this.this$0));
                            Project project2 = this.this$0.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)((Object)task));
                            this.label = 1;
                            Object object2 = JupyterExecutionManager.Companion.getInstance(project2, this.this$0.getNotebookFile()).submitTask((JupyterExecutionTask)task, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            JupyterDebugCellTask task = (JupyterDebugCellTask)((Object)this.L$0);
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super CompletableDeferred<JupyterTaskExecutorResult>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame frame) {
        XValueChildrenList frameVariables;
        block0: {
            frameVariables = super.loadFrame(frame);
            PythonNotebookEnvironmentStateManager pythonNotebookEnvironmentStateManager = this.myEnvironmentUpdater;
            if (pythonNotebookEnvironmentStateManager == null) break block0;
            pythonNotebookEnvironmentStateManager.updateDebugEnvironmentState((PyFrameAccessor)this, frameVariables);
        }
        return frameVariables;
    }

    public final void executeAfterCell() {
        block0: {
            ProcessHandler processHandler = this.doGetProcessHandler();
            if (processHandler == null) break block0;
            processHandler.destroyProcess();
        }
    }

    public boolean isSimplifiedView() {
        return PyDebuggerSettings.getInstance().isSimplifiedView();
    }

    public void sessionInitialized() {
        boolean bl = PyDebuggerOptionsProvider.getInstance((Project)this.getProject()).isRunDebuggerInServerMode() && Registry.Companion.is("python.debug.use.single.port");
        if (bl) {
            this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
        } else {
            super.sessionInitialized();
        }
    }

    public void showWarning(@Nullable String warningId) {
        super.showWarning(warningId);
        if (Intrinsics.areEqual((Object)warningId, (Object)"jupyter")) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JupyterDebugProcess.Companion.showCellEditedBetweenSessions(project);
        }
    }

    @Nullable
    public final Integer getConsolePromptCount() {
        Integer result2 = null;
        try {
            String string = this.evaluate(GET_CONSOLE_PROMPT_COUNT_COMMAND, false, false).getValue();
            result2 = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        return result2;
    }

    private final String createPydevConnectionCommand(int portToConnect) {
        StringBuilder command = new StringBuilder();
        if (LOG.isDebugEnabled()) {
            command.append("import os\n");
            command.append("os.environ['PYCHARM_DEBUG'] = 'True'\n");
        }
        command.append(StringsKt.trimMargin$default((String)("\n        |import pydev_jupyter_utils\n        |pydev_jupyter_utils.attach_to_debugger(" + portToConnect + ")\n        |"), null, (int)1, null));
        String string = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ String access$createPydevConnectionCommand(JupyterDebugProcess $this, int portToConnect) {
        return $this.createPydevConnectionCommand(portToConnect);
    }

    public static final /* synthetic */ NotebookIntervalPointer access$getCellPointer$p(JupyterDebugProcess $this) {
        return $this.cellPointer;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DONT_WRITE_BYTECODE = "def do_not_write_bytecode():\n  import sys;\n  sys.dont_write_bytecode = True\ndo_not_write_bytecode()\ndel do_not_write_bytecode\n";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PYDEV_COMMAND_PREFIX", "", "GET_CONSOLE_PROMPT_COUNT_COMMAND", "DONT_WRITE_BYTECODE", "getDONT_WRITE_BYTECODE", "()Ljava/lang/String;", "showCellEditedBetweenSessions", "", "project", "Lcom/intellij/openapi/project/Project;", "showCellEditedDuringSession", "enableTracingCommand", "disableTracingCommand", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final String getDONT_WRITE_BYTECODE() {
            return DONT_WRITE_BYTECODE;
        }

        private final void showCellEditedBetweenSessions(Project project) {
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.warning", (Object[])new Object[0]), NotificationType.WARNING).setDisplayId("jupyter.cell.edited.between.sessions").notify(project);
        }

        public final void showCellEditedDuringSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.error", (Object[])new Object[0]), NotificationType.ERROR).setDisplayId("jupyter.cell.edited.during.sessions").notify(project);
        }

        @NotNull
        public final String enableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(this.getDONT_WRITE_BYTECODE());
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.enable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String disableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(this.getDONT_WRITE_BYTECODE());
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.disable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

