/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.MemberFilterVisitorKt;
import com.intellij.javascript.debugger.MyMemberFilter;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.VariablesAndExpressionsCollector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/MemberFilterVisitor;", "Lorg/jetbrains/debugger/PsiVisitors$Visitor;", "Lorg/jetbrains/debugger/MemberFilter;", "viewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "callFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;Lorg/jetbrains/debugger/frame/CallFrameView;)V", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "compute", "Lorg/jetbrains/concurrency/Promise;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "defaultMemberFilterPromise", "doCompute", "visit", "element", "Lcom/intellij/psi/PsiElement;", "positionOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nMemberFilterVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberFilterVisitor.kt\ncom/intellij/javascript/debugger/MemberFilterVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n1#2:128\n14060#3,2:129\n*S KotlinDebug\n*F\n+ 1 MemberFilterVisitor.kt\ncom/intellij/javascript/debugger/MemberFilterVisitor\n*L\n81#1:129,2\n*E\n"})
public final class MemberFilterVisitor
implements PsiVisitors.Visitor<MemberFilter> {
    @NotNull
    private final JavaScriptDebuggerViewSupport viewSupport;
    @NotNull
    private final CallFrameView callFrameView;
    @Nullable
    private VirtualFile transpiledFile;

    public MemberFilterVisitor(@NotNull JavaScriptDebuggerViewSupport viewSupport, @NotNull CallFrameView callFrameView) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewSupport), (String)"viewSupport");
        Intrinsics.checkNotNullParameter((Object)callFrameView, (String)"callFrameView");
        this.viewSupport = viewSupport;
        this.callFrameView = callFrameView;
    }

    @NotNull
    public final Promise<MemberFilter> compute(@NotNull XSourcePosition position, @NotNull Promise<MemberFilter> defaultMemberFilterPromise) {
        SourceMap sourceMap;
        Script script;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(defaultMemberFilterPromise, (String)"defaultMemberFilterPromise");
        Script script2 = script = this.callFrameView.getScript();
        Object object = sourceMap = script2 != null ? script2.getSourceMap() : null;
        if (sourceMap != null && (sourceMap.getHasNameMappings() || Registry.Companion.is("js.debugger.map.this.by.source.code", false) || Registry.Companion.is("js.debugger.name.mappings.by.source.code"))) {
            Promise promise = MemberFilterVisitorKt.findTranspiledFile(script).thenAsync(arg_0 -> MemberFilterVisitor.compute$lambda$1(arg_0 -> MemberFilterVisitor.compute$lambda$0(this, position, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
            return promise;
        }
        Promise<MemberFilter> result2 = this.doCompute(position);
        return result2 == this.viewSupport ? defaultMemberFilterPromise : result2;
    }

    private final Promise<MemberFilter> doCompute(XSourcePosition position) {
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> MemberFilterVisitor.doCompute$lambda$0(position, this)).expireWith((Disposable)this.viewSupport.getDebugProcess()).submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return (Promise)cancellablePromise;
    }

    @NotNull
    public MemberFilter visit(@NotNull XSourcePosition position, @NotNull PsiElement element, int positionOffset, @NotNull Document document) {
        PsiElement psiElement;
        JSFunction jsFun;
        SourceMap sourceMap;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptNameMapper nameMapper = null;
        Script script = this.callFrameView.getScript();
        Object object = sourceMap = script != null ? script.getSourceMap() : null;
        if (sourceMap != null && this.transpiledFile != null) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            VirtualFile virtualFile = this.transpiledFile;
            Intrinsics.checkNotNull((Object)virtualFile);
            Document transpiledDocument = fileDocumentManager.getDocument(virtualFile);
            if (transpiledDocument != null && transpiledDocument.getTextLength() > 0) {
                CallFrame callFrame = this.callFrameView.getCallFrame();
                MappingEntry mappingEntry = sourceMap.getGeneratedMappings().get(callFrame.getLine(), callFrame.getColumn());
                if (mappingEntry != null) {
                    MappingEntry it = mappingEntry;
                    boolean bl = false;
                    nameMapper = new JavaScriptNameMapper(document, transpiledDocument, sourceMap.findSourceMappings(it.getSource()), sourceMap, this.transpiledFile);
                }
            }
        }
        for (Document debugAware : (Document)JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            MemberFilter memberFilter = debugAware.createMemberFilter((NameMapper)nameMapper, element, positionOffset);
            if (memberFilter == null) continue;
            MemberFilter it = memberFilter;
            boolean bl = false;
            return it;
        }
        JSFunction jSFunction = jsFun = MemberFilterVisitorKt.access$getParentFunction(element);
        if (jSFunction != null) {
            psiElement = (PsiElement)jSFunction;
        } else {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile != null) {
                psiElement = (PsiElement)psiFile;
            } else {
                return (MemberFilter)this.viewSupport;
            }
        }
        PsiElement host = psiElement;
        VariablesAndExpressionsCollector visitor2 = new VariablesAndExpressionsCollector(positionOffset, host, nameMapper, element);
        if (jsFun == null) {
            host.accept((PsiElementVisitor)visitor2);
        } else {
            NameMapper nameMapper2 = nameMapper;
            if (nameMapper2 != null) {
                NameMapper nameMapper3 = nameMapper2;
                boolean bl = false;
                JSParameter[] jSParameterArray = jsFun.getParameterVariables();
                Intrinsics.checkNotNullExpressionValue((Object)jSParameterArray, (String)"getParameterVariables(...)");
                Object[] $this$forEach$iv = jSParameterArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSParameter it = (JSParameter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    NameMapper.map$default((NameMapper)nameMapper3, (PsiElement)((PsiElement)it), (boolean)false, (int)2, null);
                }
            }
            JSBlockStatement jSBlockStatement = jsFun.getBlock();
            if (jSBlockStatement != null) {
                jSBlockStatement.accept((PsiElementVisitor)visitor2);
            }
        }
        Set<String> set = visitor2.getVariableDeclaredAfter();
        Collection<NavigatableVariableBackedPsiElement> collection = visitor2.getExpressions().values();
        Object object2 = nameMapper;
        if (object2 == null || (object2 = object2.getRawNameToSource()) == null) {
            object2 = MapsKt.emptyMap();
        }
        return (MemberFilter)new MyMemberFilter(set, collection, (Map<String, String>)object2, this.viewSupport.getDebugProcess());
    }

    private static final Promise compute$lambda$0(MemberFilterVisitor this$0, XSourcePosition $position, VirtualFile it) {
        this$0.transpiledFile = it;
        return this$0.doCompute($position);
    }

    private static final Promise compute$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final MemberFilter doCompute$lambda$0(XSourcePosition $position, MemberFilterVisitor this$0) {
        return (MemberFilter)PsiVisitors.visit((XSourcePosition)$position, (Project)this$0.viewSupport.getDebugProcess().getSession().getProject(), (Object)((Object)this$0.viewSupport), (PsiVisitors.Visitor)this$0);
    }
}

