/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.ConsolePrinterImpl;
import com.intellij.javascript.debugger.console.ConsolePrinterKt;
import com.intellij.javascript.debugger.console.ConsolePrinterSettings;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.WebConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphore;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphoreKt;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 C2\u00020\u0001:\u0007=>?@ABCB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020\rH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)H\u0002J@\u0010*\u001a\u00020+\"\u0004\b\u0000\u0010,2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u0002H,2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020100H\u0096@\u00a2\u0006\u0002\u00102JG\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\r2'\u00103\u001a#\b\u0001\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020+05\u0012\u0006\u0012\u0004\u0018\u00010604\u00a2\u0006\u0002\b7H\u0096@\u00a2\u0006\u0002\u00108J\u000e\u00109\u001a\u00020+H\u0096@\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020+H\u0016J\b\u0010<\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006D"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "settings", "Lcom/intellij/javascript/debugger/console/ConsolePrinterSettings;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/ConsolePrinterSettings;)V", "DEFAULT_FLUSH_DELAY", "", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "submissionChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Request;", "requestQueue", "Lkotlinx/coroutines/flow/Flow;", "flushSemaphore", "Lcom/intellij/platform/util/coroutines/sync/OverflowSemaphore;", "lastRender", "", "messageBuffer", "", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "workerJob", "Lkotlinx/coroutines/Job;", "messagePrinter", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "getMessagePrinter", "()Lcom/intellij/javascript/debugger/console/MessagePrinter;", "getConsoleView", "Lcom/intellij/javascript/debugger/console/WebConsoleView;", "notifyEdited", "createMessageBuilder", "vm", "Lorg/jetbrains/debugger/Vm;", "submitMessage", "", "T", "flushNow", "messageData", "messageFactory", "Lkotlin/Function1;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "(Lorg/jetbrains/debugger/Vm;ZLjava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/debugger/Vm;ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clear", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "stop", "Request", "MessageRequest", "ConsoleMessageRequest", "CustomMessageRequest", "ClearRequest", "FlushRequest", "Companion", "intellij.javascript.debugger.backend"})
public final class ConsolePrinterImpl
implements ConsolePrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ConsolePrinterSettings settings;
    private final int DEFAULT_FLUSH_DELAY;
    private volatile boolean enabled;
    @NotNull
    private final Channel<Request> submissionChannel;
    @NotNull
    private final Flow<Request> requestQueue;
    @NotNull
    private final OverflowSemaphore flushSemaphore;
    private long lastRender;
    @NotNull
    private List<ConsoleMessageBuilder> messageBuffer;
    @Nullable
    private Job workerJob;
    private static final int CONSOLE_PRINTER_BUFFER_SIZE = 2000;

    public ConsolePrinterImpl(@NotNull CoroutineScope coroutineScope, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull ConsolePrinterSettings settings) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.coroutineScope = coroutineScope;
        this.debugProcess = debugProcess;
        this.settings = settings;
        this.DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200);
        this.enabled = true;
        this.submissionChannel = ChannelKt.Channel$default((int)2000, (BufferOverflow)BufferOverflow.SUSPEND, null, (int)4, null);
        this.requestQueue = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submissionChannel));
        this.flushSemaphore = OverflowSemaphoreKt.OverflowSemaphore$default((int)0, (BufferOverflow)BufferOverflow.DROP_LATEST, (int)1, null);
        this.messageBuffer = new ArrayList();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private final MessagePrinter getMessagePrinter() {
        WebConsoleView webConsoleView = ConsolePrinterImpl.getConsoleView$default(this, false, 1, null);
        return webConsoleView != null ? webConsoleView.getPrinter$intellij_javascript_debugger_backend() : null;
    }

    private final WebConsoleView getConsoleView(boolean notifyEdited) {
        ConsoleView consoleView = this.debugProcess.getJSConsoleView(notifyEdited);
        return consoleView instanceof WebConsoleView ? (WebConsoleView)consoleView : null;
    }

    static /* synthetic */ WebConsoleView getConsoleView$default(ConsolePrinterImpl consolePrinterImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return consolePrinterImpl.getConsoleView(bl);
    }

    private final ConsoleMessageBuilder createMessageBuilder(Vm vm) {
        WebConsoleView webConsoleView = ConsolePrinterImpl.getConsoleView$default(this, false, 1, null);
        if (webConsoleView == null) {
            return null;
        }
        WebConsoleView consoleView = webConsoleView;
        MessagePrinter messagePrinter = consoleView.getPrinter$intellij_javascript_debugger_backend();
        return new WebConsoleMessageBuilder(this.debugProcess, vm, messagePrinter, consoleView.getDomPresentationProvider(), (Disposable)consoleView);
    }

    @Override
    @Nullable
    public <T> Object submitMessage(@NotNull Vm vm, boolean flushNow, T messageData, @NotNull Function1<? super T, ? extends ConsoleMessage> messageFactory, @NotNull Continuation<? super Unit> $completion) {
        if (!this.getEnabled()) {
            return Unit.INSTANCE;
        }
        Object object = this.submissionChannel.send(new ConsoleMessageRequest<T>(this, vm, flushNow, messageData, messageFactory), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object submitMessage(@NotNull Vm vm, boolean flushNow, @NotNull Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        if (!this.getEnabled()) {
            return Unit.INSTANCE;
        }
        Object object = this.submissionChannel.send((Object)new CustomMessageRequest(this, vm, flushNow, block), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object clear(@NotNull Continuation<? super Unit> $completion) {
        if (!this.getEnabled()) {
            return Unit.INSTANCE;
        }
        Object object = this.submissionChannel.send((Object)new ClearRequest(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void start() {
        if (!this.getEnabled()) {
            return;
        }
        this.workerJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("WebConsole message processor")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ ConsolePrinterImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ConsolePrinterKt.access$getLOG$p().info("Console printer worker coroutine started");
                        ConsolePrinterImpl.access$getMessageBuffer$p(this.this$0).clear();
                        prevReq = new Ref.ObjectRef();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)prevReq);
                        this.label = 1;
                        v0 = ConsolePrinterImpl.access$getRequestQueue$p(this.this$0).collect(new FlowCollector((Ref.ObjectRef<Request>)prevReq, this.this$0){
                            final /* synthetic */ Ref.ObjectRef<Request> $prevReq;
                            final /* synthetic */ ConsolePrinterImpl this$0;
                            {
                                this.$prevReq = $prevReq;
                                this.this$0 = $receiver;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object emit(Request currReq, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof start.emit.1)) ** GOTO lbl-1000
                                var5_3 = $completion;
                                if ((var5_3.label & -2147483648) != 0) {
                                    var5_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ start.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!(currReq instanceof FlushRequest)) {
                                            prev = (Request)this.$prevReq.element;
                                            if (prev != null && prev instanceof ConsoleMessageRequest && currReq instanceof ConsoleMessageRequest && ((Boolean)ConsolePrinterImpl.access$getSettings$p(this.this$0).getMessageDataEquals().invoke(((ConsoleMessageRequest)prev).getMessageData(), ((ConsoleMessageRequest)currReq).getMessageData())).booleanValue()) {
                                                ((ConsoleMessageRequest)currReq).markDuplicated();
                                            }
                                            this.$prevReq.element = currReq;
                                        }
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)currReq);
                                        $continuation.label = 1;
                                        v0 = currReq.execute((Continuation<? super Unit>)$continuation);
                                        ** if (v0 != var6_5) goto lbl24
lbl23:
                                        // 1 sources

                                        return var6_5;
lbl24:
                                        // 1 sources

                                        ** GOTO lbl36
                                    }
                                    case 1: {
                                        currReq = (Request)$continuation.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                        }
                                        catch (CancellationException ce) {
                                            throw ce;
                                        }
                                        catch (Exception e) {
                                            ConsolePrinterKt.access$getLOG$p().warn((Throwable)e);
                                        }
lbl36:
                                        // 3 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        prevReq = (Ref.ObjectRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        ConsolePrinterKt.access$getLOG$p().info("Console printer worker coroutine finished");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void stop() {
        block1: {
            if (!this.getEnabled()) {
                return;
            }
            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.submissionChannel), null, (int)1, null);
            Job job = this.workerJob;
            if (job == null) break block1;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    public static final /* synthetic */ Flow access$getRequestQueue$p(ConsolePrinterImpl $this) {
        return $this.requestQueue;
    }

    public static final /* synthetic */ ConsolePrinterSettings access$getSettings$p(ConsolePrinterImpl $this) {
        return $this.settings;
    }

    public static final /* synthetic */ ConsoleMessageBuilder access$createMessageBuilder(ConsolePrinterImpl $this, Vm vm) {
        return $this.createMessageBuilder(vm);
    }

    public static final /* synthetic */ long access$getLastRender$p(ConsolePrinterImpl $this) {
        return $this.lastRender;
    }

    public static final /* synthetic */ int access$getDEFAULT_FLUSH_DELAY$p(ConsolePrinterImpl $this) {
        return $this.DEFAULT_FLUSH_DELAY;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(ConsolePrinterImpl $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ OverflowSemaphore access$getFlushSemaphore$p(ConsolePrinterImpl $this) {
        return $this.flushSemaphore;
    }

    public static final /* synthetic */ Channel access$getSubmissionChannel$p(ConsolePrinterImpl $this) {
        return $this.submissionChannel;
    }

    public static final /* synthetic */ MessagePrinter access$getMessagePrinter(ConsolePrinterImpl $this) {
        return $this.getMessagePrinter();
    }

    public static final /* synthetic */ void access$setMessageBuffer$p(ConsolePrinterImpl $this, List list) {
        $this.messageBuffer = list;
    }

    public static final /* synthetic */ void access$setLastRender$p(ConsolePrinterImpl $this, long l) {
        $this.lastRender = l;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$ClearRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Request;", "<init>", "(Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;)V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.debugger.backend"})
    private final class ClearRequest
    implements Request {
        @Override
        @Nullable
        public Object execute(@NotNull Continuation<? super Unit> $completion) {
            ConsolePrinterImpl.this.messageBuffer.clear();
            WebConsoleView webConsoleView = ConsolePrinterImpl.this.getConsoleView(true);
            if (webConsoleView != null) {
                webConsoleView.doClear$intellij_javascript_debugger_backend();
            }
            Object object = ConsolePrinterImpl.this.debugProcess.consoleCleared($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Companion;", "", "<init>", "()V", "CONSOLE_PRINTER_BUFFER_SIZE", "", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002R\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0013R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$ConsoleMessageRequest;", "T", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$MessageRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;", "vm", "Lorg/jetbrains/debugger/Vm;", "flushNow", "", "messageData", "messageFactory", "Lkotlin/Function1;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "<init>", "(Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;Lorg/jetbrains/debugger/Vm;ZLjava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "getMessageData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "isDuplicate", "buildMessage", "", "messageBuilder", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "(Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markDuplicated", "intellij.javascript.debugger.backend"})
    private final class ConsoleMessageRequest<T>
    extends MessageRequest {
        private final T messageData;
        @NotNull
        private final Function1<T, ConsoleMessage> messageFactory;
        private boolean isDuplicate;
        final /* synthetic */ ConsolePrinterImpl this$0;

        public ConsoleMessageRequest(@NotNull ConsolePrinterImpl this$0, Vm vm, boolean flushNow, @NotNull T messageData, Function1<? super T, ? extends ConsoleMessage> messageFactory) {
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            Intrinsics.checkNotNullParameter(messageFactory, (String)"messageFactory");
            this.this$0 = this$0;
            super(this$0, vm, flushNow);
            this.messageData = messageData;
            this.messageFactory = messageFactory;
        }

        public /* synthetic */ ConsoleMessageRequest(ConsolePrinterImpl consolePrinterImpl, Vm vm, boolean bl, Object object, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consolePrinterImpl, vm, bl, object, function1);
        }

        public final T getMessageData() {
            return this.messageData;
        }

        @Override
        @Nullable
        public Object buildMessage(@NotNull ConsoleMessageBuilder messageBuilder, @NotNull Continuation<? super Unit> $completion) {
            if (this.isDuplicate) {
                messageBuilder.increaseLastMessageRepeatCount();
            } else {
                ((ConsoleMessage)this.messageFactory.invoke(this.messageData)).print(messageBuilder);
            }
            return Unit.INSTANCE;
        }

        public final void markDuplicated() {
            this.isDuplicate = true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002BB\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u00a2\u0006\u0002\b\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0013R1\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$CustomMessageRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$MessageRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;", "vm", "Lorg/jetbrains/debugger/Vm;", "flushNow", "", "block", "Lkotlin/Function2;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "Lkotlin/coroutines/Continuation;", "", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;Lorg/jetbrains/debugger/Vm;ZLkotlin/jvm/functions/Function2;)V", "Lkotlin/jvm/functions/Function2;", "buildMessage", "messageBuilder", "(Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.debugger.backend"})
    private final class CustomMessageRequest
    extends MessageRequest {
        @NotNull
        private final Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object> block;
        final /* synthetic */ ConsolePrinterImpl this$0;

        public CustomMessageRequest(@NotNull ConsolePrinterImpl this$0, Vm vm, @NotNull boolean flushNow, Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object> block) {
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this.this$0 = this$0;
            super(this$0, vm, flushNow);
            this.block = block;
        }

        public /* synthetic */ CustomMessageRequest(ConsolePrinterImpl consolePrinterImpl, Vm vm, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consolePrinterImpl, vm, bl, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)function2);
        }

        @Override
        @Nullable
        public Object buildMessage(@NotNull ConsoleMessageBuilder messageBuilder, @NotNull Continuation<? super Unit> $completion) {
            Object object = this.block.invoke((Object)messageBuilder, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$FlushRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Request;", "<init>", "(Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;)V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.debugger.backend"})
    private final class FlushRequest
    implements Request {
        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object execute(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ FlushRequest this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    ConsolePrinterKt.access$getLOG$p().debug("Executing flush request (buffer size " + ConsolePrinterImpl.access$getMessageBuffer$p(ConsolePrinterImpl.this).size() + ")");
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ConsolePrinterImpl.this, null){
                        int label;
                        final /* synthetic */ ConsolePrinterImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    MessagePrinter printer = ConsolePrinterImpl.access$getMessagePrinter(this.this$0);
                                    if (printer != null) {
                                        List bufferToFlush = ConsolePrinterImpl.access$getMessageBuffer$p(this.this$0);
                                        ConsolePrinterImpl.access$setMessageBuffer$p(this.this$0, new ArrayList<E>());
                                        printer.runInBatch((Function0<Unit>)((Function0)() -> execute.2.invokeSuspend$lambda$0(bufferToFlush)));
                                    } else {
                                        ConsolePrinterKt.access$getLOG$p().warn("FlushRequest executed before console was initialized");
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(List $bufferToFlush) {
                            ConsolePrinterKt.access$getLOG$p().debug("Flushing message buffer (buffer size " + $bufferToFlush.size() + ")");
                            Iterable $this$forEach$iv = $bufferToFlush;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ConsoleMessageBuilder it = (ConsoleMessageBuilder)element$iv;
                                boolean bl = false;
                                it.flush();
                            }
                            ConsolePrinterKt.access$getLOG$p().debug("Flushing completed");
                            return Unit.INSTANCE;
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl21
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl21:
                    // 2 sources

                    ConsolePrinterImpl.access$setLastRender$p(ConsolePrinterImpl.this, System.currentTimeMillis());
                    ConsolePrinterKt.access$getLOG$p().debug("Flush request executed");
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u00a6@\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$MessageRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Request;", "vm", "Lorg/jetbrains/debugger/Vm;", "flushNow", "", "<init>", "(Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl;Lorg/jetbrains/debugger/Vm;Z)V", "buildMessage", "", "messageBuilder", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "(Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.debugger.backend"})
    private abstract non-sealed class MessageRequest
    implements Request {
        @NotNull
        private final Vm vm;
        private final boolean flushNow;
        final /* synthetic */ ConsolePrinterImpl this$0;

        public MessageRequest(@NotNull ConsolePrinterImpl this$0, Vm vm, boolean flushNow) {
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            this.this$0 = this$0;
            this.vm = vm;
            this.flushNow = flushNow;
        }

        public /* synthetic */ MessageRequest(ConsolePrinterImpl consolePrinterImpl, Vm vm, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consolePrinterImpl, vm, bl);
        }

        @Nullable
        public abstract Object buildMessage(@NotNull ConsoleMessageBuilder var1, @NotNull Continuation<? super Unit> var2);

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public final Object execute(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MessageRequest this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    messageBuilder = ConsolePrinterImpl.access$createMessageBuilder(this.this$0, this.vm);
                    if (messageBuilder == null) {
                        ConsolePrinterKt.access$getLOG$p().warn("Message flushed before console was initialized");
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = messageBuilder;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, messageBuilder, null){
                        int label;
                        final /* synthetic */ MessageRequest this$0;
                        final /* synthetic */ ConsoleMessageBuilder $messageBuilder;
                        {
                            this.this$0 = $receiver;
                            this.$messageBuilder = $messageBuilder;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.this$0.buildMessage(this.$messageBuilder, (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    messageBuilder = (ConsoleMessageBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    ((Collection)ConsolePrinterImpl.access$getMessageBuffer$p(this.this$0)).add(messageBuilder);
                    now = System.currentTimeMillis();
                    nextRenderDelay = this.flushNow != false ? 0L : RangesKt.coerceAtLeast((long)(ConsolePrinterImpl.access$getLastRender$p(this.this$0) + (long)ConsolePrinterImpl.access$getDEFAULT_FLUSH_DELAY$p(this.this$0) - now), (long)0L);
                    BuildersKt.launch$default((CoroutineScope)ConsolePrinterImpl.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, nextRenderDelay, null){
                        int label;
                        final /* synthetic */ ConsolePrinterImpl this$0;
                        final /* synthetic */ long $nextRenderDelay;
                        {
                            this.this$0 = $receiver;
                            this.$nextRenderDelay = $nextRenderDelay;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = ConsolePrinterImpl.access$getFlushSemaphore$p(this.this$0).withPermit((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$nextRenderDelay, this.this$0, null){
                                        int label;
                                        final /* synthetic */ long $nextRenderDelay;
                                        final /* synthetic */ ConsolePrinterImpl this$0;
                                        {
                                            this.$nextRenderDelay = $nextRenderDelay;
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    v0 = DelayKt.delay((long)this.$nextRenderDelay, (Continuation)((Continuation)this));
                                                    if (v0 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl13
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl13:
                                                    // 2 sources

                                                    this.label = 2;
                                                    v1 = ConsolePrinterImpl.access$getSubmissionChannel$p(this.this$0).send((Object)this.this$0.new FlushRequest(), (Continuation)this);
                                                    if (v1 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl21
                                                }
                                                case 2: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl21:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\u00020\u0003H\u00a6@\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$Request;", "", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$ClearRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$FlushRequest;", "Lcom/intellij/javascript/debugger/console/ConsolePrinterImpl$MessageRequest;", "intellij.javascript.debugger.backend"})
    private static sealed interface Request
    permits ClearRequest, FlushRequest, MessageRequest {
        @Nullable
        public Object execute(@NotNull Continuation<? super Unit> var1);
    }
}

