/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipStyleSheet;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.css.RuleUsageValue;
import org.jetbrains.wip.protocol.profiler.CoverageRangeValue;
import org.jetbrains.wip.protocol.profiler.FunctionCoverageValue;
import org.jetbrains.wip.protocol.profiler.ScriptCoverageValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001HB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00170\bJ\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\bH\u0002JL\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\b0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0012\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002JV\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001a2\u0014\u0010*\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010\u001e0+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u001eH\u0002J&\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020(H\u0002J5\u00102\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a042\u0006\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010(H\u0002\u00a2\u0006\u0002\u00108J\u001e\u00109\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a042\u0006\u0010:\u001a\u00020\u001aH\u0002J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u0019H\u0002J&\u0010>\u001a\u00020.2\u0006\u0010'\u001a\u00020(2\u0006\u00107\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J4\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\b2\u0006\u0010,\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0\b2\u0006\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020(H\u0002J#\u0010D\u001a\u0004\u0018\u00010(2\b\u0010E\u001a\u0004\u0018\u00010(2\b\u0010F\u001a\u0004\u0018\u00010(H\u0002\u00a2\u0006\u0002\u0010GR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cssExtensions", "", "", "convertCoverageFormat", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport;", "jsDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "coverageResult", "Lorg/jetbrains/wip/protocol/profiler/ScriptCoverageValue;", "supportedExtension", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertCssCoverageFormat", "Lorg/jetbrains/wip/protocol/css/RuleUsageValue;", "convertCssDataToSegments", "", "Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "rules", "mapCoverage", "", "Lcom/intellij/openapi/editor/Document;", "generatedSegments", "generatedDocument", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "findNextValidMapping", "Lkotlin/Pair;", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mapping", "offset", "", "segment", "nullableSourcesCache", "", "document", "convertSegmentsOffsets", "", "segments", "scriptFile", "scriptStartOffset", "insertSegment", "sourceSegments", "Ljava/util/TreeSet;", "startOffsetInclusive", "endOffsetExclusive", "count", "(Ljava/util/TreeSet;IILjava/lang/Integer;)V", "merge", "endSegment", "convertToDisjointSegments", "ranges", "Lorg/jetbrains/wip/protocol/profiler/CoverageRangeValue;", "append", "result", "computeLines", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport$LineHits;", "scriptStartLine", "scriptEndLine", "nullableMax", "a", "b", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;", "CoverageSegment", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nWipCoverageReportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipCoverageReportProcessor.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n1807#2,3:412\n1512#2:415\n1538#2,3:416\n1541#2,3:426\n1266#2,4:441\n383#3,7:419\n383#3,7:432\n415#3:440\n14125#4,3:429\n1#5:439\n*S KotlinDebug\n*F\n+ 1 WipCoverageReportProcessor.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor\n*L\n99#1:412,3\n109#1:415\n109#1:416,3\n109#1:426,3\n219#1:441,4\n109#1:419,7\n200#1:432,7\n219#1:440\n181#1:429,3\n*E\n"})
public final class WipCoverageReportProcessor {
    @NotNull
    public static final WipCoverageReportProcessor INSTANCE = new WipCoverageReportProcessor();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> cssExtensions;

    private WipCoverageReportProcessor() {
    }

    @NotNull
    public final Promise<LcovCoverageReport> convertCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends ScriptCoverageValue> coverageResult) {
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        Vm vm = jsDebugProcess.getMainVm();
        Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipVm");
        WipVm vm2 = (WipVm)vm;
        LcovCoverageReport lcov = new LcovCoverageReport();
        List promises = new ArrayList();
        for (ScriptCoverageValue scriptCoverageValue : coverageResult) {
            WipScript wipScript = (WipScript)vm2.getScriptManager().findScriptById(scriptCoverageValue.scriptId());
            if (wipScript == null) continue;
            Promise<VirtualFile> promise = VmScriptFileSystemKt.getVmFile((Script)wipScript).ensureDownloaded();
            promise.onSuccess(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$1(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$0(scriptCoverageValue, wipScript, jsDebugProcess, lcov, arg_0), arg_0));
            promises.add(promise);
        }
        Promise promise = Promises.all((Collection)promises, null, (boolean)true).then(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$2(new Function1(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;
            {
                this.$lcov = $lcov;
            }

            public final LcovCoverageReport invoke(Void it) {
                return this.$lcov;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final boolean supportedExtension(VirtualFile file) {
        boolean bl;
        block3: {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path = string;
            Iterable $this$any$iv = cssExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<LcovCoverageReport> convertCssCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends RuleUsageValue> coverageResult) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        LcovCoverageReport lcov = new LcovCoverageReport();
        List promises = new ArrayList();
        Iterable $this$groupBy$iv = coverageResult;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            RuleUsageValue p0 = (RuleUsageValue)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = p0.styleSheetId();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            VirtualFile file;
            String styleSheetId = (String)entry.getKey();
            List rules = (List)entry.getValue();
            WipStyleSheet styleSheet = ((ChromeDebugProcess)jsDebugProcess).getCssManager().getIdToStyleSheet().get(styleSheetId);
            if (styleSheet == null) continue;
            VirtualFile virtualFile = file = JavaScriptDebugProcess.findFile$default(jsDebugProcess, styleSheet.getUrl(), false, null, 4, null);
            Promise promise = virtualFile == null ? Promises.rejectedPromise() : Promises.resolvedPromise((Object)virtualFile);
            promise.onSuccess(arg_0 -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$1(arg_0 -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$0(rules, styleSheet, jsDebugProcess, lcov, arg_0), arg_0));
            promises.add(promise);
        }
        Promise promise = Promises.all((Collection)promises, null, (boolean)true).then(arg_0 -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$2(new Function1(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;
            {
                this.$lcov = $lcov;
            }

            public final LcovCoverageReport invoke(Void it) {
                return this.$lcov;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final List<CoverageSegment> convertCssDataToSegments(List<? extends RuleUsageValue> rules) {
        List<Object> list = rules.stream().flatMap(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$1(WipCoverageReportProcessor::convertCssDataToSegments$lambda$0, arg_0)).sorted(Comparator.comparing(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$2((Function1)convertCssDataToSegments.segments.2.INSTANCE, arg_0))).filter(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$4(WipCoverageReportProcessor::convertCssDataToSegments$lambda$3, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        List segments2 = CollectionsKt.toMutableList((Collection)list);
        return segments2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Document, List<CoverageSegment>> mapCoverage(List<CoverageSegment> generatedSegments, Document generatedDocument, SourceMap sourceMap, JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess) {
        void $this$associateByTo$iv$iv;
        void $this$mapValuesTo$iv;
        Map.Entry it;
        Object object;
        Object object2;
        String string;
        int currentOffset = 0;
        Map coverageMap = new LinkedHashMap();
        Map nullableSourcesCache = new LinkedHashMap();
        Url[] $this$forEachIndexed$iv = sourceMap.getSources();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Url item$iv : $this$forEachIndexed$iv) {
            Document document;
            void url;
            int n = index$iv++;
            Url url2 = item$iv;
            int i = n;
            boolean bl = false;
            Map map = nullableSourcesCache;
            Integer n2 = i;
            if (JavaScriptDebugProcess.findFile$default(jsDebugProcess, (Url)url, false, null, 4, null) != null) {
                VirtualFile it2;
                boolean bl2 = false;
                document = FileDocumentManager.getInstance().getDocument(it2);
            } else {
                document = null;
            }
            Document document2 = document;
            map.put(n2, document2);
        }
        for (CoverageSegment segment : generatedSegments) {
            block15: {
                Object mapping = null;
                try {
                    Pair<Document, MappingEntry> nextMapping;
                    do {
                        if ((nextMapping = this.findNextValidMapping((MappingEntry)mapping, currentOffset, segment, nullableSourcesCache, sourceMap, generatedDocument)) != null) {
                            Object object3;
                            void $this$getOrPut$iv;
                            Pair<Document, MappingEntry> it3;
                            boolean bl = false;
                            MappingEntry sourceDocument = (Document)it3.getFirst();
                            Object object4 = mapping = it3.getSecond();
                            Intrinsics.checkNotNull((Object)object4);
                            MappingEntry currentMapping = (MappingEntry)object4;
                            currentOffset = generatedDocument.getLineStartOffset(currentMapping.getGeneratedLine()) + currentMapping.getGeneratedColumn();
                            Mappings mappings = sourceMap.findSourceMappings(currentMapping.getSource());
                            Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                            MappingList mappings2 = (MappingList)mappings;
                            Map map = coverageMap;
                            MappingEntry key$iv = sourceDocument;
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl3 = false;
                                TreeSet answer$iv = new TreeSet(new Comparator(){

                                    public final int compare(T a, T b2) {
                                        CoverageSegment p0 = (CoverageSegment)a;
                                        boolean bl = false;
                                        Comparable comparable = Integer.valueOf(p0.getEndOffsetExclusive());
                                        p0 = (CoverageSegment)b2;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getEndOffsetExclusive()));
                                    }
                                });
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object3 = answer$iv;
                            } else {
                                object3 = value$iv;
                            }
                            TreeSet sourceSegments = (TreeSet)object3;
                            int lineStartOffset = sourceDocument.getLineStartOffset(mappings2.getLine(currentMapping));
                            int sourceEndOffset = mappings2.getEndOffset(currentMapping, lineStartOffset, (Document)sourceDocument);
                            if (sourceEndOffset == sourceDocument.getLineEndOffset(mappings2.getLine(currentMapping))) {
                                ++sourceEndOffset;
                            }
                            INSTANCE.insertSegment(sourceSegments, lineStartOffset + mappings2.getColumn(currentMapping), sourceEndOffset, segment.getCount());
                        }
                    } while (nextMapping != null && currentOffset < segment.getEndOffsetExclusive());
                }
                catch (IndexOutOfBoundsException e) {
                    MappingEntry it4;
                    Url url;
                    Logger logger = LOG;
                    String string2 = e.getMessage();
                    if ((MappingEntry)mapping != null) {
                        string = string2;
                        object2 = logger;
                        boolean bl = false;
                        Url[] urlArray = sourceMap.getSources();
                        Object object5 = mapping;
                        Intrinsics.checkNotNull(object5);
                        object = urlArray[((MappingEntry)object5).getSource()];
                        logger = object2;
                        string2 = string;
                        url = object;
                    } else {
                        url = null;
                    }
                    logger.debug(string2 + "\nurl: " + url + ", segment: " + segment);
                    if ((MappingEntry)mapping == null) break block15;
                    boolean bl = false;
                    if ((Document)nullableSourcesCache.get(it4.getSource()) != null) {
                        boolean bl4 = false;
                        TreeSet cfr_ignored_0 = (TreeSet)coverageMap.remove(it);
                    }
                }
            }
            currentOffset = segment.getEndOffsetExclusive();
        }
        Map result2 = new LinkedHashMap();
        Map segment = coverageMap;
        Map destination$iv = result2;
        boolean $i$f$mapValuesTo = false;
        Iterable e = $this$mapValuesTo$iv.entrySet();
        Map destination$iv$iv = destination$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            it = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            string = it$iv.getKey();
            object2 = map;
            boolean bl5 = false;
            TreeSet segments2 = (TreeSet)entry.getValue();
            object = new ArrayList(segments2);
            object2.put(string, object);
        }
        return result2;
    }

    private final Pair<Document, MappingEntry> findNextValidMapping(MappingEntry mapping, int offset, CoverageSegment segment, Map<Integer, Document> nullableSourcesCache, SourceMap sourceMap, Document document) {
        Pair pair;
        int currentOffset = offset;
        MappingEntry nextMapping = mapping;
        Document sourceDocument = null;
        while (sourceDocument == null && currentOffset < segment.getEndOffsetExclusive()) {
            if (nextMapping == null) {
                int generatedLine = document.getLineNumber(currentOffset);
                int generatedColumn = currentOffset - document.getLineStartOffset(generatedLine);
                nextMapping = sourceMap.getGeneratedMappings().get(generatedLine, generatedColumn);
                if (nextMapping == null) {
                    if (currentOffset + 1 >= segment.getEndOffsetExclusive()) break;
                    ++currentOffset;
                }
            } else {
                if (nextMapping.getNextGenerated() == null) break;
                currentOffset = document.getLineStartOffset(nextMapping.getGeneratedLine()) + nextMapping.getGeneratedColumn();
            }
            if (nextMapping == null || nextMapping.getSourceLine() < 0 || currentOffset >= segment.getEndOffsetExclusive()) continue;
            sourceDocument = nullableSourcesCache.get(nextMapping.getSource());
        }
        if (sourceDocument == null) {
            pair = null;
        } else {
            MappingEntry mappingEntry = nextMapping;
            Intrinsics.checkNotNull((Object)mappingEntry);
            pair = new Pair(sourceDocument, (Object)mappingEntry);
        }
        return pair;
    }

    private final void convertSegmentsOffsets(List<CoverageSegment> segments2, VirtualFile scriptFile, int scriptStartOffset) {
        FileOffsetsManager fileOffsetsManager = FileOffsetsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileOffsetsManager, (String)"getInstance(...)");
        FileOffsetsManager offsetManager = fileOffsetsManager;
        for (CoverageSegment segment : segments2) {
            segment.setEndOffsetExclusive(scriptFile instanceof LightVirtualFile ? scriptStartOffset + segment.getEndOffsetExclusive() : offsetManager.getConvertedOffset(scriptFile, scriptStartOffset + segment.getEndOffsetExclusive()));
        }
    }

    private final void insertSegment(TreeSet<CoverageSegment> sourceSegments, int startOffsetInclusive, int endOffsetExclusive, Integer count) {
        CoverageSegment segment;
        CoverageSegment coverageSegment = segment = sourceSegments.higher(new CoverageSegment(startOffsetInclusive, null));
        CoverageSegment startSegment = new CoverageSegment(startOffsetInclusive, coverageSegment != null ? coverageSegment.getCount() : null);
        CoverageSegment endSegment = new CoverageSegment(endOffsetExclusive, count);
        if (segment == null) {
            if (startOffsetInclusive != 0 && !sourceSegments.contains(startSegment)) {
                sourceSegments.add(startSegment);
            }
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
            return;
        }
        if (startOffsetInclusive != 0 && Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count)) && !sourceSegments.contains(startSegment)) {
            sourceSegments.add(startSegment);
        }
        if (segment.getEndOffsetExclusive() == endOffsetExclusive) {
            segment.setCount(this.nullableMax(segment.getCount(), count));
            this.merge(sourceSegments, segment);
        } else if (Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count))) {
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
        }
    }

    private final void merge(TreeSet<CoverageSegment> sourceSegments, CoverageSegment endSegment) {
        CoverageSegment prev = sourceSegments.lower(endSegment);
        CoverageSegment current = sourceSegments.floor(endSegment);
        CoverageSegment coverageSegment = prev;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment != null ? coverageSegment.getCount() : null)) && prev != null) {
            sourceSegments.remove(prev);
        }
        CoverageSegment next = sourceSegments.higher(endSegment);
        CoverageSegment coverageSegment2 = next;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment2 != null ? coverageSegment2.getCount() : null))) {
            sourceSegments.remove(current);
        }
    }

    private final List<CoverageSegment> convertToDisjointSegments(List<CoverageRangeValue> ranges) {
        Function1[] function1Array = new Function1[]{WipCoverageReportProcessor::convertToDisjointSegments$lambda$0, WipCoverageReportProcessor::convertToDisjointSegments$lambda$1};
        CollectionsKt.sortWith(ranges, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        List result2 = new ArrayList();
        LinkedList<CoverageRangeValue> stack = new LinkedList<CoverageRangeValue>();
        for (CoverageRangeValue entry : ranges) {
            CoverageRangeValue top = (CoverageRangeValue)stack.peek();
            while (top != null && top.getEndOffset() <= entry.getStartOffset()) {
                this.append(top.getEndOffset() + 1, top.getCount(), result2);
                stack.pop();
                top = (CoverageRangeValue)stack.peek();
            }
            if (top != null) {
                this.append(entry.getStartOffset(), top.getCount(), result2);
            }
            stack.push(entry);
        }
        while (!stack.isEmpty()) {
            CoverageRangeValue top = (CoverageRangeValue)stack.pop();
            this.append(top.getEndOffset() + 1, top.getCount(), result2);
        }
        return result2;
    }

    private final void append(int offset, int count, List<CoverageSegment> result2) {
        if (!((Collection)result2).isEmpty()) {
            CoverageSegment last = (CoverageSegment)CollectionsKt.last(result2);
            if (last.getEndOffsetExclusive() == offset) {
                return;
            }
            Integer n = last.getCount();
            int n2 = count;
            if (n != null && n == n2) {
                last.setEndOffsetExclusive(offset);
                return;
            }
        }
        result2.add(new CoverageSegment(offset, count));
    }

    private final List<LcovCoverageReport.LineHits> computeLines(Document document, List<CoverageSegment> segments2, int scriptStartLine, int scriptEndLine) {
        List lines = new ArrayList(scriptEndLine - scriptStartLine);
        int currentLine = scriptStartLine;
        ListIterator<CoverageSegment> listIterator = segments2.listIterator();
        CoverageSegment segment = null;
        while (listIterator.hasNext()) {
            segment = listIterator.next();
            int inclusiveEnd = segment.getEndOffsetExclusive() - 1;
            int segmentEndLine = document.getLineNumber(inclusiveEnd);
            if (segment.getCount() != null) {
                for (int line = currentLine; line < segmentEndLine; ++line) {
                    Integer n = segment.getCount();
                    Intrinsics.checkNotNull((Object)n);
                    lines.add(new LcovCoverageReport.LineHits(line + 1, n.intValue()));
                }
            }
            Integer endLineHits = segment.getCount();
            while (inclusiveEnd < document.getLineEndOffset(segmentEndLine) && listIterator.hasNext()) {
                segment = listIterator.next();
                inclusiveEnd = segment.getEndOffsetExclusive() - 1;
                endLineHits = this.nullableMax(endLineHits, segment.getCount());
            }
            if (inclusiveEnd > document.getLineEndOffset(segmentEndLine)) {
                listIterator.previous();
            }
            if (endLineHits != null) {
                lines.add(new LcovCoverageReport.LineHits(segmentEndLine + 1, endLineHits.intValue()));
            }
            currentLine = segmentEndLine + 1;
        }
        return lines;
    }

    private final Integer nullableMax(Integer a, Integer b2) {
        return a == null ? b2 : (b2 == null ? a : Integer.valueOf(Math.max(a, b2)));
    }

    private static final Stream convertCoverageFormat$lambda$0$0$0(FunctionCoverageValue it) {
        return it.ranges().stream();
    }

    private static final Stream convertCoverageFormat$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final void convertCoverageFormat$lambda$0$0(ScriptCoverageValue $script, VirtualFile $scriptFile, WipScript $wipScript, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov) {
        try {
            List list = $script.functions().stream().flatMap(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$0$0$1(WipCoverageReportProcessor::convertCoverageFormat$lambda$0$0$0, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            List ranges = CollectionsKt.toMutableList((Collection)list);
            List<CoverageSegment> segments2 = INSTANCE.convertToDisjointSegments(ranges);
            Document document = FileDocumentManager.getInstance().getDocument($scriptFile);
            if (document == null) {
                return;
            }
            int scriptStartLine = $wipScript.getLine();
            int scriptEndLine = $wipScript.getEndLine();
            int scriptStartOffset = document.getLineStartOffset(scriptStartLine) + $wipScript.getColumn();
            Intrinsics.checkNotNull((Object)$scriptFile);
            INSTANCE.convertSegmentsOffsets(segments2, $scriptFile, scriptStartOffset);
            if ($wipScript.getSourceMap() != null) {
                SourceMap sourceMap = $wipScript.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                Map<Document, List<CoverageSegment>> coverageMap = INSTANCE.mapCoverage(segments2, document, sourceMap, $jsDebugProcess);
                for (Map.Entry<Document, List<CoverageSegment>> entry : coverageMap.entrySet()) {
                    VirtualFile sourceFile;
                    Document sourceDocument = entry.getKey();
                    List<CoverageSegment> sourceSegments = entry.getValue();
                    Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile(sourceDocument));
                    try {
                        if (!INSTANCE.supportedExtension(sourceFile)) continue;
                        List<LcovCoverageReport.LineHits> lines = INSTANCE.computeLines(sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                        $lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to process coverage for " + $wipScript.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                    }
                }
            }
            if (!($scriptFile instanceof LightVirtualFile) && INSTANCE.supportedExtension($scriptFile)) {
                List<LcovCoverageReport.LineHits> lines = INSTANCE.computeLines(document, segments2, scriptStartLine, scriptEndLine);
                $lcov.mergeFileReport(null, $scriptFile.getPath(), lines);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to process coverage for " + $wipScript.getUrl() + ". Matched file: " + $scriptFile.getPath() + ".\n" + e.getMessage());
        }
    }

    private static final Unit convertCoverageFormat$lambda$0(ScriptCoverageValue $script, WipScript $wipScript, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov, VirtualFile scriptFile) {
        ReadAction.run(() -> WipCoverageReportProcessor.convertCoverageFormat$lambda$0$0($script, scriptFile, $wipScript, $jsDebugProcess, $lcov));
        return Unit.INSTANCE;
    }

    private static final void convertCoverageFormat$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final LcovCoverageReport convertCoverageFormat$lambda$2(Function1 $tmp0, Object p0) {
        return (LcovCoverageReport)$tmp0.invoke(p0);
    }

    private static final void convertCssCoverageFormat$lambda$0$0(List $rules, VirtualFile $scriptFile, WipStyleSheet $styleSheet, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov) {
        try {
            List<CoverageSegment> segments2 = INSTANCE.convertCssDataToSegments($rules);
            Document document = FileDocumentManager.getInstance().getDocument($scriptFile);
            if (document == null) {
                return;
            }
            int scriptStartLine = 0;
            int scriptEndLine = document.getLineCount();
            Intrinsics.checkNotNull((Object)$scriptFile);
            INSTANCE.convertSegmentsOffsets(segments2, $scriptFile, 0);
            if ($styleSheet.getSourceMap() != null) {
                SourceMap sourceMap = $styleSheet.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                Map<Document, List<CoverageSegment>> coverageMap = INSTANCE.mapCoverage(segments2, document, sourceMap, $jsDebugProcess);
                for (Map.Entry<Document, List<CoverageSegment>> entry : coverageMap.entrySet()) {
                    VirtualFile sourceFile;
                    Document sourceDocument = entry.getKey();
                    List<CoverageSegment> sourceSegments = entry.getValue();
                    Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile(sourceDocument));
                    try {
                        List<LcovCoverageReport.LineHits> lines = INSTANCE.computeLines(sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                        $lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to process coverage for " + $styleSheet.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                    }
                }
            }
            if (!($scriptFile instanceof LightVirtualFile)) {
                List<LcovCoverageReport.LineHits> lines = INSTANCE.computeLines(document, segments2, scriptStartLine, scriptEndLine);
                $lcov.mergeFileReport(null, $scriptFile.getPath(), lines);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to process coverage for " + $styleSheet + ". Matched file: " + $scriptFile.getPath() + ".\n" + e.getMessage());
        }
    }

    private static final Unit convertCssCoverageFormat$lambda$0(List $rules, WipStyleSheet $styleSheet, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov, VirtualFile scriptFile) {
        ReadAction.run(() -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$0$0($rules, scriptFile, $styleSheet, $jsDebugProcess, $lcov));
        return Unit.INSTANCE;
    }

    private static final void convertCssCoverageFormat$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final LcovCoverageReport convertCssCoverageFormat$lambda$2(Function1 $tmp0, Object p0) {
        return (LcovCoverageReport)$tmp0.invoke(p0);
    }

    private static final Stream convertCssDataToSegments$lambda$0(RuleUsageValue it) {
        Object[] objectArray = new CoverageSegment[]{new CoverageSegment((int)it.getStartOffset(), 0), new CoverageSegment((int)it.getEndOffset(), it.getUsed() ? 1 : 0)};
        return CollectionsKt.listOf((Object[])objectArray).stream();
    }

    private static final Stream convertCssDataToSegments$lambda$1(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Integer convertCssDataToSegments$lambda$2(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final boolean convertCssDataToSegments$lambda$3(CoverageSegment s) {
        return s.getEndOffsetExclusive() != 0;
    }

    private static final boolean convertCssDataToSegments$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Comparable convertToDisjointSegments$lambda$0(CoverageRangeValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getStartOffset());
    }

    private static final Comparable convertToDisjointSegments$lambda$1(CoverageRangeValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getEndOffset() - it.getStartOffset());
    }

    static {
        Logger logger = Logger.getInstance(WipCoverageReportProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"css", "sass", "less", "styl"};
        cssExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "", "endOffsetExclusive", "", "count", "<init>", "(ILjava/lang/Integer;)V", "getEndOffsetExclusive", "()I", "setEndOffsetExclusive", "(I)V", "getCount", "()Ljava/lang/Integer;", "setCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "component1", "component2", "copy", "(ILjava/lang/Integer;)Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "equals", "", "other", "hashCode", "toString", "", "intellij.javascript.debugger.backend"})
    public static final class CoverageSegment {
        private int endOffsetExclusive;
        @Nullable
        private Integer count;

        public CoverageSegment(int endOffsetExclusive, @Nullable Integer count) {
            this.endOffsetExclusive = endOffsetExclusive;
            this.count = count;
        }

        public final int getEndOffsetExclusive() {
            return this.endOffsetExclusive;
        }

        public final void setEndOffsetExclusive(int n) {
            this.endOffsetExclusive = n;
        }

        @Nullable
        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(@Nullable Integer n) {
            this.count = n;
        }

        public final int component1() {
            return this.endOffsetExclusive;
        }

        @Nullable
        public final Integer component2() {
            return this.count;
        }

        @NotNull
        public final CoverageSegment copy(int endOffsetExclusive, @Nullable Integer count) {
            return new CoverageSegment(endOffsetExclusive, count);
        }

        public static /* synthetic */ CoverageSegment copy$default(CoverageSegment coverageSegment, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = coverageSegment.endOffsetExclusive;
            }
            if ((n3 & 2) != 0) {
                n2 = coverageSegment.count;
            }
            return coverageSegment.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CoverageSegment(endOffsetExclusive=" + this.endOffsetExclusive + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.endOffsetExclusive);
            result2 = result2 * 31 + (this.count == null ? 0 : ((Object)this.count).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoverageSegment)) {
                return false;
            }
            CoverageSegment coverageSegment = (CoverageSegment)other;
            if (this.endOffsetExclusive != coverageSegment.endOffsetExclusive) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.count, (Object)coverageSegment.count);
        }
    }
}

