/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.backend.TerminalContentChangesTrackerKt;
import com.intellij.terminal.backend.TerminalContentUpdate;
import com.intellij.terminal.backend.TerminalDiscardedHistoryTracker;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.TextBufferChangesListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImplKt;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StylesCollectingTerminalLinesCollector;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.DurationAndTextLength;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.session.impl.StyleRange;
import org.jetbrains.plugins.terminal.session.impl.dto.StyleRangeDtoKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0014\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/backend/TerminalContentChangesTracker;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "discardedHistoryTracker", "Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;)V", "lastChangedVisualLine", "", "anyLineChanged", "", "listeners", "", "Lkotlin/Function1;", "Lcom/intellij/terminal/backend/TerminalContentUpdate;", "", "bufferCollectionLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lorg/jetbrains/plugins/terminal/fus/DurationAndTextLength;", "addHistoryOverflowListener", "listener", "getContentUpdate", "flushChanges", "additionalLines", "", "Lcom/jediterm/terminal/model/TerminalLine;", "collectOutput", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "startLine", "intellij.terminal.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalContentChangesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalContentChangesTracker.kt\ncom/intellij/terminal/backend/TerminalContentChangesTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 BatchLatencyReporter.kt\norg/jetbrains/plugins/terminal/fus/BatchLatencyReporterKt\n*L\n1#1,179:1\n1915#2,2:180\n1586#2:188\n1661#2,3:189\n1849#2,3:193\n1021#2,2:199\n1021#2,2:228\n1#3:182\n1#3:197\n1#3:204\n1#3:226\n60#4,5:183\n101#5:192\n87#5:196\n89#5:198\n90#5,2:201\n50#5:203\n52#5,20:205\n87#5:225\n89#5:227\n90#5,2:230\n*S KotlinDebug\n*F\n+ 1 TerminalContentChangesTracker.kt\ncom/intellij/terminal/backend/TerminalContentChangesTracker\n*L\n88#1:180,2\n136#1:188\n136#1:189,3\n34#1:193,3\n35#1:199,2\n37#1:228,2\n35#1:197\n36#1:204\n37#1:226\n122#1:183,5\n34#1:192\n35#1:196\n35#1:198\n35#1:201,2\n36#1:203\n36#1:205,20\n37#1:225\n37#1:227\n37#1:230,2\n*E\n"})
public final class TerminalContentChangesTracker {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final TerminalDiscardedHistoryTracker discardedHistoryTracker;
    private int lastChangedVisualLine;
    private boolean anyLineChanged;
    @NotNull
    private final List<Function1<TerminalContentUpdate, Unit>> listeners;
    @NotNull
    private final BatchLatencyReporter<DurationAndTextLength> bufferCollectionLatencyReporter;

    public TerminalContentChangesTracker(@NotNull TerminalTextBuffer textBuffer, @NotNull TerminalDiscardedHistoryTracker discardedHistoryTracker) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)discardedHistoryTracker, (String)"discardedHistoryTracker");
        this.textBuffer = textBuffer;
        this.discardedHistoryTracker = discardedHistoryTracker;
        this.listeners = new CopyOnWriteArrayList();
        this.bufferCollectionLatencyReporter = new BatchLatencyReporter(100, TerminalContentChangesTracker::bufferCollectionLatencyReporter$lambda$0);
        this.textBuffer.addChangesListener(new TextBufferChangesListener(){

            public void linesChanged(int fromIndex) {
                int line = TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(textBuffer) + fromIndex;
                lastChangedVisualLine = Math.min(lastChangedVisualLine, line);
                anyLineChanged = true;
            }

            public void linesDiscardedFromHistory(List<TerminalLine> lines) {
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                if (textBuffer.isUsingAlternateBuffer()) {
                    return;
                }
                if (lastChangedVisualLine >= lines.size()) {
                    lastChangedVisualLine = lastChangedVisualLine - lines.size();
                } else {
                    List<TerminalLine> additionalLines = lines.subList(lastChangedVisualLine, lines.size());
                    lastChangedVisualLine = 0;
                    anyLineChanged = true;
                    this.flushChanges(additionalLines);
                }
            }

            public void widthResized() {
                lastChangedVisualLine = 0;
                anyLineChanged = true;
            }
        });
    }

    public final void addHistoryOverflowListener(@NotNull Function1<? super TerminalContentUpdate, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Nullable
    public final TerminalContentUpdate getContentUpdate() {
        return this.getContentUpdate(CollectionsKt.emptyList());
    }

    private final void flushChanges(List<TerminalLine> additionalLines) {
        TerminalContentUpdate terminalContentUpdate = this.getContentUpdate(additionalLines);
        Intrinsics.checkNotNull((Object)terminalContentUpdate);
        TerminalContentUpdate update = terminalContentUpdate;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)update);
        }
    }

    private final TerminalContentUpdate getContentUpdate(List<TerminalLine> additionalLines) {
        TerminalContentUpdate terminalContentUpdate;
        if (this.anyLineChanged) {
            long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            TerminalContentUpdate update = this.collectOutput(additionalLines);
            DurationAndTextLength latencyData = new DurationAndTextLength(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), update.getText().length(), null);
            this.bufferCollectionLatencyReporter.update(latencyData);
            terminalContentUpdate = update;
        } else {
            terminalContentUpdate = null;
        }
        return terminalContentUpdate;
    }

    /*
     * WARNING - void declaration
     */
    private final TerminalContentUpdate collectOutput(List<TerminalLine> additionalLines) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!this.anyLineChanged) {
            boolean $i$a$-check-TerminalContentChangesTracker$collectOutput$22 = false;
            String $i$a$-check-TerminalContentChangesTracker$collectOutput$22 = "It is expected that this method is called only if something is changed";
            throw new IllegalStateException($i$a$-check-TerminalContentChangesTracker$collectOutput$22.toString());
        }
        int startLine = this.lastChangedVisualLine - TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer);
        int effectiveStartLine = 0;
        effectiveStartLine = startLine;
        while (effectiveStartLine - 1 >= -TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer) && this.textBuffer.getLine(effectiveStartLine - 1).isWrapped()) {
            int n = effectiveStartLine;
            effectiveStartLine = n + -1;
        }
        StyledCommandOutput output = this.scrapeOutput(effectiveStartLine, additionalLines);
        long logicalLineIndex = (long)TerminalContentChangesTrackerKt.getLogicalLineIndex(this.textBuffer, effectiveStartLine) + this.discardedHistoryTracker.getDiscardedLogicalLinesCount() - (long)additionalLines.size();
        Object $this$debug_u24default$iv = TerminalContentChangesTrackerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Content updated: length = " + output.getText().length() + ", from line = " + startLine + " (effective " + effectiveStartLine + ", absolute " + logicalLineIndex + "), last changed visual line = " + this.lastChangedVisualLine + ", additional lines = " + additionalLines.size() + ", effective history lines = " + TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer) + ", discarded lines = " + this.discardedHistoryTracker.getDiscardedLogicalLinesCount(), t$iv);
        }
        this.lastChangedVisualLine = TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer) + this.textBuffer.getScreenLinesCount();
        this.anyLineChanged = false;
        $this$debug_u24default$iv = output.getStyleRanges();
        String string = output.getText();
        boolean $i$f$map = false;
        void $i$f$debug22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StyleRangeDtoKt.toDto((StyleRange)it));
        }
        long l = logicalLineIndex;
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new TerminalContentUpdate(string2, list, l);
    }

    private final StyledCommandOutput scrapeOutput(int startLine, List<TerminalLine> additionalLines) {
        List styles = new ArrayList();
        SimpleStringCollector stringCollector = new SimpleStringCollector();
        StylesCollectingTerminalLinesCollector terminalLinesCollector2 = new StylesCollectingTerminalLinesCollector(stringCollector, (Function1<? super StyleRange, Unit>)((Function1)new Function1<StyleRange, Unit>((Object)styles){

            public final void invoke(StyleRange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((List)this.receiver).add(p0);
            }
        }));
        for (TerminalLine line : additionalLines) {
            terminalLinesCollector2.addLine(line);
        }
        ShellCommandOutputScraperImplKt.collectLines(this.textBuffer, terminalLinesCollector2, startLine);
        return new StyledCommandOutput(stringCollector.buildText(), styles);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit bufferCollectionLatencyReporter$lambda$0(List samples) {
        List $this$thirdLargestOf$iv;
        void p0;
        List $this$percentileOf$iv;
        long l;
        void $this$fold$iv$iv;
        List $this$totalDurationOf$iv;
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        List list = samples;
        ReworkedTerminalUsageCollector reworkedTerminalUsageCollector = ReworkedTerminalUsageCollector.INSTANCE;
        boolean $i$f$totalDurationOf = false;
        Iterable iterable = $this$totalDurationOf$iv;
        long initial$iv$iv = Duration.Companion.getZERO-UwyO8pc();
        boolean $i$f$fold22 = false;
        long accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            void value$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            long acc$iv = accumulator$iv$iv;
            boolean bl = false;
            DurationAndTextLength durationAndTextLength = (DurationAndTextLength)value$iv;
            l = acc$iv;
            boolean bl2 = false;
            long l2 = p02.getDuration-UwyO8pc();
            accumulator$iv$iv = Duration.plus-LRDsOJo((long)l, (long)l2);
        }
        l = accumulator$iv$iv;
        $this$totalDurationOf$iv = samples;
        int n$iv = 90;
        boolean $i$f$percentileOf = false;
        void $this$sortBy$iv$iv = $this$percentileOf$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc())));
                }
            });
        }
        int index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        DurationAndTextLength $i$f$fold22 = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        boolean bl = false;
        Duration duration = Duration.box-impl((long)p0.getDuration-UwyO8pc());
        $this$percentileOf$iv = samples;
        long l3 = ((Duration)((Comparable)duration)).unbox-impl();
        boolean $i$f$thirdLargestOf = false;
        if (!(!((Collection)$this$thirdLargestOf$iv).isEmpty())) {
            boolean $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = false;
            String $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = "It is expected that array is not empty";
            throw new IllegalStateException($i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22.toString());
        }
        DurationAndTextLength p03 = (DurationAndTextLength)$this$thirdLargestOf$iv.get(0);
        boolean bl3 = false;
        Object max$iv = (Comparable)Duration.box-impl((long)p03.getDuration-UwyO8pc());
        Comparable secondLargest$iv = max$iv;
        Comparable thirdLargest$iv = max$iv;
        for (Object value$iv : $this$thirdLargestOf$iv) {
            DurationAndTextLength p04 = (DurationAndTextLength)value$iv;
            $i$a$-thirdLargestOf-TerminalContentChangesTracker$bufferCollectionLatencyReporter$1$3 = false;
            Comparable comparableValue$iv = (Comparable)Duration.box-impl((long)p04.getDuration-UwyO8pc());
            if (comparableValue$iv.compareTo(max$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = max$iv;
                max$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(secondLargest$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(thirdLargest$iv) <= 0) continue;
            thirdLargest$iv = comparableValue$iv;
        }
        Comparable comparable = thirdLargest$iv;
        long l4 = ((Duration)comparable).unbox-impl();
        $this$thirdLargestOf$iv = samples;
        n$iv = 90;
        $i$f$percentileOf = false;
        List $this$sortBy$iv$iv2 = $this$percentileOf$iv;
        $i$f$sortBy = false;
        if ($this$sortBy$iv$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getTextLength());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getTextLength()));
                }
            });
        }
        index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        max$iv = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        long l5 = l4;
        boolean bl4 = false;
        int n = p0.getTextLength();
        reworkedTerminalUsageCollector.logBackendTextBufferCollectionLatency-2d-g_3Q(l, l3, l5, n);
        return Unit.INSTANCE;
    }
}

