/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/terminal/backend/TerminalShellIntegrationStatisticsListener;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "commandStartTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "commandStarted", "", "command", "commandFinished", "exitCode", "", "currentDirectory", "intellij.terminal.backend"})
public final class TerminalShellIntegrationStatisticsListener
implements TerminalShellIntegrationEventsListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, Long> commandStartTimes;

    public TerminalShellIntegrationStatisticsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.commandStartTimes = new ConcurrentHashMap();
    }

    @Override
    public void commandStarted(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        ((Map)this.commandStartTimes).put(command2, System.currentTimeMillis());
        ReworkedTerminalUsageCollector.logCommandStarted(this.project, command2);
    }

    @Override
    public void commandFinished(@NotNull String command2, int exitCode, @NotNull String currentDirectory) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)currentDirectory, (String)"currentDirectory");
        long now = System.currentTimeMillis();
        long duration = 0L;
        Long started = this.commandStartTimes.remove(command2);
        if (started != null) {
            duration = now - started;
        }
        ReworkedTerminalUsageCollector.INSTANCE.logCommandFinished-Wn2Vu4Y(this.project, command2, exitCode, DurationKt.toDuration((long)duration, (DurationUnit)DurationUnit.MILLISECONDS));
    }
}

